/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.projects.ZosConnectApiProjectNature;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.editors.listeners.ApiProjectImportListener;
import com.ibm.zosconnect.ui.util.ApiProjectMigrationUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ZCeeUIPluginEarlyStartup
implements IStartup {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2021. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ZCeeUIPluginEarlyStartup.class.getName();
    public static final String PROP_BROWSER_DEFAULTTYPE = "org.eclipse.swt.browser.DefaultType";
    public static final String PROP_BROWSER_IEVERSION = "org.eclipse.swt.browser.IEVersion";
    public static final String PROP_OS_NAME = "os.name";

    public void earlyStartup() {
        ZCeeUILogger.entering((String)TAG, (String)"earlyStartup()", (Object[])new Object[0]);
        ZCeeUILogger.info((String)"Register ApiProjectImportListener...", (Object[])new Object[0]);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ApiProjectImportListener apiProjectImportListener = new ApiProjectImportListener();
        workspace.addResourceChangeListener((IResourceChangeListener)apiProjectImportListener);
        ZCeeUILogger.info((String)"Migrate and build all API projects to detect errors...", (Object[])new Object[0]);
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject currProject = iProjectArray[n2];
            try {
                if (currProject.isOpen() && ZosConnectApiProjectNature.hasNature((IProject)currProject)) {
                    new WorkspaceJob(Xlat.description((String)"STATUS_UPDATING_API_PROJECT", (String[])new String[]{currProject.getName()})){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            try {
                                ApiProjectMigrationUtil.migrate(currProject);
                                currProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                currProject.build(6, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                ZCeeUILogger.error((Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            ++n2;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ZCeeUILogger.info((String)"Activating API editor instances that were left open when the workbench closed...", (Object[])new Object[0]);
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                    int n3 = iWorkbenchPageArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                        int n5 = iEditorReferenceArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editor = iEditorReferenceArray[n6];
                            if ("com.ibm.zosconnect.ui.apieditor".equals(editor.getId())) {
                                editor.getEditor(true);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        String osName = System.getProperty(PROP_OS_NAME);
        ZCeeUILogger.info((String)"Initial browser-related config: {0}={1},{2}={3},{4}={5}", (Object[])new Object[]{PROP_OS_NAME, osName, PROP_BROWSER_DEFAULTTYPE, System.getProperty(PROP_BROWSER_DEFAULTTYPE), PROP_BROWSER_IEVERSION, System.getProperty(PROP_BROWSER_IEVERSION)});
        if (StringUtils.startsWithIgnoreCase((CharSequence)osName, (CharSequence)"Windows")) {
            if (StringUtils.isBlank((CharSequence)System.getProperty(PROP_BROWSER_DEFAULTTYPE))) {
                System.setProperty(PROP_BROWSER_DEFAULTTYPE, "edge");
            }
            if (StringUtils.isBlank((CharSequence)System.getProperty(PROP_BROWSER_IEVERSION))) {
                System.setProperty(PROP_BROWSER_IEVERSION, "11000");
            }
        }
        ZCeeUILogger.info((String)"Updated browser-related config: {0}={1},{2}={3},{4}={5}", (Object[])new Object[]{PROP_OS_NAME, osName, PROP_BROWSER_DEFAULTTYPE, System.getProperty(PROP_BROWSER_DEFAULTTYPE), PROP_BROWSER_IEVERSION, System.getProperty(PROP_BROWSER_IEVERSION)});
        ZCeeUILogger.exiting((String)TAG, (String)"earlyStartup()", (Object[])new Object[0]);
    }
}

