/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ZCeeUIPlugin
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG = ZCeeUIPlugin.class.getName();
    public static final String PLUGIN_ID = "com.ibm.zosconnect.ui";
    private static final String[] RequiredActivityIds = new String[]{"org.eclipse.javaDevelopment"};
    private static final String[] OptionalActivityIds = new String[]{"org.eclipse.wst.json.activity", "org.eclipse.wst.xml.activity"};
    private static ZCeeUIPlugin plugin;

    public ZCeeUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            FileUtils.cleanDirectory((File)plugin.getStateLocation().toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ZCeeUILogger.info((String)"Ensure required capabilities are enabled...", (Object[])new Object[0]);
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchActivitySupport workbenchActivitySupport = workbench.getActivitySupport();
                    IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
                    Set definedActivityIds = activityManager.getDefinedActivityIds();
                    ZCeeUILogger.info((String)"definedActivityIds={0}", (Object[])new Object[]{definedActivityIds});
                    Set enabledActivityIds = activityManager.getEnabledActivityIds();
                    ZCeeUILogger.info((String)"enabledActivityIds={0}", (Object[])new Object[]{enabledActivityIds});
                    HashSet<String> newEnabledActivityIds = null;
                    String[] stringArray = RequiredActivityIds;
                    int n = RequiredActivityIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String requiredActivityId = stringArray[n2];
                        if (!definedActivityIds.contains(requiredActivityId)) {
                            ZCeeUILogger.info((String)"required activityId {0} not defined!", (Object[])new Object[0]);
                        } else if (!enabledActivityIds.contains(requiredActivityId)) {
                            ZCeeUILogger.info((String)"required activityId {0} not enabled!", (Object[])new Object[0]);
                            if (newEnabledActivityIds == null) {
                                newEnabledActivityIds = new HashSet<String>(enabledActivityIds);
                            }
                            newEnabledActivityIds.add(requiredActivityId);
                        }
                        ++n2;
                    }
                    stringArray = OptionalActivityIds;
                    n = OptionalActivityIds.length;
                    n2 = 0;
                    while (n2 < n) {
                        String optionalActivityId = stringArray[n2];
                        if (!definedActivityIds.contains(optionalActivityId)) {
                            ZCeeUILogger.info((String)"optional activityId {0} not defined", (Object[])new Object[0]);
                        } else if (!enabledActivityIds.contains(optionalActivityId)) {
                            ZCeeUILogger.info((String)"optional activityId {0} not enabled", (Object[])new Object[0]);
                            if (newEnabledActivityIds == null) {
                                newEnabledActivityIds = new HashSet(enabledActivityIds);
                            }
                            newEnabledActivityIds.add(optionalActivityId);
                        }
                        ++n2;
                    }
                    if (newEnabledActivityIds != null) {
                        ZCeeUILogger.info((String)"calling setEnabledActivityIds({0})...", (Object[])new Object[]{newEnabledActivityIds});
                        workbenchActivitySupport.setEnabledActivityIds(newEnabledActivityIds);
                        ZCeeUILogger.info((String)"returned from setEnabledActivityIds()", (Object[])new Object[]{newEnabledActivityIds});
                    }
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            FileUtils.cleanDirectory((File)plugin.getStateLocation().toFile());
        }
        catch (Exception exception) {
            // empty catch block
        }
        plugin = null;
        super.stop(context);
    }

    public static ZCeeUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ZCeeUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

