/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.ims.impl;

import com.ibm.zosconnect.ui.common.exceptions.ResponseInterfaceDefaultValueException;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerAttributes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckArrayCountersVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckDatatypeOverridesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CheckFieldDefaultValuesVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtension;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceExtensionProperty;
import com.ibm.zosconnect.ui.service.controllers.model.ServiceProjectController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServicePropertiesValidator;
import com.ibm.zosconnect.ui.service.ims.ImsXlat;
import com.ibm.zosconnect.ui.service.ims.natures.ImsLdsServiceProjectNature;
import com.ibm.zosconnect.ui.service.ims.natures.ImsServiceProjectNature;
import com.ibm.zosconnect.ui.service.validation.AdvancedOptionsValidator;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

public class ImsPropertiesValidator
implements IServicePropertiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public final String className = this.getClass().getName();
    public static final String TRANSACTION_CODE = "Transaction code";
    public static final String EXECUTABLE_NAME = "executableName";
    public static final String REQUEST_SI_NAME = "requestSIName";
    public static final String RESPONSE_SI_NAME = "responseSIName";
    public static final String IMS_TRAN_CODE_SPACE_DELIMITED = "imsTranCodeSpaceDelimited";
    public static final String TRIM_OUTPUT_LEADING_WHITESPACE = "trimOutputLeadingWhitespace";
    public static final String TRIM_OUTPUT_TRAILING_WHITESPACE = "trimOutputTrailingWhitespace";
    public static final String ESCAPE_OUTPUT_CONTROL_CHARACTERS = "escapeOutputControlCharacters";
    public static final String INITIALIZE_INPUT_FIELDS = "initializeInputFields";
    public static final String OMIT_OUTPUT_FIELDS_BY_VALUE = "omitOutputFieldsByValue";
    public static final String OMIT_OUTPUT_FIELDS_BY_VALUE_BYTE = "omitOutputFieldsByValueByte";
    public static final String OMIT_OUTPUT_EMPTY_TAGS = "omitOutputEmptyTags";
    public static final String ENFORCE_MIN_ARRAY_OCCURANCE = "enforceMinArrayOccurrence";
    public static final String ENFORCE_MIN_ARRAY_OCCURANCE_RESPONSE = "enforceMinArrayOccurrenceResponse";
    public static final String LDS_STARTS_WITH_LLZZ = "ldsStartsWithLLZZ";
    public static final String LDS_STARTS_WITH_LLZZTRANCODE = "ldsStartsWithLLZZTRANCODE";
    public static final String TRUNCATE_INPUT_LAST_CHAR_FIELD = "truncateInputLastCharField";

    public List<ServiceProjectValidationError> validateDefinitionProperty(IResource resource, String key, String value) {
        ZCeeUILogger.entering((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{resource, key, value});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (!(value != null || key.equals(ENFORCE_MIN_ARRAY_OCCURANCE_RESPONSE) || key.equals(IMS_TRAN_CODE_SPACE_DELIMITED) || key.equals(LDS_STARTS_WITH_LLZZ) || key.equals(LDS_STARTS_WITH_LLZZTRANCODE) || key.equals(TRUNCATE_INPUT_LAST_CHAR_FIELD))) {
            String msg = Xlat.error((String)"REQUIRED_SERVICE_PROPERTY_MISSING", (String[])new String[]{key});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
            return result;
        }
        ServiceProjectValidationError error = null;
        AdvancedOptionsValidator advancedOptionsValidator = new AdvancedOptionsValidator();
        switch (key) {
            case "executableName": {
                if (value.isEmpty()) {
                    String msg = Xlat.error((String)"MUST_CONTAIN_1_CHARACTER", (String[])new String[]{TRANSACTION_CODE});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
                    break;
                }
                if (value.length() > 8) {
                    String msg = Xlat.error((String)"IMS_TRANCODE_TOO_LONG", (String[])new String[]{TRANSACTION_CODE});
                    error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                    error.getAttributes().put("key", TRANSACTION_CODE);
                    error.getAttributes().put("value", value);
                    result.add(error);
                    break;
                }
                if (ImsPropertiesValidator.trancodeHaveValidCharacters(value)) break;
                String msg = Xlat.error((String)"IMS_TRANCODE_INVALID_CHARS", (String[])new String[]{TRANSACTION_CODE});
                error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                error.getAttributes().put("key", TRANSACTION_CODE);
                error.getAttributes().put("value", value);
                result.add(error);
                break;
            }
            case "requestSIName": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUESTSI", false, false, true, null);
                break;
            }
            case "responseSIName": {
                result = this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSESI", true, false, true, null);
                break;
            }
            case "imsTranCodeSpaceDelimited": {
                if (value == null) {
                    ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
                    return result;
                }
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                String msg = Xlat.error((String)"MUST_BE_TRUE_OR_FALSE", (String[])new String[]{Xlat.label((String)"SERVICEEDIT_LABEL_SPACE_DELIMITED")});
                error = new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg);
                error.getAttributes().put("key", IMS_TRAN_CODE_SPACE_DELIMITED);
                error.getAttributes().put("value", value);
                result.add(error);
                break;
            }
            case "trimOutputLeadingWhitespace": {
                error = advancedOptionsValidator.validateTrimOutputLeadingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "trimOutputTrailingWhitespace": {
                error = advancedOptionsValidator.validateTrimOutputTrailingWhitespace(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "escapeOutputControlCharacters": {
                error = advancedOptionsValidator.validateEscapeOutputControlCharacters(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "initializeInputFields": {
                error = advancedOptionsValidator.validateInitializeInputFields(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputFieldsByValue": {
                error = advancedOptionsValidator.validateOmitOutputFieldsByValue(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "omitOutputEmptyTags": {
                error = advancedOptionsValidator.validateOmitOutputEmptyTags(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrence": {
                error = advancedOptionsValidator.validateEnforceMinArrayOccurrence(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "enforceMinArrayOccurrenceResponse": {
                error = advancedOptionsValidator.validateEnforceMinArrayOccurrenceResponse(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "ldsStartsWithLLZZ": {
                error = advancedOptionsValidator.validateLdsStartsWithLLZZ(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "ldsStartsWithLLZZTRANCODE": {
                error = advancedOptionsValidator.validateLdsStartsWithLLZZTRANCODE(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            case "truncateInputLastCharField": {
                error = advancedOptionsValidator.validateTruncateInputLastCharField(resource, value);
                if (error == null) break;
                result.add(error);
                break;
            }
            default: {
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"UNKNOWN_PROPERTY", (String[])new String[]{key})));
            }
            case "omitOutputFieldsByValueByte": 
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateDefinitionProperty", (Object[])new Object[]{result});
        return result;
    }

    public List<ServiceProjectValidationError> validateRequest(IResource resource, String value, boolean needToCheckLLZZForEditorChange) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_REQUESTSI", false, needToCheckLLZZForEditorChange, false, null);
    }

    public List<ServiceProjectValidationError> validateResponse(IResource resource, String value, boolean needToCheckLLZZForEditorChange, boolean callFromBuilder, IServiceModelController serviceModelController) {
        return this.validateRequestOrResponseFile(resource, value, "SERVICEEDIT_LABEL_RESPONSESI", true, needToCheckLLZZForEditorChange, callFromBuilder, serviceModelController);
    }

    private List<ServiceProjectValidationError> validateRequestOrResponseFile(IResource resource, String fileName, String label, boolean isResponse, boolean needToCheckLLZZForEditorChange, boolean callFromBuilder, IServiceModelController advancedOptionsServiceModelController) {
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{resource, fileName, label, "isResponse: " + isResponse});
        ArrayList<ServiceProjectValidationError> result = new ArrayList<ServiceProjectValidationError>();
        if (fileName.isEmpty()) {
            String msg = Xlat.error((String)"REQUEST_OR_RESPONSE_REQUIRED", (String[])new String[]{Xlat.label((String)label)});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, msg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        String filePath = "service-interfaces" + File.separator + fileName;
        if (!resource.getProject().getFile(filePath).exists()) {
            String errMsgInsert = Xlat.error((String)"PROJECT_FILE_MISSING_ERROR", (String[])new String[]{fileName, resource.getProject().getName()});
            String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Xlat.label((String)label), errMsgInsert});
            result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
            ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
            return result;
        }
        try {
            ServiceProjectValidationError error;
            FieldType errorField;
            CheckArrayCountersVisitor visitor;
            IFile file = resource.getProject().getFolder("service-interfaces").getFile(fileName);
            Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
            ServiceArchiveConstants.SP_Type project_spType = null;
            String projectServiceTypeLabel = null;
            String serviceInterfaceServiceTypeLabel = null;
            try {
                if (ImsServiceProjectNature.hasNature(resource.getProject())) {
                    serviceInterfaceServiceTypeLabel = ServiceExtension.getLabelUsingServiceInterfaceServiceType((String)msg.getServiceType());
                    projectServiceTypeLabel = ImsXlat.label("IMS_SP", new String[0]);
                    project_spType = ServiceArchiveConstants.SP_Type.IMS;
                } else if (ImsLdsServiceProjectNature.hasNature(resource.getProject())) {
                    serviceInterfaceServiceTypeLabel = ServiceExtension.getLabelUsingServiceInterfaceServiceType((String)msg.getServiceType());
                    projectServiceTypeLabel = ImsXlat.label("IMS_LDS_SP", new String[0]);
                    project_spType = ServiceArchiveConstants.SP_Type.IMS_LDS;
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
            }
            if (!ImsServiceProjectNature.hasNature(resource.getProject()) && !ImsLdsServiceProjectNature.hasNature(resource.getProject())) {
                ZCeeUILogger.error((String)("Missing project nature for project " + resource.getProject().getName() + ". Unable to complete validation for Request or Response service interface."), (Object[])new Object[0]);
                ZCeeErrorDialog.openError((Exception)new Exception("Missing project nature for project " + resource.getProject().getName() + ". Unable to complete validation for Request or Response service interface."), (boolean)true);
            }
            if (msg.getServiceType() != null && !msg.getServiceType().equals(project_spType.toString())) {
                String errMsgInsert = Xlat.error((String)"SE_INCOMPATIBLE_SI_FILE", (String[])new String[]{serviceInterfaceServiceTypeLabel, projectServiceTypeLabel});
                String errorMsg = Xlat.error((String)"PROPERTY_ERROR", (String[])new String[]{Xlat.label((String)label), errMsgInsert});
                result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, errorMsg));
                ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
                return result;
            }
            if (isResponse) {
                CheckFieldDefaultValuesVisitor visitor2 = new CheckFieldDefaultValuesVisitor();
                try {
                    new MessageWalker().accept((IMessageVisitor)visitor2, msg.getMessage());
                }
                catch (ResponseInterfaceDefaultValueException responseInterfaceDefaultValueException) {
                    String error2 = Xlat.error((String)"RESPONSE_SI_DEFAULTVALUES", (String[])new String[]{fileName});
                    result.add(new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM.toString(), error2, null, null, Integer.valueOf(1)));
                }
                if (callFromBuilder) {
                    ServiceProjectValidationError e2;
                    AdvancedOptionsValidator advancedOptionsValidator = new AdvancedOptionsValidator();
                    ServiceProjectValidationError e1 = advancedOptionsValidator.validateLdsStartsWithLLZZUseSameInterface(resource, null, false, callFromBuilder, null);
                    if (e1 != null) {
                        result.add(e1);
                    }
                    if ((e2 = advancedOptionsValidator.validateLdsStartsWithLLZZTRANCODEUseSameInterface(resource, null, false, callFromBuilder, null)) != null) {
                        result.add(e2);
                    }
                }
            }
            if (needToCheckLLZZForEditorChange) {
                ServiceProjectValidationError e2;
                AdvancedOptionsValidator advancedOptionsValidator = new AdvancedOptionsValidator();
                ServiceProjectValidationError e1 = advancedOptionsValidator.validateLdsStartsWithLLZZUseSameInterface(resource, null, needToCheckLLZZForEditorChange, callFromBuilder, advancedOptionsServiceModelController);
                if (e1 != null) {
                    result.add(e1);
                }
                if ((e2 = advancedOptionsValidator.validateLdsStartsWithLLZZTRANCODEUseSameInterface(resource, null, needToCheckLLZZForEditorChange, callFromBuilder, advancedOptionsServiceModelController)) != null) {
                    result.add(e2);
                }
            }
            List dataStructures = TranDataStructureController.getAllDataStructures((Message)msg);
            for (FieldType dataStructure : dataStructures) {
                visitor = new CheckArrayCountersVisitor();
                new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                    errorField = (FieldType)errorEntry.getKey();
                    for (String errorMessage : (List)errorEntry.getValue()) {
                        error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                        error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                        result.add(error);
                    }
                }
            }
            for (FieldType dataStructure : dataStructures) {
                visitor = new CheckDatatypeOverridesVisitor(!isResponse);
                new MessageWalker().accept((IMessageVisitor)visitor, dataStructure);
                for (Map.Entry errorEntry : visitor.getFieldErrorMessages().entrySet()) {
                    errorField = (FieldType)errorEntry.getKey();
                    for (String errorMessage : (List)errorEntry.getValue()) {
                        error = new ServiceProjectValidationError((IResource)file, ServiceProjectMarkerTypes.SERVICEINTERFACE_PROBLEM, errorMessage);
                        error.setAttribute(ServiceProjectMarkerAttributes.FIELD_PATH, errorField.getPath());
                        result.add(error);
                    }
                }
            }
        }
        catch (JAXBException | CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Object[])new Object[0]);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestOrResponseFile", (Object[])new Object[]{result});
        return result;
    }

    private static boolean trancodeHaveValidCharacters(String trancode) {
        return trancode.matches("[A-Za-z0-9\\#\\$\\@]+");
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IResource resource, String key, String value, boolean isRequired, String propertyType) {
        ServiceProjectValidationError result = null;
        if (isRequired && (value == null || value.isEmpty())) {
            result = ImsPropertiesValidator.getMissingRequiredPropertyError(resource, key);
        }
        return result;
    }

    public ServiceProjectValidationError validateConfigurationProperty(ServiceProjectController serviceController, IMessageManager messageMgr, HashMap<String, Control> configurationControls, IResource resource, ServiceExtensionProperty extensionProperty, String value) {
        ServiceProjectValidationError result = null;
        boolean isRequired = extensionProperty.isRequired();
        String propertyType = extensionProperty.getPropertyType();
        String key = extensionProperty.getPropertyName();
        result = this.validateConfigurationProperty(serviceController, resource, key, value, isRequired, propertyType);
        return result;
    }

    private static ServiceProjectValidationError getMissingRequiredPropertyError(IResource resource, String key) {
        return new ServiceProjectValidationError(resource, ServiceProjectMarkerTypes.PROPERTIES_PROBLEM, Xlat.error((String)"MISSING_REQUIRED_PROPERTY", (String[])new String[]{key}));
    }
}

