/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.ims.impl;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectValidationError;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.service.controllers.AdvancedDataConversionOptionsController;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceModelController;
import com.ibm.zosconnect.ui.service.dialogs.AdvancedDataConversionOptionsDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceInterfaceSelectionDialog;
import com.ibm.zosconnect.ui.service.dialogs.ServiceProjectSIDialog;
import com.ibm.zosconnect.ui.service.ims.ImsXlat;
import com.ibm.zosconnect.ui.service.ims.impl.ImsPropertiesValidator;
import com.ibm.zosconnect.ui.service.ims.natures.ImsLdsServiceProjectNature;
import com.ibm.zosconnect.ui.service.ims.natures.ImsServiceProjectNature;
import com.ibm.zosconnect.ui.service.interfaces.IServiceOverviewComposite;
import com.ibm.zosconnect.ui.service.interfaces.IServiceProjectEditor;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImsCompositeImpl
implements IServiceOverviewComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String className = this.getClass().getName();
    private FormToolkit formToolkit;
    private Composite parent;
    private IServiceProjectEditor spe;
    private Text txtTransNameText;
    private Label lblDescription;
    private Button btnComposeSI;
    private Button btnImportSI;
    private Label lblRequestSI;
    private Button btnEditRequestSI;
    private Button btnEditResponseSI;
    private Combo comboRequestSI;
    private Combo comboResponseSI;
    private Label lblSetAdvancedOptions;
    private Button btnAdvancedOptions;
    private Button checkBoxSpaceDelimited;
    private IServiceModelController advancedOptionsServiceModelController;

    public List<String> getCustomActions() {
        ArrayList<String> listOfActions = new ArrayList<String>();
        listOfActions.add(ImsXlat.label("SERVICEEDIT_ACTIONS_TRANSACTION_CODE", new String[0]));
        listOfActions.add(ImsXlat.label("SERVICEEDIT_ACTIONS_SERVICE_INTERFACE", new String[0]));
        return listOfActions;
    }

    public LinkedHashMap<Composite, String> getComposites(FormToolkit formToolkit, Composite parent, IServiceProjectEditor serviceProjectEditor) {
        this.formToolkit = formToolkit;
        this.parent = parent;
        this.spe = serviceProjectEditor;
        LinkedHashMap<Composite, String> listOfComposites = new LinkedHashMap<Composite, String>();
        listOfComposites.put(this.getTransactionSectionComposite(), ImsXlat.label("IMS_EXECUTABLE_NAME", new String[0]));
        listOfComposites.put(this.getDefineReqRespServiceInterfaceComposite(), Xlat.label((String)"SERVICEEDIT_SECTION_SERVICEINTERFACE"));
        return listOfComposites;
    }

    private Composite getTransactionSectionComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getTransactionSectionComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.formToolkit.createLabel(composite, ImsXlat.label("IMS_EXECUTABLE_NAME", new String[0]) + Xlat.colon(), 0);
        this.txtTransNameText = this.formToolkit.createText(composite, "", 0);
        GridData gd_txtProgNameText = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtProgNameText.widthHint = XSwt.getAverageCharWidth((Control)this.txtTransNameText) * 50;
        gd_txtProgNameText.horizontalIndent = 5;
        this.txtTransNameText.setLayoutData((Object)gd_txtProgNameText);
        this.txtTransNameText.setTextLimit(8);
        this.txtTransNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String key = "Transaction Code";
                ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setValue("executableName", ImsCompositeImpl.this.txtTransNameText.getText());
                List<ServiceProjectValidationError> errorValidation = new ImsPropertiesValidator().validateDefinitionProperty(ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().getResource(), "executableName", ImsCompositeImpl.this.txtTransNameText.getText());
                if (errorValidation != null && !errorValidation.isEmpty()) {
                    ImsCompositeImpl.this.spe.getServiceProjectValidator().setControlToError(ImsCompositeImpl.this.spe.getMessageManager(), key, errorValidation.get(0), (Control)ImsCompositeImpl.this.txtTransNameText);
                } else {
                    ImsCompositeImpl.this.spe.getServiceProjectValidator().resetControlToError(ImsCompositeImpl.this.spe.getMessageManager(), key, (Control)ImsCompositeImpl.this.txtTransNameText);
                }
                ImsCompositeImpl.this.spe.setDirty(true);
            }
        });
        this.checkBoxSpaceDelimited = this.formToolkit.createButton(composite, Xlat.label((String)"SERVICEEDIT_LABEL_SPACE_DELIMITED"), 32);
        GridData gd_checkBox = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.checkBoxSpaceDelimited.setLayoutData((Object)gd_checkBox);
        this.checkBoxSpaceDelimited.setToolTipText(Xlat.label((String)"SERVICEEDIT_LABEL_SPACE_DELIMITED_TOOLTIP"));
        boolean isChecked = this.isTrancodeSpaceDelimited();
        this.checkBoxSpaceDelimited.setSelection(isChecked);
        this.checkBoxSpaceDelimited.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean isChecked = ((Button)event.getSource()).getSelection();
                ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().setValue("imsTranCodeSpaceDelimited", Boolean.valueOf(isChecked).toString());
                ImsCompositeImpl.this.spe.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getTransactionSectionComposite", (Object[])new Object[]{composite});
        return composite;
    }

    private Composite getDefineReqRespServiceInterfaceComposite() {
        ZCeeUILogger.entering((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[0]);
        Composite composite = this.formToolkit.createComposite(this.parent, 0);
        this.formToolkit.paintBordersFor(composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.lblDescription = this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_SERVICEINTERFACE_DESCRIPTION"), 0);
        this.lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.btnComposeSI = new Button(composite, 0);
        this.formToolkit.adapt((Control)this.btnComposeSI, true, true);
        this.btnComposeSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_COMPOSEDATASET"));
        this.btnComposeSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_COMPOSEDATASET_TOOLTIP"));
        this.btnComposeSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ServiceProjectSIDialog dialog = new ServiceProjectSIDialog(null);
                    if (dialog.open() == 0) {
                        String siName = dialog.getSiName();
                        if (siName == null || siName.isEmpty()) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)"CREATE_SI_ERROR_TITLE"), (String)Xlat.error((String)"NULL_NAME_SI_ERROR"));
                        } else if (ImsCompositeImpl.this.getSiFileNameList().contains(siName + ".si")) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Xlat.label((String)"CREATE_SI_ERROR_TITLE"), (String)Xlat.error((String)"DUPLICATE_SI_ERROR", (String[])new String[]{siName + ".si"}));
                        } else {
                            Message initialMsg = null;
                            if (ImsLdsServiceProjectNature.hasNature(ImsCompositeImpl.this.spe.getProject())) {
                                initialMsg = ProjectTreeFileHelper.createNewImsLdsProgramInterface((String)siName, (String)"");
                            } else if (ImsServiceProjectNature.hasNature(ImsCompositeImpl.this.spe.getProject())) {
                                initialMsg = ProjectTreeFileHelper.createNewImsProgramInterface((String)siName, (String)"");
                            }
                            IFile newPgmInterfaceFile = ProjectTreeFileHelper.marshallzCEEServiceInterfaceMsg((String)ImsCompositeImpl.this.spe.getProjectName(), (Message)initialMsg, (String)siName);
                            ImsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                        }
                    }
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.btnImportSI = new Button(composite, 0);
        this.btnImportSI.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)this.btnImportSI, true, true);
        this.btnImportSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET"));
        this.btnImportSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_IMPORTDATASET_TOOLTIP"));
        this.btnImportSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ImsCompositeImpl.this.serviceInterfaceSelection();
                }
                catch (Exception exception) {
                    EclipseLogger.logError((Throwable)exception);
                }
            }
        });
        this.lblRequestSI = this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_LABEL_REQUESTSI") + Xlat.colon(), 0);
        GridData gd_lblRequestSI = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRequestSI.widthHint = 200;
        this.lblRequestSI.setLayoutData((Object)gd_lblRequestSI);
        this.comboRequestSI = new Combo(composite, 8);
        this.updateComboOptions(this.comboRequestSI, true);
        GridData gd_req = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_req.widthHint = 400;
        this.comboRequestSI.setLayoutData((Object)gd_req);
        this.formToolkit.adapt((Composite)this.comboRequestSI);
        this.formToolkit.paintBordersFor((Composite)this.comboRequestSI);
        List<ServiceProjectValidationError> validationErrors = new ImsPropertiesValidator().validateRequest(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboRequestSI.getText(), false);
        String key = "requestSIName";
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrors.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), key, firstError, (Control)this.comboRequestSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), key, (Control)this.comboRequestSI);
        }
        this.comboRequestSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImsCompositeImpl.this.spe.isLoading()) {
                    ImsCompositeImpl.this.validateRequestCombo();
                }
            }
        });
        this.btnEditRequestSI = new Button(composite, 0);
        this.btnEditRequestSI.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnEditRequestSI, true, true);
        this.btnEditRequestSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT"));
        this.btnEditRequestSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT_TOOLTIP"));
        this.btnEditRequestSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String siName = ImsCompositeImpl.this.comboRequestSI.getText();
                if (siName != null && !siName.isEmpty() && ImsCompositeImpl.this.getSiFileNameList().contains(siName)) {
                    try {
                        IFile newPgmInterfaceFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)ImsCompositeImpl.this.spe.getProjectName(), (String)siName);
                        ImsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                    }
                    catch (Exception e1) {
                        ZCeeUILogger.error((Throwable)e1);
                        ZCeeErrorDialog.openError((Exception)e1);
                    }
                }
            }
        });
        this.formToolkit.createLabel(composite, Xlat.label((String)"SERVICEEDIT_LABEL_RESPONSESI") + Xlat.colon(), 0);
        this.comboResponseSI = new Combo(composite, 8);
        this.updateComboOptions(this.comboResponseSI, false);
        GridData gd_resp = new GridData(0, 0x1000000, false, false, 1, 1);
        gd_resp.widthHint = 400;
        this.comboResponseSI.setLayoutData((Object)gd_resp);
        this.formToolkit.adapt((Composite)this.comboResponseSI);
        this.formToolkit.paintBordersFor((Composite)this.comboResponseSI);
        List<ServiceProjectValidationError> validationErrorsResp = new ImsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText(), false, false, null);
        String keyresp = "responseSIName";
        if (validationErrorsResp != null && !validationErrorsResp.isEmpty()) {
            ServiceProjectValidationError firstErrorResp = validationErrorsResp.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), keyresp, firstErrorResp, (Control)this.comboResponseSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), keyresp, (Control)this.comboResponseSI);
        }
        this.comboResponseSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImsCompositeImpl.this.spe.isLoading()) {
                    ImsCompositeImpl.this.validateResponseCombo();
                }
            }
        });
        this.btnEditResponseSI = new Button(composite, 0);
        this.btnEditResponseSI.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.btnEditResponseSI, true, true);
        this.btnEditResponseSI.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT"));
        this.btnEditResponseSI.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_EDIT_TOOLTIP"));
        this.lblSetAdvancedOptions = new Label(composite, 0);
        this.formToolkit.adapt((Control)this.lblSetAdvancedOptions, true, true);
        this.lblSetAdvancedOptions.setText(Xlat.label((String)"SERVICEEDIT_LABEL_ADVANCED_OPTIONS"));
        this.btnAdvancedOptions = new Button(composite, 0);
        this.btnAdvancedOptions.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.formToolkit.adapt((Control)this.btnAdvancedOptions, true, true);
        this.btnAdvancedOptions.setText(Xlat.label((String)"SERVICEEDIT_BUTTON_ADVANCED_OPTIONS"));
        this.btnAdvancedOptions.setToolTipText(Xlat.label((String)"SERVICEEDIT_BUTTON_ADVANCED_OPTIONS_TOOLTIP"));
        this.btnAdvancedOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    AdvancedDataConversionOptionsController selectAdvMobDataConvOpController = new AdvancedDataConversionOptionsController(ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel());
                    selectAdvMobDataConvOpController.saveAdvancedOptions();
                    Shell activeShell = Display.getDefault().getActiveShell();
                    AdvancedDataConversionOptionsDialog selAdvDialog = new AdvancedDataConversionOptionsDialog(activeShell, selectAdvMobDataConvOpController);
                    int result = selAdvDialog.open();
                    ImsCompositeImpl.this.advancedOptionsServiceModelController = ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel();
                    if (result == 0) {
                        ImsCompositeImpl.this.spe.setDirty(true);
                        if (ImsCompositeImpl.this.comboRequestSI.getSelectionIndex() != -1 && ImsCompositeImpl.this.comboResponseSI.getSelectionIndex() != -1) {
                            String requestSiName = ImsCompositeImpl.this.comboRequestSI.getItem(ImsCompositeImpl.this.comboRequestSI.getSelectionIndex());
                            String responseSiName = ImsCompositeImpl.this.comboResponseSI.getItem(ImsCompositeImpl.this.comboResponseSI.getSelectionIndex());
                            if (requestSiName != null && responseSiName != null) {
                                List<ServiceProjectValidationError> validationErrorsResp;
                                ImsCompositeImpl.this.spe.getServiceProjectValidator().removeMessages(ImsCompositeImpl.this.spe.getMessageManager(), (Control)ImsCompositeImpl.this.comboResponseSI);
                                boolean needToCheckLLZZForEditorChange = false;
                                if (requestSiName.equals(responseSiName)) {
                                    needToCheckLLZZForEditorChange = true;
                                }
                                if ((validationErrorsResp = new ImsPropertiesValidator().validateResponse(ImsCompositeImpl.this.spe.getServiceProjectController().getServiceModel().getResource(), ImsCompositeImpl.this.comboResponseSI.getText(), needToCheckLLZZForEditorChange, false, ImsCompositeImpl.this.advancedOptionsServiceModelController)) != null && !validationErrorsResp.isEmpty()) {
                                    Iterator<ServiceProjectValidationError> it = validationErrorsResp.iterator();
                                    int count = 0;
                                    while (it.hasNext()) {
                                        ServiceProjectValidationError currError = it.next();
                                        if (currError.getSeverity().equals(1)) {
                                            ImsCompositeImpl.this.spe.getServiceProjectValidator().setControlToWarning(ImsCompositeImpl.this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)ImsCompositeImpl.this.comboResponseSI);
                                            continue;
                                        }
                                        ImsCompositeImpl.this.spe.getServiceProjectValidator().setControlToError(ImsCompositeImpl.this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)ImsCompositeImpl.this.comboResponseSI);
                                    }
                                }
                            }
                        }
                    }
                    if (result == 1) {
                        selectAdvMobDataConvOpController.restoreAdvancedOptions();
                    }
                }
                catch (Exception e1) {
                    ZCeeUILogger.error((Throwable)e1);
                    ZCeeErrorDialog.openError((Exception)e1);
                }
            }
        });
        composite.setTabList(new Control[]{this.btnComposeSI, this.btnImportSI, this.comboRequestSI, this.btnEditRequestSI, this.comboResponseSI, this.btnEditResponseSI, this.btnAdvancedOptions});
        this.btnEditResponseSI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String siName = ImsCompositeImpl.this.comboResponseSI.getText();
                if (siName != null && !siName.isEmpty() && ImsCompositeImpl.this.getSiFileNameList().contains(siName)) {
                    try {
                        IFile newPgmInterfaceFile = ProjectTreeFileHelper.getzCEEProgramMsgFile((String)ImsCompositeImpl.this.spe.getProjectName(), (String)siName);
                        ImsCompositeImpl.this.spe.launchPgmInterfaceEditor(newPgmInterfaceFile);
                    }
                    catch (Exception e1) {
                        ZCeeUILogger.error((Throwable)e1);
                        ZCeeErrorDialog.openError((Exception)e1);
                    }
                }
            }
        });
        ZCeeUILogger.exiting((String)this.className, (String)"getDefineReqRespServiceInterfaceComposite", (Object[])new Object[]{composite});
        return composite;
    }

    public void refreshPage(Properties properties) {
        ZCeeUILogger.entering((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
        for (Object keyObj : properties.keySet()) {
            String key;
            switch (key = (String)keyObj) {
                case "executableName": {
                    this.txtTransNameText.setText(properties.getProperty(key));
                    break;
                }
                case "responseSIName": {
                    this.updateComboOptions(this.comboResponseSI, false);
                    this.validateResponseCombo();
                    break;
                }
                case "requestSIName": {
                    this.updateComboOptions(this.comboRequestSI, true);
                    this.validateRequestCombo();
                }
                case "imsTranCodeSpaceDelimited": {
                    this.isTrancodeSpaceDelimited();
                    break;
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"refreshPage", (Object[])new Object[0]);
    }

    public List<String> getSiFileNameList() {
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            IResource[] iResourceArray = this.spe.getServiceProjectController().getFolder("service-interfaces").members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getFileExtension().equalsIgnoreCase("si")) {
                    fileNames.add(resource.getName());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
        return fileNames;
    }

    private void serviceInterfaceSelection() {
        ServiceInterfaceSelectionDialog dialog = new ServiceInterfaceSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.spe.getServiceProjectController(), true);
        dialog.open();
    }

    private void updateComboOptions(Combo combo, boolean isRequestCombo) {
        ZCeeUILogger.entering((String)this.className, (String)"updateComboOptions", (Object[])new Object[]{combo, "isRequestCombo: " + isRequestCombo});
        combo.removeAll();
        for (String fileName : this.getSiFileNameList()) {
            combo.add(fileName);
        }
        IServiceModelController servModelCtrl = this.spe.getServiceProjectController().getServiceModel();
        if (isRequestCombo) {
            String modelRequestSIName = servModelCtrl.getServiceRequestSIName();
            List<String> comboRequestItems = Arrays.asList(this.comboRequestSI.getItems());
            if (modelRequestSIName != null && !modelRequestSIName.isEmpty() && comboRequestItems.contains(modelRequestSIName)) {
                this.comboRequestSI.setText(modelRequestSIName);
            } else if (!comboRequestItems.isEmpty()) {
                this.comboRequestSI.select(0);
            } else {
                this.comboRequestSI.clearSelection();
                this.comboRequestSI.setText("");
            }
            if (this.btnEditRequestSI != null) {
                String comboRequestSIName = this.comboRequestSI.getText();
                if (comboRequestSIName == null || comboRequestSIName.isEmpty()) {
                    this.btnEditRequestSI.setEnabled(false);
                    if (modelRequestSIName != null && !modelRequestSIName.isEmpty()) {
                        boolean tempLoading = this.spe.isLoading();
                        this.spe.setLoading(false);
                        this.spe.setDirty(true);
                        this.spe.setLoading(tempLoading);
                        servModelCtrl.setServiceRequestSIName("");
                    }
                } else {
                    this.btnEditRequestSI.setEnabled(true);
                }
            }
        } else {
            String modelResponseSIName = servModelCtrl.getServiceResponseSIName();
            List<String> comboResponseItems = Arrays.asList(this.comboResponseSI.getItems());
            if (modelResponseSIName != null && !modelResponseSIName.isEmpty() && comboResponseItems.contains(modelResponseSIName)) {
                this.comboResponseSI.setText(modelResponseSIName);
            } else if (!comboResponseItems.isEmpty()) {
                this.comboResponseSI.select(0);
            } else {
                this.comboResponseSI.clearSelection();
                this.comboResponseSI.setText("");
            }
            if (this.btnEditResponseSI != null) {
                String comboResponseSIName = this.comboResponseSI.getText();
                if (comboResponseSIName == null || comboResponseSIName.isEmpty()) {
                    this.btnEditResponseSI.setEnabled(false);
                    if (modelResponseSIName != null && !modelResponseSIName.isEmpty()) {
                        boolean tempLoading = this.spe.isLoading();
                        this.spe.setLoading(false);
                        this.spe.setDirty(true);
                        this.spe.setLoading(tempLoading);
                        servModelCtrl.setServiceResponseSIName("");
                    }
                } else {
                    this.btnEditResponseSI.setEnabled(true);
                }
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"updateComboOptions", (Object[])new Object[0]);
    }

    private void validateRequestCombo() {
        List<ServiceProjectValidationError> validationErrors;
        ZCeeUILogger.entering((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
        if (this.comboRequestSI.getSelectionIndex() != -1 && !this.spe.getServiceProjectController().getServiceModel().getServiceRequestSIName().equals(this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex()))) {
            this.spe.getServiceProjectController().getServiceModel().setServiceRequestSIName(this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex()));
            boolean tempLoading = this.spe.isLoading();
            this.spe.setLoading(false);
            this.spe.setDirty(true);
            this.spe.setLoading(tempLoading);
        }
        if (this.comboRequestSI.getSelectionIndex() != -1 && this.comboResponseSI.getSelectionIndex() != -1) {
            String requestSiName = this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex());
            String responseSiName = this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex());
            if (requestSiName != null && responseSiName != null) {
                List<ServiceProjectValidationError> validationErrorsResp;
                this.spe.getServiceProjectValidator().removeMessages(this.spe.getMessageManager(), (Control)this.comboResponseSI);
                boolean needToCheckLLZZForEditorChange = false;
                if (requestSiName.equals(responseSiName)) {
                    needToCheckLLZZForEditorChange = true;
                }
                if ((validationErrorsResp = new ImsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText(), needToCheckLLZZForEditorChange, false, this.advancedOptionsServiceModelController)) != null && !validationErrorsResp.isEmpty()) {
                    Iterator<ServiceProjectValidationError> it = validationErrorsResp.iterator();
                    int count = 0;
                    while (it.hasNext()) {
                        ServiceProjectValidationError currError = it.next();
                        if (currError.getSeverity().equals(1)) {
                            this.spe.getServiceProjectValidator().setControlToWarning(this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)this.comboResponseSI);
                            continue;
                        }
                        this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)this.comboResponseSI);
                    }
                }
            }
        }
        if ((validationErrors = new ImsPropertiesValidator().validateRequest(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboRequestSI.getText(), false)) != null && !validationErrors.isEmpty()) {
            ServiceProjectValidationError firstError = validationErrors.get(0);
            this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), "requestSIName", firstError, (Control)this.comboRequestSI);
        } else {
            this.spe.getServiceProjectValidator().resetControlToError(this.spe.getMessageManager(), "requestSIName", (Control)this.comboRequestSI);
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateRequestCombo", (Object[])new Object[0]);
    }

    private void validateResponseCombo() {
        ZCeeUILogger.entering((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
        this.spe.getServiceProjectValidator().removeMessages(this.spe.getMessageManager(), (Control)this.comboResponseSI);
        if (this.comboResponseSI.getSelectionIndex() != -1 && !this.spe.getServiceProjectController().getServiceModel().getServiceResponseSIName().equals(this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex()))) {
            this.spe.getServiceProjectController().getServiceModel().setServiceResponseSIName(this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex()));
            boolean tempLoading = this.spe.isLoading();
            this.spe.setLoading(false);
            this.spe.setDirty(true);
            this.spe.setLoading(tempLoading);
        }
        List<ServiceProjectValidationError> validationErrorsResp = null;
        if (this.comboRequestSI.getSelectionIndex() != -1 && this.comboResponseSI.getSelectionIndex() != -1) {
            boolean needToCheckLLZZForEditorChange = false;
            String requestSiName = this.comboRequestSI.getItem(this.comboRequestSI.getSelectionIndex());
            String responseSiName = this.comboResponseSI.getItem(this.comboResponseSI.getSelectionIndex());
            if (requestSiName != null && responseSiName != null && requestSiName.equals(responseSiName)) {
                needToCheckLLZZForEditorChange = true;
            }
            validationErrorsResp = new ImsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText(), needToCheckLLZZForEditorChange, false, this.advancedOptionsServiceModelController);
        } else {
            validationErrorsResp = new ImsPropertiesValidator().validateResponse(this.spe.getServiceProjectController().getServiceModel().getResource(), this.comboResponseSI.getText(), false, false, null);
        }
        if (validationErrorsResp != null && !validationErrorsResp.isEmpty()) {
            Iterator<ServiceProjectValidationError> it = validationErrorsResp.iterator();
            int count = 0;
            while (it.hasNext()) {
                ServiceProjectValidationError currError = it.next();
                if (currError.getSeverity().equals(1)) {
                    this.spe.getServiceProjectValidator().setControlToWarning(this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)this.comboResponseSI);
                    continue;
                }
                this.spe.getServiceProjectValidator().setControlToError(this.spe.getMessageManager(), "responseSIName" + count++, currError, (Control)this.comboResponseSI);
            }
        }
        ZCeeUILogger.exiting((String)this.className, (String)"validateResponseCombo", (Object[])new Object[0]);
    }

    public boolean isTrancodeSpaceDelimited() {
        String value = this.spe.getServiceProjectController().getServiceModel().getValue("imsTranCodeSpaceDelimited");
        return value != null && value.contentEquals("true");
    }
}

