/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.service.ims;

import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.service.controllers.model.interfaces.IServiceCapabilitiesValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ImsldsCapabilitiesValidator
implements IServiceCapabilitiesValidator {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2018. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VALIDATOR_ID = "ibm.services.imslds.";

    public ArrayList<String> getExploitedCapabilityList(IProject project) {
        ArrayList<String> usedCapabilities = new ArrayList<String>();
        IFile propsFile = (IFile)project.findMember("service.properties", false);
        InputStream is = null;
        try {
            try {
                Boolean isSpcDelim;
                is = propsFile.getContents();
                Properties props = new Properties();
                props.load(is);
                String spcDelimValStr = props.getProperty("imsTranCodeSpaceDelimited");
                if (spcDelimValStr != null && !spcDelimValStr.isEmpty() && (isSpcDelim = Boolean.valueOf(spcDelimValStr)).booleanValue()) {
                    usedCapabilities.add("ibm.services.imslds.trancodeSpaceDelimited");
                }
            }
            catch (IOException | CoreException e) {
                EclipseLogger.logError((Throwable)e);
                try {
                    is.close();
                }
                catch (IOException e2) {
                    EclipseLogger.logError((Throwable)e2);
                }
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                EclipseLogger.logError((Throwable)e);
            }
        }
        return usedCapabilities;
    }
}

