/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.io.IOException;
import java.math.BigDecimal;

public class MarshallFloatUtils {
    private static final String copyright = "Copyright IBM Corporation 2001, 2011.";
    public static final int FLOAT_FORMAT_UNSPECIFIED = 0;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_INTEL = 1;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_AIX = 2;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_OS390 = 3;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_AS400 = 4;
    public static final int FLOAT_FORMAT_IEEE_NON_EXTENTED = 5;
    public static final int FLOAT_FORMAT_IBM_390_HEX = 6;
    public static final int FLOAT_FORMAT_IBM_400_HEX = 7;
    public static final int FLOAT_FORMAT_IEEE_DFP_IBM = 8;

    public static void marshallFloatIntoBuffer(BigDecimal value, byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        switch (size) {
            case 4: {
                if (floatType == 8) {
                    byte[] tb = ConversionUtils.convertBigDecimalToIBMDFPShort(value);
                    if (!isBigEndian) {
                        ConversionUtils.endianSwap(tb);
                    }
                    System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
                    break;
                }
                float floatValue = value.floatValue();
                MarshallFloatUtils.marshallFloatIntoBuffer(floatValue, buffer, startingOffset, isBigEndian, floatType, size);
                break;
            }
            case 8: {
                if (floatType == 8) {
                    byte[] tb = ConversionUtils.convertBigDecimalToIBMDFPLong(value);
                    if (!isBigEndian) {
                        ConversionUtils.endianSwap(tb);
                    }
                    System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
                    break;
                }
                double doubleValue = value.doubleValue();
                MarshallFloatUtils.marshallFloatIntoBuffer(doubleValue, buffer, startingOffset, isBigEndian, floatType, size);
                break;
            }
            case 16: {
                byte[] tb = null;
                switch (floatType) {
                    case 1: {
                        tb = ConversionUtils.convertBigDecimalToIEEEExtendedIntel(value);
                        break;
                    }
                    case 2: {
                        tb = ConversionUtils.convertBigDecimalToIEEEExtendedAIX(value);
                        break;
                    }
                    case 3: {
                        tb = ConversionUtils.convertBigDecimalToIEEEExtendedOS390(value);
                        break;
                    }
                    case 6: 
                    case 7: {
                        tb = ConversionUtils.convertBigDecimalToIBM390HexExtended(value);
                        break;
                    }
                    case 8: {
                        tb = ConversionUtils.convertBigDecimalToIBMDFPExtended(value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_16_NOT_SUPPORTED"));
                    }
                }
                if (!isBigEndian) {
                    ConversionUtils.endianSwap(tb);
                }
                System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
    }

    public static void marshallFloatIntoBuffer(double value, byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        byte[] tb = null;
        if (size != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        if (floatType == 6 || floatType == 7) {
            try {
                long s390Value = ConversionUtils.doubleToS390LongBits(value);
                tb = ConversionUtils.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        } else {
            tb = floatType == 8 ? ConversionUtils.convertBigDecimalToIBMDFPLong(new BigDecimal(Double.toString(value))) : ConversionUtils.convertToByte(value);
        }
        if (!isBigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static void marshallFloatIntoBuffer(float value, byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        byte[] tb = null;
        if (size != 4) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        if (floatType == 6 || floatType == 7) {
            try {
                int s390Value = ConversionUtils.floatToS390IntBits(value);
                tb = ConversionUtils.convertToByte(s390Value);
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        } else {
            tb = floatType == 8 ? ConversionUtils.convertBigDecimalToIBMDFPShort(new BigDecimal(Float.toString(value))) : ConversionUtils.convertToByte(value);
        }
        if (!isBigEndian) {
            ConversionUtils.endianSwap(tb);
        }
        System.arraycopy(tb, 0, buffer, startingOffset, tb.length);
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        BigDecimal result = null;
        switch (size) {
            case 4: {
                if (floatType == 8) {
                    return MarshallFloatUtils.unmarshallIBMDFPShortFromBuffer(buffer, startingOffset, isBigEndian, floatType, size);
                }
                float floatResult = MarshallFloatUtils.unmarshallFloatFromBuffer(buffer, startingOffset, isBigEndian, floatType, size);
                result = new BigDecimal(Float.toString(floatResult));
                break;
            }
            case 8: {
                if (floatType == 8) {
                    return MarshallFloatUtils.unmarshallIBMDFPLongFromBuffer(buffer, startingOffset, isBigEndian, floatType, size);
                }
                double doubleResult = MarshallFloatUtils.unmarshallDoubleFromBuffer(buffer, startingOffset, isBigEndian, floatType, size);
                result = new BigDecimal(Double.toString(doubleResult));
                break;
            }
            case 16: {
                byte[] sb = null;
                sb = floatType == 1 ? new byte[10] : new byte[16];
                System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
                if (!isBigEndian) {
                    ConversionUtils.endianSwap(sb);
                }
                String fpString = null;
                switch (floatType) {
                    case 1: {
                        fpString = ConversionUtils.convertIEEEExtendedIntelToString(sb);
                        break;
                    }
                    case 2: {
                        fpString = ConversionUtils.convertIEEEExtendedAIXToString(sb);
                        break;
                    }
                    case 3: {
                        fpString = ConversionUtils.convertIEEEExtendedOS390ToString(sb);
                        break;
                    }
                    case 6: 
                    case 7: {
                        fpString = ConversionUtils.convertIBM390HexExtendedToString(sb);
                        break;
                    }
                    case 8: {
                        return ConversionUtils.convertIBMDFPExtendedToBigDecimal(sb);
                    }
                    default: {
                        throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_16_NOT_SUPPORTED"));
                    }
                }
                result = new BigDecimal(fpString);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
            }
        }
        return result;
    }

    public static double unmarshallDoubleFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        if (size != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        byte[] sb = new byte[8];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        double result = 0.0;
        if (floatType == 6 || floatType == 7) {
            try {
                result = ConversionUtils.longS390BitsToDouble(ConversionUtils.convertFromByteToLong(sb));
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        } else if (floatType == 8) {
            BigDecimal bd = ConversionUtils.convertIBMDFPLongToBigDecimal(sb);
            result = bd.doubleValue();
        } else {
            result = ConversionUtils.convertFromByteToDouble(sb);
        }
        return result;
    }

    public static float unmarshallFloatFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) throws IllegalArgumentException {
        if (size != 4) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        byte[] sb = new byte[4];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        float result = 0.0f;
        if (floatType == 6 || floatType == 7) {
            try {
                result = ConversionUtils.intS390BitsToFloat(ConversionUtils.convertFromByteToInt(sb));
            }
            catch (IOException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        } else if (floatType == 8) {
            BigDecimal bd = ConversionUtils.convertIBMDFPShortToBigDecimal(sb);
            result = bd.floatValue();
        } else {
            result = ConversionUtils.convertFromByteToFloat(sb);
        }
        return result;
    }

    public static BigDecimal unmarshallIBMDFPShortFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) {
        if (size != 4) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        if (floatType != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FLOAT_TYPE_NOT_VALID", Integer.toString(floatType)));
        }
        byte[] sb = new byte[4];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        BigDecimal result = ConversionUtils.convertIBMDFPShortToBigDecimal(sb);
        return result;
    }

    public static BigDecimal unmarshallIBMDFPLongFromBuffer(byte[] buffer, int startingOffset, boolean isBigEndian, int floatType, int size) {
        if (size != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(size)));
        }
        if (floatType != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FLOAT_TYPE_NOT_VALID", Integer.toString(floatType)));
        }
        byte[] sb = new byte[8];
        System.arraycopy(buffer, startingOffset, sb, 0, sb.length);
        if (!isBigEndian) {
            ConversionUtils.endianSwap(sb);
        }
        BigDecimal result = ConversionUtils.convertIBMDFPLongToBigDecimal(sb);
        return result;
    }
}

