/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;
import java.math.BigInteger;

public class BigIntegerRange
implements IRangeObject {
    private static String copyright = "Copyright IBM Corporation 2000, 2004.";
    private static final long serialVersionUID = 5L;
    protected BigInteger lowerRange_;
    protected BigInteger upperRange_;

    public BigIntegerRange() {
        this.lowerRange_ = BigInteger.ZERO;
        this.upperRange_ = BigInteger.ZERO;
    }

    public BigIntegerRange(BigInteger lowerRange, BigInteger upperRange) throws IllegalArgumentException {
        if (lowerRange.compareTo(upperRange) == 1) {
            throw new IllegalArgumentException(upperRange.toString());
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    @Override
    public Object clone() {
        try {
            BigIntegerRange newType = (BigIntegerRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BigIntegerRange)) {
            return false;
        }
        BigIntegerRange tmpRange = (BigIntegerRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    @Override
    public Object getLowerRange() {
        return this.lowerRange_;
    }

    @Override
    public Object getUpperRange() {
        return this.upperRange_;
    }

    @Override
    public boolean isInRange(Object value) {
        if (!(value instanceof BigInteger)) {
            return false;
        }
        return BigIntegerRange.isInRange(this.lowerRange_, this.upperRange_, (BigInteger)value);
    }

    public static boolean isInRange(BigInteger lowerRange, BigInteger upperRange, BigInteger value) throws IllegalArgumentException {
        if (lowerRange.compareTo(upperRange) == 1) {
            throw new IllegalArgumentException(upperRange.toString());
        }
        return value.compareTo(lowerRange) != -1 && value.compareTo(upperRange) != 1;
    }

    @Override
    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof BigInteger)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (BigInteger)value;
    }

    @Override
    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof BigInteger)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (BigInteger)value;
    }
}

