/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.utils;

import com.ibm.zcc.ccl.annotations.resource.Messages;
import java.util.StringTokenizer;

public class QualifiedName {
    private String orig;
    private String[] pieces = null;

    public QualifiedName(String qname) throws IllegalArgumentException {
        if (qname == null) {
            throw new IllegalArgumentException(Messages.Null_Qualified_Name);
        }
        this.orig = qname;
    }

    private String[] getPieces() {
        if (this.pieces == null) {
            StringTokenizer st = new StringTokenizer(this.orig, ".");
            this.pieces = new String[st.countTokens()];
            int i = 0;
            while (i < this.pieces.length) {
                this.pieces[i] = st.nextToken();
                ++i;
            }
        }
        return this.pieces;
    }

    public boolean isEmptyName() {
        return this.getPieces().length == 0;
    }

    public String last() {
        if (!this.isEmptyName()) {
            return this.pieces[this.pieces.length - 1];
        }
        return null;
    }

    public int numPieces() {
        return this.getPieces().length;
    }

    public String piece(int index) {
        return this.getPieces()[index];
    }

    public void setPiece(int index, String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.Null_Name);
        }
        if (name.indexOf(46) != -1) {
            throw new IllegalArgumentException(Messages.Char_Not_Allowed);
        }
        this.getPieces()[index] = name;
    }

    public String coalescePieces(int start, int end) {
        if (start > end) {
            return null;
        }
        StringBuffer acc = new StringBuffer(this.orig.length() * 2);
        this.getPieces();
        int i = start;
        while (i <= end) {
            acc.append(this.pieces[i]);
            if (i != end) {
                acc.append('.');
            }
            ++i;
        }
        return acc.toString();
    }

    public String allButLastPiece() {
        String[] p = this.getPieces();
        if (p.length < 2) {
            return Messages.Blank;
        }
        return this.coalescePieces(0, p.length - 2);
    }

    public String getOriginalName() {
        return this.orig;
    }
}

