/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource;

import com.ibm.zcc.ws.rd.io.services.JARUtil;
import com.ibm.zcc.ws.rd.resource.ResourceUtility;
import com.ibm.zcc.ws.rd.utils.ResourceFinder;
import com.ibm.zcc.wsspi.rd.resources.IWRDResourceAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class WRDResourceAdapter
implements IWRDResourceAdapter {
    private static Map adapterInstances = null;
    private IResource _resource;
    private List mappedLocations;
    private List generatedParts;
    private Hashtable jarResourcePaths;

    protected WRDResourceAdapter(IResource resource) {
        this.init();
        this._resource = resource;
    }

    protected static WRDResourceAdapter getWRDResourceAdapter(IResource resource) {
        WRDResourceAdapter adapter;
        if (adapterInstances == null) {
            adapterInstances = new WeakHashMap();
        }
        if ((adapter = (WRDResourceAdapter)adapterInstances.get(resource)) == null && resource.exists()) {
            adapter = new WRDResourceAdapter(resource);
            adapterInstances.put(resource, adapter);
        }
        return adapter;
    }

    protected static Collection getAdapters() {
        if (adapterInstances == null) {
            adapterInstances = new WeakHashMap();
        }
        return adapterInstances.values();
    }

    private void init() {
        this.mappedLocations = new ArrayList();
        this.generatedParts = new ArrayList();
        this.jarResourcePaths = new Hashtable();
    }

    public IResource getResource() {
        return this._resource;
    }

    @Override
    public IResource[] getMappedLocations() {
        return this.mappedLocations.toArray(new IResource[this.mappedLocations.size()]);
    }

    @Override
    public IResource[] getGeneratedParts() {
        ArrayList<IFile> allGenerated = new ArrayList<IFile>();
        allGenerated.addAll(this.generatedParts);
        try {
            IFile searchResult;
            if (this._resource.getFileExtension() != null && this._resource.getFileExtension().equals("java") && (searchResult = this.doSearch(true)) != null) {
                allGenerated.add(searchResult);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return allGenerated.toArray(new IResource[allGenerated.size()]);
    }

    private IFile doSearch(boolean searchForGenerated) throws CoreException, JavaModelException {
        if (this._resource.getProject().isOpen() && this._resource.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)this._resource.getProject());
            IPath output = javaProject.getOutputLocation();
            IPath[] srcFolders = ResourceUtility.getSourceFolderEntries(javaProject);
            ResourceFinder finder = new ResourceFinder();
            IPath filePath = this._resource.getFullPath();
            if (!filePath.toOSString().startsWith(output.toOSString())) {
                int i = 0;
                while (i < srcFolders.length) {
                    if (filePath.toOSString().startsWith(srcFolders[i].toOSString())) {
                        String append = filePath.toOSString().substring(srcFolders[i].toOSString().length());
                        if (searchForGenerated && append.endsWith(".java")) {
                            int index = append.lastIndexOf(".java");
                            append = append.substring(0, index).concat(".class");
                        }
                        IPath searchFor = output.removeFirstSegments(1).append(append);
                        IResource resource = finder.find(this._resource.getProject(), searchFor);
                        if (resource != null && resource != this._resource) {
                            return (IFile)resource;
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    @Override
    public void addGeneratedPart(IResource resource) {
        try {
            if (!resource.isLocal(0)) {
                resource.refreshLocal(0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (resource.exists() && !this.generatedParts.contains(resource)) {
            this.generatedParts.add(resource);
        }
    }

    @Override
    public void addMappedLocation(IResource resource) {
        if (resource.exists() && !this.mappedLocations.contains(resource)) {
            this.mappedLocations.add(resource);
        }
    }

    @Override
    public void addJarMappedLocation(String path, IResource jarResource) {
        if (jarResource.exists()) {
            if (!this.mappedLocations.contains(jarResource)) {
                this.mappedLocations.add(jarResource);
            }
            this.jarResourcePaths.put(path, jarResource.getFullPath().toOSString());
        }
    }

    @Override
    public String[][] getJarMappedLocations() {
        if (this.jarResourcePaths.size() == 0) {
            return null;
        }
        String[][] jarMaps = new String[this.jarResourcePaths.size()][2];
        Enumeration elements = this.jarResourcePaths.keys();
        int i = 0;
        while (elements.hasMoreElements()) {
            String key = elements.nextElement().toString();
            String value = this.jarResourcePaths.get(key).toString();
            jarMaps[i][0] = key;
            jarMaps[i][1] = value;
            ++i;
        }
        return jarMaps;
    }

    @Override
    public boolean removeMappedParts() {
        boolean result = this.removeResources(this.mappedLocations);
        if (!this.hasAnyMappings()) {
            this.discard();
        }
        return result;
    }

    @Override
    public boolean removeGeneratedParts() {
        boolean result = this.removeResources(this.generatedParts);
        if (!this.hasAnyMappings()) {
            this.discard();
        }
        return result;
    }

    @Override
    public IResource getGeneratedFromResource() {
        Set adapters = adapterInstances.keySet();
        Iterator i = adapters.iterator();
        IResource parent = null;
        while (i.hasNext()) {
            WRDResourceAdapter adapter = (WRDResourceAdapter)i.next();
            IResource[] resources = adapter.getGeneratedParts();
            int j = 0;
            while (j < resources.length) {
                if (resources[j] == this._resource) {
                    parent = adapter.getResource();
                    break;
                }
                ++j;
            }
            if (parent == null) continue;
            return parent;
        }
        return parent;
    }

    @Override
    public IResource getMappedFromResource() {
        Set adapters = adapterInstances.keySet();
        Iterator i = adapters.iterator();
        IResource parent = null;
        while (i.hasNext()) {
            WRDResourceAdapter adapter = (WRDResourceAdapter)i.next();
            IResource[] resources = adapter.getMappedLocations();
            int j = 0;
            while (j < resources.length) {
                if (resources[j] == this._resource) {
                    parent = adapter.getResource();
                    break;
                }
                ++j;
            }
            if (parent == null) continue;
            return parent;
        }
        return parent;
    }

    private boolean removeResources(List list) {
        ListIterator i = list.listIterator();
        while (i.hasNext()) {
            IResource aFile = (IResource)i.next();
            if (!aFile.exists() || !aFile.isDerived()) continue;
            try {
                if (aFile.getFileExtension() != null && aFile.getFileExtension().equals("jar")) {
                    Enumeration keys = this.jarResourcePaths.keys();
                    while (keys.hasMoreElements()) {
                        String jarDest = keys.nextElement().toString();
                        String jarPath = this.jarResourcePaths.get(jarDest).toString();
                        JARUtil.removeFileFromJar((IFile)this._resource, jarDest, ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(jarPath)));
                    }
                    continue;
                }
                aFile.delete(false, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }
        list.clear();
        return true;
    }

    @Override
    public boolean removeCachedGeneratedPart(IResource generatedResource) {
        if (generatedResource == null) {
            return false;
        }
        return this.generatedParts.remove(generatedResource);
    }

    @Override
    public boolean hasAnyMappings() {
        return !this.generatedParts.isEmpty() || !this.mappedLocations.isEmpty();
    }

    @Override
    public void discard() {
        if (this._resource != null) {
            adapterInstances.remove(this._resource);
        }
    }
}

