/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.resource;

import com.ibm.zcc.ccl.annotations.resource.Messages;
import com.ibm.zcc.ccl.annotations.resource.ResourcePlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.UIContextDetermination;

public class ResourceProblemManager
implements IResourceChangeListener {
    private static final String annotProblemMarker = "com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationProblemMarker";
    private static final String problemSuperType = "org.eclipse.core.resources.problemmarker";

    public boolean isFile(IResource r) {
        if (r != null) {
            return r.getType() == 1;
        }
        return false;
    }

    public boolean isRunningHeadless() {
        return UIContextDetermination.getCurrentContext() == 102;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.isRunningHeadless()) {
            if (event.getType() != 16) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            final ArrayList changed = new ArrayList();
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (delta.getKind() != 1) {
                        if (resource.getType() == 1) {
                            changed.add(resource);
                        }
                        return true;
                    }
                    if ((delta.getFlags() & 0x100) == 0) {
                        if (resource.getType() == 1) {
                            changed.add(resource);
                        }
                        return true;
                    }
                    return true;
                }
            };
            try {
                rootDelta.accept(visitor);
            }
            catch (CoreException coreException) {
                return;
            }
            if (changed.size() == 0) {
                return;
            }
            try {
                this.processProblemMarkers(changed);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    public void processProblemMarkers(List changed) throws CoreException {
        int numChanged = changed.size();
        int i = 0;
        while (i < numChanged) {
            IResource r = (IResource)changed.get(i);
            IMarker[] markers = r.findMarkers(problemSuperType, true, 2);
            if (markers == null) {
                return;
            }
            int j = 0;
            while (j < markers.length) {
                IResource resource;
                IMarker marker = markers[j];
                if (marker != null && marker.isSubtypeOf(problemSuperType) && (resource = marker.getResource()) != null) {
                    try {
                        String markerMessage = this.constructMarkerMessage(marker);
                        int sev = (Integer)marker.getAttribute("severity");
                        if (sev == 2) {
                            if (!markerMessage.equals("")) {
                                ResourcePlugin.logError(markerMessage, null);
                            }
                        } else if (sev < 2 && !markerMessage.equals("")) {
                            ResourcePlugin.logError(markerMessage, null);
                        }
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public String constructMarkerMessage(IMarker marker) throws CoreException {
        boolean displayAnnotationMessage = false;
        Integer charStart = null;
        String tagName = null;
        if (marker.getType().equals(annotProblemMarker)) {
            tagName = (String)marker.getAttribute("annotationTagName");
            charStart = (Integer)marker.getAttribute("charStart");
            displayAnnotationMessage = true;
        }
        String message = (String)marker.getAttribute("message");
        String resourceID = marker.getResource().getName();
        Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
        ArrayList<String> messageContainer = new ArrayList<String>();
        if (tagName != null) {
            messageContainer.add(tagName);
        }
        if (message != null) {
            messageContainer.add(message);
        }
        if (charStart != null) {
            messageContainer.add(charStart.toString());
        }
        if (resourceID != null) {
            messageContainer.add(resourceID);
        }
        if (lineNumber != null) {
            messageContainer.add(lineNumber.toString());
        } else if (!displayAnnotationMessage) {
            messageContainer.add("?");
        }
        Object[] stringMsgs = messageContainer.toArray(new String[messageContainer.size()]);
        if (displayAnnotationMessage) {
            return Messages.bind((String)Messages.Annotation_Problem, (Object[])stringMsgs);
        }
        return Messages.bind((String)Messages.Resource_Problem, (Object[])stringMsgs);
    }
}

