/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.wizard.importds;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.DataStructureSegmentAssociation;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.InformationException;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.ImportParseException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.UnsupportedTypesException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ParseException;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.Utility;
import com.ibm.zosconnect.ui.programinterface.utilities.Warnings;
import com.ibm.zosconnect.ui.programinterface.wizard.importds.ImportDSExceptionDialog;
import com.ibm.zosconnect.ui.programinterface.wizard.importds.ImportDataSetWizard;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ImportDSTranMessageMetadataWizardPage
extends WizardPage
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private TranDataStructureController controller;
    private Label fileLabel;
    private Label folderLabel;
    private Combo importFromField;
    private Combo sourceTypeField;
    private Combo folderNameField;
    private Button sourceBrowseButton;
    private Combo fileNameField;
    private Combo dataStructureField;
    private Combo segmentNameField;
    private Combo messageNameField;
    private Button associateButton;
    private Button removeButton;
    private Table associationTable;
    private int buttonWidth;
    private boolean entryChanged = false;
    private boolean showImportList = false;
    private static Logger logger;
    private String sourceFolderStr;
    private String sourceFileStr;
    private String sourceFileTypeStr;
    private Composite compContents;
    public Vector<InformationException> parsingInformationExceptionList;
    private static final String STORE_LOCAL_SOURCE_NAMES_ID = "ImportDSTranMessageMetadataWizardPage.STORE_LOCAL_SOURCE_NAMES_ID";
    private static final String STORE_HOST_SOURCE_NAMES_ID = "ImportDSTranMessageMetadataWizardPage.STORE_HOST_SOURCE_NAMES_ID";
    private static final String[] sourceTypes;
    private ServiceArchiveConstants.SP_Type spType;

    static {
        sourceTypes = new String[]{PgmIntXlat.getLabel().getString("IDSW_LOCAL_FILE"), PgmIntXlat.getLabel().getString("IDSW_ZOS")};
    }

    public ImportDSTranMessageMetadataWizardPage(String pageName, TranDataStructureController controller, ServiceArchiveConstants.SP_Type spType, boolean showImportList) {
        super(pageName);
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.controller = controller;
        this.spType = spType;
        this.showImportList = showImportList;
        this.setTitle(pageName);
        this.setDescription(PgmIntXlat.getDescription().getString("IDSW_DESC"));
        this.setImageDescriptor(Utility.getImageDescriptor("data_structure_imprt_wizard_64.gif"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)");
        try {
            String segmentName;
            parent.setBackground(this.formToolkit.getColors().getBackground());
            parent.setBackgroundMode(2);
            this.compContents = new Composite(parent, 0);
            this.setControl((Control)this.compContents);
            GridLayout gl_compContents = new GridLayout(3, false);
            gl_compContents.horizontalSpacing = 10;
            gl_compContents.marginTop = 5;
            gl_compContents.verticalSpacing = 10;
            this.compContents.setLayout((Layout)gl_compContents);
            GridData gd_compContents = new GridData(4, 4, true, true, 1, 1);
            this.compContents.setLayoutData((Object)gd_compContents);
            int fieldWidthHint = XSwt.getAverageCharWidth((Control)this.compContents) * 50;
            Label importFromLabel = new Label(this.compContents, 0);
            GridData gd_importFromLabel = new GridData(16384, 0x1000000, false, false);
            importFromLabel.setText(PgmIntXlat.getLabel().getString("IDSW_IMPORT_LBL"));
            importFromLabel.setLayoutData((Object)gd_importFromLabel);
            this.importFromField = new Combo(this.compContents, 2056);
            GridData gd_importFromField = new GridData(4, 0x1000000, true, false);
            gd_importFromField.horizontalSpan = 2;
            gd_importFromField.widthHint = fieldWidthHint;
            this.importFromField.setLayoutData((Object)gd_importFromField);
            this.importFromField.setItems(sourceTypes);
            if (this.controller.isLocalImport()) {
                this.importFromField.setText(sourceTypes[0]);
            } else {
                this.importFromField.setText(sourceTypes[1]);
            }
            Label sourceTypeLabel = new Label(this.compContents, 0);
            sourceTypeLabel.setText(PgmIntXlat.getLabel().getString("IDSW_FILE_TYPE_LBL"));
            GridData gd_sourceTypeLabel = new GridData(16384, 0x1000000, false, false);
            sourceTypeLabel.setLayoutData((Object)gd_sourceTypeLabel);
            this.sourceTypeField = new Combo(this.compContents, 2056);
            GridData gd_sourceTypeField = new GridData(4, 0x1000000, true, false);
            gd_sourceTypeField.horizontalSpan = 2;
            gd_sourceTypeField.widthHint = fieldWidthHint;
            this.sourceTypeField.setLayoutData((Object)gd_sourceTypeField);
            this.sourceTypeField.setItems(TranDataStructureController.sourceLanguages);
            String importLanguage = this.controller.getImportLanguage();
            if (importLanguage != null) {
                this.sourceTypeField.setText(importLanguage);
            } else {
                this.sourceTypeField.setText(TranDataStructureController.sourceLanguages[0]);
            }
            this.folderLabel = new Label(this.compContents, 0);
            GridData gd_folderLabel = new GridData(16384, 0x1000000, false, false);
            this.folderLabel.setLayoutData((Object)gd_folderLabel);
            if (this.controller.isLocalImport()) {
                this.folderLabel.setText(PgmIntXlat.getLabel().getString("IDSW_SOURCE_FLD_LBL"));
            } else {
                this.folderLabel.setText(PgmIntXlat.getLabel().getString("IDSW_SOURCE_PDS_LBL"));
            }
            this.folderNameField = new Combo(this.compContents, 2056);
            GridData gd_folderNameField = new GridData(4, 0x1000000, true, false);
            gd_folderNameField.horizontalSpan = 2;
            gd_folderNameField.widthHint = fieldWidthHint;
            this.folderNameField.setLayoutData((Object)gd_folderNameField);
            this.folderNameField.setText(this.restoreFolderValues());
            this.fileLabel = new Label(this.compContents, 0);
            GridData gd_fileLabel = new GridData(16384, 0x1000000, false, false);
            this.fileLabel.setLayoutData((Object)gd_fileLabel);
            if (this.controller.isLocalImport()) {
                this.fileLabel.setText(PgmIntXlat.getLabel().getString("IDSW_DS_FILE_LBL"));
            } else {
                this.fileLabel.setText(PgmIntXlat.getLabel().getString("IDSW_DS_MEM_LBL"));
            }
            this.fileLabel.setToolTipText(PgmIntXlat.getDescription().getString("IDSW_DESC_DSFILE"));
            this.fileNameField = new Combo(this.compContents, 2056);
            GridData gd_fileNameField = new GridData(4, 0x1000000, true, false);
            gd_fileNameField.widthHint = fieldWidthHint;
            this.fileNameField.setLayoutData((Object)gd_fileNameField);
            if (this.controller.isLocalImport() && !this.folderNameField.getText().isEmpty()) {
                this.populateFileCombo(this.folderNameField.getText());
            } else {
                this.fileNameField.setEnabled(false);
            }
            this.sourceBrowseButton = new Button(this.compContents, 8);
            GridData gd_sourceBrowseButton = new GridData(131072, 0x1000000, false, false);
            this.sourceBrowseButton.setLayoutData((Object)gd_sourceBrowseButton);
            this.sourceBrowseButton.setText(PgmIntXlat.getLabel().getString("IDSW_BROWSE_BUTTON"));
            Label dataStructureLabel = new Label(this.compContents, 0);
            dataStructureLabel.setText(PgmIntXlat.getLabel().getString("IDSW_DS_NAME_LBL"));
            GridData gd_dataStructureLabel = new GridData(16384, 0x1000000, false, false);
            dataStructureLabel.setLayoutData((Object)gd_dataStructureLabel);
            dataStructureLabel.setToolTipText(PgmIntXlat.getDescription().getString("IDSW_DESC_DSNAME"));
            this.dataStructureField = new Combo(this.compContents, 2056);
            GridData gd_dataStructureField = new GridData(4, 0x1000000, true, false);
            gd_dataStructureField.horizontalSpan = 2;
            gd_dataStructureField.widthHint = fieldWidthHint;
            this.dataStructureField.setLayoutData((Object)gd_dataStructureField);
            this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty());
            Label messageLabel = new Label(this.compContents, 0);
            GridData gd_messageLabel = new GridData(16384, 0x1000000, false, false);
            boolean bl = gd_messageLabel.exclude = !this.showImportList || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                messageLabel.setText(PgmIntXlat.getLabel().getString("IDSW_MSG_NAME_LBL"));
            } else {
                messageLabel.setText(PgmIntXlat.getLabel().getString("EM_CHANNEL_NAME") + Xlat.colon());
            }
            messageLabel.setLayoutData((Object)gd_messageLabel);
            messageLabel.setToolTipText(PgmIntXlat.getLabel().getString("IDSW_MSG_NAME_COLUMN"));
            this.messageNameField = new Combo(this.compContents, 2056);
            GridData gd_messageNameField = new GridData(4, 0x1000000, true, false);
            gd_messageNameField.exclude = !this.showImportList || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
            gd_messageNameField.widthHint = fieldWidthHint;
            gd_messageNameField.horizontalSpan = 2;
            this.messageNameField.setLayoutData((Object)gd_messageNameField);
            this.messageNameField.setEnabled(false);
            Label segmentLabel = new Label(this.compContents, 0);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                segmentLabel.setText(PgmIntXlat.getLabel().getString("IDSW_SEGNAME_LBL"));
            } else {
                segmentLabel.setText(PgmIntXlat.getLabel().getString("EC_CONTAINERNAME") + Xlat.colon());
            }
            GridData gd_segmentLabel = new GridData(16384, 0x1000000, false, false);
            gd_segmentLabel.exclude = !this.showImportList || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
            segmentLabel.setLayoutData((Object)gd_segmentLabel);
            segmentLabel.setToolTipText(PgmIntXlat.getDescription().getString("IDSW_DESC_SEGNAME"));
            this.segmentNameField = new Combo(this.compContents, 2056);
            GridData gd_segmentNameField = new GridData(4, 0x1000000, true, false);
            gd_segmentNameField.exclude = !this.showImportList || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
            gd_segmentNameField.widthHint = fieldWidthHint;
            gd_segmentNameField.horizontalSpan = 2;
            this.segmentNameField.setLayoutData((Object)gd_segmentNameField);
            this.segmentNameField.setEnabled(false);
            this.associateButton = new Button(this.compContents, 8);
            this.associateButton.setText(PgmIntXlat.getLabel().getString("IDSW_ADD_IPLIST_BUTTON"));
            GridData gd_associateButton = new GridData(131072, 0x1000000, true, false);
            gd_associateButton.exclude = !this.showImportList;
            gd_associateButton.horizontalSpan = 3;
            this.associateButton.setLayoutData((Object)gd_associateButton);
            this.associateButton.setEnabled(false);
            this.associateButton.addListener(13, (Listener)this);
            this.associationTable = new Table(this.compContents, 67586);
            this.associationTable.addListener(13, (Listener)this);
            this.associationTable.setHeaderVisible(true);
            this.associationTable.setLinesVisible(true);
            this.associationTable.setVisible(this.showImportList);
            GridData gd_associationTable = new GridData(4, 4, true, false);
            gd_associationTable.exclude = !this.showImportList;
            gd_associationTable.verticalIndent = 10;
            gd_associationTable.horizontalSpan = 3;
            gd_associationTable.heightHint = XSwt.getFontHeight((Control)this.associationTable) * 10;
            this.associationTable.setLayoutData((Object)gd_associationTable);
            this.associationTable.setEnabled(false);
            this.setColumns();
            this.removeButton = new Button(this.compContents, 8);
            this.removeButton.setText(PgmIntXlat.getLabel().getString("IDSW_REMOVE_BUTTON"));
            GridData gd_removeButton = new GridData(131072, 0x1000000, false, false);
            gd_removeButton.exclude = !this.showImportList;
            gd_removeButton.horizontalSpan = 3;
            this.removeButton.setLayoutData((Object)gd_removeButton);
            this.removeButton.setEnabled(false);
            String messageName = this.controller.getSelectedMessageName();
            if (messageName != null && !messageName.isEmpty()) {
                this.populateMessageCombo();
                this.setMessageName(messageName);
            }
            if ((segmentName = this.controller.getSelectedSegmentName()) != null && !segmentName.isEmpty()) {
                this.setSegmentName(segmentName);
            }
            this.addListeners();
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)parent, "com.ibm.zosconnect.ui.programinterface.importdatastructure");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            EclipseLogger.logError((Throwable)e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)");
    }

    private void addListeners() {
        this.fileNameField.addModifyListener((ModifyListener)this);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceTypeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateSourceTypeField();
            }
        });
        this.importFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateImportFromField();
            }
        });
        this.folderNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ImportDSTranMessageMetadataWizardPage.this.updateFromFolderField();
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
                    EclipseLogger.logError((Throwable)e);
                }
            }
        });
        this.folderNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent event) {
                try {
                    if (ImportDSTranMessageMetadataWizardPage.this.entryChanged) {
                        ImportDSTranMessageMetadataWizardPage.this.entryChanged = false;
                        ImportDSTranMessageMetadataWizardPage.this.updateFromFolderField();
                    } else if (ImportDSTranMessageMetadataWizardPage.this.getMessageType() == 2) {
                        ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 4);
                    }
                }
                catch (Throwable e) {
                    logger.throwing(this.getClass().getName(), "handleEvent(Event event)", e);
                    EclipseLogger.logError((Throwable)e);
                }
            }
        });
        this.segmentNameField.addModifyListener((ModifyListener)this);
        this.segmentNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateFromSegmentField();
            }
        });
        this.segmentNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.segmentNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportDSTranMessageMetadataWizardPage.this.entryChanged) {
                    ImportDSTranMessageMetadataWizardPage.this.entryChanged = false;
                    ImportDSTranMessageMetadataWizardPage.this.updateFromSegmentField();
                } else if (ImportDSTranMessageMetadataWizardPage.this.getMessageType() == 2) {
                    ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 4);
                }
            }
        });
        this.compContents.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.resizeColumns();
            }
        });
        this.removeButton.addListener(13, (Listener)this);
        this.dataStructureField.addModifyListener((ModifyListener)this);
        this.messageNameField.addModifyListener((ModifyListener)this);
    }

    private void resizeColumns() {
        Rectangle area = this.compContents.getClientArea();
        int width = area.width - 2 * this.associationTable.getBorderWidth() - this.buttonWidth - 5;
        TableColumn[] tableColumns = this.associationTable.getColumns();
        this.associationTable.setSize(area.width, area.height);
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].setWidth(width / tableColumns.length);
            ++i;
        }
    }

    private void setColumns() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumns()");
        String[] columnLabels = null;
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            columnLabels = new String[]{PgmIntXlat.getLabel().getString("EM_CHANNEL_NAME"), PgmIntXlat.getLabel().getString("IDSW_DS_NAME_COLUMN"), PgmIntXlat.getLabel().getString("EC_CONTAINERNAME"), PgmIntXlat.getLabel().getString("IDSW_DS_FILE_COLUMN")};
        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            columnLabels = new String[]{PgmIntXlat.getLabel().getString("IDSW_DS_NAME_COLUMN"), PgmIntXlat.getLabel().getString("IDSW_DS_FILE_COLUMN")};
        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
            columnLabels = new String[]{PgmIntXlat.getLabel().getString("IDSW_MSG_NAME_COLUMN"), PgmIntXlat.getLabel().getString("IDSW_DS_NAME_COLUMN"), PgmIntXlat.getLabel().getString("IDSW_SEGNAME_COLUMN"), PgmIntXlat.getLabel().getString("IDSW_DS_FILE_COLUMN")};
        }
        String[] stringArray = new String[4];
        stringArray[1] = PgmIntXlat.getDescription().getString("IDSW_DESC_SEGNAME");
        stringArray[3] = PgmIntXlat.getDescription().getString("IDSW_DESC_DSNAME");
        String[] columnTooltips = stringArray;
        int i = 0;
        while (i < columnLabels.length) {
            this.setColumn(columnLabels[i], columnTooltips[i]);
            ++i;
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumns()");
    }

    private void setColumn(String columnLabel, String columnTooltip) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumn(String label)");
        TableColumn tableColumn = new TableColumn(this.associationTable, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumn(String label)");
    }

    public void handleEvent(Event event) {
        try {
            this.setMessage(null, 2);
            if (event.widget == this.sourceBrowseButton) {
                this.handleSourceBrowseButtonPressed();
            } else if (event.widget == this.associateButton) {
                this.handleAssociateButtonPressed();
            } else if (event.widget == this.associationTable) {
                this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
                this.setMessage(null, 2);
            } else if (event.widget == this.removeButton) {
                this.handleRemoveButtonPressed();
            }
            this.setPageComplete(this.associationTable.getItemCount() > 0);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public void modifyText(ModifyEvent event) {
        try {
            String segName;
            this.setMessage(null, 2);
            if (event.widget == this.fileNameField) {
                String fileName = this.fileNameField.getText();
                if (fileName != null && !fileName.isEmpty()) {
                    this.setFileName(fileName);
                    this.updateWidgetEnablements();
                }
            } else if (event.widget == this.dataStructureField) {
                String dsName = this.dataStructureField.getText();
                if (dsName != null && !dsName.isEmpty()) {
                    this.setDataStructureName(dsName);
                    this.updateWidgetEnablements();
                    if (!this.showImportList) {
                        this.handleAssociateButtonPressed();
                    }
                }
            } else if (event.widget == this.messageNameField) {
                String msgName = this.messageNameField.getText();
                if (msgName != null && !msgName.isEmpty()) {
                    this.setMessageName(msgName);
                    this.updateWidgetEnablements();
                }
            } else if (event.widget == this.segmentNameField && (segName = this.segmentNameField.getText()) != null && !segName.isEmpty()) {
                this.setSegmentName(segName);
                this.updateWidgetEnablements();
            }
            this.setPageComplete(this.associationTable.getItemCount() > 0);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    private void parseApplicationSourceFile() throws InvocationTargetException, InterruptedException {
        this.sourceFolderStr = this.folderNameField.getText();
        this.sourceFileStr = this.fileNameField.getText();
        this.sourceFileTypeStr = this.sourceTypeField.getText();
        final ImportDSTranMessageMetadataWizardPage wizPage = this;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(PgmIntXlat.getLabel().getString("IDSW_PARSING") + "...", -1);
                try {
                    ImportDSTranMessageMetadataWizardPage.this.controller.parseApplicationSourceFile(ImportDSTranMessageMetadataWizardPage.this.sourceFolderStr, ImportDSTranMessageMetadataWizardPage.this.sourceFileStr, ImportDSTranMessageMetadataWizardPage.this.sourceFileTypeStr);
                }
                catch (ParseException e) {
                    final String errMsg = e.getMessage();
                    XSwt.getActiveShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String fullPath = (this).ImportDSTranMessageMetadataWizardPage.this.controller.getTempFileName();
                            ImportDSExceptionDialog errorDialog = new ImportDSExceptionDialog(ImportDSTranMessageMetadataWizardPage.this.getShell(), PgmIntXlat.getLabel().getString("IDSW_ERR"), wizPage, (this).ImportDSTranMessageMetadataWizardPage.this.controller);
                            errorDialog.create();
                            errorDialog.setParseErrorMessage(errMsg);
                            errorDialog.setFileContent((this).ImportDSTranMessageMetadataWizardPage.this.controller.readFileToString(new File(fullPath)));
                            errorDialog.getShell().setSize(700, 570);
                            errorDialog.open();
                            ArrayList<FieldType> segModels = errorDialog.getSegmentModels();
                            if (segModels != null && segModels.size() > 0) {
                                String newFileType = errorDialog.getFileType();
                                (this).ImportDSTranMessageMetadataWizardPage.this.controller.setImportLanguage(newFileType);
                                (this).ImportDSTranMessageMetadataWizardPage.this.controller.updateFileNameToSegmentModelsTable(segModels);
                                (this).ImportDSTranMessageMetadataWizardPage.this.sourceTypeField.setText(newFileType);
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setItems((this).ImportDSTranMessageMetadataWizardPage.this.controller.getDataStructureNames());
                                (this).ImportDSTranMessageMetadataWizardPage.this.parsingInformationExceptionList = errorDialog.getInformationExceptionList();
                                ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 2);
                            } else {
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setItems(new String[0]);
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setEnabled(false);
                                (this).ImportDSTranMessageMetadataWizardPage.this.segmentNameField.setEnabled(false);
                                (this).ImportDSTranMessageMetadataWizardPage.this.associateButton.setEnabled(false);
                                ImportDSTranMessageMetadataWizardPage.this.setMessage(ImportDSTranMessageMetadataWizardPage.this.getParseErrorMessage(), 2);
                                (this).ImportDSTranMessageMetadataWizardPage.this.fileNameField.setFocus();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    EclipseLogger.logError((Throwable)e);
                }
                monitor.done();
            }
        };
        new ProgressMonitorDialog(this.getShell()).run(false, false, op);
        this.controller.deleteTempFile();
        this.sourceTypeField.setText(this.controller.getImportLanguage());
        ImportParseException e = this.controller.getImportParseException();
        if (e != null) {
            if (e instanceof UnsupportedTypesException) {
                ErrorDialog.openError((Shell)this.getShell(), (String)PgmIntXlat.getLabel().getString("IDSW_WARN"), (String)e.getMessage(), (IStatus)((UnsupportedTypesException)e).getMultiStatus());
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)PgmIntXlat.getLabel().getString("IDSW_ERR"), (String)e.getMessage());
            }
        }
    }

    protected final File getSourceDirectory(String path) {
        return new File(this.getSourceDirectoryName(path));
    }

    private String getSourceDirectoryName(String sourceName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "getSourceDirectoryName(String sourceName)");
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "getSourceDirectoryName(String sourceName)");
        return result.toOSString();
    }

    private void setFolderName(String path, boolean isFolder) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setFolderName(String path)");
        if (path != null && !path.isEmpty()) {
            String folderName = path;
            if (!isFolder) {
                folderName = path.substring(0, path.lastIndexOf(File.separator));
            }
            String[] currentItems = this.folderNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(folderName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                this.folderNameField.add(folderName);
                this.folderNameField.setText(folderName);
                this.saveFolderValues();
            } else {
                this.restoreFolderValues();
                this.folderNameField.select(selectionIndex);
            }
            this.populateFileCombo(path);
        } else {
            this.fileNameField.removeAll();
        }
        if (isFolder) {
            this.dataStructureField.removeAll();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setFolderName(String path)");
    }

    private void updateWidgetEnablements() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()");
        this.fileNameField.setEnabled(!this.folderNameField.getText().isEmpty());
        if (this.dataStructureField.getItemCount() == 0) {
            return;
        }
        if (this.dataStructureField.getItemCount() == 1) {
            this.dataStructureField.select(0);
        }
        this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty() && this.getSourceDirectory() != null);
        this.segmentNameField.setEnabled(!this.messageNameField.getText().isEmpty());
        this.associateButton.setEnabled(this.segmentNameField.isEnabled() && !this.segmentNameField.getText().isEmpty() && this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty() && !this.messageNameField.getText().isEmpty());
        this.associationTable.setEnabled(this.associationTable.getItemCount() > 0);
        this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()");
    }

    private void saveFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "saveFolderValues()");
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = Utility.addToHistory(sourceNames, this.getSourceDirectoryName());
            if (!this.controller.isLocalImport()) {
                settings.put(STORE_HOST_SOURCE_NAMES_ID, sourceNames);
            } else {
                settings.put(STORE_LOCAL_SOURCE_NAMES_ID, sourceNames);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "saveFolderValues()");
    }

    private String restoreFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()");
        this.folderNameField.removeAll();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                return "";
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (!sourceNames[i].isEmpty()) {
                    this.folderNameField.add(sourceNames[i]);
                }
                ++i;
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()");
        return this.controller.getLastDirectory();
    }

    protected final File getSourceDirectory() {
        return this.getSourceDirectory(this.folderNameField.getText());
    }

    protected String getSourceDirectoryName() {
        if (this.controller.isLocalImport()) {
            return this.getSourceDirectoryName(this.folderNameField.getText());
        }
        return this.folderNameField.getText();
    }

    private void populateFileCombo(String selectedFileFullPath) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)");
        String selectedFileName = selectedFileFullPath.substring(selectedFileFullPath.lastIndexOf(File.separator) + 1, selectedFileFullPath.length());
        File folder = this.getSourceDirectory();
        if (folder != null) {
            File[] allFiles = folder.listFiles();
            if (allFiles != null) {
                Vector<String> fileNames = new Vector<String>();
                int i = 0;
                while (i < allFiles.length) {
                    if (allFiles[i].isFile()) {
                        String currentFileName = allFiles[i].getName();
                        fileNames.add(currentFileName);
                    }
                    ++i;
                }
                this.fileNameField.removeModifyListener((ModifyListener)this);
                this.fileNameField.setItems(fileNames.toArray(new String[fileNames.size()]));
                this.fileNameField.addModifyListener((ModifyListener)this);
                if (this.fileNameField.getItems().length == 0) {
                    this.setMessage("", 2);
                } else {
                    this.setMessage(null, 2);
                    this.fileNameField.setText(selectedFileName);
                }
            } else {
                this.setMessage("", 2);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)");
    }

    private void updateImportFromField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateImportFromField()");
        this.setImportFrom();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateImportFromField()");
    }

    private void setImportFrom() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setImportFrom()");
        boolean importFromLocal = true;
        if (this.importFromField.getText().equals(sourceTypes[1])) {
            importFromLocal = false;
        }
        if (this.controller.isLocalImport() != importFromLocal) {
            this.controller.setLocalImport(importFromLocal);
            if (this.controller.isLocalImport()) {
                this.folderLabel.setText(PgmIntXlat.getLabel().getString("IDSW_SOURCE_FLD_LBL"));
                this.fileLabel.setText(PgmIntXlat.getLabel().getString("IDSW_DS_FILE_LBL"));
            } else {
                this.folderLabel.setText(PgmIntXlat.getLabel().getString("IDSW_SOURCE_PDS_LBL"));
                this.fileLabel.setText(PgmIntXlat.getLabel().getString("IDSW_DS_MEM_LBL"));
            }
            this.fileLabel.getParent().layout();
            this.restoreFolderValues();
            this.setFolderName(null, true);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setImportFrom()");
    }

    private void updateSourceTypeField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()");
        this.setSourceType();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()");
    }

    private void setSourceType() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setSourceType()");
        String importLanguage = this.controller.getImportLanguage();
        if (importLanguage == null || !importLanguage.equals(this.sourceTypeField.getText())) {
            importLanguage = this.sourceTypeField.getText();
            String wizardMessage = this.getMessage();
            if (!this.fileNameField.getText().isEmpty() && wizardMessage != null && (wizardMessage.equals(PgmIntXlat.getError().getString("IDSW_ERR_01")) || wizardMessage.equals(this.getParseErrorMessage()) || wizardMessage.equals(PgmIntXlat.getError().getString("IDSW_ERR_03")))) {
                this.updateFromFileField();
            }
            this.controller.setImportLanguage(importLanguage);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setSourceType()");
    }

    private String getParseErrorMessage() {
        MessageFormat formatter = new MessageFormat(PgmIntXlat.getError().getString("IDSW_ERR_04"), Locale.getDefault());
        Object[] messageArguments = new Object[]{this.controller.isCOBOLLanguage() ? "COBOL" : "PL/I", this.fileNameField.getText()};
        return formatter.format(messageArguments);
    }

    private void updateFromFileField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFileField()");
        this.setFileName(this.fileNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFileField()");
    }

    private void setFileName(String fileName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMemberName(String mName)");
        if (fileName != null && !fileName.isEmpty()) {
            String[] currentItems = this.fileNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(fileName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = fileName;
                this.fileNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fileNameField.select(selectionIndex);
            this.populateDataStructureComboModel();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setMemberName(String mName)");
    }

    private void updateFromFolderField() throws PermissionDeniedException, FileNotFoundException, ConnectionException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()");
        if (this.controller.isLocalImport()) {
            this.setFolderName(this.folderNameField.getText(), true);
            this.updateWidgetEnablements();
        } else {
            this.handlePdsSelected();
            this.updateWidgetEnablements();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()");
    }

    private void handlePdsSelected() throws PermissionDeniedException, ConnectionException, FileNotFoundException {
        DataSet dataSet;
        IConnectionService connService;
        IZOSConnectable zosConn;
        this.fileNameField.removeAll();
        String folderPath = this.folderNameField.getText();
        if (folderPath != null) {
            folderPath = folderPath.trim();
        }
        if ((zosConn = (IZOSConnectable)(connService = ConnectionsPlugin.getDefault().getConnectionService()).getConnectable("com.ibm.cics.zos.comm.connection")) != null && zosConn.isConnected() && folderPath != null && !folderPath.isEmpty() && (dataSet = zosConn.getDataSet(folderPath)) instanceof PartitionedDataSet) {
            PartitionedDataSet pds = (PartitionedDataSet)dataSet;
            Vector<Member> memberVector = null;
            if (!this.controller.pdsAlreadyInList(pds)) {
                this.controller.addPds(pds);
                memberVector = new Vector<Member>();
            }
            List memberList = zosConn.getMembers(pds);
            String[] memberNameList = new String[memberList.size()];
            int i = 0;
            while (i < memberList.size()) {
                Member currMember = (Member)memberList.get(i);
                memberNameList[i] = currMember.getName();
                if (memberVector != null) {
                    memberVector.add(currMember);
                }
                ++i;
            }
            this.fileNameField.setItems(memberNameList);
            if (memberVector != null) {
                this.controller.addToAllPdsMembers(pds, memberVector);
            }
        }
    }

    private void populateDataStructureComboModel() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()");
        try {
            this.parseApplicationSourceFile();
        }
        catch (InvocationTargetException e) {
            EclipseLogger.logError((Throwable)e);
            Warnings warnings = new Warnings(this.getShell(), "ERROR", null, "Parsing source file errors", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings(e.getMessage() != null ? e.getMessage() : "");
            warnings.open();
            this.dataStructureField.setItems(new String[0]);
            this.dataStructureField.setEnabled(false);
            this.segmentNameField.setEnabled(false);
            this.associateButton.setEnabled(false);
            this.setMessage(this.getParseErrorMessage(), 2);
            this.fileNameField.setFocus();
        }
        catch (InterruptedException e) {
            EclipseLogger.logError((Throwable)e);
            Warnings warnings = new Warnings(this.getShell(), "ERROR", null, "Parsing source file errors", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings(e.getMessage() != null ? e.getMessage() : "");
            warnings.open();
            this.dataStructureField.setItems(new String[0]);
            this.dataStructureField.setEnabled(false);
            this.segmentNameField.setEnabled(false);
            this.associateButton.setEnabled(false);
            this.setMessage(this.getParseErrorMessage(), 2);
            this.fileNameField.setFocus();
        }
        String[] dsNames = this.controller.getDataStructureNames();
        this.dataStructureField.setItems(dsNames);
        if (dsNames.length > 0) {
            if (dsNames.length == 1) {
                this.dataStructureField.select(0);
            }
            this.setMessage(null, 4);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()");
    }

    private void populateMessageCombo() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMessageCombo()");
        ArrayList<String> allMessageNamesList = new ArrayList<String>();
        List messageNames = this.controller.getInputMessageNames();
        for (String messageName : messageNames) {
            allMessageNamesList.add(messageName);
        }
        messageNames = this.controller.getOutputMessageNames();
        for (String messageName : messageNames) {
            allMessageNamesList.add(messageName);
        }
        String[] allMessageNames = allMessageNamesList.toArray(new String[0]);
        this.messageNameField.setItems(allMessageNames);
        if (allMessageNames.length == 1) {
            this.messageNameField.select(0);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMessageCombo()");
    }

    private void populateSegmentCombo() {
        List segmentNames;
        MessageType mtObject;
        String msgName = this.messageNameField.getText();
        if (msgName != null && !msgName.isEmpty() && (mtObject = this.controller.getMessageType(msgName)) != null && (segmentNames = this.controller.getSegmentNames(mtObject)) != null && segmentNames.size() > 0) {
            this.segmentNameField.setItems(segmentNames.toArray(new String[segmentNames.size()]));
            if (segmentNames.size() == 1) {
                this.segmentNameField.select(0);
            }
            return;
        }
        this.segmentNameField.setItems(new String[]{""});
    }

    private void populateMemberCombo(Vector<Member> selectedMembers) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()");
        if (selectedMembers != null) {
            String[] memberNames = new String[selectedMembers.size()];
            int i = 0;
            while (i < selectedMembers.size()) {
                memberNames[i] = selectedMembers.get(i).getName();
                ++i;
            }
            this.fileNameField.setItems(memberNames);
            if (this.fileNameField.getItems().length == 0) {
                this.setMessage(PgmIntXlat.getError().getString("IDSW_ERR_02"), 2);
            } else {
                this.setMessage(null, 2);
                this.folderNameField.setEnabled(true);
            }
            this.controller.setLastDirectory(this.folderNameField.getText());
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()");
    }

    private void handleSourceBrowseButtonPressed() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()");
        if (this.controller.isLocalImport()) {
            FileDialog dialog = new FileDialog(new Shell(), 4096);
            dialog.setFilterPath(this.folderNameField.getText() + File.separator);
            dialog.setText(PgmIntXlat.getLabel().getString("IDSW_SELECT_FILE"));
            String selectedFile = dialog.open();
            if (selectedFile != null && this.getSourceDirectory(selectedFile) != null) {
                this.setFolderName(selectedFile, false);
                this.updateWidgetEnablements();
            }
        } else {
            ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard(1, false);
            importDataSetWizard.setCallingWizard(this.getWizard());
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
            dialog.open();
            Vector<PartitionedDataSet> impliedPdsList = importDataSetWizard.getImpliedPdsList();
            if (impliedPdsList != null && impliedPdsList.size() == 1) {
                PartitionedDataSet pds = impliedPdsList.get(0);
                if (!this.controller.pdsAlreadyInList(pds)) {
                    this.controller.addPds(pds);
                    HashMap<PartitionedDataSet, Vector<Member>> impliedPdsMembers = importDataSetWizard.getImpliedPdsMembers();
                    Vector<Member> pds_members = impliedPdsMembers.get(pds);
                    this.controller.addToAllPdsMembers(pds, pds_members);
                    this.setDataEntryName(pds.getPath());
                    this.populateMemberCombo(pds_members);
                }
                this.fileNameField.setText(importDataSetWizard.getSelectedMembers().elementAt(0).getName());
                this.updateWidgetEnablements();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()");
    }

    private void handleAssociateButtonPressed() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()");
        String dsName = this.dataStructureField.getText();
        String msgName = this.messageNameField.getText();
        String segName = this.segmentNameField.getText();
        String fullPath = this.folderNameField.getText() + File.separator + this.fileNameField.getText();
        if (!this.controller.isLocalImport()) {
            fullPath = this.folderNameField.getText() + "(" + this.fileNameField.getText() + ")";
        }
        if (!this.showImportList) {
            this.controller.clearAssociations();
        }
        String errorMessage = null;
        if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            errorMessage = this.controller.addAssociation(dsName, msgName, segName, fullPath);
        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            errorMessage = this.controller.addAssociationSingleSeg(dsName, msgName, segName, fullPath);
        }
        if (errorMessage == null) {
            this.refreshTable();
        }
        this.setMessage(errorMessage, 2);
        this.updateWidgetEnablements();
        this.associateButton.setEnabled(false);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()");
    }

    private void refreshTable() {
        block3: {
            Vector associations;
            block2: {
                this.associationTable.removeAll();
                associations = this.controller.getAssociations();
                if (this.spType != ServiceArchiveConstants.SP_Type.CICS_CHANNEL && this.spType != ServiceArchiveConstants.SP_Type.IMS) break block2;
                int i = 0;
                while (i < associations.size()) {
                    DataStructureSegmentAssociation currAssoc = (DataStructureSegmentAssociation)associations.get(i);
                    TableItem item = new TableItem(this.associationTable, 0);
                    item.setText(0, currAssoc.messageName);
                    item.setText(1, currAssoc.dataStructure.getName());
                    item.setText(2, currAssoc.segmentName);
                    item.setText(3, currAssoc.importFile);
                    ++i;
                }
                break block3;
            }
            if (this.spType != ServiceArchiveConstants.SP_Type.CICS_COMM_AREA && this.spType != ServiceArchiveConstants.SP_Type.IMS_LDS && this.spType != ServiceArchiveConstants.SP_Type.MQ_MESSAGE) break block3;
            int i = 0;
            while (i < associations.size()) {
                DataStructureSegmentAssociation currAssoc = (DataStructureSegmentAssociation)associations.get(i);
                TableItem item = new TableItem(this.associationTable, 0);
                item.setText(0, currAssoc.dataStructure.getName());
                item.setText(1, currAssoc.importFile);
                ++i;
            }
        }
    }

    private void handleRemoveButtonPressed() {
        int[] selIdx;
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()");
        int[] nArray = selIdx = this.associationTable.getSelectionIndices();
        int n = selIdx.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableItem ti = this.associationTable.getItem(i);
            if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                this.controller.removeAssociation(ti.getText(1), ti.getText(0), ti.getText(2), ti.getText(3));
            } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                this.controller.removeAssociation(ti.getText(0), ti.getText(1));
            }
            ++n2;
        }
        this.associationTable.remove(selIdx);
        this.updateWidgetEnablements();
        this.setMessage(null, 2);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()");
    }

    private void setDataStructureName(String path) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)");
        if (path != null && !path.isEmpty()) {
            String[] currentItems = this.dataStructureField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.dataStructureField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.dataStructureField.select(selectionIndex);
            if (this.messageNameField.getItemCount() == 0) {
                this.populateMessageCombo();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)");
    }

    private void updateFromSegmentField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()");
        this.setSegmentName(this.segmentNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()");
    }

    private void setSegmentName(String segmentName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setSegmentName(String segmentName)");
        if (segmentName.length() > 0) {
            String[] currentItems = this.segmentNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(segmentName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = segmentName;
                this.segmentNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.segmentNameField.select(selectionIndex);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setSegmentName(String segmentName)");
    }

    private void setMessageName(String messageName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMessagetName(String messageName)");
        if (messageName.length() > 0) {
            String[] currentItems = this.messageNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(messageName)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = messageName;
                this.messageNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.messageNameField.select(selectionIndex);
            this.populateSegmentCombo();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setMessagetName(String messageName)");
    }

    public Table getAssociationTable() {
        return this.associationTable;
    }

    private void setDataEntryName(String dePath) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)");
        if (dePath != null && !dePath.isEmpty()) {
            String[] currentItems = this.folderNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(dePath)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                this.folderNameField.add(dePath);
                this.folderNameField.setText(dePath);
                this.saveFolderValues();
            } else {
                this.restoreFolderValues();
                this.folderNameField.select(selectionIndex);
            }
        } else {
            this.fileNameField.removeAll();
        }
        this.dataStructureField.removeAll();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)");
    }

    public TranDataStructureController getController() {
        return this.controller;
    }
}

