/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.wizard.importds;

import com.ibm.zosconnect.ui.programinterface.ProgramInterfacePlugin;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.DataStructureSegmentAssociation;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.TranDataStructureController;
import com.ibm.zosconnect.ui.programinterface.editors.TransactionEditorPage;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.wizard.importds.ImportDSTranMessageMetadataWizardPage;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ImportDSTranMessageMetadataWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger;
    protected static final String STORE_IMPORT_DATA_STRUCTURE_ID = "ImportDSTranMessageMetadataWizard.STORE_IMPORT_DATA_STRUCTURE_ID";
    private static final String STORE_LAST_FOLDER_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_FOLDER_ID";
    private static final String STORE_LAST_SOURCE_TYPE_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_SOURCE_TYPE_ID";
    private static final String STORE_LAST_SOURCE_LANGUAGE_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_SOURCE_LANGUAGE_ID";
    private ImportDSTranMessageMetadataWizardPage page;
    private TranDataStructureController controller;
    private Vector<DataStructureSegmentAssociation> importResult;
    private boolean isLocalSource;
    private String importLanguage;
    private String lastDirectory;
    private boolean showImportList;
    private ServiceArchiveConstants.SP_Type spType;

    public Vector<DataStructureSegmentAssociation> getImportResult() {
        return this.importResult;
    }

    public ImportDSTranMessageMetadataWizard(TransactionEditorPage parentEditor, String selectedMessageName, String selectedSegmentName, ServiceArchiveConstants.SP_Type spType, boolean showImportList) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setWindowTitle(PgmIntXlat.getLabel().getString("IDSW_WINDOW_TITLE"));
        this.restoreWidgetValues();
        this.controller = new TranDataStructureController(parentEditor.getController(), parentEditor.getParent().getProjectName(), this.isLocalSource, this.importLanguage, this.lastDirectory, selectedMessageName, selectedSegmentName);
        this.spType = spType;
        this.showImportList = showImportList;
    }

    public void addPages() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "addPages()");
        try {
            this.page = new ImportDSTranMessageMetadataWizardPage(PgmIntXlat.getLabel().getString("IDSW_TITLE"), this.controller, this.spType, this.showImportList);
            this.addPage((IWizardPage)this.page);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "addPages()");
    }

    public boolean performFinish() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()");
        this.doFinish();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()");
        return true;
    }

    private void doFinish() {
        this.saveWidgetValues();
        this.importResult = this.controller.getAssociations();
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.isLocalSource = settings.getBoolean(STORE_LAST_SOURCE_TYPE_ID);
            this.importLanguage = settings.get(STORE_LAST_SOURCE_LANGUAGE_ID);
            this.lastDirectory = settings.get(STORE_LAST_FOLDER_ID);
        }
        if (this.importLanguage == null) {
            this.isLocalSource = true;
            this.importLanguage = TranDataStructureController.sourceLanguages[0];
            this.lastDirectory = "";
        }
    }

    private void saveWidgetValues() {
        this.isLocalSource = this.controller.isLocalImport();
        this.importLanguage = this.controller.getImportLanguage();
        this.lastDirectory = this.controller.getLastDirectory();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_LAST_SOURCE_TYPE_ID, this.isLocalSource);
            settings.put(STORE_LAST_SOURCE_LANGUAGE_ID, this.importLanguage);
            settings.put(STORE_LAST_FOLDER_ID, this.lastDirectory);
        }
    }

    public IDialogSettings getDialogSettings() {
        return ImportDSTranMessageMetadataWizard.getDialogSettings(STORE_IMPORT_DATA_STRUCTURE_ID);
    }

    public static IDialogSettings getDialogSettings(String sectionID) {
        ProgramInterfacePlugin plugin = ProgramInterfacePlugin.getDefault();
        IDialogSettings settings = plugin.getDialogSettings();
        if (settings == null) {
            settings = plugin.getDialogSettings().addNewSection(sectionID);
        } else {
            settings = plugin.getDialogSettings().getSection(sectionID);
            if (settings == null) {
                settings = plugin.getDialogSettings().addNewSection(sectionID);
            }
        }
        return settings;
    }
}

