/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.utilities;

import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.Utility;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Warnings
extends MessageDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text text;
    private String warnings;
    private Label encodingStatus;
    private Label remarksStatus;
    private Text encodingText;
    private boolean isDbd = false;
    private boolean isReadOnly;

    public Warnings(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public Control createCustomArea(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns = 3;
        GridData gData = new GridData(1808);
        gData.heightHint = 25;
        gData.verticalIndent = 4;
        Label label1 = new Label(parent, 0);
        label1.setText(PgmIntXlat.getLabel().getString("IMS_ENCODING") + " (" + PgmIntXlat.getLabel().getString("WB477") + ")" + PgmIntXlat.getColon().getString("COLON"));
        if (this.isDbd) {
            label1.setToolTipText(PgmIntXlat.getDescription().getString("WW_OVERRIDE_DEFAULT"));
        } else {
            label1.setToolTipText(PgmIntXlat.getDescription().getString("WW_OVERRIDE_ENCODING"));
        }
        label1.setLayoutData((Object)gData);
        gData = new GridData(1808);
        gData.widthHint = 250;
        gData.heightHint = 23;
        this.encodingText = new Text(parent, 2048);
        this.encodingText.setTextLimit(25);
        this.encodingText.setLayoutData((Object)gData);
        String encoding = PgmIntXlat.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");
        this.encodingText.setText(encoding);
        Object[] args = new Object[]{new String(Character.toChars(8482)), PgmIntXlat.getColon().getString("COLON")};
        this.encodingText.setToolTipText(PgmIntXlat.getDescription().getString("WB23A", args));
        this.encodingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (Warnings.this.encodingStatus != null && Warnings.this.remarksStatus != null) {
                    Warnings.this.encodingStatus.setToolTipText(null);
                    Warnings.this.encodingStatus.setVisible(false);
                    try {
                        Warnings.this.encodingText.getText().getBytes(Warnings.this.encodingText.getText());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Warnings.this.encodingStatus.setToolTipText(PgmIntXlat.getError().getString("EISRC21"));
                        Warnings.this.encodingStatus.setVisible(true);
                    }
                    Warnings.this.getButton(0).setEnabled(!Warnings.this.encodingStatus.isVisible() && !Warnings.this.remarksStatus.isVisible());
                }
            }
        });
        gData = new GridData(1808);
        gData.heightHint = 25;
        gData.widthHint = 25;
        this.encodingStatus = new Label(parent, 0);
        this.encodingStatus.setImage(IconAndMessageDialog.getImage((String)"dialog_message_error_image"));
        this.encodingStatus.setVisible(false);
        this.encodingStatus.setLayoutData((Object)gData);
        gData = new GridData(1808);
        gData.heightHint = 25;
        gData.verticalIndent = 4;
        Label label2 = new Label(parent, 0);
        label2.setToolTipText(PgmIntXlat.getDescription().getString("WB099"));
        label2.setText(PgmIntXlat.getLabel().getString("WB019A") + " (" + PgmIntXlat.getLabel().getString("WB478") + ")" + PgmIntXlat.getColon().getString("COLON"));
        label2.setLayoutData((Object)gData);
        gData = new GridData(1808);
        gData.widthHint = 250;
        gData.heightHint = 100;
        this.text = new Text(parent, 2882);
        this.text.setToolTipText(PgmIntXlat.getDescription().getString("WB100"));
        this.text.setLayoutData((Object)gData);
        this.text.setText(this.warnings == null ? "" : this.warnings);
        this.text.setTextLimit(255);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (Warnings.this.encodingStatus != null && Warnings.this.remarksStatus != null) {
                    Warnings.this.remarksStatus.setToolTipText(null);
                    Warnings.this.remarksStatus.setVisible(false);
                    String invalidCharacter = Utility.getInvalidRemarksCharacter((String)Warnings.this.text.getText());
                    if (invalidCharacter != null) {
                        Object[] inserts = new String[]{PgmIntXlat.getLabel().getString("WB019A"), invalidCharacter};
                        Object errorMessage = PgmIntXlat.getError().getString("EISRC11", inserts);
                        if (invalidCharacter.equals("'")) {
                            errorMessage = (String)errorMessage + " " + PgmIntXlat.getError().getString("EISRC11A");
                        }
                        Warnings.this.remarksStatus.setVisible(true);
                        Warnings.this.remarksStatus.setToolTipText(Utility.formatMessage((String)errorMessage));
                    }
                    Warnings.this.getButton(0).setEnabled(!Warnings.this.encodingStatus.isVisible() && !Warnings.this.remarksStatus.isVisible());
                }
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.character == '\t') {
                    e.text = null;
                    Warnings.this.text.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    Warnings.this.text.traverse(4, (KeyEvent)e);
                }
            }
        });
        gData = new GridData(1808);
        gData.heightHint = 25;
        gData.widthHint = 25;
        this.remarksStatus = new Label(parent, 0);
        this.remarksStatus.setImage(IconAndMessageDialog.getImage((String)"dialog_message_error_image"));
        this.remarksStatus.setVisible(false);
        this.remarksStatus.setLayoutData((Object)gData);
        parent.setSize(parent.computeSize(-1, -1));
        if (this.isReadOnly) {
            this.text.setEditable(false);
            this.encodingText.setEditable(false);
        }
        return parent;
    }

    public void setWarnings(String warnings) {
        this.warnings = warnings;
    }
}

