/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors.providers;

import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.RedefinesGroup;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranMessageModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.editors.Images;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;

public class FieldNameCellLabelProvider
extends StyledCellLabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ServiceArchiveConstants.SP_Type spType;
    private TranEditorController tranEditCtrl;

    public FieldNameCellLabelProvider(ServiceArchiveConstants.SP_Type spType, TranEditorController tranEditCtrl) {
        this.spType = spType;
        this.tranEditCtrl = tranEditCtrl;
    }

    public void update(ViewerCell cell) {
        ArrayList styleRanges = new ArrayList();
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        cell.setImage(this.getImage(element));
        cell.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }

    private String getText(Object element) {
        Object name = element.toString();
        if (element instanceof FieldModel) {
            FieldModel fieldNode = (FieldModel)element;
            FieldType field = fieldNode.getField();
            name = field.getOriginalName();
            RedefinesGroup redefinesGroup = fieldNode.getRedefinesGroup();
            if (field.getMaxOccurs() != null) {
                Integer maxOccursVal = field.getMaxOccurs();
                String maxOccurs = "";
                maxOccurs = maxOccursVal != null && maxOccursVal > 0 ? String.valueOf(maxOccursVal) : "*";
                name = (String)name + " [" + String.valueOf(field.getMinOccurs()) + ".." + maxOccurs + "]";
            }
            if (redefinesGroup != null) {
                String redefines = field.getRedefines();
                if (redefines == null || redefines.isEmpty()) {
                    name = (String)name + " " + PgmIntXlat.getLabel().getString("FIELDNAME_REDEFINED");
                } else {
                    Object[] inserts = new Object[]{name, redefines};
                    name = PgmIntXlat.getLabel().getString("FIELDNAME_REDEFINES", inserts);
                }
            }
        } else if (element instanceof TranDataStructureModel) {
            TranDataStructureModel node = (TranDataStructureModel)element;
            name = node.getField().getOriginalName();
        }
        return name;
    }

    private Image getImage(Object element) {
        Image retVal = Images.getFieldBlankImage();
        if (element instanceof FieldModel) {
            FieldModel node = (FieldModel)element;
            boolean hasErrorMarkers = this.tranEditCtrl.hasErrorMarkers(node.getField());
            if (node.getRedefinesGroup() != null) {
                retVal = !hasErrorMarkers ? (node.isUserDefined() ? Images.getUserRedefiningFieldImage() : Images.getRedfiningFieldImage()) : Images.getRedfiningFieldErrorImage();
            } else if (node.isArrayField()) {
                retVal = !hasErrorMarkers ? Images.getArrayFieldImage() : Images.getArrayFieldErrorImage();
            } else if (node.isDependedOnField() || node.isCounterField()) {
                retVal = !hasErrorMarkers ? Images.getArrayCounterImage() : Images.getArrayCounterErrorImage();
            } else if (hasErrorMarkers) {
                retVal = Images.getFieldErrorImage();
            }
        } else if (element instanceof TranSegmentModel) {
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                retVal = Images.getContainerImage();
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                retVal = Images.getSegmentImage();
            } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA) {
                retVal = Images.getCommareaImage();
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS) {
                retVal = Images.getImsLdsImage();
            } else if (this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                retVal = Images.getMQMessageImage();
            }
        } else if (element instanceof TranMessageModel) {
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                retVal = Images.getChannelImage();
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                int messageType = ((TranMessageModel)element).getMessageType();
                retVal = messageType == 0 ? Images.getInputMessageImage() : Images.getOutputMessageImage();
            }
        } else if (element instanceof TranDataStructureModel) {
            retVal = Images.getDataStructureImage();
        }
        return retVal;
    }
}

