/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors.providers;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.wv.metadata.transaction.ApplicationDatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class FieldDatatypeCellLabelProvider
extends StyledCellLabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Color overrideDatatypeColor = XSwt.getColor((int)36);

    public void update(ViewerCell cell) {
        StringBuilder cellText = new StringBuilder();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        Image cellImage = null;
        Object element = cell.getElement();
        if (element instanceof FieldModel) {
            FieldModel fieldNode = (FieldModel)element;
            FieldType fieldType = fieldNode.getField();
            ApplicationDatatypeType datatypeType = fieldType.getApplicationDatatype();
            String origDatatypeName = datatypeType.getDatatype().toString();
            DatatypeOverride overrideType = fieldType.getDatatypeOverride();
            String overrideDatatypeName = OverrideTypeUtil.getUIStringFromType((DatatypeOverride)overrideType);
            String token1 = origDatatypeName;
            StyleRange styleRange1 = new StyleRange();
            styleRange1 = new StyleRange();
            styleRange1.start = 0;
            styleRange1.length = token1.length();
            styleRange1.fontStyle = 0;
            styleRanges.add(styleRange1);
            cellText.append(token1);
            if (StringUtils.isNotBlank((CharSequence)overrideDatatypeName)) {
                String token2 = " (" + overrideDatatypeName + ")";
                StyleRange styleRange2 = new StyleRange();
                styleRange2 = new StyleRange();
                styleRange2.start = cellText.length();
                styleRange2.length = token2.length();
                styleRange2.fontStyle = 0;
                styleRange2.foreground = this.overrideDatatypeColor;
                styleRanges.add(styleRange2);
                cellText.append(token2);
            }
        }
        cell.setText(cellText.toString());
        cell.setImage(cellImage);
        cell.setStyleRanges(styleRanges.toArray(new StyleRange[0]));
    }
}

