/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors.properties;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FieldsPropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite compContents;
    private Label labelOriginalName;
    private Label labelNewFieldName;
    private Label fieldDataTypeLabel;
    private Label fieldDefaultValueTypeLabel;
    private Label fieldDefaultValueLabel;
    private Label labelLength;
    private Label labelStartbyte;
    private Label labelRemarks;
    private Text textOriginalName;
    private Text textNewFieldName;
    private Text fieldDataTypeText;
    private Text fieldDefaultValueText;
    private Text textLength;
    private Text textStartbyte;
    private Text textRemarks;
    private CCombo fieldDefaultValueTypeCombo;
    private TabbedPropertySheetPage page;
    private TabbedPropertySheetWidgetFactory factory;
    private FieldModel selectedFieldNode;
    private static final String HEXADECIMAL = "X (HEXADECIMAL)";
    private static final String CHARACTER = "C (CHARACTER)";

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.factory = this.getWidgetFactory();
        this.compContents = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(10, false);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 500;
        this.compContents.setLayout((Layout)layout);
        this.compContents.setData((Object)data);
        this.labelOriginalName = this.factory.createLabel(this.compContents, "", 0);
        this.labelOriginalName.setText(PgmIntXlat.getLabel().getString("EDS_ORIGINAL_NAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelOriginalName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelOriginalName.setLayoutData((Object)gd_labelOriginalName);
        this.textOriginalName = this.factory.createText(this.compContents, "", 8);
        GridData gd_textOriginalName = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textOriginalName.setLayoutData((Object)gd_textOriginalName);
        this.textOriginalName.setEnabled(false);
        this.labelNewFieldName = this.factory.createLabel(this.compContents, "", 0);
        this.labelNewFieldName.setText(PgmIntXlat.getLabel().getString("EC_RENAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelNewFieldName.setLayoutData((Object)gd_labelFieldName);
        this.textNewFieldName = this.factory.createText(this.compContents, "", 8);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textNewFieldName.setLayoutData((Object)gd_textFieldName);
        this.textNewFieldName.setEnabled(false);
        this.fieldDataTypeLabel = this.factory.createLabel(this.compContents, "", 0);
        this.fieldDataTypeLabel.setText(PgmIntXlat.getLabel().getString("TCMLE_COLNAME_VALUETYPE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_fieldDataTypeLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fieldDataTypeLabel.setLayoutData((Object)gd_fieldDataTypeLabel);
        this.fieldDataTypeText = this.factory.createText(this.compContents, "", 8);
        GridData gd_fieldDataTypeText = new GridData(4, 0x1000000, true, false, 9, 1);
        this.fieldDataTypeText.setLayoutData((Object)gd_fieldDataTypeText);
        this.fieldDataTypeText.setEnabled(false);
        this.labelLength = this.factory.createLabel(this.compContents, "", 0);
        this.labelLength.setText(PgmIntXlat.getLabel().getString("TCMLE_LENGTH") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelLength = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelLength.setLayoutData((Object)gd_labelLength);
        this.textLength = this.factory.createText(this.compContents, "", 8);
        GridData gd_textLength = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textLength.setLayoutData((Object)gd_textLength);
        this.textLength.setEnabled(false);
        this.labelStartbyte = this.factory.createLabel(this.compContents, "", 0);
        this.labelStartbyte.setText(PgmIntXlat.getLabel().getString("EFD_START_BYTE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelStartbyte = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelStartbyte.setLayoutData((Object)gd_labelStartbyte);
        this.textStartbyte = this.factory.createText(this.compContents, "", 8);
        GridData gd_textStartbyte = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textStartbyte.setLayoutData((Object)gd_textStartbyte);
        this.textStartbyte.setEnabled(false);
        this.fieldDefaultValueTypeLabel = this.factory.createLabel(this.compContents, "", 0);
        this.fieldDefaultValueTypeLabel.setText(PgmIntXlat.getLabel().getString("DEFAULT_VALUE_TYPE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_fieldValueTypeLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fieldDefaultValueTypeLabel.setLayoutData((Object)gd_fieldValueTypeLabel);
        this.fieldDefaultValueTypeCombo = this.factory.createCCombo(this.compContents, 2056);
        GridData gd_fieldValueTypeCombo = new GridData(4, 0x1000000, true, false, 9, 1);
        this.fieldDefaultValueTypeCombo.setLayoutData((Object)gd_fieldValueTypeCombo);
        this.fieldDefaultValueTypeCombo.setEnabled(false);
        this.fieldDefaultValueLabel = this.factory.createLabel(this.compContents, "", 0);
        this.fieldDefaultValueLabel.setText(PgmIntXlat.getLabel().getString("DEFAULT_VALUE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_fieldValueLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fieldDefaultValueLabel.setLayoutData((Object)gd_fieldValueLabel);
        this.fieldDefaultValueText = this.factory.createText(this.compContents, "", 8);
        GridData gd_fieldValueText = new GridData(4, 0x1000000, true, false, 9, 1);
        this.fieldDefaultValueText.setLayoutData((Object)gd_fieldValueText);
        this.fieldDefaultValueText.setEnabled(false);
        this.labelRemarks = this.factory.createLabel(this.compContents, "", 0);
        this.labelRemarks.setText(PgmIntXlat.getLabel().getString("EM_REMARKS") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelRemarks = new GridData(4, 128, true, false, 1, 1);
        this.labelRemarks.setLayoutData((Object)gd_labelRemarks);
        this.textRemarks = this.factory.createText(this.compContents, "", 586);
        GridData gd_textRemarks = new GridData(4, 0x1000000, true, false, 9, 1);
        gd_textRemarks.widthHint = 800;
        gd_textRemarks.heightHint = XSwt.getFontHeight((Control)this.textRemarks) * 5;
        this.textRemarks.setLayoutData((Object)gd_textRemarks);
        this.textRemarks.setEnabled(false);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedFieldNode = (FieldModel)((IStructuredSelection)selection).getFirstElement();
        this.setValues();
    }

    private void setValues() {
        String fieldName = this.selectedFieldNode.getField().getName();
        String remarks = this.selectedFieldNode.getField().getRemarks();
        String originalName = this.selectedFieldNode.getField().getOriginalName();
        if (originalName == null) {
            originalName = fieldName;
        }
        String length = this.selectedFieldNode.getField().getBytes() != null ? this.selectedFieldNode.getField().getBytes().toString() : "";
        String startbyte = this.selectedFieldNode.getField().getStartPos() != null ? this.selectedFieldNode.getField().getStartPos().toString() : "";
        this.textOriginalName.setText(originalName);
        this.textNewFieldName.setText(fieldName == null ? "" : fieldName);
        this.textLength.setText(length);
        this.textStartbyte.setText(startbyte);
        this.textRemarks.setText(remarks == null ? "" : remarks);
        this.fieldDataTypeText.setText(this.selectedFieldNode.getField().getApplicationDatatype().getDatatype().name());
        Boolean isHex = this.selectedFieldNode.getField().isIsHex();
        if (isHex != null) {
            if (isHex.booleanValue()) {
                this.fieldDefaultValueTypeCombo.setText(HEXADECIMAL);
            } else {
                this.fieldDefaultValueTypeCombo.setText(CHARACTER);
            }
        } else {
            this.fieldDefaultValueTypeCombo.setText(CHARACTER);
        }
        String defaultValue = this.selectedFieldNode.getField().getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            this.fieldDefaultValueText.setText(defaultValue);
        } else {
            this.fieldDefaultValueText.setText("");
        }
    }

    public void refresh() {
        super.refresh();
        this.setValues();
        this.compContents.layout(true);
    }
}

