/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors.properties;

import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DataStructurePropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite compContents;
    private Label labelOriginalName;
    private Label labelNewFieldName;
    private Label labelRemarks;
    private Text textOriginalName;
    private Text textNewFieldName;
    private Text textRemarks;
    private TabbedPropertySheetPage page;
    private TabbedPropertySheetWidgetFactory factory;
    private TranDataStructureModel selectedDSNode;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.factory = this.getWidgetFactory();
        this.compContents = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(10, false);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 500;
        this.compContents.setLayout((Layout)layout);
        this.compContents.setData((Object)data);
        this.labelOriginalName = this.factory.createLabel(this.compContents, "", 0);
        this.labelOriginalName.setText(PgmIntXlat.getLabel().getString("EDS_ORIGINAL_NAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelOriginalName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelOriginalName.setLayoutData((Object)gd_labelOriginalName);
        this.textOriginalName = this.factory.createText(this.compContents, "", 8);
        GridData gd_textOriginalName = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textOriginalName.setLayoutData((Object)gd_textOriginalName);
        this.textOriginalName.setEnabled(false);
        this.labelNewFieldName = this.factory.createLabel(this.compContents, "", 0);
        this.labelNewFieldName.setText(PgmIntXlat.getLabel().getString("EC_RENAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelNewFieldName.setLayoutData((Object)gd_labelFieldName);
        this.textNewFieldName = this.factory.createText(this.compContents, "", 8);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textNewFieldName.setLayoutData((Object)gd_textFieldName);
        this.textNewFieldName.setEnabled(false);
        this.labelRemarks = this.factory.createLabel(this.compContents, "", 0);
        this.labelRemarks.setText(PgmIntXlat.getLabel().getString("EM_REMARKS") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelRemarks = new GridData(4, 128, true, false, 1, 1);
        this.labelRemarks.setLayoutData((Object)gd_labelRemarks);
        this.textRemarks = this.factory.createText(this.compContents, "", 586);
        GridData gd_textRemarks = new GridData(4, 0x1000000, true, false, 9, 1);
        gd_textRemarks.widthHint = 800;
        gd_textRemarks.heightHint = XSwt.getFontHeight((Control)this.textRemarks) * 5;
        this.textRemarks.setLayoutData((Object)gd_textRemarks);
        this.textRemarks.setEnabled(false);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedDSNode = (TranDataStructureModel)((IStructuredSelection)selection).getFirstElement();
        this.setValues();
    }

    private void setValues() {
        String originalName = "";
        String fieldName = "";
        String remarks = "";
        if (this.selectedDSNode instanceof TranDataStructureModel) {
            TranDataStructureModel fieldNode = this.selectedDSNode;
            originalName = fieldNode.getField().getOriginalName();
            fieldName = fieldNode.getField().getName();
            remarks = fieldNode.getField().getRemarks();
        }
        if (originalName == null) {
            originalName = fieldName;
        }
        this.textOriginalName.setText(originalName);
        this.textNewFieldName.setText(fieldName == null ? "" : fieldName);
        this.textRemarks.setText(remarks == null ? "" : remarks);
    }

    public void refresh() {
        super.refresh();
        this.setValues();
        this.compContents.layout(true);
    }
}

