/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors.properties;

import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.CicsContainerType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ContainerPropertiesSection
extends AbstractPropertySection {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Composite compContents;
    private Label labelContainerName;
    private Label labelRename;
    private Label labelContainerType;
    private Text textContainerName;
    private Text textRename;
    private CCombo comboContainerType;
    private Button buttonRequired;
    private TabbedPropertySheetPage page;
    private TabbedPropertySheetWidgetFactory factory;
    private TranSegmentModel selectedContainerNode;
    private static final String CHAR = "CHAR";
    private static final String BIT = "BIT";

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        this.factory = this.getWidgetFactory();
        this.compContents = this.factory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(10, false);
        GridData data = new GridData(4, 4, true, false);
        data.widthHint = 500;
        this.compContents.setLayout((Layout)layout);
        this.compContents.setData((Object)data);
        this.labelContainerName = this.factory.createLabel(this.compContents, "", 0);
        this.labelContainerName.setText(PgmIntXlat.getLabel().getString("EC_CONTAINERNAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelOriginalName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelContainerName.setLayoutData((Object)gd_labelOriginalName);
        this.textContainerName = this.factory.createText(this.compContents, "", 8);
        GridData gd_textOriginalName = new GridData(4, 0x1000000, true, false, 9, 1);
        gd_textOriginalName.widthHint = 800;
        this.textContainerName.setLayoutData((Object)gd_textOriginalName);
        this.textContainerName.setEnabled(false);
        this.labelRename = this.factory.createLabel(this.compContents, "", 0);
        this.labelRename.setText(PgmIntXlat.getLabel().getString("EC_RENAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelRename.setLayoutData((Object)gd_labelFieldName);
        this.textRename = this.factory.createText(this.compContents, "", 8);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 9, 1);
        this.textRename.setLayoutData((Object)gd_textFieldName);
        this.textRename.setEnabled(false);
        this.labelContainerType = this.factory.createLabel(this.compContents, "", 0);
        this.labelContainerType.setText(PgmIntXlat.getLabel().getString("EC_TYPE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_fieldValueTypeLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelContainerType.setLayoutData((Object)gd_fieldValueTypeLabel);
        this.comboContainerType = this.factory.createCCombo(this.compContents, 2056);
        GridData gd_fieldValueTypeCombo = new GridData(4, 0x1000000, true, false, 9, 1);
        this.comboContainerType.setLayoutData((Object)gd_fieldValueTypeCombo);
        this.comboContainerType.setEnabled(false);
        this.buttonRequired = this.factory.createButton(this.compContents, "", 32);
        this.buttonRequired.setText(PgmIntXlat.getLabel().getString("EC_REQUIRED"));
        GridData gd_buttonRequired = new GridData(16384, 0x1000000, false, false, 10, 1);
        this.buttonRequired.setLayoutData((Object)gd_buttonRequired);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.selectedContainerNode = (TranSegmentModel)((IStructuredSelection)selection).getFirstElement();
        this.setValues();
    }

    private void setValues() {
        String rename = this.selectedContainerNode.getSegment().getName();
        String containerName = this.selectedContainerNode.getSegment().getOriginalName();
        CicsContainerType containerType = this.selectedContainerNode.getSegment().getContainerType();
        YesnoType containerRequired = this.selectedContainerNode.getSegment().getRequired();
        this.textContainerName.setText(containerName);
        this.textRename.setText(rename == null ? "" : rename);
        if (containerType == CicsContainerType.CHAR) {
            this.comboContainerType.setText(CHAR);
        } else {
            this.comboContainerType.setText(BIT);
        }
        if (containerRequired == YesnoType.Y) {
            this.buttonRequired.setSelection(true);
        } else {
            this.buttonRequired.setSelection(false);
        }
    }

    public void refresh() {
        super.refresh();
        this.setValues();
        this.compContents.layout(true);
    }
}

