/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.zosconnect.ui.programinterface.ProgramInterfacePlugin;
import com.ibm.zosconnect.ui.programinterface.controllers.model.GwTreeParent;
import com.ibm.zosconnect.ui.programinterface.controllers.model.ServiceNode;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class Utility {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<String, ImageDescriptor> imageCache;
    private static char[] specialChar;

    static {
        specialChar = new char[]{'<', '>', '&', '\\', '/', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '`', '~', ' ', '\"', '\''};
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        ImageDescriptor img;
        if (imageCache == null) {
            imageCache = new HashMap<String, ImageDescriptor>();
        }
        if ((img = imageCache.get(fileName)) == null || img.equals(ImageDescriptor.getMissingImageDescriptor())) {
            Bundle bundle = ProgramInterfacePlugin.getDefault().getBundle();
            Path iconPath = new Path("icons/" + fileName);
            URL url = FileLocator.find((Bundle)bundle, (IPath)iconPath, null);
            img = ImageDescriptor.createFromURL((URL)url);
            imageCache.put(fileName, img);
        }
        return img;
    }

    public static URL getURL(String path) {
        try {
            ProgramInterfacePlugin plugin = ProgramInterfacePlugin.getDefault();
            URL installURL = plugin.getBundle().getEntry(File.separator);
            URL url = FileLocator.resolve((URL)installURL);
            return new URL(url, path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getTextWidth(Composite composite, int style, String label) {
        Text text = new Text(composite, style);
        text.setText(label);
        text.setFont(composite.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public static int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    public static String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        Utility.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private static void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        if (!newEntry.isEmpty()) {
            history.add(0, newEntry);
        }
    }

    public static GwTreeParent getSelection(ExecutionEvent event) {
        TreeSelection currSel;
        Object selObj;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null) {
            HandlerUtil.getActivePart((ExecutionEvent)event);
        }
        if (selection != null && selection instanceof TreeSelection && (selObj = (currSel = (TreeSelection)selection).getFirstElement()) instanceof GwTreeParent) {
            return (GwTreeParent)selObj;
        }
        return null;
    }

    public static List<GwTreeParent> getSelectedNodes(ExecutionEvent event) {
        HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelection selection = null;
        return Utility.getSelectedNodes(selection);
    }

    public static List<GwTreeParent> getSelectedNodes(ISelection selection) {
        ArrayList<GwTreeParent> treeParents = new ArrayList<GwTreeParent>();
        if (selection instanceof TreeSelection) {
            TreeSelection currSel = (TreeSelection)selection;
            for (GwTreeParent obj : currSel) {
                treeParents.add(obj);
            }
        }
        return treeParents;
    }

    private static boolean nameInList(String name, Vector<String> list) {
        boolean retVal = false;
        int i = 0;
        while (i < list.size()) {
            String currName = list.get(i);
            if (name.equals(currName)) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public static boolean isStringNumeric(String text) {
        try {
            if (text.length() > 0) {
                Integer.parseInt(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isValidName(String name) {
        name = name.trim();
        Object invalidChars = "";
        char[] cArray = specialChar;
        int n = specialChar.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            invalidChars = (String)invalidChars + c;
            ++n2;
        }
        int i = 0;
        while (i < name.length()) {
            if (((String)invalidChars).contains(String.valueOf(name.charAt(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void editTranService(ServiceNode serviceNode) {
    }
}

