/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.programinterface.common.ui.SinglePageWizardDialog;
import com.ibm.zosconnect.ui.programinterface.controllers.datastructure.DataStructureSegmentAssociation;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.RedefineAsCharController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranMessageModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeParent;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.TreeNodeToolTipTreeListener;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditChannelDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditCompositeFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditContainerDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditMessageDialog;
import com.ibm.zosconnect.ui.programinterface.editors.Images;
import com.ibm.zosconnect.ui.programinterface.editors.MultiPageEditor;
import com.ibm.zosconnect.ui.programinterface.editors.RedefineAsCharDialog;
import com.ibm.zosconnect.ui.programinterface.editors.RedefinesSelectionDialog;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorAddAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorCopyAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorEditAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorExcludeAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorImportDSAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorIncludeAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorMoveDownAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorMoveUpAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorPasteAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorRedefineAsCharAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorRemoveAction;
import com.ibm.zosconnect.ui.programinterface.editors.actions.ProgramInterfaceEditorSelectRedefinesAction;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldDatatypeCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldDefaultValueCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldIncludeCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldLengthCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldNameCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldRenameCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.FieldStartByteCellLabelProvider;
import com.ibm.zosconnect.ui.programinterface.editors.providers.TransactionEditorContentProvider;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.Utility;
import com.ibm.zosconnect.ui.programinterface.wizard.importds.ImportDSTranMessageMetadataWizard;
import com.ibm.zosconnect.wv.metadata.transaction.CicsContainerType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MessageType;
import com.ibm.zosconnect.wv.metadata.transaction.SegmentType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TransactionEditorPage
extends FormPage
implements SelectionListener,
ModifyListener,
VerifyListener,
MouseListener,
ISelectionChangedListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MultiPageEditor editorParent;
    private static Logger logger;
    private ToolItem importDsButtonToolbar;
    private ToolItem addButtonToolbar;
    private ToolItem editButtonToolbar;
    private ToolItem copyButtonToolbar;
    private ToolItem pasteButtonToolbar;
    private ToolItem redefineSelectionButtonToolbar;
    private ToolItem removeButtonToolbar;
    private ToolItem moveUpButtonToolbar;
    private ToolItem moveDownButtonToolbar;
    private ToolItem includeInInterfaceButtonToolbar;
    private ToolItem excludeFromInterfaceButtonToolbar;
    private Form form;
    private TranEditorController controller;
    private TreeViewer viewer;
    private Tree tree;
    private Text searchText;
    private Label searchResultsLbl;
    private Button searchDownButton;
    private Button searchUpButton;
    private ArrayList<Object> nodesToBeRemoved = null;
    private boolean multiplePastes;
    private int msgDirection;
    private IMessageManager messageMgr;
    private Composite mainComposite;
    private Set<String> expandedFieldPaths = new HashSet<String>();
    private boolean isFindDialogOpen = false;
    private ServiceArchiveConstants.SP_Type spType = ServiceArchiveConstants.SP_Type.IMS;
    private static final String[] COLUMN_NAMES;

    static {
        COLUMN_NAMES = new String[]{PgmIntXlat.getLabel().getString("TSW_FIELD_NAME"), PgmIntXlat.getLabel().getString("TSW_FIELD_INCLUDE"), PgmIntXlat.getLabel().getString("TSW_FIELD_INTERFACE_RENAME"), PgmIntXlat.getLabel().getString("TSW_FIELD_DEFAULT_VALUE"), PgmIntXlat.getLabel().getString("TSW_FIELD_DATA_TYPE"), PgmIntXlat.getLabel().getString("TSW_FIELD_LENGTH"), PgmIntXlat.getLabel().getString("TSW_FIELD_START_BYTE")};
    }

    public TransactionEditorPage(MultiPageEditor parent, Composite compositeContainer, TranEditorController controller, int msgDirection, ServiceArchiveConstants.SP_Type spType) {
        super(null, "TransactionEditor", "");
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.editorParent = parent;
        this.controller = controller;
        this.msgDirection = msgDirection;
        this.spType = spType;
        this.createContent(compositeContainer);
        parent.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.validateEverything();
    }

    public TranEditorController getController() {
        return this.controller;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void createContent(Composite parent) {
        FormColors formColors = new FormColors(parent.getDisplay());
        formColors.markShared();
        FormToolkit toolkit = new FormToolkit(formColors);
        this.form = toolkit.createForm(parent);
        this.form.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point point = TransactionEditorPage.this.form.getSize();
                if (point.x > 0 && point.y > 0) {
                    TransactionEditorPage.this.validateEverything();
                }
            }
        });
        this.createEditor(toolkit);
    }

    private void createEditor(FormToolkit toolkit) {
        this.form.setText(PgmIntXlat.getLabel().getString("TMME_TITLE"));
        this.messageMgr = this.form.getMessageManager();
        this.messageMgr.setAutoUpdate(true);
        this.messageMgr.removeAllMessages();
        IToolBarManager toolbarMgr = this.form.getToolBarManager();
        toolbarMgr.add((IAction)new Action(Xlat.label((String)"HELP"), ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/xx_help16.gif")){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.zosconnect.ui.programinterface.edit_service_interface");
            }
        });
        toolbarMgr.update(true);
        Composite body = this.form.getBody();
        toolkit.decorateFormHeading(this.form);
        toolkit.paintBordersFor(body);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 10;
        body.setLayout((Layout)gridLayout);
        this.mainComposite = toolkit.createComposite(body, 0);
        GridLayout gl_compMain = new GridLayout(1, false);
        gl_compMain.marginWidth = 0;
        gl_compMain.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gl_compMain);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(this.mainComposite);
        Composite client = toolkit.createComposite(this.mainComposite, 0);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label editorDesc = new Label(client, 64);
        editorDesc.setText(PgmIntXlat.getDescription().getString("TMME_DESC"));
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        editorDesc.setLayoutData((Object)gd);
        Label separator = new Label(client, 258);
        gd = new GridData(4, 0x1000000, true, false, 2, 1);
        separator.setLayoutData((Object)gd);
        this.createSearchAndButtonsComposite(client);
        this.viewer = new TreeViewer(client, 68098);
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent arg0) {
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData treeGridData = new GridData(4, 4, true, true, 2, 1);
        treeGridData.verticalSpan = 11;
        this.tree = this.viewer.getTree();
        this.tree.setLayoutData((Object)treeGridData);
        this.tree.addMouseListener((MouseListener)this);
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(true);
        this.tree.addMouseMoveListener((MouseMoveListener)new TreeNodeToolTipTreeListener(this.tree, this.controller));
        final Menu contextMenu = new Menu((Control)this.tree);
        this.tree.setMenu(contextMenu);
        contextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = contextMenu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                boolean enableImport = false;
                boolean enableAdd = false;
                boolean enableEdit = false;
                boolean enableCopy = false;
                boolean enablePaste = false;
                boolean enableRemove = false;
                boolean enableMoveUp = false;
                boolean enableMoveDown = false;
                boolean enableIncludeInInterface = false;
                boolean enableExcludeFromInterface = false;
                boolean enableRedefineSelection = false;
                boolean enableRedefineAsChar = false;
                if (TransactionEditorPage.this.tree.getSelection().length > 1) {
                    ActionContributionItem item;
                    boolean includesFieldNode = false;
                    boolean includesMessageNode = false;
                    boolean includesSegNode = false;
                    boolean includesDSNode = false;
                    TreeItem[] selections = TransactionEditorPage.this.tree.getSelection();
                    int selectedSegmentCount = 0;
                    int i2 = 0;
                    while (i2 < selections.length) {
                        Object selectedNode = selections[i2].getData();
                        if (selectedNode instanceof FieldModel) {
                            includesFieldNode = true;
                        } else if (selectedNode instanceof TranMessageModel) {
                            includesMessageNode = true;
                        } else if (selectedNode instanceof TranSegmentModel) {
                            includesSegNode = true;
                            ++selectedSegmentCount;
                        } else if (selectedNode instanceof TranDataStructureModel) {
                            includesDSNode = true;
                        }
                        ++i2;
                    }
                    if (!includesFieldNode && !includesMessageNode) {
                        enableRemove = true;
                        if (selectedSegmentCount == TransactionEditorPage.this.controller.getSegmentsCount()) {
                            enableRemove = false;
                        }
                        if ((TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) && includesSegNode) {
                            enableRemove = false;
                        }
                    } else if (!(includesMessageNode || includesSegNode || includesDSNode)) {
                        enableIncludeInInterface = true;
                        enableExcludeFromInterface = true;
                    }
                    if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMSDB) {
                        enableRemove = false;
                    }
                    if (enableRemove) {
                        ProgramInterfaceEditorRemoveAction removeAction = new ProgramInterfaceEditorRemoveAction(TransactionEditorPage.this);
                        removeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)removeAction);
                        item.fill(contextMenu, -1);
                        removeAction.setImageDescriptor(Images.getRemoveImageDescriptor());
                    }
                    if (enableIncludeInInterface) {
                        ProgramInterfaceEditorIncludeAction includeAction = new ProgramInterfaceEditorIncludeAction(TransactionEditorPage.this, true);
                        includeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)includeAction);
                        item.fill(contextMenu, -1);
                        includeAction.setImageDescriptor(Images.getIncludeImageDescriptor());
                    }
                    if (enableExcludeFromInterface) {
                        ProgramInterfaceEditorExcludeAction excludeAction = new ProgramInterfaceEditorExcludeAction(TransactionEditorPage.this, true);
                        excludeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)excludeAction);
                        item.fill(contextMenu, -1);
                        excludeAction.setImageDescriptor(Images.getExcludeImageDescriptor());
                    }
                } else if (TransactionEditorPage.this.tree.getSelection().length == 1) {
                    ActionContributionItem item;
                    Object selectedNode = TransactionEditorPage.this.tree.getSelection()[0].getData();
                    if (selectedNode instanceof TranMessageModel) {
                        enableEdit = true;
                        enableAdd = true;
                        if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMSDB) {
                            enableEdit = false;
                            enableAdd = false;
                        }
                    } else if (selectedNode instanceof TranSegmentModel) {
                        if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            TranSegmentModel containerNode = (TranSegmentModel)selectedNode;
                            if (containerNode.getSegment().getContainerType() == CicsContainerType.BIT) {
                                enableImport = true;
                            }
                        } else if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMS || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                            enableImport = true;
                        }
                        if (TransactionEditorPage.this.controller.canPaste()) {
                            enablePaste = true;
                        }
                        if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL || TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                            if (TransactionEditorPage.this.controller.getSegmentsCount() > 1) {
                                enableRemove = true;
                            }
                            if (TransactionEditorPage.this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                                enableMoveUp = true;
                            }
                            if (TransactionEditorPage.this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                                enableMoveDown = true;
                            }
                        }
                        if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            enableEdit = true;
                        }
                    } else if (selectedNode instanceof TranDataStructureModel) {
                        enableCopy = true;
                        enableEdit = true;
                        if (TransactionEditorPage.this.controller.canPaste()) {
                            enablePaste = true;
                        }
                        enableRemove = true;
                        if (TransactionEditorPage.this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                            enableMoveUp = true;
                        }
                        if (TransactionEditorPage.this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                            enableMoveDown = true;
                        }
                    } else if (selectedNode instanceof FieldModel) {
                        FieldModel node = (FieldModel)selectedNode;
                        RedefineAsCharController redefAsCharCtrl = new RedefineAsCharController(node.getField());
                        if (TransactionEditorPage.this.controller.isInRedefinesGroup(node)) {
                            enableRedefineSelection = true;
                        }
                        if (!node.isDependedOnField() && !node.isCounterField()) {
                            enableEdit = true;
                            if (TransactionEditorPage.this.controller.getInclude(node) == YesnoType.Y) {
                                enableExcludeFromInterface = true;
                            } else {
                                enableIncludeInInterface = true;
                            }
                        }
                        if (node.isUserDefined()) {
                            enableRemove = true;
                        }
                        if (redefAsCharCtrl.canRedefineAsChar(true)) {
                            enableRedefineAsChar = true;
                        }
                    }
                    if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMSDB) {
                        enableImport = false;
                        enableAdd = false;
                        enableRedefineSelection = false;
                        enableCopy = false;
                        enablePaste = false;
                        enableRemove = false;
                        enableMoveUp = false;
                        enableMoveDown = false;
                    }
                    if (enableImport) {
                        ProgramInterfaceEditorImportDSAction importAction = new ProgramInterfaceEditorImportDSAction(TransactionEditorPage.this);
                        importAction.setEnabled(true);
                        ActionContributionItem item1 = new ActionContributionItem((IAction)importAction);
                        item1.fill(contextMenu, -1);
                        importAction.setImageDescriptor(Images.getImportDSImageDescriptor());
                    }
                    if (enableAdd) {
                        ProgramInterfaceEditorAddAction addAction = new ProgramInterfaceEditorAddAction(TransactionEditorPage.this);
                        addAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)addAction);
                        item.fill(contextMenu, -1);
                        if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            addAction.setImageDescriptor(Images.getAddContainerImageDescriptor());
                        } else if (TransactionEditorPage.this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                            addAction.setImageDescriptor(Images.getAddSegmentImageDescriptor());
                        }
                    }
                    if (enableEdit) {
                        ProgramInterfaceEditorEditAction editAction = new ProgramInterfaceEditorEditAction(TransactionEditorPage.this, selectedNode);
                        editAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)editAction);
                        item.fill(contextMenu, -1);
                        editAction.setImageDescriptor(Images.getEditRowImageDescriptor());
                    }
                    if (enableRedefineSelection) {
                        ProgramInterfaceEditorSelectRedefinesAction redefinesAction = new ProgramInterfaceEditorSelectRedefinesAction(TransactionEditorPage.this);
                        redefinesAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)redefinesAction);
                        item.fill(contextMenu, -1);
                        redefinesAction.setImageDescriptor(Images.getRedefineSelectionImageDescriptor());
                    }
                    if (enableCopy) {
                        ProgramInterfaceEditorCopyAction copyAction = new ProgramInterfaceEditorCopyAction(TransactionEditorPage.this);
                        copyAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)copyAction);
                        item.fill(contextMenu, -1);
                        copyAction.setImageDescriptor(Images.getCopyImageDescriptor());
                    }
                    if (enablePaste) {
                        ProgramInterfaceEditorPasteAction pasteAction = new ProgramInterfaceEditorPasteAction(TransactionEditorPage.this);
                        pasteAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)pasteAction);
                        item.fill(contextMenu, -1);
                        pasteAction.setImageDescriptor(Images.getPasteImageDescriptor());
                    }
                    if (enableRemove) {
                        ProgramInterfaceEditorRemoveAction removeAction = new ProgramInterfaceEditorRemoveAction(TransactionEditorPage.this, selectedNode);
                        removeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)removeAction);
                        item.fill(contextMenu, -1);
                        removeAction.setImageDescriptor(Images.getRemoveImageDescriptor());
                    }
                    if (enableMoveUp) {
                        ProgramInterfaceEditorMoveUpAction moveupAction = new ProgramInterfaceEditorMoveUpAction(TransactionEditorPage.this, selectedNode);
                        moveupAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)moveupAction);
                        item.fill(contextMenu, -1);
                        moveupAction.setImageDescriptor(Images.getMoveUpImageDescriptor());
                    }
                    if (enableMoveDown) {
                        ProgramInterfaceEditorMoveDownAction movedownAction = new ProgramInterfaceEditorMoveDownAction(TransactionEditorPage.this, selectedNode);
                        movedownAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)movedownAction);
                        item.fill(contextMenu, -1);
                        movedownAction.setImageDescriptor(Images.getMoveDownImageDescriptor());
                    }
                    if (enableIncludeInInterface) {
                        ProgramInterfaceEditorIncludeAction includeAction = new ProgramInterfaceEditorIncludeAction(TransactionEditorPage.this, false);
                        includeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)includeAction);
                        item.fill(contextMenu, -1);
                        includeAction.setImageDescriptor(Images.getIncludeImageDescriptor());
                    }
                    if (enableExcludeFromInterface) {
                        ProgramInterfaceEditorExcludeAction excludeAction = new ProgramInterfaceEditorExcludeAction(TransactionEditorPage.this, false);
                        excludeAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)excludeAction);
                        item.fill(contextMenu, -1);
                        excludeAction.setImageDescriptor(Images.getExcludeImageDescriptor());
                    }
                    if (enableRedefineAsChar) {
                        ProgramInterfaceEditorRedefineAsCharAction redefineAsCharAction = new ProgramInterfaceEditorRedefineAsCharAction(TransactionEditorPage.this, (FieldModel)selectedNode);
                        redefineAsCharAction.setEnabled(true);
                        item = new ActionContributionItem((IAction)redefineAsCharAction);
                        item.fill(contextMenu, -1);
                        redefineAsCharAction.setImageDescriptor(Images.getUserRedefiningFieldImageDescriptor());
                    }
                }
            }
        });
        this.viewer.setColumnProperties(COLUMN_NAMES);
        TreeViewerColumn fieldNameColumn = new TreeViewerColumn(this.viewer, 2);
        fieldNameColumn.getColumn().setWidth(300);
        fieldNameColumn.getColumn().setMoveable(true);
        fieldNameColumn.getColumn().setText(COLUMN_NAMES[0]);
        fieldNameColumn.setLabelProvider((CellLabelProvider)new FieldNameCellLabelProvider(this.spType, this.controller));
        final CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor((Composite)this.viewer.getTree());
        TreeViewerColumn checkboxColumn = new TreeViewerColumn(this.viewer, 16384);
        int titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[1]) + 10;
        int colWidth = titleWidth > 30 ? titleWidth : 30;
        checkboxColumn.getColumn().setWidth(colWidth);
        checkboxColumn.getColumn().setMoveable(true);
        checkboxColumn.getColumn().setText(COLUMN_NAMES[1]);
        checkboxColumn.setLabelProvider((CellLabelProvider)new FieldIncludeCellLabelProvider());
        checkboxColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected boolean canEdit(Object element) {
                FieldModel node;
                return !(element instanceof FieldModel) || !(node = (FieldModel)element).isDependedOnField() && !node.isCounterField();
            }

            protected CellEditor getCellEditor(Object element) {
                return checkboxCellEditor;
            }

            protected Object getValue(Object element) {
                FieldModel node;
                boolean retVal = false;
                if (element instanceof FieldModel && (node = (FieldModel)element).getField().getIncluded() == YesnoType.Y) {
                    retVal = true;
                }
                return retVal;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof FieldModel) {
                    TransactionEditorPage.this.controller.setInclude((FieldModel)element, ((Boolean)value).booleanValue());
                    TransactionEditorPage.this.editorParent.setDirty(true);
                    TransactionEditorPage.this.viewer.refresh();
                    TransactionEditorPage.this.validateEverything();
                }
            }
        });
        TreeViewerColumn renameColumn = new TreeViewerColumn(this.viewer, 16384);
        titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[2]) + 10;
        colWidth = titleWidth > 200 ? titleWidth : 200;
        renameColumn.getColumn().setWidth(colWidth);
        renameColumn.getColumn().setMoveable(true);
        renameColumn.getColumn().setText(COLUMN_NAMES[2]);
        renameColumn.setLabelProvider((CellLabelProvider)new FieldRenameCellLabelProvider(this.spType));
        TreeViewerColumn defaultValueColumn = new TreeViewerColumn(this.viewer, 16384);
        titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[3]) + 10;
        colWidth = titleWidth > 140 ? titleWidth : 140;
        defaultValueColumn.getColumn().setWidth(colWidth);
        defaultValueColumn.getColumn().setMoveable(true);
        defaultValueColumn.getColumn().setText(COLUMN_NAMES[3]);
        defaultValueColumn.getColumn().setToolTipText(PgmIntXlat.getLabel().getString("TSW_FIELD_DEFAULT_VALUE_TOOLTIP"));
        defaultValueColumn.setLabelProvider((CellLabelProvider)new FieldDefaultValueCellLabelProvider());
        TreeViewerColumn dataTypeColumn = new TreeViewerColumn(this.viewer, 16384);
        titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[4]) + 10;
        colWidth = titleWidth > 140 ? titleWidth : 140;
        dataTypeColumn.getColumn().setWidth(colWidth);
        dataTypeColumn.getColumn().setMoveable(true);
        dataTypeColumn.getColumn().setText(COLUMN_NAMES[4]);
        dataTypeColumn.setLabelProvider((CellLabelProvider)new FieldDatatypeCellLabelProvider());
        TreeViewerColumn lengthColumn = new TreeViewerColumn(this.viewer, 16384);
        titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[5]) + 10;
        colWidth = titleWidth > 100 ? titleWidth : 100;
        lengthColumn.getColumn().setWidth(colWidth);
        lengthColumn.getColumn().setMoveable(true);
        lengthColumn.getColumn().setText(COLUMN_NAMES[5]);
        lengthColumn.setLabelProvider((CellLabelProvider)new FieldLengthCellLabelProvider());
        if (this.spType != ServiceArchiveConstants.SP_Type.IMSDB) {
            TreeViewerColumn startByteColumn = new TreeViewerColumn(this.viewer, 16384);
            titleWidth = Utility.getTextWidth(this.mainComposite, 0, COLUMN_NAMES[6]) + 10;
            colWidth = titleWidth > 100 ? titleWidth : 100;
            startByteColumn.getColumn().setWidth(colWidth);
            startByteColumn.getColumn().setMoveable(true);
            startByteColumn.getColumn().setText(COLUMN_NAMES[6]);
            startByteColumn.setLabelProvider((CellLabelProvider)new FieldStartByteCellLabelProvider());
        }
        this.viewer.setContentProvider((IContentProvider)new TransactionEditorContentProvider(this));
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            this.viewer.setInput((Object)this.controller.getInvisibleRootRequest().getChildren()[0]);
        } else if (this.msgDirection == 0) {
            this.viewer.setInput((Object)this.controller.getInvisibleRootRequest());
        } else {
            this.viewer.setInput((Object)this.controller.getInvisibleRootResponse());
        }
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 102) {
                    TransactionEditorPage.this.searchText.setFocus();
                    TransactionEditorPage.this.searchText.setSelection(0, TransactionEditorPage.this.searchText.getText().length());
                } else if (e.character == '\r') {
                    TransactionEditorPage.this.handleSearchDown();
                    TransactionEditorPage.this.enableSearchButtons();
                }
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.viewer.expandAll();
        toolkit.paintBordersFor(client);
    }

    private void createSearchAndButtonsComposite(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        containerComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(20, true);
        containerComposite.setLayout((Layout)gridLayout);
        Composite searchComposite = new Composite(containerComposite, 64);
        gridData = new GridData(4, 4, false, false, 5, 1);
        gridData.widthHint = 90;
        searchComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(5, false);
        searchComposite.setLayout((Layout)gridLayout);
        Label searchLbl = new Label(searchComposite, 64);
        searchLbl.setText(PgmIntXlat.getLabel().getString("SIE_SEARCH") + PgmIntXlat.getColon().getString("COLON"));
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        searchLbl.setLayoutData((Object)gridData);
        int fieldWidthHint = XSwt.getAverageCharWidth((Control)searchComposite) * 10;
        int searchTextWidth = 25;
        this.searchText = new Text(searchComposite, 2628);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = searchTextWidth;
        gridData.minimumWidth = fieldWidthHint;
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener((ModifyListener)this);
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    TransactionEditorPage.this.handleSearchDown();
                    TransactionEditorPage.this.enableSearchButtons();
                }
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.searchDownButton = new Button(searchComposite, 72);
        this.searchDownButton.setImage(Images.getSearchDownImage());
        this.searchDownButton.setToolTipText(PgmIntXlat.getLabel().getString("SIE_SEARCHDOWN_HOVER"));
        this.searchDownButton.addSelectionListener((SelectionListener)this);
        this.searchDownButton.setEnabled(false);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.searchDownButton.setLayoutData((Object)gridData);
        this.searchUpButton = new Button(searchComposite, 72);
        this.searchUpButton.setImage(Images.getSearchUpImage());
        this.searchUpButton.setToolTipText(PgmIntXlat.getLabel().getString("SIE_SEARCHUP_HOVER"));
        this.searchUpButton.addSelectionListener((SelectionListener)this);
        this.searchUpButton.setEnabled(false);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.searchUpButton.setLayoutData((Object)gridData);
        String results = "100/100";
        Object[] inserts = new Object[]{results};
        int searchResultStringLength = XSwt.getAverageCharWidth((Control)searchComposite) * PgmIntXlat.getLabel().getString("SIE_SEARCH_RESULTS", inserts).length();
        this.searchResultsLbl = new Label(searchComposite, 64);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.widthHint = searchResultStringLength;
        this.searchResultsLbl.setLayoutData((Object)gridData);
        this.searchResultsLbl.setVisible(false);
        Composite buttonsComposite = new Composite(containerComposite, 0);
        gridData = new GridData(4, 4, true, false, 15, 1);
        buttonsComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(2, false);
        buttonsComposite.setLayout((Layout)gridLayout);
        ToolBar toolBar = new ToolBar(buttonsComposite, 8519744);
        this.importDsButtonToolbar = new ToolItem(toolBar, 8);
        this.importDsButtonToolbar.setImage(Images.getImportDSImage());
        this.importDsButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_IMPORT_DATA_STRUCTURE_HOVER"));
        this.importDsButtonToolbar.addSelectionListener((SelectionListener)this);
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            this.importDsButtonToolbar.setEnabled(false);
        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            this.importDsButtonToolbar.setEnabled(true);
        }
        new ToolItem(toolBar, 2);
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL || this.spType == ServiceArchiveConstants.SP_Type.IMS) {
            this.addButtonToolbar = new ToolItem(toolBar, 8);
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                this.addButtonToolbar.setImage(Images.getAddContainerImage());
                this.addButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_ADD_CONTAINER_HOVER"));
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                this.addButtonToolbar.setImage(Images.getAddSegmentImage());
                this.addButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_ADD_SEGMENT_HOVER"));
            }
            this.addButtonToolbar.addSelectionListener((SelectionListener)this);
            this.addButtonToolbar.setEnabled(true);
            new ToolItem(toolBar, 2);
        }
        this.moveUpButtonToolbar = new ToolItem(toolBar, 8);
        this.moveUpButtonToolbar.setImage(Images.getMoveUpImage());
        this.moveUpButtonToolbar.addSelectionListener((SelectionListener)this);
        this.moveUpButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.moveDownButtonToolbar = new ToolItem(toolBar, 8);
        this.moveDownButtonToolbar.setImage(Images.getMoveDownImage());
        this.moveDownButtonToolbar.addSelectionListener((SelectionListener)this);
        this.moveDownButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.editButtonToolbar = new ToolItem(toolBar, 8);
        this.editButtonToolbar.setImage(Images.getEditRowImage());
        this.editButtonToolbar.addSelectionListener((SelectionListener)this);
        this.editButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.redefineSelectionButtonToolbar = new ToolItem(toolBar, 8);
        this.redefineSelectionButtonToolbar.setImage(Images.getRedefineSelectionImage());
        this.redefineSelectionButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_REDEFINESELECTION_HOVER"));
        this.redefineSelectionButtonToolbar.addSelectionListener((SelectionListener)this);
        this.redefineSelectionButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.includeInInterfaceButtonToolbar = new ToolItem(toolBar, 8);
        this.includeInInterfaceButtonToolbar.setImage(Images.getIncludeImage());
        this.includeInInterfaceButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_INCLUDE_HOVER"));
        this.includeInInterfaceButtonToolbar.addSelectionListener((SelectionListener)this);
        this.includeInInterfaceButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.excludeFromInterfaceButtonToolbar = new ToolItem(toolBar, 8);
        this.excludeFromInterfaceButtonToolbar.setImage(Images.getExcludeImage());
        this.excludeFromInterfaceButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EXCLUDE_HOVER"));
        this.excludeFromInterfaceButtonToolbar.addSelectionListener((SelectionListener)this);
        this.excludeFromInterfaceButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.copyButtonToolbar = new ToolItem(toolBar, 8);
        this.copyButtonToolbar.setImage(Images.getCopyImage());
        this.copyButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_COPY_DISABLE_HOVER"));
        this.copyButtonToolbar.addSelectionListener((SelectionListener)this);
        this.copyButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.pasteButtonToolbar = new ToolItem(toolBar, 8);
        this.pasteButtonToolbar.setImage(Images.getPasteImage());
        this.pasteButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_PASTE_HOVER"));
        this.pasteButtonToolbar.addSelectionListener((SelectionListener)this);
        this.pasteButtonToolbar.setEnabled(false);
        new ToolItem(toolBar, 2);
        this.removeButtonToolbar = new ToolItem(toolBar, 8);
        this.removeButtonToolbar.setImage(Images.getRemoveImage());
        this.removeButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_REMOVE_HOVER"));
        this.removeButtonToolbar.addSelectionListener((SelectionListener)this);
        this.removeButtonToolbar.setEnabled(false);
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_CICSCHANNEL_DISABLED_HOVER"));
            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_CICSCHANNEL_DISABLED_HOVER"));
        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_IMS_DISABLED_HOVER"));
            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_IMS_DISABLED_HOVER"));
        }
        this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_DISABLED_HOVER"));
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        toolBar.setLayoutData((Object)gridData);
        toolBar.pack();
    }

    public void dispose() {
        this.form.dispose();
        super.dispose();
    }

    public Composite getPage() {
        return this.form;
    }

    private void displaySearchResults(int position, int totalMatches) {
        String results = position + "/" + totalMatches;
        Object[] inserts = new Object[]{results};
        this.searchResultsLbl.setVisible(true);
        this.searchResultsLbl.setText(PgmIntXlat.getLabel().getString("SIE_SEARCH_RESULTS", inserts));
    }

    private void displayNoResultsFound() {
        this.searchResultsLbl.setVisible(true);
        this.searchResultsLbl.setText(PgmIntXlat.getLabel().getString("SIE_SEARCH_NO_RESULTS"));
    }

    private void clearSearchResults() {
        this.searchResultsLbl.setVisible(false);
        this.searchResultsLbl.setText("");
    }

    public void handleEdit() {
        FieldModel node;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranMessageModel) {
            this.handleEditMessageOrChannel();
        } else if (selectedNode instanceof TranSegmentModel) {
            this.handleEditContainer();
        } else if (selectedNode instanceof TranDataStructureModel) {
            this.handleEditDataStructure();
        } else if (selectedNode instanceof FieldModel && !(node = (FieldModel)selectedNode).isDependedOnField() && !node.isCounterField()) {
            this.handleEditField();
        }
    }

    private void handleEditMessageOrChannel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof TranMessageModel) {
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                TranMessageModel channelNode = (TranMessageModel)selection.getFirstElement();
                EditChannelDialog editDialog = new EditChannelDialog(XSwt.getActiveShell(), (TranTreeObject)channelNode, this.controller);
                editDialog.open();
                if (editDialog.getReturnCode() == 0) {
                    this.viewer.refresh();
                    this.editorParent.setDirty(true);
                    this.refreshProperties();
                }
            } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                TranMessageModel msgNode = (TranMessageModel)selection.getFirstElement();
                EditMessageDialog editDialog = new EditMessageDialog(XSwt.getActiveShell(), (TranTreeObject)msgNode, this.controller);
                editDialog.open();
                if (editDialog.getReturnCode() == 0) {
                    this.viewer.refresh();
                    this.editorParent.setDirty(true);
                    this.refreshProperties();
                }
            }
        }
    }

    private void handleEditContainer() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof TranSegmentModel && this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            TranSegmentModel containerNode = (TranSegmentModel)selection.getFirstElement();
            Vector existingContainerNames = this.controller.getExistingContainerNames(this.controller.getMsgOrChannelNode());
            Vector existingContainerInterfaceRenames = this.controller.getExistingContainerInterfaceRenames(this.controller.getMsgOrChannelNode());
            EditContainerDialog editDialog = new EditContainerDialog(XSwt.getActiveShell(), (TranTreeObject)containerNode, existingContainerNames, existingContainerInterfaceRenames, this.controller);
            editDialog.open();
            if (editDialog.getReturnCode() == 0) {
                if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                    if (this.controller.haveBitContainerInInterface()) {
                        this.importDsButtonToolbar.setEnabled(true);
                    } else {
                        this.importDsButtonToolbar.setEnabled(false);
                    }
                }
                this.viewer.refresh();
                this.editorParent.setDirty(true);
                this.refreshProperties();
            }
        }
    }

    public void handleAddContainer() throws MessageWalkerException {
        Vector existingContainerNames = this.controller.getExistingFieldNamesUnderThisNode((TranTreeParent)this.controller.getMsgOrChannelNode());
        Vector existingContainerInterfaceRenames = this.controller.getExistingContainerInterfaceRenames(this.controller.getMsgOrChannelNode());
        Object[] expandedElements = this.viewer.getExpandedElements();
        EditContainerDialog editDialog = new EditContainerDialog(XSwt.getActiveShell(), existingContainerNames, existingContainerInterfaceRenames, this.controller);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                if (this.controller.haveBitContainerInInterface()) {
                    this.importDsButtonToolbar.setEnabled(true);
                } else {
                    this.importDsButtonToolbar.setEnabled(false);
                }
            }
            TranMessageModel channelNode = this.controller.getMsgOrChannelNode();
            this.controller.populateSegmentNodes(channelNode.getSegments(), (TranTreeParent)channelNode);
            this.viewer.refresh();
            this.updateExpandTreeWithNewNodes(channelNode, expandedElements);
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void handleEditDataStructure() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TranDataStructureModel dataStructureNode = (TranDataStructureModel)selection.getFirstElement();
        Vector existingDataStructureNames = this.controller.getExistingDsNamesForPaste((Object)dataStructureNode);
        FieldEditorController fieldEditCtrl = new FieldEditorController(dataStructureNode.getField(), null, dataStructureNode.getField().getRemarks(), "Cp1047");
        EditCompositeFieldDialog editDialog = new EditCompositeFieldDialog(XSwt.getActiveShell(), (TranTreeObject)dataStructureNode, existingDataStructureNames, fieldEditCtrl, this.spType);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            this.controller.editDataStructure(dataStructureNode, fieldEditCtrl.getNewFieldName(), fieldEditCtrl.getNewFieldRemarks());
            this.viewer.refresh();
            this.editorParent.setDirty(true);
            this.refreshProperties();
        }
    }

    private void handleEditField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        FieldModel fieldNode = (FieldModel)selection.getFirstElement();
        Vector existingFieldNames = this.controller.getExistingFieldNamesUnderParent((TranTreeObject)fieldNode);
        FieldEditorController fieldEditCtrl = null;
        boolean isLeafField = false;
        if (TranEditorController.isLeafField((FieldModel)fieldNode)) {
            isLeafField = true;
            fieldEditCtrl = new FieldEditorController(fieldNode.getField(), fieldNode.getField().getDefaultValue(), fieldNode.getField().getRemarks(), "Cp1047");
            if (fieldNode.getField().isIsHex() == null) {
                fieldEditCtrl.setHex(false);
            } else {
                fieldEditCtrl.setHex(fieldNode.getField().isIsHex().booleanValue());
            }
        } else {
            fieldEditCtrl = new FieldEditorController(fieldNode.getField(), null, fieldNode.getField().getRemarks(), "Cp1047");
        }
        AbstractEditFieldDialog editDialog = null;
        editDialog = isLeafField ? new EditFieldDialog(XSwt.getActiveShell(), (TranTreeObject)fieldNode, existingFieldNames, fieldEditCtrl, this.spType) : new EditCompositeFieldDialog(XSwt.getActiveShell(), (TranTreeObject)fieldNode, existingFieldNames, fieldEditCtrl, this.spType);
        editDialog.open();
        if (editDialog.getReturnCode() == 0) {
            this.controller.editField(fieldNode, fieldEditCtrl);
            this.viewer.refresh();
            this.editorParent.setDirty(true);
            this.refreshProperties();
        }
    }

    public void refreshViewer() {
        if (XSwt.isNotDisposed((Control)this.viewer.getTree())) {
            this.viewer.refresh();
        }
    }

    public void handleRemove() throws MessageWalkerException {
        TranMessageModel currMsgNode;
        Object object;
        Object[] objectArray;
        ArrayList<TranTreeObject> onlyTheseNeedToBeRemoved = new ArrayList<TranTreeObject>();
        HashMap<TranMessageModel, TranMessageModel> messagesAffectedMap = new HashMap<TranMessageModel, TranMessageModel>();
        Object[] expandedElements = null;
        StructuredSelection restoreSelection = null;
        int i = 0;
        while (i < this.nodesToBeRemoved.size()) {
            TranTreeObject currNode = (TranTreeObject)this.nodesToBeRemoved.get(i);
            if (currNode instanceof TranSegmentModel) {
                onlyTheseNeedToBeRemoved.add(currNode);
            } else if (currNode instanceof TranDataStructureModel) {
                TranTreeObject segNode = (TranTreeObject)currNode.getParent();
                if (!this.nodesToBeRemoved.contains(segNode)) {
                    onlyTheseNeedToBeRemoved.add(currNode);
                }
            } else if (currNode instanceof FieldModel) {
                onlyTheseNeedToBeRemoved.add(currNode);
            }
            ++i;
        }
        boolean segmentsRemoved = false;
        HashMap<String, ArrayList<TranDataStructureModel>> removeDsMap = new HashMap<String, ArrayList<TranDataStructureModel>>();
        int i2 = 0;
        while (i2 < onlyTheseNeedToBeRemoved.size()) {
            Object currNode = onlyTheseNeedToBeRemoved.get(i2);
            if (currNode instanceof TranSegmentModel) {
                segmentsRemoved = true;
                TranSegmentModel currSegmentModel = (TranSegmentModel)currNode;
                TranMessageModel msgNode = (TranMessageModel)currSegmentModel.getParent();
                if (messagesAffectedMap.get(msgNode) == null) {
                    messagesAffectedMap.put(msgNode, msgNode);
                }
                expandedElements = this.viewer.getExpandedElements();
                this.controller.removeSegment(currSegmentModel);
                this.editorParent.setDirty(true);
                this.viewer.refresh();
            } else if (currNode instanceof TranDataStructureModel) {
                TranSegmentModel segNode = (TranSegmentModel)((TranDataStructureModel)currNode).getParent();
                ArrayList<TranDataStructureModel> dsNodeList = (ArrayList<TranDataStructureModel>)removeDsMap.get(segNode.getName());
                if (dsNodeList == null) {
                    dsNodeList = new ArrayList<TranDataStructureModel>();
                    removeDsMap.put(segNode.getName(), dsNodeList);
                }
                dsNodeList.add((TranDataStructureModel)currNode);
            } else if (currNode instanceof FieldModel) {
                FieldModel fieldNode = (FieldModel)currNode;
                this.saveTreeExpansionState();
                TranTreeParent redefinedNode = this.controller.removeRedefineAsCharField(fieldNode);
                this.editorParent.setDirty(true);
                this.refreshTreeAndRestoreExpansionState();
                restoreSelection = new StructuredSelection((Object)redefinedNode);
            }
            ++i2;
        }
        if (removeDsMap.keySet().size() > 0) {
            ArrayList segNameList = new ArrayList(removeDsMap.keySet());
            for (String segName : segNameList) {
                this.controller.removeDataStructureListUnderSameSegment((ArrayList)removeDsMap.get(segName));
            }
            this.editorParent.setDirty(true);
            this.viewer.refresh();
        }
        Object[] messagesAffected = messagesAffectedMap.values().toArray();
        if (this.spType == ServiceArchiveConstants.SP_Type.IMS && segmentsRemoved) {
            objectArray = messagesAffected;
            int n = messagesAffected.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                currMsgNode = (TranMessageModel)object;
                this.controller.reorganizeSegmentNumbers(currMsgNode);
                ++n2;
            }
        }
        objectArray = messagesAffected;
        int n = messagesAffected.length;
        int n3 = 0;
        while (n3 < n) {
            object = objectArray[n3];
            currMsgNode = (TranMessageModel)object;
            this.controller.populateSegmentNodes(currMsgNode.getSegments(), (TranTreeParent)currMsgNode);
            this.viewer.refresh();
            if (expandedElements != null) {
                this.expandTree(expandedElements);
            }
            ++n3;
        }
        this.resetToolbarForNoItemsSelected();
        if (restoreSelection != null) {
            this.viewer.setSelection(restoreSelection);
        }
        this.validateEverything();
    }

    private void resetToolbarForNoItemsSelected() {
        this.importDsButtonToolbar.setEnabled(true);
        if (this.addButtonToolbar != null) {
            this.addButtonToolbar.setEnabled(true);
        }
        this.editButtonToolbar.setEnabled(false);
        this.copyButtonToolbar.setEnabled(false);
        this.pasteButtonToolbar.setEnabled(false);
        this.redefineSelectionButtonToolbar.setEnabled(false);
        this.removeButtonToolbar.setEnabled(false);
        this.moveUpButtonToolbar.setEnabled(false);
        this.moveDownButtonToolbar.setEnabled(false);
        this.includeInInterfaceButtonToolbar.setEnabled(false);
        this.excludeFromInterfaceButtonToolbar.setEnabled(false);
    }

    public void handleAddSegment() throws MessageWalkerException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        TranMessageModel msgNode = this.controller.getMsgOrChannelNode();
        this.controller.addSegment(msgNode);
        this.controller.populateSegmentNodes(msgNode.getSegments(), (TranTreeParent)msgNode);
        this.viewer.refresh();
        this.updateExpandTreeWithNewNodes(msgNode, expandedElements);
        this.expandTree(expandedElements);
        this.editorParent.setDirty(true);
    }

    public void handleInclude() {
        IStructuredSelection selected = (IStructuredSelection)this.viewer.getSelection();
        for (Object element : selected) {
            if (!(element instanceof FieldModel)) continue;
            this.controller.setInclude((FieldModel)element, true);
            this.editorParent.setDirty(true);
            this.validateEverything();
        }
        this.viewer.refresh();
    }

    public void handleExclude() {
        IStructuredSelection selected = (IStructuredSelection)this.viewer.getSelection();
        for (Object element : selected) {
            if (!(element instanceof FieldModel)) continue;
            this.controller.setInclude((FieldModel)element, false);
            this.editorParent.setDirty(true);
            this.validateEverything();
        }
        this.viewer.refresh();
    }

    private void handleSearchDown() {
        String searchPattern = this.searchText.getText();
        int position = 0;
        int selectedNodeIndex = 0;
        if (searchPattern != null && !searchPattern.isEmpty()) {
            TranTreeObject selectedNode;
            searchPattern = searchPattern.toUpperCase();
            TreeItem[] selectedItems = this.tree.getSelection();
            ArrayList<TranTreeObject> allNodes = new ArrayList<TranTreeObject>();
            this.getAllNodes(allNodes);
            if (selectedItems.length == 0) {
                selectedNode = allNodes.get(0);
                selectedNodeIndex = 0;
            } else {
                selectedNode = (TranTreeObject)selectedItems[0].getData();
            }
            int matchCount = 0;
            ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
            int i = 0;
            while (i < allNodes.size()) {
                TranTreeObject currNode = allNodes.get(i);
                if (currNode != null && currNode.getName().toUpperCase().contains(searchPattern)) {
                    ++matchCount;
                    matchingIndices.add(i);
                }
                if (currNode == selectedNode) {
                    selectedNodeIndex = i;
                }
                ++i;
            }
            if (matchCount > 0) {
                boolean itemFound = false;
                for (Integer currMatchinIndex : matchingIndices) {
                    ++position;
                    if (selectedNodeIndex >= currMatchinIndex) continue;
                    TranTreeObject matchingNode = allNodes.get(currMatchinIndex);
                    this.viewer.reveal((Object)matchingNode);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)matchingNode));
                    itemFound = true;
                    break;
                }
                if (!itemFound) {
                    TranTreeObject matchingNode = allNodes.get((Integer)matchingIndices.get(0));
                    this.viewer.reveal((Object)matchingNode);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)matchingNode));
                    position = 1;
                }
                this.displaySearchResults(position, matchCount);
            } else {
                this.displayNoResultsFound();
            }
        }
    }

    private void handleSearchUp() {
        String searchPattern = this.searchText.getText();
        int position = 0;
        int selectedNodeIndex = 0;
        if (searchPattern != null && !searchPattern.isEmpty()) {
            TranTreeObject selectedNode;
            searchPattern = searchPattern.toUpperCase();
            TreeItem[] selectedItems = this.tree.getSelection();
            ArrayList<TranTreeObject> allNodes = new ArrayList<TranTreeObject>();
            this.getAllNodes(allNodes);
            if (selectedItems.length == 0) {
                selectedNode = allNodes.get(allNodes.size() - 1);
                selectedNodeIndex = allNodes.size() - 1;
            } else {
                TreeItem lastSelectedItem = selectedItems[selectedItems.length - 1];
                selectedNode = (TranTreeObject)lastSelectedItem.getData();
            }
            int matchCount = 0;
            ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
            int i = 0;
            while (i < allNodes.size()) {
                TranTreeObject currNode = allNodes.get(i);
                if (currNode != null && currNode.getName().toUpperCase().contains(searchPattern)) {
                    ++matchCount;
                    matchingIndices.add(i);
                }
                if (currNode == selectedNode) {
                    selectedNodeIndex = i;
                }
                ++i;
            }
            if (matchCount > 0) {
                boolean itemFound = false;
                if (selectedNodeIndex <= (Integer)matchingIndices.get(0)) {
                    if (!itemFound) {
                        TranTreeObject matchingNode = allNodes.get((Integer)matchingIndices.get(matchingIndices.size() - 1));
                        this.viewer.reveal((Object)matchingNode);
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)matchingNode));
                        position = matchCount;
                    }
                } else {
                    int i2 = 0;
                    for (Integer currMatchinIndex : matchingIndices) {
                        ++position;
                        if (selectedNodeIndex <= currMatchinIndex) {
                            int foundIndex = (Integer)matchingIndices.get(i2 - 1);
                            TranTreeObject matchingNode = allNodes.get(foundIndex);
                            this.viewer.reveal((Object)matchingNode);
                            this.viewer.setSelection((ISelection)new StructuredSelection((Object)matchingNode));
                            itemFound = true;
                            --position;
                            break;
                        }
                        ++i2;
                    }
                    if (!itemFound) {
                        TranTreeObject matchingNode = allNodes.get((Integer)matchingIndices.get(matchingIndices.size() - 1));
                        this.viewer.reveal((Object)matchingNode);
                        this.viewer.setSelection((ISelection)new StructuredSelection((Object)matchingNode));
                        position = matchCount;
                    }
                }
                this.displaySearchResults(position, matchCount);
            } else {
                this.displayNoResultsFound();
            }
        }
    }

    public void handleRedefineSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        FieldModel fieldNode = (FieldModel)selection.getFirstElement();
        Map saveMap = this.controller.saveRedefineGroupSelection(fieldNode);
        RedefinesSelectionDialog dialog = new RedefinesSelectionDialog(XSwt.getActiveShell(), fieldNode, this.controller);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.viewer.refresh();
            this.validateEverything();
            this.editorParent.setDirty(true);
        } else if (dialog.getReturnCode() == 1) {
            this.controller.resetRedefineGroupSelection(saveMap, fieldNode);
        }
    }

    public void handleRedefineAsCharField() throws MessageWalkerException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        FieldModel redefinedFieldNode = (FieldModel)selection.getFirstElement();
        this.saveTreeExpansionState();
        String redefiningFieldName = null;
        RedefineAsCharDialog dialog = new RedefineAsCharDialog(XSwt.getActiveShell(), redefinedFieldNode, this.controller);
        if (dialog.open() != 0) {
            return;
        }
        redefiningFieldName = dialog.getNewFieldName();
        TranTreeParent redefiningNode = this.controller.addRedefineAsCharField(redefinedFieldNode, redefiningFieldName);
        this.refreshTreeAndRestoreExpansionState();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)redefiningNode), true);
        this.validateEverything();
        this.editorParent.setDirty(true);
    }

    public void saveTreeExpansionState() {
        this.expandedFieldPaths.clear();
        Object[] objectArray = this.viewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object expandedElement = objectArray[n2];
            if (expandedElement instanceof FieldModel) {
                this.expandedFieldPaths.add(((FieldModel)expandedElement).getPath());
            } else if (expandedElement instanceof TranDataStructureModel) {
                this.expandedFieldPaths.add(((TranDataStructureModel)expandedElement).getName());
            }
            ++n2;
        }
    }

    public void refreshTreeAndRestoreExpansionState() {
        this.viewer.getTree().setVisible(false);
        this.viewer.refresh();
        for (String expandedFieldPath : this.expandedFieldPaths) {
            TranTreeParent fieldNode = (TranTreeParent)this.controller.getFieldPathToFieldModel().get(expandedFieldPath);
            if (fieldNode == null) continue;
            this.viewer.setExpandedState((Object)fieldNode, true);
        }
        this.viewer.getTree().setVisible(true);
    }

    private void refreshProperties() {
        TabbedPropertySheetPage propPage = this.editorParent.getPropertiesPage();
        if (propPage != null) {
            propPage.refresh();
        }
    }

    private void getAllNodes(ArrayList<TranTreeObject> allNodes) {
        TranTreeObject rootNode = null;
        if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            rootNode = this.controller.getInvisibleRootRequest().getChildren()[0];
        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            TranTreeObject rootMsgNode = this.controller.getInvisibleRootRequest().getChildren()[0];
            rootNode = ((TranTreeParent)rootMsgNode).getChildren()[0];
        }
        allNodes.add(rootNode);
        if (rootNode instanceof TranTreeParent) {
            TranTreeParent parentNode = (TranTreeParent)rootNode;
            TranTreeObject[] tranTreeObjectArray = parentNode.getChildren();
            int n = tranTreeObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TranTreeObject currNode = tranTreeObjectArray[n2];
                allNodes.add(currNode);
                this.addAllChildrenNodes(currNode, allNodes);
                ++n2;
            }
        }
    }

    private void addAllChildrenNodes(TranTreeObject node, ArrayList<TranTreeObject> allNodes) {
        TranTreeParent parentNode = (TranTreeParent)node;
        TranTreeObject[] tranTreeObjectArray = parentNode.getChildren();
        int n = tranTreeObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            TranTreeObject currNode = tranTreeObjectArray[n2];
            allNodes.add(currNode);
            if (node instanceof TranTreeParent) {
                this.addAllChildrenNodes(currNode, allNodes);
            }
            ++n2;
        }
    }

    private void updateExpandTreeWithNewNodes(TranMessageModel msgNode, Object[] expandedElements) {
        Vector<TranSegmentModel> alreadyReplacedSegs = new Vector<TranSegmentModel>();
        int i = 0;
        while (i < expandedElements.length) {
            if (expandedElements[i] == msgNode) {
                ++i;
                while (i < expandedElements.length && expandedElements[i] instanceof TranSegmentModel) {
                    TranTreeObject[] newSegs = msgNode.getChildren();
                    TranSegmentModel expandedSeg = (TranSegmentModel)expandedElements[i];
                    int j = 0;
                    while (j < newSegs.length) {
                        TranSegmentModel currSeg = (TranSegmentModel)newSegs[j];
                        if (expandedSeg.getName().equals(currSeg.getName())) {
                            alreadyReplacedSegs.add(currSeg);
                            expandedElements[i] = currSeg;
                            ++i;
                            while (i < expandedElements.length && expandedElements[i] instanceof TranDataStructureModel) {
                                TranTreeObject[] newDsNodes = currSeg.getChildren();
                                TranDataStructureModel expandedDs = (TranDataStructureModel)expandedElements[i];
                                int k = 0;
                                while (k < newDsNodes.length) {
                                    TranDataStructureModel currDs = (TranDataStructureModel)newDsNodes[k];
                                    if (expandedDs.getName().equals(currDs.getName())) {
                                        expandedElements[i] = currDs;
                                        break;
                                    }
                                    ++k;
                                }
                                ++i;
                            }
                            break;
                        }
                        ++j;
                    }
                    if (i >= expandedElements.length || !alreadyReplacedSegs.contains(expandedElements[i])) continue;
                    ++i;
                }
                break;
            }
            ++i;
        }
    }

    public void handleCopy() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.copyDataStructure((TranDataStructureModel)selectedNode);
            this.viewer.refresh();
            this.multiplePastes = false;
            this.enableToolbarButtons();
        }
    }

    public void handlePaste() throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel || selectedNode instanceof TranSegmentModel) {
            String collidedName;
            if (this.multiplePastes) {
                this.controller.reCopyDsForMultiplePastes();
            }
            if ((collidedName = this.controller.checkNameCollisionForPaste(selectedNode)) != null) {
                Vector existingDsNames = this.controller.getExistingDsNamesForPaste(selectedNode);
                this.controller.renameDsForPaste(collidedName, existingDsNames);
            }
            this.controller.pasteDataStructure(selectedNode);
            this.viewer.refresh();
            this.multiplePastes = true;
            this.validateEverything();
            this.editorParent.setDirty(true);
            this.enableToolbarButtons();
        }
    }

    public void handleMoveUp() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.moveUpDataStructure((TranDataStructureModel)selectedNode);
        } else if (selectedNode instanceof TranSegmentModel) {
            this.controller.moveUpSegment((TranSegmentModel)selectedNode);
        }
        this.viewer.refresh();
        this.expandTree(expandedElements);
        this.editorParent.setDirty(true);
        this.enableToolbarButtons();
    }

    public void handleMoveDown() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.moveDownDataStructure((TranDataStructureModel)selectedNode);
        } else if (selectedNode instanceof TranSegmentModel) {
            this.controller.moveDownSegment((TranSegmentModel)selectedNode);
        }
        this.viewer.refresh();
        this.expandTree(expandedElements);
        this.editorParent.setDirty(true);
        this.enableToolbarButtons();
    }

    public void expandTree(Object[] expandElements) {
        int i = 0;
        while (i < expandElements.length) {
            TranTreeObject currNode = (TranTreeObject)expandElements[i];
            boolean shouldExpand = true;
            TranTreeObject ancestorNode = (TranTreeObject)currNode.getParent();
            while (ancestorNode != null && ancestorNode != this.controller.getInvisibleRootRequest()) {
                boolean isExpanded = this.viewer.getExpandedState((Object)ancestorNode);
                if (!isExpanded) {
                    shouldExpand = false;
                    break;
                }
                ancestorNode = (TranTreeObject)ancestorNode.getParent();
            }
            if (shouldExpand) {
                this.viewer.expandToLevel(expandElements[i], 1);
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.handleSelectionChanged(e.getSource());
    }

    public void selectionChanged(SelectionChangedEvent e) {
        this.handleSelectionChanged(e.getSource());
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleSelectionChanged(e.getSource());
    }

    public void handleSelectionChanged(Object source) {
        try {
            if (source == this.importDsButtonToolbar) {
                this.handleImportDS(true);
            } else if (source == this.addButtonToolbar) {
                if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                    this.handleAddContainer();
                } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                    this.handleAddSegment();
                }
            } else if (source == this.editButtonToolbar) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectedNode instanceof TranMessageModel) {
                    this.handleEditMessageOrChannel();
                } else if (selectedNode instanceof TranDataStructureModel) {
                    this.handleEditDataStructure();
                } else if (selectedNode instanceof FieldModel) {
                    this.handleEditField();
                } else if (selectedNode instanceof TranSegmentModel) {
                    this.handleEditContainer();
                }
            } else if (source == this.removeButtonToolbar) {
                this.handleRemove();
            } else if (source == this.copyButtonToolbar) {
                this.handleCopy();
            } else if (source == this.pasteButtonToolbar) {
                this.handlePaste();
            } else if (source == this.moveUpButtonToolbar) {
                this.handleMoveUp();
            } else if (source == this.moveDownButtonToolbar) {
                this.handleMoveDown();
            } else if (source == this.includeInInterfaceButtonToolbar) {
                this.handleInclude();
            } else if (source == this.excludeFromInterfaceButtonToolbar) {
                this.handleExclude();
            } else if (source == this.searchDownButton) {
                this.handleSearchDown();
            } else if (source == this.searchUpButton) {
                this.handleSearchUp();
            } else if (source == this.redefineSelectionButtonToolbar) {
                this.handleRedefineSelection();
            } else if (source == this.tree || source == this.viewer) {
                this.enableToolbarButtons();
                this.enableSearchButtons();
                this.clearSearchResults();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public IStructuredSelection getSelections() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    private void enableToolbarButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            this.importDsButtonToolbar.setEnabled(true);
        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            if (this.controller.haveBitContainerInInterface()) {
                this.importDsButtonToolbar.setEnabled(true);
            } else {
                this.importDsButtonToolbar.setEnabled(false);
            }
        }
        this.editButtonToolbar.setEnabled(false);
        this.copyButtonToolbar.setEnabled(false);
        this.pasteButtonToolbar.setEnabled(false);
        this.removeButtonToolbar.setEnabled(false);
        this.moveUpButtonToolbar.setEnabled(false);
        this.moveDownButtonToolbar.setEnabled(false);
        this.includeInInterfaceButtonToolbar.setEnabled(false);
        this.excludeFromInterfaceButtonToolbar.setEnabled(false);
        this.redefineSelectionButtonToolbar.setEnabled(false);
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_CICSCHANNEL_DISABLED_HOVER"));
            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_CICSCHANNEL_DISABLED_HOVER"));
        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_CICSCOMMAREA_DISABLED_HOVER"));
            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_CICSCOMMAREA_DISABLED_HOVER"));
        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_IMS_DISABLED_HOVER"));
            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_IMS_DISABLED_HOVER"));
        }
        this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_DISABLED_HOVER"));
        this.copyButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_COPY_DISABLE_HOVER"));
        if (this.nodesToBeRemoved == null) {
            this.nodesToBeRemoved = new ArrayList();
        } else {
            this.nodesToBeRemoved.clear();
        }
        if (selection.size() > 1) {
            boolean includesFieldNode = false;
            boolean includesMessageNode = false;
            boolean includesSegNode = false;
            boolean includesDSNode = false;
            boolean atLeastOneSegmentPostDelete = true;
            int selectedSegmentCount = 0;
            for (Object selectedNode : selection.toList()) {
                if (!(selectedNode instanceof TranSegmentModel)) continue;
                ++selectedSegmentCount;
            }
            for (Object selectedNode : selection) {
                if (selectedNode instanceof FieldModel) {
                    includesFieldNode = true;
                    continue;
                }
                if (selectedNode instanceof TranMessageModel) {
                    includesMessageNode = true;
                    continue;
                }
                if (selectedNode instanceof TranSegmentModel) {
                    TranSegmentModel currentSelection;
                    TranMessageModel currentSelectionParent;
                    includesSegNode = true;
                    if ((this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) && selectedSegmentCount == (currentSelectionParent = (TranMessageModel)(currentSelection = (TranSegmentModel)selectedNode).getParent()).getSegments().size()) {
                        atLeastOneSegmentPostDelete = false;
                    }
                    if (this.spType != ServiceArchiveConstants.SP_Type.CICS_CHANNEL && this.spType != ServiceArchiveConstants.SP_Type.IMS) continue;
                    this.nodesToBeRemoved.add(selectedNode);
                    continue;
                }
                if (!(selectedNode instanceof TranDataStructureModel)) continue;
                includesDSNode = true;
                this.nodesToBeRemoved.add(selectedNode);
            }
            if (!includesFieldNode && !includesMessageNode) {
                if (atLeastOneSegmentPostDelete) {
                    this.removeButtonToolbar.setEnabled(true);
                }
                if ((this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) && includesSegNode) {
                    this.removeButtonToolbar.setEnabled(false);
                }
            } else if (!(includesMessageNode || includesSegNode || includesDSNode)) {
                this.includeInInterfaceButtonToolbar.setEnabled(true);
                this.excludeFromInterfaceButtonToolbar.setEnabled(true);
            }
        } else {
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof TranMessageModel) {
                if (this.spType == ServiceArchiveConstants.SP_Type.IMSDB) {
                    this.editButtonToolbar.setEnabled(false);
                } else {
                    this.editButtonToolbar.setEnabled(true);
                }
                this.editButtonToolbar.setEnabled(true);
                if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                    this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_CHANNEL_HOVER"));
                } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                    this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_MESSAGE_HOVER"));
                }
            } else if (selectedNode instanceof TranSegmentModel) {
                if (this.controller.canPaste()) {
                    this.pasteButtonToolbar.setEnabled(true);
                }
                if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL || this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                    if (this.controller.getSegmentsCount() > 1) {
                        this.nodesToBeRemoved.add(selectedNode);
                        this.removeButtonToolbar.setEnabled(true);
                    } else {
                        this.removeButtonToolbar.setEnabled(false);
                    }
                    if (this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                        this.moveUpButtonToolbar.setEnabled(true);
                        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_CONTAINER_HOVER"));
                        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                            this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_SEGMENT_HOVER"));
                        }
                    }
                    if (this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                        this.moveDownButtonToolbar.setEnabled(true);
                        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_CONTAINER_HOVER"));
                        } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                            this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_SEGMENT_HOVER"));
                        }
                    }
                    if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                        this.editButtonToolbar.setEnabled(true);
                        this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_CONTAINER_HOVER"));
                    }
                }
            } else if (selectedNode instanceof TranDataStructureModel) {
                this.copyButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_COPY_HOVER"));
                this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_DS_HOVER"));
                if (this.spType == ServiceArchiveConstants.SP_Type.IMSDB) {
                    this.copyButtonToolbar.setEnabled(false);
                    this.editButtonToolbar.setEnabled(true);
                    this.removeButtonToolbar.setEnabled(false);
                } else {
                    this.copyButtonToolbar.setEnabled(true);
                    this.editButtonToolbar.setEnabled(true);
                    this.removeButtonToolbar.setEnabled(true);
                }
                if (this.controller.canPaste()) {
                    this.pasteButtonToolbar.setEnabled(true);
                }
                this.nodesToBeRemoved.add(selectedNode);
                if (this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                    this.moveUpButtonToolbar.setEnabled(true);
                    this.moveUpButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEUP_DS_HOVER"));
                }
                if (this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                    this.moveDownButtonToolbar.setEnabled(true);
                    this.moveDownButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_MOVEDOWN_DS_HOVER"));
                }
            } else if (selectedNode instanceof FieldModel) {
                FieldModel node = (FieldModel)selectedNode;
                if (((FieldModel)selectedNode).isUserDefined()) {
                    this.nodesToBeRemoved.add(selectedNode);
                    this.removeButtonToolbar.setEnabled(true);
                } else {
                    this.removeButtonToolbar.setEnabled(false);
                }
                if (this.controller.isInRedefinesGroup(node)) {
                    this.redefineSelectionButtonToolbar.setEnabled(true);
                }
                if (!node.isDependedOnField() && !node.isCounterField()) {
                    this.editButtonToolbar.setEnabled(true);
                    this.editButtonToolbar.setToolTipText(PgmIntXlat.getLabel().getString("TNT_BUTTON_EDIT_FIELD_HOVER"));
                    if (this.controller.getInclude((FieldModel)selectedNode) == YesnoType.Y) {
                        this.excludeFromInterfaceButtonToolbar.setEnabled(true);
                    } else {
                        this.includeInInterfaceButtonToolbar.setEnabled(true);
                    }
                }
            }
        }
    }

    public void handleImportDS(boolean showImportList) throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        String selectedMessageName = null;
        String selectedSegmentName = null;
        TranSegmentModel tranSegmentModel = null;
        if (selection.size() == 1) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof TranMessageModel) {
                selectedMessageName = ((TranMessageModel)selectedObject).getMessage().getMessage().getName();
            } else if (selectedObject instanceof TranSegmentModel) {
                tranSegmentModel = (TranSegmentModel)selectedObject;
                selectedSegmentName = tranSegmentModel.getName();
                TranMessageModel msgNode = (TranMessageModel)tranSegmentModel.getParent();
                selectedMessageName = msgNode.getMessage().getMessage().getName();
            } else if (selectedObject instanceof TranDataStructureModel) {
                dataStructure = (TranDataStructureModel)selectedObject;
                tranSegmentModel = (TranSegmentModel)dataStructure.getParent();
                selectedSegmentName = tranSegmentModel.getName();
                msgNode = (TranMessageModel)tranSegmentModel.getParent();
                selectedMessageName = msgNode.getMessage().getMessage().getName();
            } else if (selectedObject instanceof FieldModel) {
                selectedObject = ((FieldModel)selectedObject).getParent();
                dataStructure = (TranDataStructureModel)selectedObject;
                tranSegmentModel = (TranSegmentModel)dataStructure.getParent();
                selectedSegmentName = tranSegmentModel.getName();
                msgNode = (TranMessageModel)tranSegmentModel.getParent();
                selectedMessageName = msgNode.getMessage().getMessage().getName();
            }
        }
        if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL && tranSegmentModel != null && tranSegmentModel.getSegment().getContainerType() == CicsContainerType.CHAR) {
            selectedSegmentName = "";
        }
        ImportDSTranMessageMetadataWizard dsMsgMetadataWizard = new ImportDSTranMessageMetadataWizard(this, selectedMessageName, selectedSegmentName, this.spType, showImportList);
        SinglePageWizardDialog dialog = new SinglePageWizardDialog(XSwt.getActiveShell(), (IWizard)dsMsgMetadataWizard);
        dialog.create();
        dialog.open();
        Vector<DataStructureSegmentAssociation> importResult = dsMsgMetadataWizard.getImportResult();
        if (importResult != null) {
            Object[] importDsArray = importResult.toArray();
            int i = 0;
            while (i < importDsArray.length) {
                DataStructureSegmentAssociation dssa = (DataStructureSegmentAssociation)importDsArray[i];
                String possibleCollideName = dssa.dataStructure.getName();
                if (dssa.nameCollision && dssa.sameSegmentCollision) {
                    String replaceMsg = null;
                    if (this.spType == ServiceArchiveConstants.SP_Type.IMS || this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                        inserts = new Object[3];
                        inserts[0] = possibleCollideName;
                        if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                            inserts[1] = PgmIntXlat.getLabel().getString("TNT_HOVER_ENTITY_SEGMENT");
                        } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                            inserts[1] = PgmIntXlat.getLabel().getString("CICS_CONTAINER");
                        }
                        inserts[2] = dssa.segmentName;
                        replaceMsg = PgmIntXlat.getDescription().getString("IDSNC_CONFIRM", inserts);
                    } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA || this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS || this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                        inserts = new Object[]{possibleCollideName};
                        replaceMsg = PgmIntXlat.getDescription().getString("IDSNC_CONFIRM2", inserts);
                    }
                    if (MessageDialog.openQuestion((Shell)this.getPage().getShell(), (String)PgmIntXlat.getLabel().getString("TNT_REPLACE_DIALOG_TITLE"), (String)replaceMsg)) {
                        this.controller.preserveFieldInfoAndRemoveDs(dssa);
                        dssa.preserveFieldInfo = true;
                    } else {
                        existingDsNames = this.controller.getExistingDsNamesForImport(dssa);
                        this.controller.renameDsForImport(possibleCollideName, existingDsNames, dssa);
                    }
                } else if (dssa.nameCollision && !dssa.sameSegmentCollision && !dssa.canUseOrigNameAsRename) {
                    Object[] inserts = new Object[3];
                    if (this.spType == ServiceArchiveConstants.SP_Type.IMS) {
                        inserts[0] = PgmIntXlat.getLabel().getString("TNT_HOVER_ENTITY_MESSAGE");
                    } else if (this.spType == ServiceArchiveConstants.SP_Type.IMS_LDS) {
                        inserts[0] = PgmIntXlat.getLabel().getString("TNT_HOVER_ENTITY_DATASTRUCTURE");
                    } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_CHANNEL) {
                        inserts[0] = PgmIntXlat.getLabel().getString("CICS_CHANNEL");
                    } else if (this.spType == ServiceArchiveConstants.SP_Type.CICS_COMM_AREA) {
                        inserts[0] = "COMMAREA";
                    } else if (this.spType == ServiceArchiveConstants.SP_Type.MQ_MESSAGE) {
                        inserts[0] = PgmIntXlat.getLabel().getString("MQ_SEGMENT_NAME");
                    }
                    inserts[1] = possibleCollideName;
                    MessageDialog.openInformation((Shell)this.getPage().getShell(), (String)PgmIntXlat.getLabel().getString("TNT_RENAME_DS_DIALOG_TITLE"), (String)PgmIntXlat.getDescription().getString("IDSNC_RENAME", inserts));
                    existingDsNames = this.controller.getExistingDsNamesForImport(dssa);
                    this.controller.renameDsForImport(possibleCollideName, existingDsNames, dssa);
                }
                this.controller.checkNameCollisionAmongImportDS(possibleCollideName, importResult, i);
                ++i;
            }
            this.controller.addImportedDS(importResult);
            this.viewer.refresh();
            this.editorParent.setDirty(true);
        }
    }

    private FieldType getFirstDSFound(List<MessageType> msgTypes) {
        FieldType dataStructure = null;
        int i = 0;
        while (i < msgTypes.size()) {
            if (dataStructure != null) break;
            MessageType currMsgType = msgTypes.get(i);
            List segTypes = currMsgType.getSegment();
            int j = 0;
            while (j < segTypes.size()) {
                SegmentType currSegType = (SegmentType)segTypes.get(j);
                List fieldTypeList = currSegType.getField();
                if (fieldTypeList.size() > 0) {
                    dataStructure = (FieldType)fieldTypeList.get(0);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return dataStructure;
    }

    public MultiPageEditor getParent() {
        return this.editorParent;
    }

    private void clearMessages() {
        this.messageMgr.removeAllMessages();
    }

    private void validateEverything() {
        this.clearMessages();
        this.validateInputFile();
        this.validateRedefines();
    }

    private void validateInputFile() {
        String warning = this.controller.geMismatchedInputFileWarning();
        if (warning != null) {
            this.messageMgr.addMessage((Object)warning, warning, null, 2);
        }
    }

    private void validateRedefines() {
        ArrayList warningMsgs = this.controller.validateRedefinesInclude();
        int i = 0;
        for (String msg : warningMsgs) {
            this.messageMgr.addMessage((Object)i, msg, null, 2);
            ++i;
        }
    }

    public ServiceArchiveConstants.SP_Type getSpType() {
        return this.spType;
    }

    public void setSpType(ServiceArchiveConstants.SP_Type spType) {
        this.spType = spType;
    }

    public void verifyText(VerifyEvent arg0) {
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.searchText) {
            this.enableSearchButtons();
        }
    }

    private void enableSearchButtons() {
        String searchString = this.searchText.getText();
        if (searchString != null && !searchString.isEmpty()) {
            this.searchDownButton.setEnabled(true);
            this.searchUpButton.setEnabled(true);
        } else {
            this.searchDownButton.setEnabled(false);
            this.searchUpButton.setEnabled(false);
        }
    }

    protected Tree getTree() {
        return this.tree;
    }

    private synchronized boolean testAndSetFindDialogOpen() {
        boolean retVal = this.isFindDialogOpen;
        this.isFindDialogOpen = true;
        return retVal;
    }

    public void setFindDialogOpen(boolean isFindDialogOpen) {
        this.isFindDialogOpen = isFindDialogOpen;
    }

    public void mouseDoubleClick(MouseEvent event) {
        Object sourceObj = event.getSource();
        if (sourceObj == this.tree) {
            this.handleEdit();
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }
}

