/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.editors.Images;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RedefinesSelectionDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private TranEditorController controller;
    private Composite compContents;
    private Composite mainComposite;
    private Label labelTable;
    private TableViewer tableViewer;
    private FieldModel fieldNode;
    private ArrayList<FieldModel> redefineFieldList;
    private Button okButton;
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int COMPOSITE_WIDTH = 410;
    private static final int NUM_ROWS_DISPLAYED = 7;
    private static final String[] COLUMN_NAMES = new String[]{PgmIntXlat.getLabel().getString("RSD_TABLE_COL1_NAME"), PgmIntXlat.getLabel().getString("RSD_TABLE_COL2_NAME")};

    public RedefinesSelectionDialog(Shell parentShell, FieldModel fieldNode, TranEditorController controller) {
        super(parentShell);
        this.fieldNode = fieldNode;
        this.controller = controller;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 410;
        this.compContents.setLayoutData((Object)gridData);
        GridLayout gl_compContents = new GridLayout(1, false);
        gl_compContents.marginTop = 5;
        gl_compContents.marginLeft = 2;
        gl_compContents.marginRight = 2;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.labelTable = new Label(this.compContents, 0);
        this.labelTable.setText(PgmIntXlat.getLabel().getString("RSD_TABLE_LABEL") + PgmIntXlat.getColon().getString("COLON"));
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.labelTable.setLayoutData((Object)gridData);
        Table table = this.formToolkit.createTable(this.compContents, 68096);
        gridData = new GridData(4, 0x1000000, true, true, 1, 1);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.redefineFieldList = this.fieldNode.getRedefinesGroup().getRedefinesGroupFields();
        if (this.redefineFieldList.size() > 7) {
            int tableHeight;
            gridData.heightHint = tableHeight = table.getItemHeight() * 7 + table.getHeaderHeight();
        }
        table.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(COLUMN_NAMES);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
        column.setText(COLUMN_NAMES[0]);
        column.setWidth(300);
        TableViewerColumn col1 = new TableViewerColumn(this.tableViewer, column);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FieldModel field = (FieldModel)element;
                return field.getName();
            }
        });
        final CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor((Composite)table);
        TableViewerColumn checkboxColumn = new TableViewerColumn(this.tableViewer, 16384);
        checkboxColumn.getColumn().setWidth(80);
        checkboxColumn.getColumn().setMoveable(true);
        checkboxColumn.getColumn().setText(COLUMN_NAMES[1]);
        checkboxColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                Image retVal = null;
                if (element instanceof FieldModel) {
                    FieldModel node = (FieldModel)element;
                    retVal = node.getField().getIncluded() == YesnoType.Y ? Images.getSelectedCheckbox() : Images.getUnselectedCheckbox();
                }
                return retVal;
            }
        });
        checkboxColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return checkboxCellEditor;
            }

            protected Object getValue(Object element) {
                FieldModel node;
                boolean retVal = false;
                if (element instanceof FieldModel && (node = (FieldModel)element).getField().getIncluded() == YesnoType.Y) {
                    retVal = true;
                }
                return retVal;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof FieldModel) {
                    RedefinesSelectionDialog.this.controller.setInclude((FieldModel)element, ((Boolean)value).booleanValue());
                    XSwt.enable((Control[])new Control[]{RedefinesSelectionDialog.this.okButton});
                    RedefinesSelectionDialog.this.tableViewer.refresh();
                    RedefinesSelectionDialog.this.validateRedefines();
                }
            }
        });
        this.tableViewer.setInput(this.redefineFieldList);
        return compDialogArea;
    }

    public void validateRedefines() {
        String warningMsg = this.controller.validateRedefinesInclude(this.redefineFieldList);
        if (warningMsg != null && !warningMsg.isEmpty()) {
            Status status = new Status(2, "com.ibm.zosconnect.ui.programinterface", warningMsg);
            this.updateStatusAndPack((IStatus)status);
        } else {
            this.updateStatusAndPack(Status.OK_STATUS);
        }
    }

    private void updateStatusAndPack(IStatus status) {
        this.updateStatus(status);
        XSwt.pack((Control)this.getShell());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
        XSwt.disable((Control[])new Control[]{this.okButton});
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PgmIntXlat.getLabel().getString("TNT_BUTTON_REDEFINESELECTION_HOVER"));
    }

    public void create() {
        super.create();
        this.validateRedefines();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }
}

