/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.StringUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RedefineAsCharDialog
extends StatusDialog
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String SOURCE_TYPE = PgmIntXlat.error((String)"EDS_FLD_LABEL");
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite mainComposite;
    private Label labelNewFieldName;
    private Text textNewFieldName;
    private ControlDecoration cd_textFieldName;
    private Button okButton;
    private FieldModel fieldNode;
    private TranEditorController controller;
    private List<String> existingNames;
    private String newFieldName;

    public RedefineAsCharDialog(Shell parentShell, FieldModel fieldNode, TranEditorController controller) {
        super(parentShell);
        this.fieldNode = fieldNode;
        this.controller = controller;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(2, false);
        gl_compDialogArea.horizontalSpacing = 10;
        gl_compDialogArea.verticalSpacing = 10;
        gl_compDialogArea.marginHeight = 10;
        gl_compDialogArea.marginWidth = 10;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        String fieldName = this.fieldNode.getOriginalName() + "_CHAR";
        this.labelNewFieldName = new Label(compDialogArea, 64);
        this.labelNewFieldName.setText(PgmIntXlat.labelWithColon((String)"EC_NEW_REDEFINES_FIELD_NAME"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelNewFieldName.setLayoutData((Object)gd_labelFieldName);
        this.textNewFieldName = new Text(compDialogArea, 2048);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textFieldName.widthHint = 43 * XSwt.getAverageCharWidth((Control)compDialogArea);
        this.textNewFieldName.setLayoutData((Object)gd_textFieldName);
        this.textNewFieldName.setText((String)(fieldName == null ? "" : fieldName));
        this.cd_textFieldName = new ControlDecoration((Control)this.textNewFieldName, 17408);
        XSwt.setTooltipText((Control)this.textNewFieldName, (String)PgmIntXlat.label((String)"EC_NEW_REDEFINES_FIELD_TOOLTIP"));
        XSwt.addTabTraverseListener((Control)this.textNewFieldName);
        this.textNewFieldName.addModifyListener((ModifyListener)this);
        this.textNewFieldName.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textNewFieldName.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        this.textNewFieldName.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        return compDialogArea;
    }

    protected void validatePage() {
        String msg = null;
        Status status = null;
        this.updateStatus(null);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textFieldName);
        if (this.existingNames == null) {
            this.existingNames = this.controller.getAllExistingNamesUnderParent((TranTreeObject)this.fieldNode);
        }
        this.newFieldName = this.textNewFieldName.getText().trim();
        if (this.newFieldName == null || this.newFieldName.isEmpty()) {
            String[] inserts = new String[]{SOURCE_TYPE};
            msg = PgmIntXlat.error((String)"EDS_MISSING_NAME", (String[])inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        } else if (!StringUtilz.isUniqueString(this.existingNames, (String)this.newFieldName, (boolean)true)) {
            String[] inserts = new String[]{this.newFieldName};
            msg = PgmIntXlat.error((String)"EDS_COLLIDED_NAME_FIELD", (String[])inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        }
        this.updateStatusAndPack((IStatus)status);
    }

    public void modifyText(ModifyEvent arg0) {
        this.validatePage();
    }

    private void updateStatusAndPack(IStatus status) {
        if (status != null && !status.isOK()) {
            this.updateStatus(status);
        } else {
            this.updateStatus(null);
        }
        XSwt.pack((Control)this.getShell());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
        XSwt.disable((Control[])new Control[]{this.okButton});
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            if (status.getSeverity() == 4) {
                XSwt.disable((Control[])new Control[]{this.okButton});
            } else {
                XSwt.enable((Control[])new Control[]{this.okButton});
            }
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PgmIntXlat.getLabel().getString("TNT_REDEFINE_AS_CHAR_DIALOG_TITLE"));
    }

    public void create() {
        super.create();
        XSwt.centerInWorkbench((Shell)this.getShell());
        this.validatePage();
    }

    public String getNewFieldName() {
        return this.newFieldName;
    }
}

