/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerTypes;
import com.ibm.zosconnect.ui.common.validation.ServiceProjectMarkerUtil;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.messages.InvalidInputException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeParent;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.ProjectTreeFileHelper;
import com.ibm.zosconnect.ui.programinterface.editors.TransactionEditorPage;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.UIHelper;
import com.ibm.zosconnect.wv.metadata.transaction.Message;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class MultiPageEditor
extends MultiPageEditorPart
implements ITabbedPropertySheetPageContributor,
IGotoMarker {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2019. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String EDITOR_ID = "com.ibm.zosconnect.editors.programinterface";
    private static Logger logger;
    public boolean isAtmtestCaseName = false;
    String tcName;
    private boolean isDirty = false;
    private String projectName;
    private String pgmName;
    private TransactionEditorPage tranEditorPage;
    private TranEditorController tranEditorController;
    private TabbedPropertySheetPage page;
    private String fileName;
    private ServiceArchiveConstants.SP_Type spType;
    private ServiceArchiveConstants.SP_Type project_spType;
    private boolean hasCapabilityErrors = false;
    private ResourceTracker resourceTracker;

    public MultiPageEditor() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    void addPages() throws JAXBException, CoreException, MessageWalkerException, UnsupportedTypeConversion, IOException, ConversionException, InvalidInputException {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        this.fileName = fileInput.getName();
        if (this.fileName.indexOf(".si") > 0) {
            this.fileName = this.fileName.substring(0, this.fileName.indexOf(".si"));
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            this.projectName = path.segments()[0];
            IProject project = ProjectTreeFileHelper.getProject((String)this.projectName);
            try {
                if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.CicsChannelServiceProjectNature")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.CICS_CHANNEL;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.CicsCommareaServiceProjectNature")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.CICS_COMM_AREA;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.ImsServiceProjectNature")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.IMS;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.ImsLdsServiceProjectNature")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.IMS_LDS;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.ImsdbServiceProjectNature")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.IMSDB;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureTwoWay")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureOneWayPut")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
                } else if (MultiPageEditor.hasNature(project, "com.ibm.zosconnect.ui.projects.MQServiceProjectNatureOneWayGet")) {
                    this.project_spType = ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            Message msg = ProjectTreeFileHelper.unmarshallzCEEPgmMsg((IFile)file);
            if (ServiceArchiveConstants.SP_Type.CICS_CHANNEL.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.CICS_CHANNEL;
            } else if (ServiceArchiveConstants.SP_Type.CICS_COMM_AREA.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.CICS_COMM_AREA;
            } else if (ServiceArchiveConstants.SP_Type.IMS.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.IMS;
            } else if (ServiceArchiveConstants.SP_Type.IMS_LDS.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.IMS_LDS;
            } else if (ServiceArchiveConstants.SP_Type.MQ_MESSAGE.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.MQ_MESSAGE;
            } else if (ServiceArchiveConstants.SP_Type.IMSDB.toString().equalsIgnoreCase(msg.getServiceType())) {
                this.spType = ServiceArchiveConstants.SP_Type.IMSDB;
            } else {
                throw new InvalidInputException(PgmIntXlat.getError().getString("SIE_INVALID_FILE"));
            }
            this.pgmName = path.segments()[1];
            this.tranEditorController = new TranEditorController(msg, this.pgmName, this.projectName, file, this.project_spType, this.spType);
            this.tranEditorPage = new TransactionEditorPage(this, this.getContainer(), this.tranEditorController, 0, this.spType);
            this.addPage((Control)this.tranEditorPage.getPage());
            this.setPartName(this.fileName);
            if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(0);
            }
        }
    }

    protected void createPages() {
        try {
            this.addPages();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            EclipseLogger.logError((Throwable)e);
        }
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.tranEditorController != null) {
                this.tranEditorController.doSave(this.projectName, this.fileName);
            }
            this.setDirty(false);
        }
        catch (Throwable e) {
            EclipseLogger.logError((Throwable)e);
            UIHelper.displayErrorDialog(this.getSite().getShell(), PgmIntXlat.getError().getString("TME_SAVE_TRAN_FAILED"), e);
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(final IMarker marker) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TranTreeParent treeNode;
                if (XSwt.isDisposed((Control)MultiPageEditor.this.tranEditorPage.getPage())) {
                    return;
                }
                String fieldPath = ServiceProjectMarkerUtil.getFieldPath((IMarker)marker);
                if (StringUtils.isNotBlank((CharSequence)fieldPath) && (treeNode = (TranTreeParent)MultiPageEditor.this.tranEditorController.getFieldPathToFieldModel().get(fieldPath)) != null) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)treeNode);
                    MultiPageEditor.this.tranEditorPage.getViewer().setSelection((ISelection)structuredSelection, true);
                    MultiPageEditor.this.tranEditorPage.handleEdit();
                }
            }
        });
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(PgmIntXlat.getError().getString("INVALIDINPUT_FILEEDITOR"));
        }
        super.init(site, editorInput);
        String unknownCapabilities = Xlat.colon() + "\n";
        boolean haveCapabilityErrors = false;
        try {
            IFile serviceFile = ((IFileEditorInput)editorInput).getFile();
            IProject project = serviceFile.getProject();
            IMarker[] capMarkers = project.findMarkers(ServiceProjectMarkerTypes.CAPABILITIES_PROBLEM.toString(), false, 0);
            int i = 0;
            while (i < capMarkers.length) {
                unknownCapabilities = unknownCapabilities + String.valueOf(capMarkers[i].getAttribute("message")) + "\n";
                ++i;
            }
            if (capMarkers.length > 0) {
                haveCapabilityErrors = true;
            }
        }
        catch (CoreException e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            ZCeeErrorDialog.openError((Exception)((Object)e));
        }
        if (haveCapabilityErrors) {
            String errorMsg = Xlat.error((String)"UNKNOWN_CAPABILITY_EDITOR", (String[])new String[]{unknownCapabilities});
            Status status = new Status(4, "com.ibm.zosconnect.ui.programinterface", errorMsg);
            this.hasCapabilityErrors = true;
            throw new PartInitException((IStatus)status);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getProjectName() {
        return this.projectName;
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)MultiPageEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    public void setServiceType(ServiceArchiveConstants.SP_Type serviceType) {
        this.spType = serviceType;
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(file.getName());
        }
    }

    public void dispose() {
        if (!this.hasCapabilityErrors) {
            super.dispose();
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            if (file != null) {
                file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            }
            this.resourceTracker = null;
        }
    }

    protected TabbedPropertySheetPage getPropertiesPage() {
        return this.page;
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.page = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            return this.page;
        }
        return super.getAdapter(adapter);
    }

    public static boolean hasNature(IProject project, String id) throws Exception {
        boolean hasNature = false;
        if (project != null && project.isAccessible() && project.getDescription() != null) {
            hasNature = project.getDescription().hasNature(id);
        }
        return hasNature;
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                EclipseLogger.logError((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)MultiPageEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    MultiPageEditor.this.closeEditor(false);
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = MultiPageEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            } else if (delta.getKind() == 4 && delta.getMarkerDeltas().length > 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((ResourceTracker)ResourceTracker.this).MultiPageEditor.this.tranEditorController.refreshMarkers();
                        ((ResourceTracker)ResourceTracker.this).MultiPageEditor.this.tranEditorPage.refreshViewer();
                    }
                });
            }
            return false;
        }
    }
}

