/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editors;

import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.EclipseLogger;
import com.ibm.zosconnect.ui.programinterface.editors.TransactionEditorPage;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.UIHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FieldSearchDialog
extends Dialog
implements SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger;
    private String searchDialogTitle;
    private static final int margin = 10;
    private UIHelper uih;
    private Label searchLabel;
    private Text searchText;
    private TransactionEditorPage tranEditorPage;
    private Group groupDirection;
    private Button buttonForward;
    private Button buttonBackward;

    public FieldSearchDialog(Shell parentShell, String searchDialogTitle, TransactionEditorPage tranEditorPage) {
        super(parentShell);
        this.searchDialogTitle = searchDialogTitle;
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
        this.uih = new UIHelper();
        this.tranEditorPage = tranEditorPage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.searchDialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, PgmIntXlat.getLabel().getString("FSD_FINDNEXT"), true);
        this.createButton(parent, 1, PgmIntXlat.getLabel().getString("FSD_CLOSE"), false);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = (Composite)super.createDialogArea(dialogParent);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        parent.setLayoutData((Object)gd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        parent.setLayout((Layout)formLayout);
        Display display = parent.getDisplay();
        this.uih.setDisplay(display);
        FormData fd_search = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
        this.searchLabel = new Label(parent, 64);
        this.searchLabel.setText(PgmIntXlat.getLabel().getString("FSD_SEARCHTEXT") + PgmIntXlat.getColon().getString("COLON"));
        this.searchLabel.setToolTipText(PgmIntXlat.getLabel().getString("FSD_TYPEFIELD"));
        this.searchLabel.setLayoutData((Object)fd_search);
        FormData fd_searchTxt = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment((Control)this.searchLabel, 10), new FormAttachment(100, 0));
        this.searchText = new Text(parent, 2116);
        this.searchText.setLayoutData((Object)fd_searchTxt);
        this.searchText.forceFocus();
        FormData fldTypeFD = this.uih.genFormData(new FormAttachment((Control)this.searchText, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.groupDirection = new Group(parent, 0);
        this.groupDirection.setText(PgmIntXlat.getLabel().getString("FSD_DIRECTION"));
        FormLayout groupDirectionFL = new FormLayout();
        groupDirectionFL.marginHeight = 10;
        groupDirectionFL.marginWidth = 10;
        this.groupDirection.setLayout((Layout)groupDirectionFL);
        this.groupDirection.setLayoutData((Object)fldTypeFD);
        FormData fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.buttonForward = new Button((Composite)this.groupDirection, 16);
        this.buttonForward.setText(PgmIntXlat.getLabel().getString("FSD_FORWARD"));
        this.buttonForward.setLayoutData((Object)fd);
        this.buttonForward.setSelection(true);
        fd = this.uih.genFormData(new FormAttachment((Control)this.buttonForward, 10), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
        this.buttonBackward = new Button((Composite)this.groupDirection, 16);
        this.buttonBackward.setText(PgmIntXlat.getLabel().getString("FSD_BACKWARD"));
        this.buttonBackward.setLayoutData((Object)fd);
        return parent;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        block8: {
            try {
                Button findButton = this.getButton(1025);
                if (event.widget != findButton) break block8;
                String searchPattern = this.searchText.getText().toUpperCase();
                Tree tree = this.tranEditorPage.getTree();
                TreeItem[] selectedItems = tree.getSelection();
                ArrayList<TreeItem> allItems = new ArrayList<TreeItem>();
                FieldSearchDialog.getAllTreeItems(tree, allItems);
                if (this.buttonForward.getSelection()) {
                    int currSelIx = 0;
                    if (selectedItems.length > 0) {
                        currSelIx = allItems.indexOf(selectedItems[0]);
                    }
                    int i = currSelIx + 1;
                    while (i < allItems.size()) {
                        TreeItem currItem = (TreeItem)allItems.get(i);
                        TranTreeObject currNode = (TranTreeObject)currItem.getData();
                        if (currNode.getName().toUpperCase().contains(searchPattern)) {
                            tree.setSelection(currItem);
                            tree.setFocus();
                            break block8;
                        }
                        ++i;
                    }
                    break block8;
                }
                TreeItem lastSelectedItem = selectedItems[selectedItems.length - 1];
                int currSelIx = allItems.indexOf(lastSelectedItem);
                int i = currSelIx - 1;
                while (i >= 0) {
                    TreeItem currItem = (TreeItem)allItems.get(i);
                    TranTreeObject currNode = (TranTreeObject)currItem.getData();
                    if (currNode.getName().toUpperCase().contains(searchPattern)) {
                        tree.setSelection(currItem);
                        break;
                    }
                    --i;
                }
            }
            catch (Throwable e) {
                logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
                EclipseLogger.logError((Throwable)e);
            }
        }
    }

    private static void getAllTreeItems(Tree tree, List<TreeItem> allItems) {
        allItems.add(tree.getItems()[0]);
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            FieldSearchDialog.getAllItems(item, allItems);
            ++n2;
        }
    }

    private static void getAllItems(TreeItem currentItem, List<TreeItem> allItems) {
        TreeItem[] children = currentItem.getItems();
        int i = 0;
        while (i < children.length) {
            allItems.add(children[i]);
            FieldSearchDialog.getAllItems(children[i], allItems);
            ++i;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bBar = super.createButtonBar(parent);
        Button findButton = this.getButton(1025);
        findButton.addSelectionListener((SelectionListener)this);
        findButton.setEnabled(true);
        return bBar;
    }

    public boolean close() {
        this.tranEditorPage.setFindDialogOpen(false);
        return super.close();
    }
}

