/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeErrorDialog;
import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfMonth;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeHexLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeMonthOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYearOfCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.editdialogs.DatePropertiesComposite;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InsertPatternDialog
extends StatusDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2020. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Composite compContents;
    private Composite mainComposite;
    private Button okButton;
    private org.eclipse.swt.widgets.List patternList;
    private FieldEditorController fieldEditCtrl;
    private String selectedPatternStr;
    private List<DateTimePatternToken> tokenList;
    private DatePropertiesComposite parentComposite;
    private static final int LEFT_MARGIN = 2;
    private static final int RIGHT_MARGIN = 2;
    private static final int COMPOSITE_WIDTH = 280;
    private static final int NUM_ROWS_DISPLAYED = 7;
    private HashMap<String, DateTimePatternToken> validInsertPatterns = new HashMap();
    private ArrayList<String> insertList = new ArrayList();

    public InsertPatternDialog(DatePropertiesComposite parentComposite, FieldEditorController fieldEditCtrl, List<DateTimePatternToken> tokenList) {
        super(XSwt.getActiveShell());
        this.parentComposite = parentComposite;
        this.fieldEditCtrl = fieldEditCtrl;
        this.tokenList = tokenList;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        DateTimeDayOfMonth dayOfMonth = new DateTimeDayOfMonth();
        DateTimeDayOfYear dayOfYear = new DateTimeDayOfYear();
        DateTimeMonthOfYear monthOfYear = new DateTimeMonthOfYear();
        DateTimeYear year = new DateTimeYear();
        DateTimeYearOfCentury yearOfEra = new DateTimeYearOfCentury();
        DateTimeCentury centuryOfEra = new DateTimeCentury();
        DateTimeLiteral literal = new DateTimeLiteral();
        DateTimeHexLiteral hexLiteral = new DateTimeHexLiteral();
        boolean isNumericField = JSONConversionUtil.isNumeric((FieldType)fieldEditCtrl.getFieldType());
        this.validInsertPatterns.put(dayOfMonth.getXlatNameText(), (DateTimePatternToken)dayOfMonth);
        this.validInsertPatterns.put(dayOfYear.getXlatNameText(), (DateTimePatternToken)dayOfYear);
        this.validInsertPatterns.put(monthOfYear.getXlatNameText(), (DateTimePatternToken)monthOfYear);
        this.validInsertPatterns.put(year.getXlatNameText(), (DateTimePatternToken)year);
        this.validInsertPatterns.put(yearOfEra.getXlatNameText(), (DateTimePatternToken)yearOfEra);
        this.validInsertPatterns.put(centuryOfEra.getXlatNameText(), (DateTimePatternToken)centuryOfEra);
        this.validInsertPatterns.put(literal.getXlatNameText(), (DateTimePatternToken)literal);
        if (!isNumericField) {
            this.validInsertPatterns.put(hexLiteral.getXlatNameText(), (DateTimePatternToken)hexLiteral);
        }
        this.insertList.add(dayOfMonth.getXlatNameText());
        this.insertList.add(dayOfYear.getXlatNameText());
        this.insertList.add(monthOfYear.getXlatNameText());
        this.insertList.add(year.getXlatNameText());
        this.insertList.add(yearOfEra.getXlatNameText());
        this.insertList.add(centuryOfEra.getXlatNameText());
        this.insertList.add(literal.getXlatNameText());
        if (!isNumericField) {
            this.insertList.add(hexLiteral.getXlatNameText());
        }
        this.insertList.add(PgmIntXlat.label((String)"DT_LITERAL_ESCAPE"));
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        this.mainComposite = parent;
        this.mainComposite.setBackground(this.formToolkit.getColors().getBackground());
        this.mainComposite.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(this.mainComposite);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 280;
        this.compContents.setLayoutData((Object)gridData);
        GridLayout gl_compContents = new GridLayout(1, false);
        gl_compContents.marginTop = 5;
        gl_compContents.marginLeft = 2;
        gl_compContents.marginRight = 2;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        this.patternList = new org.eclipse.swt.widgets.List(this.compContents, 2816);
        GridData gd_compResourceBrowser = new GridData(4, 4, true, true, 1, 1);
        gd_compResourceBrowser.widthHint = 250;
        gd_compResourceBrowser.heightHint = 250;
        this.patternList.setLayoutData((Object)gd_compResourceBrowser);
        this.patternList.setBounds(0, 0, 89, 89);
        String[] insertArray = this.insertList.toArray(new String[this.insertList.size()]);
        this.patternList.setItems(insertArray);
        this.patternList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (InsertPatternDialog.this.patternList.getSelectionCount() == 1) {
                    InsertPatternDialog.this.selectedPatternStr = InsertPatternDialog.this.patternList.getSelection()[0];
                    InsertPatternDialog.this.okButton.setEnabled(true);
                } else {
                    InsertPatternDialog.this.okButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.compContents.layout(true);
        return compDialogArea;
    }

    private void validateInput() {
        this.updateStatus(null);
        XSwt.pack((Control)this.getShell());
    }

    private String getActualPattern() {
        if (this.selectedPatternStr.equals(PgmIntXlat.label((String)"DT_LITERAL_ESCAPE"))) {
            return "\\";
        }
        this.validInsertPatterns.get(this.selectedPatternStr);
        return this.validInsertPatterns.get(this.selectedPatternStr).getText();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        try {
            this.parentComposite.setInsertPatternStr(this.getActualPattern());
            super.okPressed();
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
            ZCeeErrorDialog.openError((Exception)e);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PgmIntXlat.label((String)"ODT_DATE_INSERTDIALOG_NAME"));
    }

    public void create() {
        super.create();
        this.validateInput();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }
}

