/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.InvalidValueException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialogComposite;
import com.ibm.zosconnect.ui.programinterface.editdialogs.BooleanPropertiesComposite;
import com.ibm.zosconnect.ui.programinterface.editdialogs.DatePropertiesComposite;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.TextFocusHightlightListener;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DateOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.metadata.transaction.MarshallerType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EditFieldDialog
extends AbstractEditFieldDialog
implements VerifyListener,
ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private static final String SOURCE_TYPE = PgmIntXlat.error((String)"EDS_FLD_LABEL");
    private static final String HEXADECIMAL = "X (HEX)";
    private static final String CHARACTER = "C (CHAR)";
    private static final String[] valueTypes = new String[]{"X (HEX)", "C (CHAR)"};
    private Label labelOriginalName;
    private Label labelNewFieldName;
    private Label fieldDataTypeLabel;
    private Label fieldOverrideTypeLabel;
    private Label fieldDefaultValueTypeLabel;
    private Label fieldDefaultValueLabel;
    private Label labelLength;
    private Label labelStartbyte;
    private Label labelRemarks;
    private Label labelCodepage;
    private Text textOriginalName;
    private Text textNewFieldName;
    private Text fieldDataTypeText;
    private Text fieldDefaultValueText;
    private Text textLength;
    private Text textStartbyte;
    private Text textRemarks;
    private Combo fieldOverrideTypeCombo;
    private Combo fieldDefaultValueTypeCombo;
    private Button okButton;
    private Button buttonCodepage;
    private ControlDecoration cd_textFieldName;
    private ControlDecoration cd_fieldValueText;
    private ControlDecoration cd_fieldOverrideTypeCombo;
    private Composite mainComposite;
    private Composite compDialogArea;
    private AbstractEditFieldDialogComposite overrideTypeComposite;
    private BooleanPropertiesComposite booleanPropertiesComposite;
    private DatePropertiesComposite datePropertiesComposite;
    private FieldEditorController fieldEditCtrl;
    private TranTreeObject field;
    private boolean isHex;
    private boolean codepageConversion;
    private boolean isCodepageShown;
    private Vector<String> existingNames;
    private ServiceArchiveConstants.SP_Type spType;

    public EditFieldDialog(Shell parentShell, TranTreeObject field, Vector<String> existingNames, FieldEditorController fieldEditCtrl, ServiceArchiveConstants.SP_Type spType) {
        super(parentShell);
        this.field = field;
        this.existingNames = existingNames;
        this.fieldEditCtrl = fieldEditCtrl;
        this.spType = spType;
        if (existingNames != null) {
            this.existingNames.remove(field.getName());
        }
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        FieldModel fieldNode = (FieldModel)this.field;
        String fieldName = fieldNode.getField().getName();
        String remarks = fieldNode.getField().getRemarks();
        String originalName = fieldNode.getField().getOriginalName();
        if (fieldNode.getField().getCodepageConversion() != YesnoType.N) {
            this.codepageConversion = true;
        }
        if (originalName == null) {
            originalName = fieldName;
        }
        String length = fieldNode.getField().getBytes() != null ? fieldNode.getField().getBytes().toString() : "";
        String startbyte = fieldNode.getField().getStartPos() != null ? fieldNode.getField().getStartPos().toString() : "";
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.compDialogArea = (Composite)super.createDialogArea(parent);
        this.compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        this.compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.mainComposite = new Composite(this.compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.horizontalSpacing = 10;
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.mainComposite.setLayout((Layout)gl_compContents);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labelOriginalName = new Label(this.mainComposite, 0);
        this.labelOriginalName.setText(PgmIntXlat.labelWithColon((String)"EDS_ORIGINAL_NAME"));
        GridData gd_labelOriginalName = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelOriginalName.setLayoutData((Object)gd_labelOriginalName);
        this.textOriginalName = new Text(this.mainComposite, 8);
        GridData gd_textOriginalName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textOriginalName.setLayoutData((Object)gd_textOriginalName);
        this.textOriginalName.setText(originalName);
        XSwt.addTabTraverseListener((Control)this.textOriginalName);
        this.labelNewFieldName = new Label(this.mainComposite, 64);
        this.labelNewFieldName.setText(PgmIntXlat.labelWithColon((String)"EC_RENAME"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelNewFieldName.setLayoutData((Object)gd_labelFieldName);
        this.textNewFieldName = new Text(this.mainComposite, 2048);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textNewFieldName.setLayoutData((Object)gd_textFieldName);
        this.textNewFieldName.setText(fieldName == null ? "" : fieldName);
        this.cd_textFieldName = new ControlDecoration((Control)this.textNewFieldName, 17408);
        XSwt.addTabTraverseListener((Control)this.textNewFieldName);
        XSwt.setTooltipText((Control)this.textNewFieldName, (String)PgmIntXlat.label((String)"EF_RENAME_TOOLTIP"));
        this.textNewFieldName.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textNewFieldName.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        if (this.spType != ServiceArchiveConstants.SP_Type.IMSDB) {
            this.labelStartbyte = new Label(this.mainComposite, 0);
            this.labelStartbyte.setText(PgmIntXlat.labelWithColon((String)"EFD_START_BYTE"));
            GridData gd_labelStartbyte = new GridData(4, 0x1000000, false, false, 1, 1);
            this.labelStartbyte.setLayoutData((Object)gd_labelStartbyte);
            this.textStartbyte = new Text(this.mainComposite, 8);
            GridData gd_textStartbyte = new GridData(4, 0x1000000, true, false, 1, 1);
            this.textStartbyte.setLayoutData((Object)gd_textStartbyte);
            this.textStartbyte.setText(startbyte);
            XSwt.addTabTraverseListener((Control)this.textStartbyte);
        }
        this.labelLength = new Label(this.mainComposite, 0);
        this.labelLength.setText(PgmIntXlat.labelWithColon((String)"TCMLE_LENGTH"));
        GridData gd_labelLength = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelLength.setLayoutData((Object)gd_labelLength);
        this.textLength = new Text(this.mainComposite, 8);
        GridData gd_textLength = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textLength.setLayoutData((Object)gd_textLength);
        this.textLength.setText(length);
        XSwt.addTabTraverseListener((Control)this.textLength);
        this.fieldDataTypeLabel = new Label(this.mainComposite, 0);
        this.fieldDataTypeLabel.setText(PgmIntXlat.labelWithColon((String)"TCMLE_COLNAME_ORIGINALTYPE"));
        GridData gd_fieldDataTypeLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        this.fieldDataTypeLabel.setLayoutData((Object)gd_fieldDataTypeLabel);
        this.fieldDataTypeText = new Text(this.mainComposite, 8);
        GridData gd_fieldDataTypeText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.fieldDataTypeText.setLayoutData((Object)gd_fieldDataTypeText);
        if (this.fieldEditCtrl != null) {
            this.fieldDataTypeText.setText(this.fieldEditCtrl.getDataType());
            if (this.fieldEditCtrl.getDataType().equals("CHAR")) {
                this.isCodepageShown = true;
            }
        }
        XSwt.addTabTraverseListener((Control)this.fieldDataTypeText);
        if (this.spType != ServiceArchiveConstants.SP_Type.IMSDB) {
            this.fieldOverrideTypeLabel = new Label(this.mainComposite, 0);
            this.fieldOverrideTypeLabel.setText(PgmIntXlat.labelWithColon((String)"TCMLE_COLNAME_OVERRIDETYPE"));
            GridData gd_fieldOverrideTypeLabel = new GridData(4, 0x1000000, false, false, 1, 1);
            this.fieldOverrideTypeLabel.setLayoutData((Object)gd_fieldOverrideTypeLabel);
            this.fieldOverrideTypeCombo = new Combo(this.mainComposite, 2056);
            GridData gd_fieldOverrideTypeCombo = new GridData(4, 0x1000000, true, false, 1, 1);
            this.fieldOverrideTypeCombo.setLayoutData((Object)gd_fieldOverrideTypeCombo);
            this.fieldOverrideTypeCombo.add(" ");
            this.initializefieldOverrideTypeCombo();
            XSwt.addTabTraverseListener((Control)this.fieldOverrideTypeCombo);
            this.cd_fieldOverrideTypeCombo = new ControlDecoration((Control)this.fieldOverrideTypeCombo, 17408);
            this.fieldDefaultValueTypeLabel = new Label(this.mainComposite, 0);
            this.fieldDefaultValueTypeLabel.setText(PgmIntXlat.labelWithColon((String)"DEFAULT_VALUE_TYPE"));
            GridData gd_fieldValueTypeLabel = new GridData(4, 0x1000000, false, false, 1, 1);
            this.fieldDefaultValueTypeLabel.setLayoutData((Object)gd_fieldValueTypeLabel);
            this.fieldDefaultValueTypeCombo = new Combo(this.mainComposite, 2056);
            GridData gd_fieldValueTypeCombo = new GridData(4, 0x1000000, true, false, 1, 1);
            this.fieldDefaultValueTypeCombo.setLayoutData((Object)gd_fieldValueTypeCombo);
            if (this.fieldEditCtrl != null) {
                this.fieldDefaultValueTypeCombo.setItems(valueTypes);
                this.isHex = this.fieldEditCtrl.isHex();
                if (this.isHex) {
                    this.fieldDefaultValueTypeCombo.setText(HEXADECIMAL);
                } else {
                    this.fieldDefaultValueTypeCombo.setText(CHARACTER);
                }
            } else {
                this.fieldDefaultValueTypeCombo.setEnabled(false);
            }
            XSwt.addTabTraverseListener((Control)this.fieldDefaultValueTypeCombo);
            XSwt.setTooltipText((Control)this.fieldDefaultValueTypeCombo, (String)PgmIntXlat.label((String)"EF_DEFAULT_VALUE_TYPE_TOOLTIP"));
        }
        this.fieldDefaultValueLabel = new Label(this.mainComposite, 0);
        this.fieldDefaultValueLabel.setText(PgmIntXlat.labelWithColon((String)"DEFAULT_VALUE"));
        GridData gd_fieldValueLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        this.fieldDefaultValueLabel.setLayoutData((Object)gd_fieldValueLabel);
        this.fieldDefaultValueText = new Text(this.mainComposite, 2048);
        GridData gd_fieldValueText = new GridData(4, 0x1000000, true, false, 1, 1);
        if (this.fieldEditCtrl != null) {
            String origValue = this.fieldEditCtrl.getOrigFieldValue();
            if (origValue == null) {
                origValue = "";
            }
            this.fieldDefaultValueText.setText(origValue);
        } else {
            this.fieldDefaultValueText.setEnabled(false);
        }
        this.fieldDefaultValueText.setLayoutData((Object)gd_fieldValueText);
        this.fieldDefaultValueText.forceFocus();
        this.cd_fieldValueText = new ControlDecoration((Control)this.fieldDefaultValueText, 17408);
        XSwt.addTabTraverseListener((Control)this.fieldDefaultValueText);
        XSwt.setTooltipText((Control)this.fieldDefaultValueText, (String)PgmIntXlat.label((String)"TSW_FIELD_DEFAULT_VALUE_TOOLTIP"));
        this.fieldDefaultValueText.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.fieldDefaultValueText.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        if (this.spType != ServiceArchiveConstants.SP_Type.IMSDB && this.isCodepageShown) {
            this.labelCodepage = new Label(this.mainComposite, 0);
            this.labelCodepage.setText(PgmIntXlat.labelWithColon((String)"TCMLE_COLNAME_CODEPAGE"));
            GridData gd_labelCodepage = new GridData(4, 0x1000000, false, false, 1, 1);
            this.labelCodepage.setLayoutData((Object)gd_labelCodepage);
            this.buttonCodepage = new Button(this.mainComposite, 32);
            GridData gd_buttonCodepage = new GridData(4, 0x1000000, false, false, 1, 1);
            this.buttonCodepage.setLayoutData((Object)gd_buttonCodepage);
            this.buttonCodepage.setSelection(this.codepageConversion);
            XSwt.addTabTraverseListener((Control)this.buttonCodepage);
        }
        this.labelRemarks = new Label(this.mainComposite, 0);
        this.labelRemarks.setText(PgmIntXlat.labelWithColon((String)"EM_REMARKS"));
        GridData gd_labelRemarks = new GridData(4, 128, false, false, 1, 1);
        this.labelRemarks.setLayoutData((Object)gd_labelRemarks);
        this.textRemarks = new Text(this.mainComposite, 2626);
        this.textRemarks.setText(remarks == null ? "" : remarks);
        GridData gd_textRemarks = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textRemarks.widthHint = 350;
        gd_textRemarks.heightHint = XSwt.getFontHeight((Control)this.textRemarks) * 5;
        this.textRemarks.setLayoutData((Object)gd_textRemarks);
        this.textRemarks.addVerifyListener((VerifyListener)this);
        XSwt.addTabTraverseListener((Control)this.textRemarks);
        XSwt.addTextEnterKeyListener((Text)this.textRemarks);
        XSwt.setTooltipText((Control)this.textRemarks, (String)PgmIntXlat.label((String)"EF_BUSINESS_DESCRIPTION_TOOLTIP"));
        this.textRemarks.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textRemarks.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        this.addListeners();
        this.textNewFieldName.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compDialogArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        DatatypeOverride overrideType = this.fieldEditCtrl.getDatatypeOverride();
        if (overrideType != null) {
            this.fieldOverrideTypeCombo.setText(OverrideTypeUtil.getUIStringFromType((DatatypeOverride)overrideType));
            this.handleUpdateFieldOverrideType();
        }
        return this.compDialogArea;
    }

    private void initializefieldOverrideTypeCombo() {
        String overrideTypeName2;
        DatatypeOverride overrideType;
        ArrayList<String> overrideTypeNames = new ArrayList<String>();
        if (this.canOverrideToBoolean()) {
            overrideTypeNames.add(OverrideTypeUtil.getUIStringFromType(BooleanOverrideType.class));
        }
        if (this.canOverrideToDate()) {
            overrideTypeNames.add(OverrideTypeUtil.getUIStringFromType(DateOverrideType.class));
        }
        if ((overrideType = this.fieldEditCtrl.getDatatypeOverride()) != null && !overrideTypeNames.contains(overrideTypeName2 = OverrideTypeUtil.getUIStringFromType((DatatypeOverride)overrideType))) {
            overrideTypeNames.add(overrideTypeName2);
        }
        for (String overrideTypeName2 : overrideTypeNames) {
            this.fieldOverrideTypeCombo.add(overrideTypeName2);
        }
    }

    private boolean canOverrideToDate() {
        DatatypeType dataType = this.fieldEditCtrl.getApplicationDatatype().getDatatype();
        MarshallerType marshaller = ((FieldModel)this.field).getField().getMarshaller();
        if (marshaller != null && marshaller.getIsNativeInteger() == YesnoType.Y) {
            if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
                ZCeeUILogger.info((String)PgmIntXlat.error((String)"EF_ERROR_CANNOT_BE_NATIVE_INT", (String[])new String[]{this.fieldEditCtrl.getFieldPath()}), (Object[])new Object[0]);
            }
            return false;
        }
        if (FieldEditorController.isDBCSOnlyCharField((FieldType)((FieldModel)this.field).getField())) {
            if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
                ZCeeUILogger.info((String)PgmIntXlat.error((String)"EF_ERROR_CANNOT_BE_DBCS", (String[])new String[]{this.fieldEditCtrl.getFieldPath()}), (Object[])new Object[0]);
            }
            return false;
        }
        if (dataType.equals((Object)DatatypeType.CHAR) || JSONConversionUtil.isInteger((FieldType)((FieldModel)this.field).getField())) {
            return true;
        }
        if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
            ZCeeUILogger.info((String)PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_AS_TYPE", (String[])new String[]{this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldPath(), "Date"}), (Object[])new Object[0]);
        }
        return false;
    }

    private boolean canOverrideToBoolean() {
        DatatypeType dataType = this.fieldEditCtrl.getApplicationDatatype().getDatatype();
        if (dataType.equals((Object)DatatypeType.CHAR) || JSONConversionUtil.isInteger((FieldType)((FieldModel)this.field).getField())) {
            return true;
        }
        if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
            ZCeeUILogger.info((String)PgmIntXlat.error((String)"FIELD_TYPE_CANT_OVERRIDE_AS_TYPE", (String[])new String[]{this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldPath(), "Boolean"}), (Object[])new Object[0]);
        }
        return false;
    }

    private void addListeners() {
        if (this.textNewFieldName != null) {
            this.textNewFieldName.addModifyListener((ModifyListener)this);
            this.textNewFieldName.addVerifyListener((VerifyListener)this);
        }
        if (this.fieldDefaultValueTypeCombo != null) {
            this.fieldDefaultValueTypeCombo.addSelectionListener((SelectionListener)this);
        }
        if (this.fieldOverrideTypeCombo != null) {
            this.fieldOverrideTypeCombo.addSelectionListener((SelectionListener)this);
        }
        if (this.fieldDefaultValueText != null) {
            this.fieldDefaultValueText.addModifyListener((ModifyListener)this);
            this.fieldDefaultValueText.addVerifyListener((VerifyListener)this);
            this.fieldDefaultValueText.addFocusListener((FocusListener)new TextFocusHightlightListener());
        }
        if (this.isCodepageShown && this.buttonCodepage != null) {
            this.buttonCodepage.addSelectionListener((SelectionListener)this);
        }
        if (this.textRemarks != null) {
            this.textRemarks.addVerifyListener((VerifyListener)this);
        }
    }

    private boolean nameCollision(String name) {
        boolean retVal = false;
        Iterator<String> iter = this.existingNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private void handleUpdateFieldOverrideType() {
        String ovrTypeUIStr = XSwt.getText((Combo)this.fieldOverrideTypeCombo);
        Class ovrType = OverrideTypeUtil.getTypeFromUIString((String)ovrTypeUIStr);
        if (BooleanOverrideType.class == ovrType) {
            if (this.booleanPropertiesComposite == null) {
                this.booleanPropertiesComposite = new BooleanPropertiesComposite(this, this.mainComposite, (FieldModel)this.field, this.fieldEditCtrl);
                this.booleanPropertiesComposite.moveBelow((Control)this.fieldOverrideTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.booleanPropertiesComposite});
            XSwt.exclude((Control[])new Control[]{this.datePropertiesComposite});
            XSwt.exclude((Control[])new Control[]{this.fieldDefaultValueTypeLabel, this.fieldDefaultValueTypeCombo, this.fieldDefaultValueLabel, this.fieldDefaultValueText, this.labelCodepage, this.buttonCodepage});
            this.overrideTypeComposite = this.booleanPropertiesComposite;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compDialogArea, "com.ibm.zosconnect.ui.programinterface.definingbooleanfields");
        } else if (DateOverrideType.class == ovrType) {
            if (this.datePropertiesComposite == null) {
                this.datePropertiesComposite = new DatePropertiesComposite(this, this.mainComposite, (FieldModel)this.field, this.fieldEditCtrl, this.formToolkit);
                this.datePropertiesComposite.moveBelow((Control)this.fieldOverrideTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.datePropertiesComposite});
            XSwt.exclude((Control[])new Control[]{this.booleanPropertiesComposite});
            XSwt.exclude((Control[])new Control[]{this.fieldDefaultValueTypeLabel, this.fieldDefaultValueTypeCombo, this.fieldDefaultValueLabel, this.fieldDefaultValueText, this.labelCodepage, this.buttonCodepage, this.booleanPropertiesComposite});
            this.overrideTypeComposite = this.datePropertiesComposite;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compDialogArea, "com.ibm.zosconnect.ui.programinterface.definingdatefields");
        } else {
            XSwt.exclude((Control[])new Control[]{this.booleanPropertiesComposite});
            XSwt.exclude((Control[])new Control[]{this.datePropertiesComposite});
            XSwt.include((Control[])new Control[]{this.fieldDefaultValueTypeLabel, this.fieldDefaultValueTypeCombo, this.fieldDefaultValueLabel, this.fieldDefaultValueText, this.labelCodepage, this.buttonCodepage});
            this.overrideTypeComposite = null;
            this.fieldEditCtrl.setDatatypeOverride(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.compDialogArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        }
        XSwt.layout((Composite)this.mainComposite, (boolean)true);
        this.alignControlsVertically();
    }

    private void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textFieldName);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_fieldValueText);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_fieldOverrideTypeCombo);
    }

    protected void validatePage() {
        this.updateStatus(null);
        this.resetControlDecorators();
        String msg = null;
        Status status = null;
        String name = this.textNewFieldName.getText().trim();
        if (name == null || name.isEmpty()) {
            inserts = new String[]{SOURCE_TYPE};
            msg = PgmIntXlat.error((String)"EDS_MISSING_NAME", (String[])inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        } else if (this.existingNames != null && this.nameCollision(name)) {
            inserts = new String[]{name, SOURCE_TYPE};
            msg = PgmIntXlat.error((String)"EDS_COLLIDED_NAME", (String[])inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        } else {
            String fieldValue = XSwt.getText((Text)this.fieldDefaultValueText);
            try {
                if (!fieldValue.isEmpty() && this.fieldEditCtrl != null) {
                    if (this.isHex) {
                        this.fieldEditCtrl.validateHexValue(fieldValue);
                    } else {
                        this.fieldEditCtrl.validateValue(fieldValue);
                    }
                }
            }
            catch (InvalidValueException e) {
                msg = e.getMessage();
                status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_fieldValueText, (String)msg);
            }
            catch (Exception exception) {
                msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{fieldValue, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_fieldValueText, (String)msg);
            }
        }
        String overrideTypeName = XSwt.getText((Combo)this.fieldOverrideTypeCombo);
        Class overrideType = OverrideTypeUtil.getTypeFromUIString((String)overrideTypeName);
        if (BooleanOverrideType.class == overrideType && this.canOverrideToBoolean()) {
            if (XSwt.isNotDisposed((Control)this.booleanPropertiesComposite)) {
                IStatus overrideTypeStatus = this.booleanPropertiesComposite.validate();
                if (status == null || status.isOK()) {
                    status = overrideTypeStatus;
                }
            }
        } else if (DateOverrideType.class == overrideType && this.canOverrideToDate()) {
            if (XSwt.isNotDisposed((Control)this.datePropertiesComposite)) {
                IStatus overrideTypeStatus = this.datePropertiesComposite.validate();
                if (status == null || status.isOK()) {
                    status = overrideTypeStatus;
                }
            }
        } else if (overrideType != null) {
            msg = PgmIntXlat.error((String)"EF_CANT_OVERRIDE_AS_TYPE", (String[])new String[]{this.fieldEditCtrl.getDataType(), overrideTypeName});
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_fieldOverrideTypeCombo, (String)msg);
        }
        this.updateStatusAndPack((IStatus)status);
    }

    private void updateStatusAndPack(IStatus status) {
        if (status != null && !status.isOK()) {
            this.updateStatus(status);
        } else {
            this.updateStatus(null);
        }
        XSwt.pack((Control)this.getShell());
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            } else if (e.widget == this.fieldDefaultValueText && this.isHex && e.character >= 'a' && e.character <= 'z') {
                String upperCaseChar;
                e.text = upperCaseChar = e.text.toUpperCase();
            }
        }
        catch (Throwable err) {
            ZCeeUILogger.error((String)err.getMessage(), (Throwable)err, (Object[])new Object[0]);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fieldDefaultValueTypeCombo) {
            if (this.fieldDefaultValueTypeCombo.getText().equals(CHARACTER)) {
                this.isHex = false;
            } else {
                this.isHex = true;
                this.fieldDefaultValueText.setText(this.fieldDefaultValueText.getText().toUpperCase());
            }
            this.validatePage();
        } else if (e.widget == this.fieldOverrideTypeCombo) {
            this.handleUpdateFieldOverrideType();
            this.validatePage();
        } else if (e.widget == this.buttonCodepage) {
            this.codepageConversion = this.codepageConversion ? !this.codepageConversion : !this.codepageConversion;
            this.buttonCodepage.setSelection(this.codepageConversion);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PgmIntXlat.getDescription().getString("EF_TITLE_EDIT"));
    }

    public void create() {
        super.create();
        this.alignControlsVertically();
        XSwt.centerInWorkbench((Shell)this.getShell());
        this.validatePage();
        this.getShell().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle newDialogAreaBounds = EditFieldDialog.this.getDialogArea().getBounds();
                GridDataBuilder.setWidthHint((Control)EditFieldDialog.this.getDialogArea(), (int)newDialogAreaBounds.width);
            }
        });
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            if (status.getSeverity() == 4) {
                XSwt.disable((Control[])new Control[]{this.okButton});
            } else {
                XSwt.enable((Control[])new Control[]{this.okButton});
            }
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void okPressed() {
        this.fieldEditCtrl.setNewFieldName(XSwt.getTrimText((Text)this.textNewFieldName));
        this.fieldEditCtrl.setNewFieldRemarks(XSwt.getText((Text)this.textRemarks));
        this.fieldEditCtrl.setNewFieldValue(XSwt.getText((Text)this.fieldDefaultValueText));
        this.fieldEditCtrl.setHex(this.isHex);
        this.fieldEditCtrl.setCodepageChecked(this.codepageConversion);
        if (this.overrideTypeComposite != null) {
            this.overrideTypeComposite.okPressed();
        }
        super.okPressed();
    }

    @Override
    public Composite getMainComposite() {
        return this.mainComposite;
    }

    @Override
    public List<Control> getControlsToAlignVertically() {
        ArrayList<Control> controlsToVAlign = new ArrayList<Control>();
        if (XSwt.isNotDisposed((Control)this.textOriginalName)) {
            controlsToVAlign.add((Control)this.textOriginalName);
        }
        if (XSwt.isNotDisposed((Control)this.textNewFieldName)) {
            controlsToVAlign.add((Control)this.textNewFieldName);
        }
        if (XSwt.isNotDisposed((Control)this.textRemarks)) {
            controlsToVAlign.add((Control)this.textRemarks);
        }
        if (XSwt.isNotDisposed((Control)this.textStartbyte)) {
            controlsToVAlign.add((Control)this.textStartbyte);
        }
        if (XSwt.isNotDisposed((Control)this.textLength)) {
            controlsToVAlign.add((Control)this.textLength);
        }
        if (XSwt.isNotDisposed((Control)this.fieldDataTypeText)) {
            controlsToVAlign.add((Control)this.fieldDataTypeText);
        }
        if (XSwt.isNotDisposed((Control)this.fieldOverrideTypeCombo)) {
            controlsToVAlign.add((Control)this.fieldOverrideTypeCombo);
        }
        if (XSwt.isNotDisposed((Control)this.fieldDefaultValueTypeCombo)) {
            controlsToVAlign.add((Control)this.fieldDefaultValueTypeCombo);
        }
        if (XSwt.isNotDisposed((Control)this.fieldDefaultValueText)) {
            controlsToVAlign.add((Control)this.fieldDefaultValueText);
        }
        if (XSwt.isNotDisposed((Control)this.buttonCodepage)) {
            controlsToVAlign.add((Control)this.buttonCodepage);
        }
        if (XSwt.isNotDisposed((Control)this.overrideTypeComposite)) {
            controlsToVAlign.addAll(this.overrideTypeComposite.getControlsToAlignVertically());
        }
        return controlsToVAlign;
    }
}

