/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranSegmentModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.Utility;
import com.ibm.zosconnect.wv.metadata.transaction.CicsContainerType;
import com.ibm.zosconnect.wv.metadata.transaction.YesnoType;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EditContainerDialog
extends StatusDialog
implements VerifyListener,
ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label labelContainerName;
    private Label labelRename;
    private Label labelContainerType;
    private Text textContainerName;
    private Text textRename;
    private Combo comboContainerType;
    private Button okButton;
    private Button buttonRequired;
    private TranSegmentModel containerNode;
    private Vector<String> existingNames;
    private Vector<String> existingInterfaceRenames;
    private TranEditorController controller;
    private Composite compContents;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private static final String CHAR = "CHAR";
    private static final String BIT = "BIT";
    private static final String[] valueTypes = new String[]{"CHAR", "BIT"};
    private ControlDecoration cd_textContainerName;
    private ControlDecoration cd_textRename;
    private boolean isEdit;

    public EditContainerDialog(Shell parentShell, TranTreeObject containerNode, Vector<String> existingNames, Vector<String> existingInterfaceRenames, TranEditorController controller) {
        super(parentShell);
        this.containerNode = (TranSegmentModel)containerNode;
        this.existingNames = existingNames;
        this.existingInterfaceRenames = existingInterfaceRenames;
        this.controller = controller;
        this.isEdit = true;
        if (existingNames != null) {
            this.existingNames.remove(containerNode.getName());
            TranSegmentModel tsm = (TranSegmentModel)containerNode;
            if (!tsm.getSegment().getName().isEmpty()) {
                this.existingInterfaceRenames.remove(tsm.getSegment().getName());
            }
        }
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    public EditContainerDialog(Shell parentShell, Vector<String> existingNames, Vector<String> existingInterfaceRenames, TranEditorController controller) {
        super(parentShell);
        this.existingNames = existingNames;
        this.existingInterfaceRenames = existingInterfaceRenames;
        this.controller = controller;
        this.isEdit = false;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        YesnoType containerRequired;
        CicsContainerType containerType;
        String containerName;
        String rename;
        if (this.isEdit) {
            rename = this.containerNode.getSegment().getName();
            containerName = this.containerNode.getSegment().getOriginalName();
            containerType = this.containerNode.getSegment().getContainerType();
            containerRequired = this.containerNode.getSegment().getRequired();
        } else {
            rename = "";
            containerName = "";
            containerType = CicsContainerType.BIT;
            containerRequired = YesnoType.Y;
        }
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.horizontalSpacing = 10;
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        GridData gd_compContents = new GridData(4, 4, true, false, 1, 1);
        this.compContents.setLayoutData((Object)gd_compContents);
        this.labelContainerName = new Label(this.compContents, 0);
        this.labelContainerName.setText(PgmIntXlat.getLabel().getString("EC_CONTAINERNAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelOriginalName = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.labelContainerName.setLayoutData((Object)gd_labelOriginalName);
        this.textContainerName = new Text(this.compContents, 2048);
        GridData gd_textContainerName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textContainerName.widthHint = 350;
        this.textContainerName.setLayoutData((Object)gd_textContainerName);
        this.textContainerName.setText(containerName);
        this.textContainerName.setTextLimit(16);
        this.textContainerName.setToolTipText(PgmIntXlat.getLabel().getString("EC_CONTAINERNAME_TOOLTIP"));
        this.cd_textContainerName = new ControlDecoration((Control)this.textContainerName, 17408);
        XSwt.addTabTraverseListener((Control)this.textContainerName);
        this.textContainerName.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textContainerName.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        this.labelRename = new Label(this.compContents, 64);
        this.labelRename.setText(PgmIntXlat.getLabel().getString("EC_RENAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelRename = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.labelRename.setLayoutData((Object)gd_labelRename);
        this.textRename = new Text(this.compContents, 2048);
        GridData gd_textRename = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textRename.setLayoutData((Object)gd_textRename);
        this.textRename.setText(rename == null ? "" : rename);
        this.textRename.setToolTipText(PgmIntXlat.getLabel().getString("EC_RENAME_TOOLTIP"));
        this.cd_textRename = new ControlDecoration((Control)this.textRename, 17408);
        XSwt.addTabTraverseListener((Control)this.textRename);
        this.textRename.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textRename.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        this.labelContainerType = new Label(this.compContents, 0);
        this.labelContainerType.setText(PgmIntXlat.getLabel().getString("EC_TYPE") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelContainerType = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.labelContainerType.setLayoutData((Object)gd_labelContainerType);
        this.comboContainerType = new Combo(this.compContents, 2056);
        GridData gd_comboContainerType = new GridData(4, 0x1000000, true, false, 1, 1);
        this.comboContainerType.setLayoutData((Object)gd_comboContainerType);
        this.comboContainerType.setItems(valueTypes);
        if (containerType == CicsContainerType.CHAR) {
            this.comboContainerType.setText(CHAR);
        } else {
            this.comboContainerType.setText(BIT);
            if (this.isEdit && this.alreadyHasDataStructures()) {
                this.comboContainerType.setEnabled(false);
            }
        }
        XSwt.addTabTraverseListener((Control)this.comboContainerType);
        this.buttonRequired = new Button(this.compContents, 32);
        this.buttonRequired.setText(PgmIntXlat.getLabel().getString("EC_REQUIRED"));
        GridData gd_buttonRequired = new GridData(16384, 0x1000000, false, false, 2, 1);
        this.buttonRequired.setLayoutData((Object)gd_buttonRequired);
        if (containerRequired == YesnoType.Y) {
            this.buttonRequired.setSelection(true);
        } else {
            this.buttonRequired.setSelection(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        this.addListeners();
        return compDialogArea;
    }

    private boolean alreadyHasDataStructures() {
        return this.containerNode.getChildren().length > 0;
    }

    private void addListeners() {
        this.textContainerName.addModifyListener((ModifyListener)this);
        this.textContainerName.addVerifyListener((VerifyListener)this);
        this.textRename.addModifyListener((ModifyListener)this);
        this.textRename.addVerifyListener((VerifyListener)this);
        this.comboContainerType.addSelectionListener((SelectionListener)this);
        this.buttonRequired.addSelectionListener((SelectionListener)this);
    }

    private boolean hasNameCollision(String name) {
        return this.genericNameCollisionChecker(name, this.existingNames);
    }

    private boolean hasInterfaceRenameCollision(String interfaceRename) {
        return this.genericNameCollisionChecker(interfaceRename, this.existingInterfaceRenames);
    }

    private boolean genericNameCollisionChecker(String name, Vector<String> existingValues) {
        boolean retVal = false;
        Iterator<String> iter = existingValues.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textContainerName);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textRename);
    }

    private void validatePage() {
        Object[] inserts;
        this.updateStatus(null);
        this.resetControlDecorators();
        String msg = null;
        Status status = null;
        boolean haveError = false;
        String name = this.textContainerName.getText().trim();
        String interfaceRename = this.textRename.getText().trim();
        if (name.toUpperCase().startsWith("DFH") || name.toUpperCase().startsWith("BAQ")) {
            inserts = new String[]{name};
            msg = PgmIntXlat.getError().getString("EDD_RESERVED_NAME", inserts);
            status = new Status(2, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showWarningFieldDecoration((ControlDecoration)this.cd_textContainerName, (String)msg);
        }
        if (interfaceRename.equals(name)) {
            inserts = new String[]{interfaceRename};
            msg = PgmIntXlat.getError().getString("EDD_COLLIDED_RENAME", inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textRename, (String)msg);
        }
        if (name == null || name.isEmpty()) {
            msg = PgmIntXlat.getError().getString("EDD_MISSING_NAME");
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textContainerName, (String)msg);
        } else if (this.existingNames != null && (this.hasNameCollision(name) || this.hasInterfaceRenameCollision(name))) {
            inserts = new String[]{name};
            msg = PgmIntXlat.getError().getString("EDD_COLLIDED_NAME", inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textContainerName, (String)msg);
        } else if (!Utility.cicsNameHaveValidCharacters(name)) {
            inserts = new String[]{name};
            msg = PgmIntXlat.getError().getString("EDD_INVALID_NAME", inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textContainerName, (String)msg);
        }
        if (interfaceRename != null && (this.hasInterfaceRenameCollision(interfaceRename) || this.hasNameCollision(interfaceRename))) {
            inserts = new String[]{interfaceRename};
            msg = PgmIntXlat.getError().getString("EDD_COLLIDED_RENAME", inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textRename, (String)msg);
        }
        if (haveError) {
            this.updateStatusAndPack((IStatus)status);
        }
    }

    private void updateStatusAndPack(IStatus status) {
        this.updateStatus(status);
        XSwt.pack((Control)this.getShell());
    }

    public void verifyText(VerifyEvent e) {
    }

    public void modifyText(ModifyEvent arg0) {
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEdit) {
            newShell.setText(PgmIntXlat.getDescription().getString("EC_TITLE_EDIT"));
        } else {
            newShell.setText(PgmIntXlat.getDescription().getString("EC_TITLE_ADD"));
        }
    }

    public void create() {
        super.create();
        XSwt.centerInWorkbench((Shell)this.getShell());
        XSwt.disable((Control[])new Control[]{this.okButton});
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null && status.getSeverity() == 4) {
            XSwt.disable((Control[])new Control[]{this.okButton});
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void okPressed() {
        String containerName = XSwt.getText((Text)this.textContainerName).trim();
        String rename = XSwt.getText((Text)this.textRename).trim();
        CicsContainerType containerType = this.comboContainerType.getText().equals(CHAR) ? CicsContainerType.CHAR : CicsContainerType.BIT;
        YesnoType containerRequired = this.buttonRequired.getSelection() ? YesnoType.Y : YesnoType.N;
        if (this.isEdit) {
            this.controller.editContainer(this.containerNode, containerName, rename, containerType, containerRequired);
        } else {
            this.controller.addContainer(containerName, rename, containerType, containerRequired);
        }
        super.okPressed();
    }
}

