/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranDataStructureModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.ArrayPropertiesComposite;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.sar.common.ServiceArchiveConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EditCompositeFieldDialog
extends AbstractEditFieldDialog {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private static final String SOURCE_TYPE = PgmIntXlat.error((String)"EDS_DS_LABEL");
    private Label labelOriginalName;
    private Label labelNewFieldName;
    private Label labelRemarks;
    private Text textOriginalName;
    private Text textNewFieldName;
    private Text textRemarks;
    private Button okButton;
    private ControlDecoration cd_textFieldName;
    private Composite mainComposite;
    private FieldEditorController fieldEditCtrl;
    private TranTreeObject field;
    private Vector<String> existingNames;
    private ArrayPropertiesComposite arrayPropertiesComposite;
    private ServiceArchiveConstants.SP_Type spType;

    public EditCompositeFieldDialog(Shell parentShell, TranTreeObject field, Vector<String> existingNames, FieldEditorController fieldEditCtrl, ServiceArchiveConstants.SP_Type spType) {
        super(parentShell);
        this.field = field;
        this.existingNames = existingNames;
        this.fieldEditCtrl = fieldEditCtrl;
        this.spType = spType;
        if (existingNames != null) {
            this.existingNames.remove(field.getName());
        }
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        boolean editingArrayField = false;
        String originalName = "";
        String fieldName = "";
        String remarks = "";
        if (this.field instanceof FieldModel) {
            fieldNode = (FieldModel)this.field;
            originalName = fieldNode.getField().getOriginalName();
            fieldName = fieldNode.getField().getName();
            remarks = fieldNode.getField().getRemarks();
            editingArrayField = fieldNode.isArrayField();
        } else if (this.field instanceof TranDataStructureModel) {
            fieldNode = (TranDataStructureModel)this.field;
            originalName = fieldNode.getField().getOriginalName();
            fieldName = fieldNode.getField().getName();
            remarks = fieldNode.getField().getRemarks();
        }
        if (originalName == null) {
            originalName = fieldName;
        }
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialgArea = (Composite)super.createDialogArea(parent);
        compDialgArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialgArea.setLayout((Layout)gl_compDialogArea);
        this.mainComposite = new Composite(compDialgArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.horizontalSpacing = 10;
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.mainComposite.setLayout((Layout)gl_compContents);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.labelOriginalName = new Label(this.mainComposite, 0);
        this.labelOriginalName.setText(PgmIntXlat.labelWithColon((String)"EDS_ORIGINAL_NAME"));
        GridData gd_labelOriginalName = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelOriginalName.setLayoutData((Object)gd_labelOriginalName);
        this.textOriginalName = new Text(this.mainComposite, 8);
        GridData gd_textOriginalName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textOriginalName.setLayoutData((Object)gd_textOriginalName);
        this.textOriginalName.setText(originalName);
        XSwt.addTabTraverseListener((Control)this.textOriginalName);
        this.labelNewFieldName = new Label(this.mainComposite, 64);
        this.labelNewFieldName.setText(PgmIntXlat.labelWithColon((String)"EC_RENAME"));
        GridData gd_labelFieldName = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelNewFieldName.setLayoutData((Object)gd_labelFieldName);
        this.textNewFieldName = new Text(this.mainComposite, 2048);
        GridData gd_textFieldName = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textNewFieldName.setLayoutData((Object)gd_textFieldName);
        this.textNewFieldName.setText(fieldName == null ? "" : fieldName);
        this.cd_textFieldName = new ControlDecoration((Control)this.textNewFieldName, 17408);
        this.textNewFieldName.addModifyListener((ModifyListener)this);
        this.textNewFieldName.addVerifyListener((VerifyListener)this);
        XSwt.addTabTraverseListener((Control)this.textNewFieldName);
        this.textNewFieldName.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textNewFieldName.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        this.labelRemarks = new Label(this.mainComposite, 0);
        this.labelRemarks.setText(PgmIntXlat.labelWithColon((String)"EM_REMARKS"));
        GridData gd_labelRemarks = new GridData(4, 128, false, false, 1, 1);
        this.labelRemarks.setLayoutData((Object)gd_labelRemarks);
        this.textRemarks = new Text(this.mainComposite, 2626);
        this.textRemarks.setText(remarks == null ? "" : remarks);
        GridData gd_textRemarks = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textRemarks.widthHint = 350;
        gd_textRemarks.heightHint = XSwt.getFontHeight((Control)this.textRemarks) * 5;
        this.textRemarks.setLayoutData((Object)gd_textRemarks);
        this.textRemarks.addVerifyListener((VerifyListener)this);
        XSwt.addTabTraverseListener((Control)this.textRemarks);
        XSwt.addTextEnterKeyListener((Text)this.textRemarks);
        this.textRemarks.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textRemarks.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        if (editingArrayField && this.spType != ServiceArchiveConstants.SP_Type.IMSDB) {
            this.arrayPropertiesComposite = new ArrayPropertiesComposite(this, this.mainComposite, (FieldModel)this.field, this.fieldEditCtrl);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialgArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        this.textNewFieldName.setFocus();
        return compDialgArea;
    }

    private boolean nameCollision(String name) {
        boolean retVal = false;
        Iterator<String> iter = this.existingNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textFieldName);
    }

    private void validate() {
        this.updateStatus(null);
        this.resetControlDecorators();
        String msg = null;
        IStatus status = Status.OK_STATUS;
        String name = this.textNewFieldName.getText().trim();
        if (name == null || name.isEmpty()) {
            msg = PgmIntXlat.error((String)"EDS_MISSING_NAME", (String[])new String[]{SOURCE_TYPE});
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        } else if (this.existingNames != null && this.nameCollision(name)) {
            msg = PgmIntXlat.error((String)"EDS_COLLIDED_NAME", (String[])new String[]{name, SOURCE_TYPE});
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textFieldName, (String)msg);
        }
        if (this.arrayPropertiesComposite != null) {
            IStatus arrayStatus = this.arrayPropertiesComposite.validate();
            if (status.isOK()) {
                status = arrayStatus;
            }
        }
        if (!status.isOK()) {
            this.updateStatus(status);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
        }
        catch (Throwable err) {
            ZCeeUILogger.error((String)err.getMessage(), (Throwable)err, (Object[])new Object[0]);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.validate();
    }

    public void widgetSelected(SelectionEvent e) {
        this.validate();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.validate();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.field instanceof FieldModel) {
            newShell.setText(PgmIntXlat.getDescription().getString("EF_TITLE_EDIT"));
        } else if (this.field instanceof TranDataStructureModel) {
            newShell.setText(PgmIntXlat.getDescription().getString("EDS_TITLE_EDIT"));
        }
    }

    public void create() {
        super.create();
        this.alignControlsVertically();
        XSwt.centerInWorkbench((Shell)this.getShell());
        this.validate();
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            XSwt.disable((Control[])new Control[]{this.okButton});
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void okPressed() {
        this.fieldEditCtrl.setNewFieldName(XSwt.getTrimText((Text)this.textNewFieldName));
        this.fieldEditCtrl.setNewFieldRemarks(XSwt.getText((Text)this.textRemarks));
        if (this.arrayPropertiesComposite != null) {
            this.arrayPropertiesComposite.okPressed();
        }
        super.okPressed();
    }

    @Override
    public Composite getMainComposite() {
        return this.mainComposite;
    }

    @Override
    public List<Control> getControlsToAlignVertically() {
        ArrayList<Control> controlsToVAlign = new ArrayList<Control>();
        if (XSwt.isNotDisposed((Control)this.textOriginalName)) {
            controlsToVAlign.add((Control)this.textOriginalName);
        }
        if (XSwt.isNotDisposed((Control)this.textNewFieldName)) {
            controlsToVAlign.add((Control)this.textNewFieldName);
        }
        if (XSwt.isNotDisposed((Control)this.textRemarks)) {
            controlsToVAlign.add((Control)this.textRemarks);
        }
        if (XSwt.isNotDisposed((Control)this.arrayPropertiesComposite)) {
            controlsToVAlign.addAll(this.arrayPropertiesComposite.getControlsToAlignVertically());
        }
        return controlsToVAlign;
    }
}

