/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.TranEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranMessageModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.TranTreeObject;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.ui.programinterface.utilities.Utility;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EditChannelDialog
extends StatusDialog
implements VerifyListener,
ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Label labelChannelName;
    private Label labelRemarks;
    private Text textChannelName;
    private Text textRemarks;
    private Button okButton;
    private TranMessageModel channelNode;
    private TranEditorController controller;
    private Composite compContents;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private ControlDecoration cd_textChannelName;

    public EditChannelDialog(Shell parentShell, TranTreeObject channelNode, TranEditorController controller) {
        super(parentShell);
        this.channelNode = (TranMessageModel)channelNode;
        this.controller = controller;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Control retVal = null;
        try {
            retVal = this.createDialogAreaBody(parent);
        }
        catch (Exception e) {
            ZCeeUILogger.error((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
        }
        return retVal;
    }

    private Control createDialogAreaBody(Composite parent) {
        String channelName = this.channelNode.getMessage().getMessage().getName();
        String remarks = this.channelNode.getMessage().getMessage().getRemarks();
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        Composite compDialogArea = (Composite)super.createDialogArea(parent);
        compDialogArea.setBackground(this.formToolkit.getColors().getBackground());
        GridLayout gl_compDialogArea = new GridLayout(1, false);
        gl_compDialogArea.horizontalSpacing = 0;
        gl_compDialogArea.verticalSpacing = 0;
        gl_compDialogArea.marginHeight = 0;
        compDialogArea.setLayout((Layout)gl_compDialogArea);
        this.compContents = new Composite(compDialogArea, 0);
        GridLayout gl_compContents = new GridLayout(2, false);
        gl_compContents.horizontalSpacing = 10;
        gl_compContents.marginTop = 5;
        gl_compContents.verticalSpacing = 10;
        this.compContents.setLayout((Layout)gl_compContents);
        GridData gd_compContents = new GridData(4, 4, true, false, 1, 1);
        this.compContents.setLayoutData((Object)gd_compContents);
        this.labelChannelName = new Label(this.compContents, 0);
        this.labelChannelName.setText(PgmIntXlat.getLabel().getString("EM_CHANNEL_NAME") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelChannelName = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.labelChannelName.setLayoutData((Object)gd_labelChannelName);
        this.textChannelName = new Text(this.compContents, 2048);
        GridData gd_textChannelName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textChannelName.widthHint = 350;
        this.textChannelName.setLayoutData((Object)gd_textChannelName);
        this.textChannelName.setTextLimit(16);
        this.textChannelName.setText(channelName);
        this.cd_textChannelName = new ControlDecoration((Control)this.textChannelName, 17408);
        XSwt.addTabTraverseListener((Control)this.textChannelName);
        this.textChannelName.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textChannelName.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)true);
            }
        });
        this.labelRemarks = new Label(this.compContents, 0);
        this.labelRemarks.setText(PgmIntXlat.getLabel().getString("EM_REMARKS") + PgmIntXlat.getColon().getString("COLON"));
        GridData gd_labelRemarks = new GridData(16384, 128, false, false, 1, 1);
        this.labelRemarks.setLayoutData((Object)gd_labelRemarks);
        this.textRemarks = new Text(this.compContents, 2626);
        this.textRemarks.setText(remarks == null ? "" : remarks);
        GridData gd_textRemarks = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textRemarks.widthHint = 350;
        gd_textRemarks.heightHint = XSwt.getFontHeight((Control)this.textRemarks) * 5;
        this.textRemarks.setLayoutData((Object)gd_textRemarks);
        this.textRemarks.addVerifyListener((VerifyListener)this);
        XSwt.addTabTraverseListener((Control)this.textRemarks);
        XSwt.addTextEnterKeyListener((Text)this.textRemarks);
        this.textRemarks.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textRemarks.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)compDialogArea, "com.ibm.zosconnect.ui.programinterface.edit_service_interface");
        this.addListeners();
        return compDialogArea;
    }

    private void addListeners() {
        this.textChannelName.addModifyListener((ModifyListener)this);
        this.textChannelName.addVerifyListener((VerifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
    }

    private void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textChannelName);
    }

    private void validatePage() {
        this.updateStatus(null);
        this.resetControlDecorators();
        String msg = null;
        Status status = null;
        boolean haveError = false;
        String name = this.textChannelName.getText().trim();
        if (name == null || name.isEmpty()) {
            msg = PgmIntXlat.getError().getString("ECD_MISSING_NAME");
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textChannelName, (String)msg);
        } else if (!Utility.cicsNameHaveValidCharacters(name)) {
            Object[] inserts = new String[]{name};
            msg = PgmIntXlat.getError().getString("EDD_INVALID_NAME", inserts);
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            haveError = true;
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textChannelName, (String)msg);
        }
        if (haveError) {
            this.updateStatusAndPack((IStatus)status);
        }
    }

    private void updateStatusAndPack(IStatus status) {
        this.updateStatus(status);
        XSwt.pack((Control)this.getShell());
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
        }
        catch (Throwable err) {
            ZCeeUILogger.error((String)err.getMessage(), (Throwable)err, (Object[])new Object[0]);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.formToolkit.getColors().getBackground());
        parent.setBackgroundMode(2);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.getButton(0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PgmIntXlat.getDescription().getString("ECH_TITLE_EDIT"));
    }

    public void create() {
        super.create();
        XSwt.centerInWorkbench((Shell)this.getShell());
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (status != null) {
            XSwt.disable((Control[])new Control[]{this.okButton});
        } else {
            XSwt.enable((Control[])new Control[]{this.okButton});
        }
    }

    protected void okPressed() {
        String channelName = XSwt.getText((Text)this.textChannelName).trim();
        String remarks = XSwt.getText((Text)this.textRemarks);
        this.controller.editMessageOrChannel(this.channelNode, channelName, remarks);
        super.okPressed();
    }
}

