/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.SWTResourceManager;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.Xlat;
import com.ibm.zosconnect.ui.common.util.swt.ButtonBuilder;
import com.ibm.zosconnect.ui.common.util.swt.CompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.FormStyledTextBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperLinkBuilder;
import com.ibm.zosconnect.ui.common.util.swt.HyperlinkAdapter2;
import com.ibm.zosconnect.ui.common.util.swt.LabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.TextBuilder;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfMonth;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeDayOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeHexLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeLiteral;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeMonthOfYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYear;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.model.DateTimeYearOfCentury;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseError;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParseResult;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParser;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternParserMode;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimePatternToken;
import com.ibm.zosconnect.ui.programinterface.controllers.datetime.parser.DateTimeProposalGenerator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.InvalidValueException;
import com.ibm.zosconnect.ui.programinterface.controllers.exceptions.DateTimePatternParserException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialogComposite;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.InsertPatternDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.StyledTextContentAdapter;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentType;
import com.ibm.zosconnect.wv.metadata.transaction.DateComponentTypeType;
import com.ibm.zosconnect.wv.metadata.transaction.DateOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.DateType;
import com.ibm.zosconnect.wv.metadata.transaction.PatternDateType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DatePropertiesComposite
extends AbstractEditFieldDialogComposite
implements VerifyListener,
ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AbstractEditFieldDialog parentDialog;
    private DatePropertiesComposite self = this;
    private DatePropertiesComposite mainComp = this;
    private FieldEditorController fieldEditCtrl;
    private String insertPatternStr = "";
    private FormToolkit toolkit;
    private Group dateGroup;
    private Composite patternsCmp;
    private Composite summaryCmp;
    private StyledText patternText;
    private Text summaryText;
    private ControlDecoration cd_patternText;
    private ControlDecoration cd_contentAssistHint;
    private Button insertButton;
    private Hyperlink referenceLink;
    private List<DateTimePatternToken> tokenList;
    private DateTimePatternParseResult parseResult;
    private ContentProposalAdapter adapter;

    public DatePropertiesComposite(AbstractEditFieldDialog parentDialog, Composite parentComposite, FieldModel fieldNode, FieldEditorController fieldEditCtrl, FormToolkit formToolkit) {
        super(parentComposite, 0);
        this.parentDialog = parentDialog;
        this.fieldEditCtrl = fieldEditCtrl;
        this.toolkit = formToolkit;
        this.setLayout((Layout)new GridLayoutBuilder().horizontalSpacing(0).marginHeight(0).marginWidth(0).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
        this.createContents();
    }

    private void createContents() {
        this.dateGroup = new Group((Composite)this.self, 0);
        this.dateGroup.setText(OverrideTypeUtil.getUIStringFromType(DateOverrideType.class));
        this.dateGroup.setLayout((Layout)new GridLayoutBuilder().marginTop(5).marginWidth(5).verticalSpacing(10).build());
        this.dateGroup.setLayoutData((Object)new GridDataBuilder().grabExcessHorizontalSpace(true).build());
        this.patternsCmp = (Composite)new CompositeBuilder().numColumns(3).marginWidth(0).grabExcessHorizontalSpace(true).build((Composite)this.dateGroup);
        new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_DATE_PATTERN")).verticalAlignment(0x1000000).build(this.patternsCmp);
        this.patternText = (StyledText)new FormStyledTextBuilder(this.toolkit).listener((VerifyListener)this.mainComp).listener((ModifyListener)this.mainComp).grabExcessHorizontalSpace(true).widthHint(43 * XSwt.getAverageCharWidth((Control)this.patternsCmp)).style(Integer.valueOf(2052)).verticalAlignment(0x1000000).build(this.patternsCmp);
        this.cd_patternText = new ControlDecoration((Control)this.patternText, 17408);
        this.cd_contentAssistHint = new ControlDecoration((Control)this.patternText, 16512);
        this.cd_contentAssistHint.setShowOnlyOnFocus(true);
        XSwt.showInfoFieldDecoration((ControlDecoration)this.cd_contentAssistHint, (String)PgmIntXlat.label((String)"DT_CONTENT_ASSIST_TIP"));
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException e) {
            ZCeeUILogger.error((Throwable)e);
        }
        this.adapter = new ContentProposalAdapter((Control)this.patternText, (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)new PatternProposalProvider(), keyStroke, null);
        this.adapter.setProposalAcceptanceStyle(2);
        this.adapter.setPropagateKeys(true);
        this.patternText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent ve) {
                try {
                    KeyStroke k = KeyStroke.getInstance((String)"Enter");
                    if (k.getNaturalKey() == ve.keyCode) {
                        ve.doit = false;
                    }
                }
                catch (Exception e) {
                    ZCeeUILogger.error((Throwable)e);
                }
            }
        });
        this.insertButton = (Button)new ButtonBuilder().text(PgmIntXlat.label((String)"ODT_DATE_INSERTDIALOG_NAME")).verticalAlignment(0x1000000).listener((SelectionListener)this.mainComp).build(this.patternsCmp);
        new LabelBuilder().build(this.patternsCmp);
        this.referenceLink = (Hyperlink)new HyperLinkBuilder().text(PgmIntXlat.label((String)"ODT_DATE_REFERENCE_LINK")).listener((IHyperlinkListener)new HyperlinkAdapter2((Control)this.self){

            public void linkActivated(HyperlinkEvent event, Control owner) throws Exception {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.zosconnect.ui.programinterface.datepatterns");
            }
        }).horizontalAlignment(16384).verticalAlignment(0x1000000).build(this.patternsCmp);
        this.referenceLink.setUnderlined(true);
        this.referenceLink.setForeground(this.getDisplay().getSystemColor(9));
        this.summaryCmp = (Composite)new CompositeBuilder().marginWidth(0).grabExcessHorizontalSpace(true).build((Composite)this.dateGroup);
        new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_DATE_SUMMARY")).verticalAlignment(0x1000000).build(this.summaryCmp);
        this.summaryText = (Text)new TextBuilder().style(Integer.valueOf(2632)).background(XSwt.getColor((RGB)XSwt.RGB_LIGHT_GRAY)).grabExcessHorizontalSpace(true).build(this.summaryCmp);
        this.restorePattern();
        GridData gd_summaryText = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_summaryText.widthHint = 300;
        gd_summaryText.heightHint = XSwt.getFontHeight((Control)this.summaryText) * 4;
        this.summaryText.setLayoutData((Object)gd_summaryText);
    }

    @Override
    public List<Control> getControlsToAlignVertically() {
        ArrayList<Control> controls = new ArrayList<Control>();
        controls.add((Control)this.patternText);
        controls.add((Control)this.referenceLink);
        return controls;
    }

    private void restorePattern() {
        DateOverrideType dateOverrideType;
        DatatypeOverride overrideType = this.fieldEditCtrl.getDatatypeOverride();
        if (overrideType != null && overrideType instanceof DateOverrideType && (dateOverrideType = (DateOverrideType)overrideType).getDate() instanceof PatternDateType) {
            PatternDateType patternDate = (PatternDateType)dateOverrideType.getDate();
            XSwt.setText((StyledText)this.patternText, (String)patternDate.getPattern());
            ((EditFieldDialog)this.parentDialog).validatePage();
        }
    }

    private void updateSummary() {
        if (this.tokenList == null || this.tokenList.isEmpty()) {
            this.summaryText.setText("");
        }
        Iterator<DateTimePatternToken> it = this.tokenList.iterator();
        Object summaryStr = "";
        if (it.hasNext()) {
            summaryStr = it.next().getXlatSummaryText();
        }
        while (it.hasNext()) {
            DateTimePatternToken currToken = it.next();
            summaryStr = (String)summaryStr + ", " + currToken.getXlatSummaryText();
        }
        this.summaryText.setText((String)summaryStr);
    }

    @Override
    public IStatus validate() {
        this.resetControlDecorators();
        IStatus status = Status.OK_STATUS;
        String msg = null;
        String patternVal = this.patternText.getText();
        if (patternVal.isEmpty()) {
            this.summaryText.setText("");
            this.parseResult = null;
            this.tokenList = null;
            msg = PgmIntXlat.error((String)"EF_EMPTY_VALUE");
            status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_patternText, (String)msg);
        } else {
            try {
                try {
                    this.tokenList = Collections.emptyList();
                    DateTimePatternParser parser = new DateTimePatternParser(DateTimePatternParserMode.DATE);
                    this.parseResult = parser.parse(patternVal);
                    this.tokenList = this.parseResult.getTokens();
                    this.highlightPatternText(this.parseResult);
                    if (this.parseResult.hasErrors()) {
                        throw this.parseResult.getFirstError();
                    }
                    this.fieldEditCtrl.validateDateOverrideValue(this.parseResult);
                }
                catch (DateTimePatternParseError | InvalidValueException e) {
                    msg = e.getMessage();
                    status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_patternText, (String)msg);
                    this.updateSummary();
                }
                catch (DateTimePatternParserException e) {
                    ZCeeUILogger.error((Throwable)e);
                    msg = Xlat.error((String)"UNEXPECTED_ERROR");
                    status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_patternText, (String)msg);
                    this.updateSummary();
                }
            }
            finally {
                this.updateSummary();
            }
        }
        return status;
    }

    private void updatePatternTextWithInsert() {
        if (!this.insertPatternStr.isEmpty()) {
            if (!this.patternText.setFocus()) {
                this.patternText.forceFocus();
            }
            String newStr = "";
            String oldStr = this.patternText.getText();
            int strLen = oldStr.length();
            int caretOffest = this.patternText.getCaretOffset();
            if (caretOffest < strLen) {
                String start = oldStr.substring(0, caretOffest);
                String end = oldStr.substring(caretOffest, strLen);
                newStr = newStr.concat(start + this.insertPatternStr + end);
                this.patternText.setText(newStr);
                if (this.insertPatternStr.equals("''") || this.insertPatternStr.equals("%''")) {
                    this.patternText.setCaretOffset((start + this.insertPatternStr).length() - 1);
                } else {
                    this.patternText.setCaretOffset((start + this.insertPatternStr).length());
                }
            } else {
                this.patternText.setText(oldStr.concat(this.insertPatternStr));
                if (this.insertPatternStr.equals("''") || this.insertPatternStr.equals("%''")) {
                    this.patternText.setCaretOffset(this.patternText.getText().length() - 1);
                } else {
                    this.patternText.setCaretOffset(this.patternText.getText().length());
                }
            }
        }
    }

    private IStatus updateStatus(IStatus oldStatus, IStatus newStatus) {
        IStatus status = null;
        status = oldStatus != null && newStatus != null && newStatus.getSeverity() > oldStatus.getSeverity() ? newStatus : oldStatus;
        return status;
    }

    public void highlightPatternText(DateTimePatternParseResult result) {
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        Set errorTokens = result.getErrorTokens();
        for (DateTimePatternToken token : result.getTokens()) {
            StyleRange style;
            if (errorTokens.contains(token)) {
                style = new StyleRange();
                style.start = token.getBeginColumn() - 1;
                style.length = token.getText().length();
                style.foreground = SWTResourceManager.getColor((int)3);
                styleRanges.add(style);
                continue;
            }
            if (token instanceof DateTimeLiteral) {
                DateTimeLiteral literal = (DateTimeLiteral)token;
                StyleRange style2 = new StyleRange();
                style2.start = token.getBeginColumn() - 1;
                style2.length = token.getText().length();
                style2.foreground = literal.isQuoted() || literal.isEscaped() ? SWTResourceManager.getColor((int)14) : SWTResourceManager.getColor((int)2);
                style2.fontStyle = 0;
                styleRanges.add(style2);
                continue;
            }
            if (token instanceof DateTimeHexLiteral) {
                style = new StyleRange();
                style.start = token.getBeginColumn() - 1;
                style.length = token.getText().length();
                style.foreground = SWTResourceManager.getColor((int)14);
                style.fontStyle = 0;
                styleRanges.add(style);
                continue;
            }
            style = new StyleRange();
            style.start = token.getBeginColumn() - 1;
            style.length = token.getText().length();
            style.foreground = SWTResourceManager.getColor((int)12);
            style.fontStyle = 0;
            styleRanges.add(style);
        }
        this.patternText.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
    }

    @Override
    public void okPressed() {
        DateOverrideType dateOverride = new DateOverrideType();
        PatternDateType patternDate = new PatternDateType();
        List dateComponentList = patternDate.getDateComponent();
        int hexCharLength = this.fieldEditCtrl.getEncodingUnitSize() * 2;
        patternDate.setPattern(this.patternText.getText());
        for (DateTimePatternToken currToken : this.tokenList) {
            DateComponentType datePart = new DateComponentType();
            datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            if (currToken instanceof DateTimeCentury) {
                datePart.setType(DateComponentTypeType.Century);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeDayOfMonth) {
                datePart.setType(DateComponentTypeType.DayOfMonth);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeDayOfYear) {
                datePart.setType(DateComponentTypeType.DayOfYear);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeMonthOfYear) {
                datePart.setType(DateComponentTypeType.MonthOfYear);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeYear) {
                datePart.setType(DateComponentTypeType.Year);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeYearOfCentury) {
                datePart.setType(DateComponentTypeType.YearOfCentury);
                datePart.setNumChars(Integer.valueOf(currToken.getText().length()));
            } else if (currToken instanceof DateTimeHexLiteral) {
                DateTimeHexLiteral hexLiteral = (DateTimeHexLiteral)currToken;
                datePart.setType(DateComponentTypeType.HexLiteral);
                datePart.setValue(hexLiteral.getLiteral());
                datePart.setNumChars(Integer.valueOf(hexLiteral.getLiteral().length() / hexCharLength));
                patternDate.setHasHexLiteral(Boolean.TRUE);
            } else if (currToken instanceof DateTimeLiteral) {
                DateTimeLiteral literal = (DateTimeLiteral)currToken;
                datePart.setType(DateComponentTypeType.Literal);
                datePart.setValue(literal.getLiteral());
                datePart.setNumChars(Integer.valueOf(literal.getLiteral().length()));
            }
            dateComponentList.add(datePart);
        }
        dateOverride.setDate((DateType)patternDate);
        this.fieldEditCtrl.setDatatypeOverride((DatatypeOverride)dateOverride);
    }

    @Override
    public void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_patternText);
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.insertButton) {
            InsertPatternDialog dialog = new InsertPatternDialog(this, this.fieldEditCtrl, this.tokenList);
            dialog.open();
            this.updatePatternTextWithInsert();
        }
        ((EditFieldDialog)this.parentDialog).validatePage();
    }

    public void modifyText(ModifyEvent event) {
        ((EditFieldDialog)this.parentDialog).validatePage();
    }

    public void verifyText(VerifyEvent event) {
        event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
    }

    public void setInsertPatternStr(String insertPatternStr) {
        this.insertPatternStr = insertPatternStr;
    }

    private class PatternProposalProvider
    implements IContentProposalProvider {
        private PatternProposalProvider() {
        }

        public IContentProposal[] getProposals(String text, int textLen) {
            text = StringUtils.trimToEmpty((String)text);
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            int caretOffset = DatePropertiesComposite.this.patternText.getCaretOffset();
            try {
                DateTimeProposalGenerator generator;
                List proposalList;
                if (DatePropertiesComposite.this.parseResult == null) {
                    DatePropertiesComposite.this.parseResult = new DateTimePatternParseResult("");
                }
                if ((proposalList = (generator = new DateTimeProposalGenerator(DatePropertiesComposite.this.parseResult, caretOffset + 1)).generatePatternProposals()).isEmpty()) {
                    DatePropertiesComposite.this.adapter.setProposalAcceptanceStyle(3);
                    proposals.add(new ContentProposal(PgmIntXlat.label((String)"DT_NO_PROPOSALS")));
                } else {
                    DatePropertiesComposite.this.adapter.setProposalAcceptanceStyle(2);
                    proposals.addAll(generator.generatePatternProposals());
                }
            }
            catch (Exception e) {
                ZCeeUILogger.error((Throwable)e);
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }
}

