/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.util.NumberUtilz;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.ButtonBuilder;
import com.ibm.zosconnect.ui.common.util.swt.ComboBuilder;
import com.ibm.zosconnect.ui.common.util.swt.CompositeBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.LabelBuilder;
import com.ibm.zosconnect.ui.common.util.swt.TextBuilder;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.InvalidValueException;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.BooleanOverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.controllers.model.utilities.OverrideTypeUtil;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialogComposite;
import com.ibm.zosconnect.ui.programinterface.editdialogs.EditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.IEditFieldDialogComposite;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanOverrideType;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanRequest;
import com.ibm.zosconnect.wv.metadata.transaction.BooleanResponse;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeOverride;
import com.ibm.zosconnect.wv.metadata.transaction.DatatypeType;
import com.ibm.zosconnect.wv.metadata.transaction.OverrideValueType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.BoolUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BooleanPropertiesComposite
extends AbstractEditFieldDialogComposite
implements VerifyListener,
ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private AbstractEditFieldDialog parentDialog;
    private Composite parentComposite;
    private Composite requestTabContents;
    private Composite responseTabContents;
    private CTabFolder reqRespCTabFolder;
    private CTabItem requestCTabItem;
    private CTabItem responseCTabItem;
    private Label requestTrueValueTypeLabel;
    private Label requestFalseValueTypeLabel;
    private Label responseTrueValueTypeLabel;
    private Label responseFalseValueTypeLabel;
    private Combo requestTrueValueTypeCombo;
    private Combo requestFalseValueTypeCombo;
    private Combo responseTrueValueTypeCombo;
    private Combo responseFalseValueTypeCombo;
    private ValueTypeComposite requestTrueValueTypeComp;
    private ValueTypeComposite requestFalseValueTypeComp;
    private ValueTypeComposite responseTrueValueTypeComp;
    private ValueTypeComposite responseFalseValueTypeComp;
    private SingleValueComposite requestTrueSingleValueComp;
    private SingleValueComposite requestFalseSingleValueComp;
    private SingleValueComposite responseTrueSingleValueComp;
    private SingleValueComposite responseFalseSingleValueComp;
    private MultValuesComposite requestTrueMultValuesComp;
    private MultValuesComposite requestFalseMultValuesComp;
    private MultValuesComposite responseTrueMultValuesComp;
    private MultValuesComposite responseFalseMultValuesComp;
    private RangeComposite requestTrueRangeComp;
    private RangeComposite requestFalseRangeComp;
    private RangeComposite responseTrueRangeComp;
    private RangeComposite responseFalseRangeComp;
    private Group booleanGroup;
    private BooleanPropertiesComposite self = this;
    private BooleanPropertiesComposite mainBooleanComp = this;
    private FieldModel fieldNode;
    private FieldEditorController fieldEditCtrl;
    private boolean useHex;
    private ControlDecoration cd_booleanTrueReqValueTypeCombo;
    private ControlDecoration cd_booleanFalseReqValueTypeCombo;
    private ControlDecoration cd_booleanTrueRespValueTypeCombo;
    private ControlDecoration cd_booleanFalseRespValueTypeCombo;

    public BooleanPropertiesComposite(AbstractEditFieldDialog parentDialog, Composite parentComposite, FieldModel fieldNode, FieldEditorController fieldEditCtrl) {
        super(parentComposite, 0);
        this.parentDialog = parentDialog;
        this.parentComposite = parentComposite;
        this.fieldNode = fieldNode;
        this.fieldEditCtrl = fieldEditCtrl;
        this.useHex = false;
        if (fieldEditCtrl.getApplicationDatatype().getDatatype() == DatatypeType.CHAR) {
            this.useHex = true;
        }
        this.setLayout((Layout)new GridLayoutBuilder().horizontalSpacing(0).marginHeight(0).marginWidth(0).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
        this.createContents();
    }

    private void createContents() {
        this.booleanGroup = new Group((Composite)this.self, 0);
        this.booleanGroup.setText(OverrideTypeUtil.getUIStringFromType(BooleanOverrideType.class));
        this.booleanGroup.setLayout((Layout)new GridLayoutBuilder().marginTop(5).marginWidth(5).verticalSpacing(10).build());
        this.booleanGroup.setLayoutData((Object)new GridDataBuilder().grabExcessHorizontalSpace(true).build());
        this.reqRespCTabFolder = new CTabFolder((Composite)this.booleanGroup, 0x800080);
        this.reqRespCTabFolder.setLayoutData((Object)new GridDataBuilder().grabExcessHorizontalSpace(true).build());
        this.requestCTabItem = new CTabItem(this.reqRespCTabFolder, 0);
        this.requestCTabItem.setText(PgmIntXlat.label((String)"ODT_BOOLEAN_REQUEST_TAB"));
        this.requestCTabItem.setControl((Control)this.createRequestTabContents(this.reqRespCTabFolder));
        this.responseCTabItem = new CTabItem(this.reqRespCTabFolder, 0);
        this.responseCTabItem.setText(PgmIntXlat.label((String)"ODT_BOOLEAN_RESPONSE_TAB"));
        this.responseCTabItem.setControl((Control)this.createResponseTabContents(this.reqRespCTabFolder));
        this.reqRespCTabFolder.setSelection(0);
    }

    private Composite createRequestTabContents(CTabFolder parentFolder) {
        this.requestTabContents = (Composite)new CompositeBuilder().grabExcessHorizontalSpace(true).verticalSpacing(10).marginTop(10).numColumns(2).build((Composite)parentFolder);
        this.requestTrueValueTypeLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_BOOLEAN_TRUE_VALUE_TYPE")).verticalAlignment(0x1000000).build(this.requestTabContents);
        this.requestTrueValueTypeCombo = (Combo)new ComboBuilder().items(BooleanOverrideTypeUtil.getRequestUIStrings()).toolTipText(PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP")).grabExcessHorizontalSpace(true).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).verticalAlignment(0x1000000).listener((SelectionListener)this.self).style(Integer.valueOf(8)).build(this.requestTabContents);
        this.requestFalseValueTypeLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_BOOLEAN_FALSE_VALUE_TYPE")).verticalAlignment(0x1000000).build(this.requestTabContents);
        this.requestFalseValueTypeCombo = (Combo)new ComboBuilder().items(BooleanOverrideTypeUtil.getRequestUIStrings()).toolTipText(PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP")).grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).listener((SelectionListener)this.self).style(Integer.valueOf(8)).build(this.requestTabContents);
        this.restoreRequestTabValues();
        this.requestTabContents.pack();
        return this.requestTabContents;
    }

    private Composite createResponseTabContents(CTabFolder parentFolder) {
        this.responseTabContents = (Composite)new CompositeBuilder().grabExcessHorizontalSpace(true).verticalSpacing(10).marginTop(10).numColumns(2).build((Composite)parentFolder);
        this.responseTrueValueTypeLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_BOOLEAN_TRUE_VALUE_TYPE")).verticalAlignment(0x1000000).build(this.responseTabContents);
        this.responseTrueValueTypeCombo = (Combo)new ComboBuilder().items(BooleanOverrideTypeUtil.getResponseUIStrings()).toolTipText(PgmIntXlat.label((String)"EF_RESPONSE_EMPTY_VALUE_TOOLTIP")).grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).listener((SelectionListener)this).style(Integer.valueOf(8)).build(this.responseTabContents);
        this.responseFalseValueTypeLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_BOOLEAN_FALSE_VALUE_TYPE")).verticalAlignment(0x1000000).build(this.responseTabContents);
        this.responseFalseValueTypeCombo = (Combo)new ComboBuilder().items(BooleanOverrideTypeUtil.getResponseUIStrings()).toolTipText(PgmIntXlat.label((String)"EF_RESPONSE_EMPTY_VALUE_TOOLTIP")).grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).listener((SelectionListener)this).style(Integer.valueOf(8)).build(this.responseTabContents);
        this.restoreResponseTabValues();
        this.responseTabContents.pack();
        return this.responseTabContents;
    }

    private void restoreRequestTabValues() {
        BooleanOverrideType booleanOverrideType;
        BooleanRequest booleanReq;
        DatatypeOverride overrideType = this.fieldEditCtrl.getDatatypeOverride();
        if (overrideType != null && overrideType instanceof BooleanOverrideType && (booleanReq = (booleanOverrideType = (BooleanOverrideType)overrideType).getBooleanRequest()) != null) {
            if (OverrideValueType.SINGLE_VALUE.equals((Object)booleanReq.getTrueValueType())) {
                this.requestTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.SINGLE_VALUE));
                this.handleUpdateRequestTrueValueType();
                this.requestTrueSingleValueComp.getHexButton().setSelection(booleanReq.getTrueValueIsHex());
                this.requestTrueSingleValueComp.getValueText().setText(booleanReq.getTrueValue());
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)booleanReq.getTrueValueType())) {
                this.requestTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.HIGH_VALUES));
                this.handleUpdateRequestTrueValueType();
            } else if (OverrideValueType.LOW_VALUES.equals((Object)booleanReq.getTrueValueType())) {
                this.requestTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.LOW_VALUES));
                this.handleUpdateRequestTrueValueType();
            }
            if (OverrideValueType.SINGLE_VALUE.equals((Object)booleanReq.getFalseValueType())) {
                this.requestFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.SINGLE_VALUE));
                this.handleUpdateRequestFalseValueType();
                this.requestFalseSingleValueComp.getHexButton().setSelection(booleanReq.getFalseValueIsHex());
                this.requestFalseSingleValueComp.getValueText().setText(booleanReq.getFalseValue());
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)booleanReq.getFalseValueType())) {
                this.requestFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.HIGH_VALUES));
                this.handleUpdateRequestFalseValueType();
            } else if (OverrideValueType.LOW_VALUES.equals((Object)booleanReq.getFalseValueType())) {
                this.requestFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.LOW_VALUES));
                this.handleUpdateRequestFalseValueType();
            }
        }
    }

    private void restoreResponseTabValues() {
        BooleanOverrideType booleanOverrideType;
        BooleanResponse booleanResp;
        DatatypeOverride overrideType = this.fieldEditCtrl.getDatatypeOverride();
        if (overrideType != null && overrideType instanceof BooleanOverrideType && (booleanResp = (booleanOverrideType = (BooleanOverrideType)overrideType).getBooleanResponse()) != null) {
            String delimiter;
            if (OverrideValueType.SINGLE_VALUE.equals((Object)booleanResp.getTrueValueType())) {
                this.responseTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.SINGLE_VALUE));
                this.handleUpdateResponseTrueValueType();
                this.responseTrueSingleValueComp.getHexButton().setSelection(booleanResp.getTrueValueIsHex());
                this.responseTrueSingleValueComp.getValueText().setText((String)booleanResp.getTrueValue().get(0));
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)booleanResp.getTrueValueType())) {
                this.responseTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.HIGH_VALUES));
                this.handleUpdateResponseTrueValueType();
            } else if (OverrideValueType.LOW_VALUES.equals((Object)booleanResp.getTrueValueType())) {
                this.responseTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.LOW_VALUES));
                this.handleUpdateResponseTrueValueType();
            } else if (OverrideValueType.MULT_VALUES.equals((Object)booleanResp.getTrueValueType())) {
                this.responseTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.MULT_VALUES));
                this.handleUpdateResponseTrueValueType();
                this.responseTrueMultValuesComp.getHexButton().setSelection(booleanResp.getTrueValueIsHex());
                delimiter = booleanResp.getTrueDelimiterChar();
                this.responseTrueMultValuesComp.setDelimiter(delimiter);
                this.responseTrueMultValuesComp.getValueText().setText(String.join((CharSequence)delimiter, booleanResp.getTrueValue()));
            } else if (OverrideValueType.RANGE.equals((Object)booleanResp.getTrueValueType())) {
                this.responseTrueValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.RANGE));
                this.handleUpdateResponseTrueValueType();
                this.responseTrueRangeComp.getHexButton().setSelection(booleanResp.getTrueValueIsHex());
                this.responseTrueRangeComp.getLowValueText().setText(booleanResp.getTrueValueRangeLow());
                this.responseTrueRangeComp.getHighValueText().setText(booleanResp.getTrueValueRangeHigh());
            }
            if (OverrideValueType.SINGLE_VALUE.equals((Object)booleanResp.getFalseValueType())) {
                this.responseFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.SINGLE_VALUE));
                this.handleUpdateResponseFalseValueType();
                this.responseFalseSingleValueComp.getHexButton().setSelection(booleanResp.getFalseValueIsHex());
                this.responseFalseSingleValueComp.getValueText().setText((String)booleanResp.getFalseValue().get(0));
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)booleanResp.getFalseValueType())) {
                this.responseFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.HIGH_VALUES));
                this.handleUpdateResponseFalseValueType();
            } else if (OverrideValueType.LOW_VALUES.equals((Object)booleanResp.getFalseValueType())) {
                this.responseFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.LOW_VALUES));
                this.handleUpdateResponseFalseValueType();
            } else if (OverrideValueType.MULT_VALUES.equals((Object)booleanResp.getFalseValueType())) {
                this.responseFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.MULT_VALUES));
                this.handleUpdateResponseFalseValueType();
                this.responseFalseMultValuesComp.getHexButton().setSelection(booleanResp.getFalseValueIsHex());
                delimiter = booleanResp.getFalseDelimiterChar();
                this.responseFalseMultValuesComp.setDelimiter(delimiter);
                this.responseFalseMultValuesComp.getValueText().setText(String.join((CharSequence)delimiter, booleanResp.getFalseValue()));
            } else if (OverrideValueType.RANGE.equals((Object)booleanResp.getFalseValueType())) {
                this.responseFalseValueTypeCombo.setText(BooleanOverrideTypeUtil.getUIStringFromType((OverrideValueType)OverrideValueType.RANGE));
                this.handleUpdateResponseFalseValueType();
                this.responseFalseRangeComp.getHexButton().setSelection(booleanResp.getFalseValueIsHex());
                this.responseFalseRangeComp.getLowValueText().setText(booleanResp.getFalseValueRangeLow());
                this.responseFalseRangeComp.getHighValueText().setText(booleanResp.getFalseValueRangeHigh());
            }
        }
    }

    @Override
    public IStatus validate() {
        this.resetControlDecorators();
        this.resetTabImages();
        IStatus reqStatus = this.validateRequestValues();
        IStatus respStatus = this.validateResponseValues();
        XSwt.updateTabImageFromStatus((CTabItem)this.requestCTabItem, (IStatus)reqStatus);
        XSwt.updateTabImageFromStatus((CTabItem)this.responseCTabItem, (IStatus)respStatus);
        return this.updateStatus(reqStatus, respStatus);
    }

    private String getHighValueStr(int byteSize) {
        Object retVal = "";
        int i = 0;
        while (i < byteSize) {
            retVal = (String)retVal + "FF";
            ++i;
        }
        return retVal;
    }

    private String getLowValueStr(int byteSize) {
        Object retVal = "";
        int i = 0;
        while (i < byteSize) {
            retVal = (String)retVal + "00";
            ++i;
        }
        return retVal;
    }

    private IStatus validateRequestTrueFalseEquivalence() {
        IStatus status = Status.OK_STATUS;
        String msg = null;
        OverrideValueType reqTrueValType = this.getRequestTrueValueType();
        OverrideValueType reqFalseValType = this.getRequestFalseValueType();
        if (OverrideValueType.HIGH_VALUES.equals((Object)reqTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)reqFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)reqTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)reqFalseValType)) {
            msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_WARNING");
            status = new Status(2, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showWarningFieldDecoration((ControlDecoration)this.cd_booleanTrueReqValueTypeCombo, (String)msg);
            XSwt.showWarningFieldDecoration((ControlDecoration)this.cd_booleanFalseReqValueTypeCombo, (String)msg);
        } else if (OverrideValueType.HIGH_VALUES.equals((Object)reqTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)reqFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)reqTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)reqFalseValType)) {
            SingleValueComposite singleValComp = (SingleValueComposite)this.requestFalseValueTypeComp;
            if (singleValComp.isHex()) {
                String trueValue = OverrideValueType.HIGH_VALUES.equals((Object)reqTrueValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(singleValComp.getValue(), singleValComp.getValue(), trueValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_WARNING");
                    status = new Status(2, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showWarningFieldDecoration((ControlDecoration)this.cd_booleanTrueReqValueTypeCombo, (String)msg);
                    XSwt.showWarningFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                }
            }
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)reqTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)reqFalseValType) || OverrideValueType.SINGLE_VALUE.equals((Object)reqTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)reqFalseValType)) {
            SingleValueComposite singleValComp = (SingleValueComposite)this.requestTrueValueTypeComp;
            if (singleValComp.isHex()) {
                String falseValue = OverrideValueType.HIGH_VALUES.equals((Object)reqFalseValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(singleValComp.getValue(), singleValComp.getValue(), falseValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_WARNING");
                    status = new Status(2, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showWarningFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                    XSwt.showWarningFieldDecoration((ControlDecoration)this.cd_booleanFalseReqValueTypeCombo, (String)msg);
                }
            }
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)reqTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)reqFalseValType)) {
            SingleValueComposite trueValComp = (SingleValueComposite)this.requestTrueValueTypeComp;
            SingleValueComposite falseValComp = (SingleValueComposite)this.requestFalseValueTypeComp;
            if ((trueValComp.isHex() && falseValComp.isHex() || !trueValComp.isHex() && !falseValComp.isHex()) && this.testInRange(trueValComp.getValue(), trueValComp.getValue(), falseValComp.getValue())) {
                msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_WARNING");
                status = new Status(2, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showWarningFieldDecoration((ControlDecoration)trueValComp.getCdValueText(), (String)msg);
                XSwt.showWarningFieldDecoration((ControlDecoration)falseValComp.getCdValueText(), (String)msg);
            }
        }
        return status;
    }

    private IStatus validateResponseTrueFalseEquivalence() {
        IStatus status = Status.OK_STATUS;
        String msg = null;
        OverrideValueType respTrueValType = this.getResponseTrueValueType();
        OverrideValueType respFalseValType = this.getResponseFalseValueType();
        if (OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)respTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)respFalseValType)) {
            msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanTrueRespValueTypeCombo, (String)msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanFalseRespValueTypeCombo, (String)msg);
        } else if (OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)respTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType)) {
            SingleValueComposite singleValComp = (SingleValueComposite)this.responseFalseValueTypeComp;
            if (singleValComp.isHex()) {
                String trueValue = OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(singleValComp.getValue(), singleValComp.getValue(), trueValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanTrueRespValueTypeCombo, (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                }
            }
        } else if (OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) && OverrideValueType.RANGE.equals((Object)respFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)respTrueValType) && OverrideValueType.RANGE.equals((Object)respFalseValType)) {
            RangeComposite rangeComp = (RangeComposite)this.responseFalseValueTypeComp;
            if (rangeComp.isHex()) {
                String trueValue = OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(rangeComp.getLowValue(), rangeComp.getHighValue(), trueValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanTrueRespValueTypeCombo, (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                }
            }
        } else if (OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) && OverrideValueType.MULT_VALUES.equals((Object)respFalseValType) || OverrideValueType.LOW_VALUES.equals((Object)respTrueValType) && OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
            String trueValue;
            MultValuesComposite multValComp = (MultValuesComposite)this.responseFalseValueTypeComp;
            if (multValComp.isHex() && this.isMultValsEquivalent(trueValue = OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize()), trueValue, multValComp)) {
                msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanTrueRespValueTypeCombo, (String)msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
            }
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) || OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)respFalseValType)) {
            SingleValueComposite singleValComp = (SingleValueComposite)this.responseTrueValueTypeComp;
            if (singleValComp.isHex()) {
                String falseValue = OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(singleValComp.getValue(), singleValComp.getValue(), falseValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanFalseRespValueTypeCombo, (String)msg);
                }
            }
        } else if (OverrideValueType.RANGE.equals((Object)respTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) || OverrideValueType.RANGE.equals((Object)respTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)respFalseValType)) {
            RangeComposite rangeComp = (RangeComposite)this.responseTrueValueTypeComp;
            if (rangeComp.isHex()) {
                String falseValue = OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize());
                if (this.testInRange(rangeComp.getLowValue(), rangeComp.getHighValue(), falseValue)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanFalseRespValueTypeCombo, (String)msg);
                }
            }
        } else if (OverrideValueType.MULT_VALUES.equals((Object)respTrueValType) && OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) || OverrideValueType.MULT_VALUES.equals((Object)respTrueValType) && OverrideValueType.LOW_VALUES.equals((Object)respFalseValType)) {
            String falseValue;
            MultValuesComposite multValComp = (MultValuesComposite)this.responseTrueValueTypeComp;
            if (multValComp.isHex() && this.isMultValsEquivalent(falseValue = OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType) ? this.getHighValueStr(this.fieldEditCtrl.getByteSize()) : this.getLowValueStr(this.fieldEditCtrl.getByteSize()), falseValue, multValComp)) {
                msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_booleanFalseRespValueTypeCombo, (String)msg);
            }
        } else if (OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType) || OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType) && OverrideValueType.RANGE.equals((Object)respFalseValType) || OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType) && OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
            SingleValueComposite singleTrueValComp = (SingleValueComposite)this.responseTrueValueTypeComp;
            if (OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType)) {
                SingleValueComposite singleFalseValComp = (SingleValueComposite)this.responseFalseValueTypeComp;
                if ((singleTrueValComp.isHex() && singleFalseValComp.isHex() || !singleTrueValComp.isHex() && !singleFalseValComp.isHex()) && this.testInRange(singleFalseValComp.getValue(), singleFalseValComp.getValue(), singleTrueValComp.getValue())) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleTrueValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleFalseValComp.getCdValueText(), (String)msg);
                }
            } else if (OverrideValueType.RANGE.equals((Object)respFalseValType)) {
                RangeComposite rangeFalseValComp = (RangeComposite)this.responseFalseValueTypeComp;
                if ((singleTrueValComp.isHex() && rangeFalseValComp.isHex() || !singleTrueValComp.isHex() && !rangeFalseValComp.isHex()) && this.testInRange(rangeFalseValComp.getLowValue(), rangeFalseValComp.getHighValue(), singleTrueValComp.getValue())) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleTrueValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdHighValText(), (String)msg);
                }
            } else if (OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
                MultValuesComposite multFalseValComp = (MultValuesComposite)this.responseFalseValueTypeComp;
                if ((singleTrueValComp.isHex() && multFalseValComp.isHex() || !singleTrueValComp.isHex() && !multFalseValComp.isHex()) && this.isMultValsEquivalent(singleTrueValComp.getValue(), singleTrueValComp.getValue(), multFalseValComp)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleTrueValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)multFalseValComp.getCdValueText(), (String)msg);
                }
            }
        } else if (OverrideValueType.RANGE.equals((Object)respTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType) || OverrideValueType.RANGE.equals((Object)respTrueValType) && OverrideValueType.RANGE.equals((Object)respFalseValType) || OverrideValueType.RANGE.equals((Object)respTrueValType) && OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
            RangeComposite rangeTrueValComp = (RangeComposite)this.responseTrueValueTypeComp;
            if (OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType)) {
                SingleValueComposite singleFalseValComp = (SingleValueComposite)this.responseFalseValueTypeComp;
                if ((rangeTrueValComp.isHex() && singleFalseValComp.isHex() || !rangeTrueValComp.isHex() && !singleFalseValComp.isHex()) && this.testInRange(rangeTrueValComp.getLowValue(), rangeTrueValComp.getHighValue(), singleFalseValComp.getValue())) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdHighValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleFalseValComp.getCdValueText(), (String)msg);
                }
            } else if (OverrideValueType.RANGE.equals((Object)respFalseValType)) {
                RangeComposite rangeFalseValComp = (RangeComposite)this.responseFalseValueTypeComp;
                if ((rangeTrueValComp.isHex() && rangeFalseValComp.isHex() || !rangeTrueValComp.isHex() && !rangeFalseValComp.isHex()) && (this.testInRange(rangeTrueValComp.getLowValue(), rangeTrueValComp.getHighValue(), rangeFalseValComp.getLowValue()) || this.testInRange(rangeTrueValComp.getLowValue(), rangeTrueValComp.getHighValue(), rangeFalseValComp.getHighValue()) || this.testInRange(rangeFalseValComp.getLowValue(), rangeFalseValComp.getHighValue(), rangeTrueValComp.getLowValue()) || this.testInRange(rangeFalseValComp.getLowValue(), rangeFalseValComp.getHighValue(), rangeTrueValComp.getHighValue()))) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdHighValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdHighValText(), (String)msg);
                }
            } else if (OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
                MultValuesComposite multFalseValComp = (MultValuesComposite)this.responseFalseValueTypeComp;
                if ((rangeTrueValComp.isHex() && multFalseValComp.isHex() || !rangeTrueValComp.isHex() && !multFalseValComp.isHex()) && this.isMultValsEquivalent(rangeTrueValComp.getLowValue(), rangeTrueValComp.getHighValue(), multFalseValComp)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeTrueValComp.getCdHighValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)multFalseValComp.getCdValueText(), (String)msg);
                }
            }
        } else if (OverrideValueType.MULT_VALUES.equals((Object)respTrueValType) && OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType) || OverrideValueType.MULT_VALUES.equals((Object)respTrueValType) && OverrideValueType.RANGE.equals((Object)respFalseValType) || OverrideValueType.MULT_VALUES.equals((Object)respTrueValType) && OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
            MultValuesComposite multTrueValComp = (MultValuesComposite)this.responseTrueValueTypeComp;
            if (OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType)) {
                SingleValueComposite singleFalseValComp = (SingleValueComposite)this.responseFalseValueTypeComp;
                if ((multTrueValComp.isHex() && singleFalseValComp.isHex() || !multTrueValComp.isHex() && !singleFalseValComp.isHex()) && this.isMultValsEquivalent(singleFalseValComp.getValue(), singleFalseValComp.getValue(), multTrueValComp)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)multTrueValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleFalseValComp.getCdValueText(), (String)msg);
                }
            } else if (OverrideValueType.RANGE.equals((Object)respFalseValType)) {
                RangeComposite rangeFalseValComp = (RangeComposite)this.responseFalseValueTypeComp;
                if ((multTrueValComp.isHex() && rangeFalseValComp.isHex() || !multTrueValComp.isHex() && !rangeFalseValComp.isHex()) && this.isMultValsEquivalent(rangeFalseValComp.getLowValue(), rangeFalseValComp.getHighValue(), multTrueValComp)) {
                    msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                    status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)multTrueValComp.getCdValueText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdLowValText(), (String)msg);
                    XSwt.showErrorFieldDecoration((ControlDecoration)rangeFalseValComp.getCdHighValText(), (String)msg);
                }
            } else if (OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
                MultValuesComposite multFalseValComp = (MultValuesComposite)this.responseFalseValueTypeComp;
                if (multTrueValComp.isHex() && multFalseValComp.isHex() || !multTrueValComp.isHex() && !multFalseValComp.isHex()) {
                    boolean hasError = false;
                    String delimiter = multFalseValComp.getDelimiterCombo().getText();
                    if (delimiter.equals("|")) {
                        delimiter = "\\|";
                    }
                    ArrayList<String> allValues = new ArrayList<String>(Arrays.asList(multFalseValComp.getValue().split(delimiter, 0)));
                    for (String currValue : allValues) {
                        if (!this.isMultValsEquivalent(currValue, currValue, multTrueValComp)) continue;
                        hasError = true;
                        break;
                    }
                    if (hasError) {
                        msg = PgmIntXlat.error((String)"EF_TRUE_FALSE_EQUIVALENT_ERROR");
                        status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                        XSwt.showErrorFieldDecoration((ControlDecoration)multTrueValComp.getCdValueText(), (String)msg);
                        XSwt.showErrorFieldDecoration((ControlDecoration)multFalseValComp.getCdValueText(), (String)msg);
                    }
                }
            }
        }
        return status;
    }

    private boolean testInRange(String lowValueInclusive, String highValueInclusive, String value) {
        if (this.fieldEditCtrl.getDataType().equals("CHAR")) {
            return BoolUtils.stringIsInRange((String)lowValueInclusive, (String)highValueInclusive, (String)value);
        }
        return BoolUtils.bigIntIsInRange((BigInteger)new BigInteger(lowValueInclusive), (BigInteger)new BigInteger(highValueInclusive), (BigInteger)new BigInteger(value));
    }

    private boolean isMultValsEquivalent(String low, String high, MultValuesComposite multValComp) {
        String delimiter = multValComp.getDelimiterCombo().getText();
        if (delimiter.equals("|")) {
            delimiter = "\\|";
        }
        ArrayList<String> allValues = new ArrayList<String>(Arrays.asList(multValComp.getValue().split(delimiter, 0)));
        for (String currValue : allValues) {
            if (!this.testInRange(low, high, currValue)) continue;
            return true;
        }
        return false;
    }

    private IStatus validateRequestValues() {
        SingleValueComposite singleValComp;
        IStatus status = Status.OK_STATUS;
        String trueFieldValue = null;
        String falseFieldValue = null;
        boolean isHex = false;
        String msg = null;
        OverrideValueType reqTrueValType = this.getRequestTrueValueType();
        OverrideValueType reqFalseValType = this.getRequestFalseValueType();
        if (OverrideValueType.SINGLE_VALUE.equals((Object)reqTrueValType)) {
            singleValComp = (SingleValueComposite)this.requestTrueValueTypeComp;
            trueFieldValue = singleValComp.getValue();
            isHex = singleValComp.isHex();
            try {
                if (trueFieldValue.isEmpty()) {
                    msg = PgmIntXlat.error((String)"EF_EMPTY_VALUE");
                    status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                } else if (this.fieldEditCtrl != null) {
                    if (isHex) {
                        this.fieldEditCtrl.validateBooleanOverrideHexValue(trueFieldValue);
                    } else {
                        this.fieldEditCtrl.validateBooleanOverrideValue(trueFieldValue);
                    }
                }
            }
            catch (InvalidValueException e) {
                msg = e.getMessage();
                status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
            }
            catch (Exception exception) {
                msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{trueFieldValue, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
            }
        }
        if (OverrideValueType.SINGLE_VALUE.equals((Object)reqFalseValType)) {
            singleValComp = (SingleValueComposite)this.requestFalseValueTypeComp;
            falseFieldValue = singleValComp.getValue();
            isHex = singleValComp.isHex();
            try {
                if (falseFieldValue.isEmpty()) {
                    msg = PgmIntXlat.error((String)"EF_EMPTY_VALUE");
                    status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                    XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                } else if (this.fieldEditCtrl != null) {
                    if (isHex) {
                        this.fieldEditCtrl.validateBooleanOverrideHexValue(falseFieldValue);
                    } else {
                        this.fieldEditCtrl.validateBooleanOverrideValue(falseFieldValue);
                    }
                }
            }
            catch (InvalidValueException e) {
                msg = e.getMessage();
                status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
            }
            catch (Exception exception) {
                msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{falseFieldValue, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                status = this.updateStatus(status, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
            }
        }
        if (status == Status.OK_STATUS && (reqTrueValType == null && reqFalseValType != null || reqTrueValType != null && reqFalseValType == null)) {
            return new Status(4, "com.ibm.zosconnect.ui.programinterface", PgmIntXlat.error((String)"EF_REQUEST_BOTH_VALUES"));
        }
        if (status == Status.OK_STATUS) {
            status = this.validateRequestTrueFalseEquivalence();
        }
        return status;
    }

    private IStatus validateResponseValues() {
        IStatus trueStatus = Status.OK_STATUS;
        IStatus falseStatus = Status.OK_STATUS;
        String fieldValue = null;
        String lowVal = null;
        String highVal = null;
        boolean isHex = false;
        String msg = null;
        int k = 0;
        while (k < 2) {
            block84: {
                OverrideValueType respValType = null;
                boolean processTrueVal = false;
                if (k == 0) {
                    respValType = this.getResponseTrueValueType();
                    processTrueVal = true;
                } else {
                    respValType = this.getResponseFalseValueType();
                    processTrueVal = false;
                }
                if (OverrideValueType.SINGLE_VALUE.equals((Object)respValType)) {
                    SingleValueComposite singleValComp = null;
                    singleValComp = processTrueVal ? (SingleValueComposite)this.responseTrueValueTypeComp : (SingleValueComposite)this.responseFalseValueTypeComp;
                    fieldValue = singleValComp.getValue();
                    isHex = singleValComp.isHex();
                    try {
                        if (fieldValue.isEmpty()) {
                            msg = PgmIntXlat.error((String)"EF_EMPTY_VALUE");
                            if (processTrueVal) {
                                trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            } else {
                                falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            }
                            XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                            break block84;
                        }
                        if (this.fieldEditCtrl == null) break block84;
                        if (isHex) {
                            this.fieldEditCtrl.validateBooleanOverrideHexValue(fieldValue);
                            break block84;
                        }
                        this.fieldEditCtrl.validateBooleanOverrideValue(fieldValue);
                    }
                    catch (InvalidValueException e) {
                        msg = e.getMessage();
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                    }
                    catch (Exception exception) {
                        msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{fieldValue, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)singleValComp.getCdValueText(), (String)msg);
                    }
                } else if (OverrideValueType.MULT_VALUES.equals((Object)respValType)) {
                    MultValuesComposite multValComp = null;
                    multValComp = processTrueVal ? (MultValuesComposite)this.responseTrueValueTypeComp : (MultValuesComposite)this.responseFalseValueTypeComp;
                    fieldValue = multValComp.getValue();
                    ArrayList<String> allValues = null;
                    String delimiter = multValComp.getDelimiterCombo().getText();
                    if (delimiter.equals("|")) {
                        delimiter = "\\|";
                    }
                    if (fieldValue.isEmpty()) {
                        msg = PgmIntXlat.error((String)"EF_EMPTY_VALUE");
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                    } else if (!BooleanPropertiesComposite.isDelimiterBalanced(fieldValue, delimiter)) {
                        msg = PgmIntXlat.error((String)"EF_ERROR_UNBALANCED_DELIMITER");
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                    } else {
                        allValues = new ArrayList<String>(Arrays.asList(fieldValue.split(delimiter, 0)));
                    }
                    if (allValues != null) {
                        HashSet<String> allValuesSet = new HashSet<String>();
                        isHex = multValComp.isHex();
                        int i = 0;
                        while (i < allValues.size()) {
                            if (allValuesSet.contains(allValues.get(i))) {
                                msg = PgmIntXlat.error((String)"EF_MULT_NONUNIQUE");
                                if (processTrueVal) {
                                    trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                } else {
                                    falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                }
                                XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                            } else {
                                allValuesSet.add(allValues.get(i));
                                try {
                                    if (this.fieldEditCtrl != null) {
                                        if (isHex) {
                                            this.fieldEditCtrl.validateBooleanOverrideHexValue(allValues.get(i));
                                        } else {
                                            this.fieldEditCtrl.validateBooleanOverrideValue(allValues.get(i));
                                        }
                                    }
                                }
                                catch (InvalidValueException e) {
                                    msg = e.getMessage();
                                    if (processTrueVal) {
                                        trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                    } else {
                                        falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                    }
                                    XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                                }
                                catch (Exception exception) {
                                    msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{allValues.get(i), this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                                    if (processTrueVal) {
                                        trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                    } else {
                                        falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                    }
                                    XSwt.showErrorFieldDecoration((ControlDecoration)multValComp.getCdValueText(), (String)msg);
                                }
                            }
                            ++i;
                        }
                    }
                } else if (OverrideValueType.RANGE.equals((Object)respValType)) {
                    boolean validateFalseRange;
                    RangeComposite rangeComp = null;
                    rangeComp = processTrueVal ? (RangeComposite)this.responseTrueValueTypeComp : (RangeComposite)this.responseFalseValueTypeComp;
                    lowVal = rangeComp.getLowValue();
                    highVal = rangeComp.getHighValue();
                    isHex = rangeComp.isHex();
                    try {
                        if (lowVal.isEmpty()) {
                            msg = PgmIntXlat.error((String)"EF_EMPTY_RANGE_VALUE");
                            if (processTrueVal) {
                                trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            } else {
                                falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            }
                            XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                        } else if (this.fieldEditCtrl != null) {
                            if (isHex) {
                                this.fieldEditCtrl.validateBooleanOverrideHexValue(lowVal);
                            } else {
                                this.fieldEditCtrl.validateBooleanOverrideValue(lowVal);
                            }
                        }
                    }
                    catch (InvalidValueException e) {
                        msg = e.getMessage();
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                    }
                    catch (Exception exception) {
                        msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{lowVal, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                    }
                    try {
                        if (highVal.isEmpty()) {
                            msg = PgmIntXlat.error((String)"EF_EMPTY_RANGE_VALUE");
                            if (processTrueVal) {
                                trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            } else {
                                falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                            }
                            XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                        } else if (this.fieldEditCtrl != null) {
                            if (isHex) {
                                this.fieldEditCtrl.validateBooleanOverrideHexValue(highVal);
                            } else {
                                this.fieldEditCtrl.validateBooleanOverrideValue(highVal);
                            }
                        }
                    }
                    catch (InvalidValueException e) {
                        msg = e.getMessage();
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                    }
                    catch (Exception exception) {
                        msg = PgmIntXlat.error((String)"TCMLE_INVALID_FIELD_VALUE", (String[])new String[]{highVal, this.fieldEditCtrl.getDataType(), this.fieldEditCtrl.getFieldName()});
                        if (processTrueVal) {
                            trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        } else {
                            falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                        }
                        XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                    }
                    boolean validateTrueRange = processTrueVal && trueStatus.isOK();
                    boolean bl = validateFalseRange = !processTrueVal && falseStatus.isOK();
                    if (validateTrueRange || validateFalseRange) {
                        boolean isCharType = false;
                        if (this.fieldEditCtrl.isDatatype(DatatypeType.CHAR)) {
                            isCharType = true;
                        }
                        if (!lowVal.isEmpty() && !highVal.isEmpty()) {
                            boolean invalidRange = false;
                            if (isCharType) {
                                int compareVal = lowVal.compareTo(highVal);
                                if (compareVal >= 0) {
                                    invalidRange = true;
                                }
                            } else if (!NumberUtilz.isValidRange((BigInteger)new BigInteger(lowVal), (BigInteger)new BigInteger(highVal))) {
                                invalidRange = true;
                            }
                            if (invalidRange) {
                                msg = PgmIntXlat.error((String)"EF_ERROR_RANGE");
                                if (processTrueVal) {
                                    trueStatus = this.updateStatus(trueStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                } else {
                                    falseStatus = this.updateStatus(falseStatus, (IStatus)new Status(4, "com.ibm.zosconnect.ui.programinterface", msg));
                                }
                                XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdLowValText(), (String)msg);
                                XSwt.showErrorFieldDecoration((ControlDecoration)rangeComp.getCdHighValText(), (String)msg);
                            }
                        }
                    }
                }
            }
            ++k;
        }
        if (!trueStatus.isOK()) {
            return trueStatus;
        }
        if (!falseStatus.isOK()) {
            return falseStatus;
        }
        return this.validateResponseTrueFalseEquivalence();
    }

    private IStatus updateStatus(IStatus oldStatus, IStatus newStatus) {
        IStatus status = null;
        status = oldStatus != null && newStatus != null && newStatus.getSeverity() > oldStatus.getSeverity() ? newStatus : oldStatus;
        return status;
    }

    @Override
    public void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_booleanTrueReqValueTypeCombo);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_booleanFalseReqValueTypeCombo);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_booleanTrueRespValueTypeCombo);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_booleanFalseRespValueTypeCombo);
        if (XSwt.isNotDisposed((Control)this.requestTrueValueTypeComp)) {
            this.requestTrueValueTypeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestFalseValueTypeComp)) {
            this.requestFalseValueTypeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseTrueValueTypeComp)) {
            this.responseTrueValueTypeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseFalseValueTypeComp)) {
            this.responseFalseValueTypeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestTrueSingleValueComp)) {
            this.requestTrueSingleValueComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestFalseSingleValueComp)) {
            this.requestFalseSingleValueComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseTrueSingleValueComp)) {
            this.responseTrueSingleValueComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseFalseSingleValueComp)) {
            this.responseFalseSingleValueComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestTrueMultValuesComp)) {
            this.requestTrueMultValuesComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestFalseMultValuesComp)) {
            this.requestFalseMultValuesComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseTrueMultValuesComp)) {
            this.responseTrueMultValuesComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseFalseMultValuesComp)) {
            this.responseFalseMultValuesComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestTrueRangeComp)) {
            this.requestTrueRangeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.requestFalseRangeComp)) {
            this.requestFalseRangeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseTrueRangeComp)) {
            this.responseTrueRangeComp.resetControlDecorators();
        }
        if (XSwt.isNotDisposed((Control)this.responseFalseRangeComp)) {
            this.responseFalseRangeComp.resetControlDecorators();
        }
    }

    private void resetTabImages() {
        XSwt.updateTabImageFromStatus((CTabItem)this.requestCTabItem, (IStatus)Status.OK_STATUS);
        XSwt.updateTabImageFromStatus((CTabItem)this.responseCTabItem, (IStatus)Status.OK_STATUS);
    }

    @Override
    public void okPressed() {
        SingleValueComposite singleValComp;
        OverrideValueType reqTrueValType = this.getRequestTrueValueType();
        OverrideValueType reqFalseValType = this.getRequestFalseValueType();
        OverrideValueType respTrueValType = this.getResponseTrueValueType();
        OverrideValueType respFalseValType = this.getResponseFalseValueType();
        BooleanOverrideType booleanOverride = new BooleanOverrideType();
        if (reqTrueValType != null && reqFalseValType != null) {
            BooleanRequest booleanReq = new BooleanRequest();
            if (OverrideValueType.SINGLE_VALUE.equals((Object)reqTrueValType)) {
                singleValComp = (SingleValueComposite)this.requestTrueValueTypeComp;
                booleanReq.setTrueValueType(OverrideValueType.SINGLE_VALUE);
                booleanReq.setTrueValueIsHex(singleValComp.isHex());
                booleanReq.setTrueValue(singleValComp.getValue());
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)reqTrueValType)) {
                booleanReq.setTrueValueType(OverrideValueType.HIGH_VALUES);
            } else if (OverrideValueType.LOW_VALUES.equals((Object)reqTrueValType)) {
                booleanReq.setTrueValueType(OverrideValueType.LOW_VALUES);
            }
            if (OverrideValueType.SINGLE_VALUE.equals((Object)reqFalseValType)) {
                singleValComp = (SingleValueComposite)this.requestFalseValueTypeComp;
                booleanReq.setFalseValueType(OverrideValueType.SINGLE_VALUE);
                booleanReq.setFalseValueIsHex(singleValComp.isHex());
                booleanReq.setFalseValue(singleValComp.getValue());
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)reqFalseValType)) {
                booleanReq.setFalseValueType(OverrideValueType.HIGH_VALUES);
            } else if (OverrideValueType.LOW_VALUES.equals((Object)reqFalseValType)) {
                booleanReq.setFalseValueType(OverrideValueType.LOW_VALUES);
            }
            booleanOverride.setBooleanRequest(booleanReq);
        }
        if (respTrueValType != null || respFalseValType != null) {
            RangeComposite rangeComp;
            String delimiter;
            String fieldValue;
            MultValuesComposite multValComp;
            BooleanResponse booleanResp = new BooleanResponse();
            if (OverrideValueType.SINGLE_VALUE.equals((Object)respTrueValType)) {
                singleValComp = (SingleValueComposite)this.responseTrueValueTypeComp;
                booleanResp.setTrueValueType(OverrideValueType.SINGLE_VALUE);
                booleanResp.setTrueValueIsHex(singleValComp.isHex());
                booleanResp.setTrueValue(new ArrayList<String>(Arrays.asList(singleValComp.getValue())));
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)respTrueValType)) {
                booleanResp.setTrueValueType(OverrideValueType.HIGH_VALUES);
            } else if (OverrideValueType.LOW_VALUES.equals((Object)respTrueValType)) {
                booleanResp.setTrueValueType(OverrideValueType.LOW_VALUES);
            } else if (OverrideValueType.MULT_VALUES.equals((Object)respTrueValType)) {
                multValComp = (MultValuesComposite)this.responseTrueValueTypeComp;
                booleanResp.setTrueValueType(OverrideValueType.MULT_VALUES);
                booleanResp.setTrueValueIsHex(multValComp.isHex());
                fieldValue = multValComp.getValue();
                delimiter = multValComp.getDelimiterCombo().getText();
                booleanResp.setTrueDelimiterChar(delimiter);
                if (delimiter.equals("|")) {
                    delimiter = "\\|";
                }
                if (!fieldValue.isEmpty()) {
                    booleanResp.setTrueValue(new ArrayList<String>(Arrays.asList(fieldValue.split(delimiter, 0))));
                } else {
                    booleanResp.setTrueValue(new ArrayList());
                }
            } else if (OverrideValueType.RANGE.equals((Object)respTrueValType)) {
                rangeComp = (RangeComposite)this.responseTrueValueTypeComp;
                booleanResp.setTrueValueType(OverrideValueType.RANGE);
                booleanResp.setTrueValueIsHex(rangeComp.isHex());
                booleanResp.setTrueValueRangeLow(rangeComp.getLowValue());
                booleanResp.setTrueValueRangeHigh(rangeComp.getHighValue());
            }
            if (OverrideValueType.SINGLE_VALUE.equals((Object)respFalseValType)) {
                singleValComp = (SingleValueComposite)this.responseFalseValueTypeComp;
                booleanResp.setFalseValueType(OverrideValueType.SINGLE_VALUE);
                booleanResp.setFalseValueIsHex(singleValComp.isHex());
                booleanResp.setFalseValue(new ArrayList<String>(Arrays.asList(singleValComp.getValue())));
            } else if (OverrideValueType.HIGH_VALUES.equals((Object)respFalseValType)) {
                booleanResp.setFalseValueType(OverrideValueType.HIGH_VALUES);
            } else if (OverrideValueType.LOW_VALUES.equals((Object)respFalseValType)) {
                booleanResp.setFalseValueType(OverrideValueType.LOW_VALUES);
            } else if (OverrideValueType.MULT_VALUES.equals((Object)respFalseValType)) {
                multValComp = (MultValuesComposite)this.responseFalseValueTypeComp;
                booleanResp.setFalseValueType(OverrideValueType.MULT_VALUES);
                booleanResp.setFalseValueIsHex(multValComp.isHex());
                fieldValue = multValComp.getValue();
                delimiter = multValComp.getDelimiterCombo().getText();
                booleanResp.setFalseDelimiterChar(delimiter);
                if (delimiter.equals("|")) {
                    delimiter = "\\|";
                }
                if (!fieldValue.isEmpty()) {
                    booleanResp.setFalseValue(new ArrayList<String>(Arrays.asList(fieldValue.split(delimiter, 0))));
                } else {
                    booleanResp.setFalseValue(new ArrayList());
                }
            } else if (OverrideValueType.RANGE.equals((Object)respFalseValType)) {
                rangeComp = (RangeComposite)this.responseFalseValueTypeComp;
                booleanResp.setFalseValueType(OverrideValueType.RANGE);
                booleanResp.setFalseValueIsHex(rangeComp.isHex());
                booleanResp.setFalseValueRangeLow(rangeComp.getLowValue());
                booleanResp.setFalseValueRangeHigh(rangeComp.getHighValue());
            }
            booleanOverride.setBooleanResponse(booleanResp);
        }
        this.fieldEditCtrl.setDatatypeOverride((DatatypeOverride)booleanOverride);
    }

    @Override
    public List<Control> getControlsToAlignVertically() {
        ArrayList<Control> controls = new ArrayList<Control>();
        controls.add((Control)this.requestTrueValueTypeCombo);
        controls.add((Control)this.requestFalseValueTypeCombo);
        controls.add((Control)this.responseTrueValueTypeCombo);
        controls.add((Control)this.responseFalseValueTypeCombo);
        if (this.requestTrueValueTypeComp != null) {
            controls.addAll(this.requestTrueValueTypeComp.getControlsToAlignVertically());
        }
        if (this.requestFalseValueTypeComp != null) {
            controls.addAll(this.requestFalseValueTypeComp.getControlsToAlignVertically());
        }
        if (this.responseTrueValueTypeComp != null) {
            controls.addAll(this.responseTrueValueTypeComp.getControlsToAlignVertically());
        }
        if (this.responseFalseValueTypeComp != null) {
            controls.addAll(this.responseFalseValueTypeComp.getControlsToAlignVertically());
        }
        return controls;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.requestTrueValueTypeCombo) {
            this.handleUpdateRequestTrueValueType();
        } else if (e.widget == this.requestFalseValueTypeCombo) {
            this.handleUpdateRequestFalseValueType();
        } else if (e.widget == this.responseTrueValueTypeCombo) {
            this.handleUpdateResponseTrueValueType();
        } else if (e.widget == this.responseFalseValueTypeCombo) {
            this.handleUpdateResponseFalseValueType();
        } else {
            SingleValueComposite singleComp = null;
            if (this.requestTrueSingleValueComp != null && e.widget == this.requestTrueSingleValueComp.getHexButton()) {
                singleComp = this.requestTrueSingleValueComp;
            } else if (this.requestFalseSingleValueComp != null && e.widget == this.requestFalseSingleValueComp.getHexButton()) {
                singleComp = this.requestFalseSingleValueComp;
            } else if (this.responseTrueSingleValueComp != null && e.widget == this.responseTrueSingleValueComp.getHexButton()) {
                singleComp = this.responseTrueSingleValueComp;
            } else if (this.responseFalseSingleValueComp != null && e.widget == this.responseFalseSingleValueComp.getHexButton()) {
                singleComp = this.responseFalseSingleValueComp;
            }
            MultValuesComposite multComp = null;
            if (this.responseTrueMultValuesComp != null && e.widget == this.responseTrueMultValuesComp.getHexButton()) {
                multComp = this.responseTrueMultValuesComp;
            } else if (this.responseFalseMultValuesComp != null && e.widget == this.responseFalseMultValuesComp.getHexButton()) {
                multComp = this.responseFalseMultValuesComp;
            }
            RangeComposite rangeComp = null;
            if (this.responseTrueRangeComp != null && e.widget == this.responseTrueRangeComp.getHexButton()) {
                rangeComp = this.responseTrueRangeComp;
            } else if (this.responseFalseRangeComp != null && e.widget == this.responseFalseRangeComp.getHexButton()) {
                rangeComp = this.responseFalseRangeComp;
            }
            if (singleComp != null) {
                if (singleComp.isHex()) {
                    Text valueText = singleComp.getValueText();
                    valueText.setText(valueText.getText().toUpperCase());
                }
            } else if (multComp != null) {
                if (multComp.isHex()) {
                    Text valueText = multComp.getValueText();
                    valueText.setText(valueText.getText().toUpperCase());
                }
            } else if (rangeComp != null && rangeComp.isHex()) {
                Text lowValueText = rangeComp.getLowValueText();
                lowValueText.setText(lowValueText.getText().toUpperCase());
                Text highValueText = rangeComp.getHighValueText();
                highValueText.setText(highValueText.getText().toUpperCase());
            }
        }
        ((EditFieldDialog)this.parentDialog).validatePage();
    }

    private OverrideValueType getRequestTrueValueType() {
        String valueTypeText = XSwt.getText((Combo)this.requestTrueValueTypeCombo);
        return BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
    }

    private OverrideValueType getRequestFalseValueType() {
        String valueTypeText = XSwt.getText((Combo)this.requestFalseValueTypeCombo);
        return BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
    }

    private OverrideValueType getResponseTrueValueType() {
        String valueTypeText = XSwt.getText((Combo)this.responseTrueValueTypeCombo);
        return BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
    }

    private OverrideValueType getResponseFalseValueType() {
        String valueTypeText = XSwt.getText((Combo)this.responseFalseValueTypeCombo);
        return BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
    }

    private void handleUpdateRequestTrueValueType() {
        String valueTypeText = XSwt.getText((Combo)this.requestTrueValueTypeCombo);
        OverrideValueType valueType = BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
        this.requestTrueValueTypeComp = null;
        if (OverrideValueType.SINGLE_VALUE.equals((Object)valueType)) {
            if (this.requestTrueSingleValueComp == null) {
                this.requestTrueSingleValueComp = new SingleValueComposite(this.requestTabContents, 0, this.fieldEditCtrl);
                this.requestTrueSingleValueComp.moveBelow((Control)this.requestTrueValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.requestTrueSingleValueComp});
            this.requestTrueValueTypeComp = this.requestTrueSingleValueComp;
            XSwt.setTooltipText((Control)this.requestTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.requestTrueSingleValueComp.getValueText(), (String)PgmIntXlat.label((String)"EF_TRUE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.requestTrueSingleValueComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
        } else {
            if (OverrideValueType.HIGH_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.requestTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_HIGH_VALUE_TOOLTIP"));
            } else if (OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.requestTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_LOW_VALUE_TOOLTIP"));
            } else {
                XSwt.setTooltipText((Control)this.requestTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP"));
            }
            if (this.cd_booleanTrueReqValueTypeCombo == null) {
                this.cd_booleanTrueReqValueTypeCombo = new ControlDecoration((Control)this.requestTrueValueTypeCombo, 17408);
            }
            XSwt.exclude((Control[])new Control[]{this.requestTrueSingleValueComp});
        }
        XSwt.layout((Composite)this.requestTabContents, (boolean)true);
        this.parentDialog.alignControlsVertically();
        ((EditFieldDialog)this.parentDialog).validatePage();
    }

    private void handleUpdateRequestFalseValueType() {
        String valueTypeText = XSwt.getText((Combo)this.requestFalseValueTypeCombo);
        OverrideValueType valueType = BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
        this.requestFalseValueTypeComp = null;
        if (OverrideValueType.SINGLE_VALUE.equals((Object)valueType)) {
            if (this.requestFalseSingleValueComp == null) {
                this.requestFalseSingleValueComp = new SingleValueComposite(this.requestTabContents, 0, this.fieldEditCtrl);
                this.requestFalseSingleValueComp.moveBelow((Control)this.requestFalseValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.requestFalseSingleValueComp});
            this.requestFalseValueTypeComp = this.requestFalseSingleValueComp;
            XSwt.setTooltipText((Control)this.requestFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.requestFalseSingleValueComp.getValueText(), (String)PgmIntXlat.label((String)"EF_FALSE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.requestFalseSingleValueComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
        } else {
            if (OverrideValueType.HIGH_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.requestFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_HIGH_VALUE_TOOLTIP"));
            } else if (OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.requestFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_LOW_VALUE_TOOLTIP"));
            } else {
                XSwt.setTooltipText((Control)this.requestFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP"));
            }
            if (this.cd_booleanFalseReqValueTypeCombo == null) {
                this.cd_booleanFalseReqValueTypeCombo = new ControlDecoration((Control)this.requestFalseValueTypeCombo, 17408);
            }
            XSwt.exclude((Control[])new Control[]{this.requestFalseSingleValueComp});
        }
        XSwt.layout((Composite)this.requestTabContents, (boolean)true);
        this.parentDialog.alignControlsVertically();
    }

    private void handleUpdateResponseTrueValueType() {
        String valueTypeText = XSwt.getText((Combo)this.responseTrueValueTypeCombo);
        OverrideValueType valueType = BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
        this.responseTrueValueTypeComp = null;
        XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP"));
        if (OverrideValueType.HIGH_VALUES.equals((Object)valueType) || OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
            if (this.cd_booleanTrueRespValueTypeCombo == null) {
                this.cd_booleanTrueRespValueTypeCombo = new ControlDecoration((Control)this.responseTrueValueTypeCombo, 17408);
            }
            if (OverrideValueType.HIGH_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_HIGH_VALUE_TOOLTIP"));
            } else if (OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_LOW_VALUE_TOOLTIP"));
            }
        }
        if (OverrideValueType.SINGLE_VALUE.equals((Object)valueType)) {
            if (this.responseTrueSingleValueComp == null) {
                this.responseTrueSingleValueComp = new SingleValueComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseTrueSingleValueComp.moveBelow((Control)this.responseTrueValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseTrueSingleValueComp});
            this.responseTrueValueTypeComp = this.responseTrueSingleValueComp;
            XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueSingleValueComp.getValueText(), (String)PgmIntXlat.label((String)"EF_TRUE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueSingleValueComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseTrueSingleValueComp});
        }
        if (OverrideValueType.MULT_VALUES.equals((Object)valueType)) {
            if (this.responseTrueMultValuesComp == null) {
                this.responseTrueMultValuesComp = new MultValuesComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseTrueMultValuesComp.moveBelow((Control)this.responseTrueValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseTrueMultValuesComp});
            this.responseTrueValueTypeComp = this.responseTrueMultValuesComp;
            XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_MULT_VALUES_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueMultValuesComp.getValueText(), (String)PgmIntXlat.label((String)"EF_TRUE_MULT_VALUES_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueMultValuesComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueMultValuesComp.getDelimiterCombo(), (String)PgmIntXlat.label((String)"EF_DELIMITER_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseTrueMultValuesComp});
        }
        if (OverrideValueType.RANGE.equals((Object)valueType)) {
            if (this.responseTrueRangeComp == null) {
                this.responseTrueRangeComp = new RangeComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseTrueRangeComp.moveBelow((Control)this.responseTrueValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseTrueRangeComp});
            this.responseTrueValueTypeComp = this.responseTrueRangeComp;
            XSwt.setTooltipText((Control)this.responseTrueValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_RANGE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueRangeComp.getLowValueText(), (String)PgmIntXlat.label((String)"EF_RANGE_LOWER_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseTrueRangeComp.getHighValueText(), (String)PgmIntXlat.label((String)"EF_RANGE_UPPER_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseTrueRangeComp});
        }
        XSwt.layout((Composite)this.responseTabContents, (boolean)true);
        this.parentDialog.alignControlsVertically();
    }

    private void handleUpdateResponseFalseValueType() {
        String valueTypeText = XSwt.getText((Combo)this.responseFalseValueTypeCombo);
        OverrideValueType valueType = BooleanOverrideTypeUtil.getTypeFromUIString((String)valueTypeText);
        this.responseFalseValueTypeComp = null;
        XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_REQUEST_EMPTY_VALUE_TOOLTIP"));
        if (OverrideValueType.HIGH_VALUES.equals((Object)valueType) || OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
            if (this.cd_booleanFalseRespValueTypeCombo == null) {
                this.cd_booleanFalseRespValueTypeCombo = new ControlDecoration((Control)this.responseFalseValueTypeCombo, 17408);
            }
            if (OverrideValueType.HIGH_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_HIGH_VALUE_TOOLTIP"));
            } else if (OverrideValueType.LOW_VALUES.equals((Object)valueType)) {
                XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_LOW_VALUE_TOOLTIP"));
            }
        }
        if (OverrideValueType.SINGLE_VALUE.equals((Object)valueType)) {
            if (this.responseFalseSingleValueComp == null) {
                this.responseFalseSingleValueComp = new SingleValueComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseFalseSingleValueComp.moveBelow((Control)this.responseFalseValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseFalseSingleValueComp});
            this.responseFalseValueTypeComp = this.responseFalseSingleValueComp;
            XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseSingleValueComp.getValueText(), (String)PgmIntXlat.label((String)"EF_FALSE_SINGLE_VALUE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseSingleValueComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseFalseSingleValueComp});
        }
        if (OverrideValueType.MULT_VALUES.equals((Object)valueType)) {
            if (this.responseFalseMultValuesComp == null) {
                this.responseFalseMultValuesComp = new MultValuesComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseFalseMultValuesComp.moveBelow((Control)this.responseFalseValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseFalseMultValuesComp});
            this.responseFalseValueTypeComp = this.responseFalseMultValuesComp;
            XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_MULT_VALUES_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseMultValuesComp.getValueText(), (String)PgmIntXlat.label((String)"EF_FALSE_MULT_VALUES_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseMultValuesComp.getHexButton(), (String)PgmIntXlat.label((String)"EF_HEX_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseMultValuesComp.getDelimiterCombo(), (String)PgmIntXlat.label((String)"EF_DELIMITER_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseFalseMultValuesComp});
        }
        if (OverrideValueType.RANGE.equals((Object)valueType)) {
            if (this.responseFalseRangeComp == null) {
                this.responseFalseRangeComp = new RangeComposite(this.responseTabContents, 0, this.fieldEditCtrl);
                this.responseFalseRangeComp.moveBelow((Control)this.responseFalseValueTypeCombo);
            }
            XSwt.include((Control[])new Control[]{this.responseFalseRangeComp});
            this.responseFalseValueTypeComp = this.responseFalseRangeComp;
            XSwt.setTooltipText((Control)this.responseFalseValueTypeCombo, (String)PgmIntXlat.label((String)"EF_RESPONSE_RANGE_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseRangeComp.getLowValueText(), (String)PgmIntXlat.label((String)"EF_RANGE_LOWER_TOOLTIP"));
            XSwt.setTooltipText((Control)this.responseFalseRangeComp.getHighValueText(), (String)PgmIntXlat.label((String)"EF_RANGE_UPPER_TOOLTIP"));
        } else {
            XSwt.exclude((Control[])new Control[]{this.responseFalseRangeComp});
        }
        XSwt.layout((Composite)this.responseTabContents, (boolean)true);
        this.parentDialog.alignControlsVertically();
    }

    public void widgetSelected(SelectionEvent event) {
        this.widgetDefaultSelected(event);
    }

    public void verifyText(VerifyEvent e) {
        e.text = Xml10Validator.removeInvalidChar((String)e.text, (boolean)false);
        SingleValueComposite singleComp = null;
        if (this.requestTrueSingleValueComp != null && e.widget == this.requestTrueSingleValueComp.getValueText()) {
            singleComp = this.requestTrueSingleValueComp;
        } else if (this.requestFalseSingleValueComp != null && e.widget == this.requestFalseSingleValueComp.getValueText()) {
            singleComp = this.requestFalseSingleValueComp;
        } else if (this.responseTrueSingleValueComp != null && e.widget == this.responseTrueSingleValueComp.getValueText()) {
            singleComp = this.responseTrueSingleValueComp;
        } else if (this.responseFalseSingleValueComp != null && e.widget == this.responseFalseSingleValueComp.getValueText()) {
            singleComp = this.responseFalseSingleValueComp;
        }
        MultValuesComposite multComp = null;
        if (this.responseTrueMultValuesComp != null && e.widget == this.responseTrueMultValuesComp.getValueText()) {
            multComp = this.responseTrueMultValuesComp;
        } else if (this.responseFalseMultValuesComp != null && e.widget == this.responseFalseMultValuesComp.getValueText()) {
            multComp = this.responseFalseMultValuesComp;
        }
        RangeComposite rangeComp = null;
        if (this.responseTrueRangeComp != null && (e.widget == this.responseTrueRangeComp.getLowValueText() || e.widget == this.responseTrueRangeComp.getHighValueText())) {
            rangeComp = this.responseTrueRangeComp;
        } else if (this.responseFalseRangeComp != null && (e.widget == this.responseFalseRangeComp.getLowValueText() || e.widget == this.responseFalseRangeComp.getHighValueText())) {
            rangeComp = this.responseFalseRangeComp;
        }
        boolean isHex = false;
        if (singleComp != null) {
            isHex = singleComp.isHex();
        } else if (multComp != null) {
            isHex = multComp.isHex();
        } else if (rangeComp != null) {
            isHex = rangeComp.isHex();
        }
        if (isHex && e.character >= 'a' && e.character <= 'z') {
            String upperCaseChar;
            e.text = upperCaseChar = e.text.toUpperCase();
        }
    }

    public void modifyText(ModifyEvent event) {
        ((EditFieldDialog)this.parentDialog).validatePage();
    }

    private static boolean isDelimiterBalanced(String str, String delimiter) {
        boolean isBalanced = true;
        if (str != null && !str.isEmpty() && delimiter != null) {
            String delimiterChar = StringUtils.remove((String)delimiter, (String)"\\");
            int delimiterCount = StringUtils.countMatches((CharSequence)str, (CharSequence)delimiterChar);
            int valueCount = 0;
            String[] stringArray = str.split(delimiter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!"".equals(value)) {
                    ++valueCount;
                }
                ++n2;
            }
            isBalanced = delimiterCount < valueCount;
        }
        return isBalanced;
    }

    private class MultValuesComposite
    extends ValueTypeComposite {
        private MultValuesComposite self;
        private FieldEditorController fieldEditCtrl;
        private Label valueLabel;
        private Label delimiterLabel;
        private Text valueText;
        private Button hexButton;
        private Combo delimiterCombo;
        private ControlDecoration cd_valueText;
        private String[] delimiterChars;

        public MultValuesComposite(Composite parent, int style, FieldEditorController fieldEditCtrl) {
            super(parent, style);
            this.delimiterChars = new String[]{",", ";", "|"};
            this.fieldEditCtrl = fieldEditCtrl;
            this.self = this;
            this.setLayout((Layout)new GridLayoutBuilder().marginHeight(0).marginWidth(0).numColumns(4).build());
            this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
            this.createContents();
        }

        private void createContents() {
            this.valueLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_VALUE")).verticalAlignment(0x1000000).build((Composite)this.self);
            this.valueText = (Text)new TextBuilder().grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).listener((VerifyListener)BooleanPropertiesComposite.this.mainBooleanComp).listener((ModifyListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(2048)).build((Composite)this.self);
            this.cd_valueText = new ControlDecoration((Control)this.valueText, 17408);
            this.delimiterLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_DELIMITER")).horizontalIndent(5).verticalAlignment(0x1000000).build((Composite)this.self);
            this.delimiterCombo = (Combo)new ComboBuilder().items(this.delimiterChars).horizontalIndent(5).verticalAlignment(0x1000000).listener((SelectionListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(8)).build((Composite)this.self);
            this.delimiterCombo.select(0);
            Label indentLabel = new LabelBuilder().build((Composite)this.self);
            this.hexButton = (Button)new ButtonBuilder().text(PgmIntXlat.label((String)"ODT_HEX")).verticalAlignment(0x1000000).style(Integer.valueOf(32)).listener((SelectionListener)BooleanPropertiesComposite.this.mainBooleanComp).build((Composite)this.self);
            if (!BooleanPropertiesComposite.this.useHex) {
                XSwt.exclude((Control[])new Control[]{indentLabel, this.hexButton});
            }
        }

        @Override
        public void resetControlDecorators() {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_valueText);
        }

        @Override
        public List<Control> getControlsToAlignVertically() {
            ArrayList<Control> controls = new ArrayList<Control>();
            controls.add((Control)this.valueText);
            controls.add((Control)this.hexButton);
            return controls;
        }

        @Override
        public IStatus validate() {
            return Status.OK_STATUS;
        }

        @Override
        public void okPressed() {
        }

        public String getValue() {
            return XSwt.getText((Text)this.valueText);
        }

        public boolean isHex() {
            return this.hexButton.getSelection();
        }

        public Button getHexButton() {
            return this.hexButton;
        }

        public Text getValueText() {
            return this.valueText;
        }

        public Combo getDelimiterCombo() {
            return this.delimiterCombo;
        }

        public void setDelimiter(String delimiter) {
            this.delimiterCombo.setText(delimiter);
        }

        public ControlDecoration getCdValueText() {
            return this.cd_valueText;
        }
    }

    private class RangeComposite
    extends ValueTypeComposite {
        private RangeComposite self;
        private FieldEditorController fieldEditCtrl;
        private Label rangeLabel;
        private Text lowValText;
        private Text highValText;
        private Button hexButton;
        private ControlDecoration cd_lowValText;
        private ControlDecoration cd_highValText;
        private ControlDecoration cd_rangeHint;
        private String rangeHint;

        public RangeComposite(Composite parent, int style, FieldEditorController fieldEditCtrl) {
            super(parent, style);
            this.fieldEditCtrl = fieldEditCtrl;
            this.self = this;
            this.setLayout((Layout)new GridLayoutBuilder().horizontalSpacing(0).marginHeight(0).marginWidth(0).numColumns(4).build());
            this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
            this.rangeHint = fieldEditCtrl.isDatatype(DatatypeType.CHAR) ? PgmIntXlat.description((String)"EF_RANGE_INCL_LEXICAL", (String[])new String[]{fieldEditCtrl.getDataType()}) : PgmIntXlat.description((String)"EF_RANGE_INCL_NUMERICAL", (String[])new String[]{fieldEditCtrl.getDataType()});
            this.createContents();
        }

        private void createContents() {
            this.rangeLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_RANGE")).verticalAlignment(0x1000000).build((Composite)this.self);
            this.lowValText = (Text)new TextBuilder().grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(23 * XSwt.getAverageCharWidth((Control)this.self)).listener((VerifyListener)BooleanPropertiesComposite.this.mainBooleanComp).listener((ModifyListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(2048)).build((Composite)this.self);
            this.cd_lowValText = new ControlDecoration((Control)this.lowValText, 17408);
            new LabelBuilder().text("-").horizontalIndent(5 + MaxFieldDecorationWidth).verticalAlignment(0x1000000).build((Composite)this.self);
            this.highValText = (Text)new TextBuilder().grabExcessHorizontalSpace(true).horizontalIndent(5 + MaxFieldDecorationWidth).verticalAlignment(0x1000000).widthHint(23 * XSwt.getAverageCharWidth((Control)this.self)).listener((VerifyListener)BooleanPropertiesComposite.this.mainBooleanComp).listener((ModifyListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(2048)).build((Composite)this.self);
            this.cd_highValText = new ControlDecoration((Control)this.highValText, 17408);
            this.cd_rangeHint = new ControlDecoration((Control)this.highValText, 131200);
            this.cd_rangeHint.setShowOnlyOnFocus(true);
            XSwt.showInfoFieldDecoration((ControlDecoration)this.cd_rangeHint, (String)this.rangeHint);
            Label indentLabel = new LabelBuilder().build((Composite)this.self);
            this.hexButton = (Button)new ButtonBuilder().text(PgmIntXlat.label((String)"ODT_HEX")).verticalAlignment(0x1000000).style(Integer.valueOf(32)).listener((SelectionListener)BooleanPropertiesComposite.this.mainBooleanComp).build((Composite)this.self);
            if (!BooleanPropertiesComposite.this.useHex) {
                XSwt.exclude((Control[])new Control[]{indentLabel, this.hexButton});
            }
        }

        @Override
        public void resetControlDecorators() {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_lowValText);
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_highValText);
        }

        @Override
        public List<Control> getControlsToAlignVertically() {
            ArrayList<Control> controls = new ArrayList<Control>();
            controls.add((Control)this.lowValText);
            controls.add((Control)this.hexButton);
            return controls;
        }

        @Override
        public IStatus validate() {
            return Status.OK_STATUS;
        }

        @Override
        public void okPressed() {
        }

        public String getLowValue() {
            return XSwt.getText((Text)this.lowValText);
        }

        public String getHighValue() {
            return XSwt.getText((Text)this.highValText);
        }

        public boolean isHex() {
            return this.hexButton.getSelection();
        }

        public Button getHexButton() {
            return this.hexButton;
        }

        public Text getLowValueText() {
            return this.lowValText;
        }

        public Text getHighValueText() {
            return this.highValText;
        }

        public ControlDecoration getCdLowValText() {
            return this.cd_lowValText;
        }

        public ControlDecoration getCdHighValText() {
            return this.cd_highValText;
        }
    }

    private class SingleValueComposite
    extends ValueTypeComposite {
        private SingleValueComposite self;
        private FieldEditorController fieldEditCtrl;
        private Label valueLabel;
        private Text valueText;
        private Button hexButton;
        private ControlDecoration cd_valueText;

        public SingleValueComposite(Composite parent, int style, FieldEditorController fieldEditCtrl) {
            super(parent, style);
            this.fieldEditCtrl = fieldEditCtrl;
            this.self = this;
            this.setLayout((Layout)new GridLayoutBuilder().horizontalSpacing(0).marginHeight(0).marginWidth(0).numColumns(2).build());
            this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
            this.createContents();
        }

        private void createContents() {
            this.valueLabel = (Label)new LabelBuilder().text(PgmIntXlat.labelWithColon((String)"ODT_VALUE")).verticalAlignment(0x1000000).build((Composite)this.self);
            this.valueText = (Text)new TextBuilder().grabExcessHorizontalSpace(true).verticalAlignment(0x1000000).widthHint(43 * XSwt.getAverageCharWidth((Control)this.self)).listener((VerifyListener)BooleanPropertiesComposite.this.mainBooleanComp).listener((ModifyListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(2048)).build((Composite)this.self);
            this.cd_valueText = new ControlDecoration((Control)this.valueText, 17408);
            Label indentLabel = new LabelBuilder().build((Composite)this.self);
            this.hexButton = (Button)new ButtonBuilder().text(PgmIntXlat.label((String)"ODT_HEX")).verticalAlignment(0x1000000).listener((SelectionListener)BooleanPropertiesComposite.this.mainBooleanComp).style(Integer.valueOf(32)).build((Composite)this.self);
            if (!BooleanPropertiesComposite.this.useHex) {
                XSwt.exclude((Control[])new Control[]{indentLabel, this.hexButton});
            }
        }

        @Override
        public void resetControlDecorators() {
            XSwt.hideFieldDecoration((ControlDecoration)this.cd_valueText);
        }

        @Override
        public List<Control> getControlsToAlignVertically() {
            ArrayList<Control> controls = new ArrayList<Control>();
            controls.add((Control)this.valueText);
            controls.add((Control)this.hexButton);
            return controls;
        }

        @Override
        public IStatus validate() {
            return Status.OK_STATUS;
        }

        @Override
        public void okPressed() {
        }

        public String getValue() {
            return XSwt.getText((Text)this.valueText);
        }

        public boolean isHex() {
            return this.hexButton.getSelection();
        }

        public Button getHexButton() {
            return this.hexButton;
        }

        public Text getValueText() {
            return this.valueText;
        }

        public ControlDecoration getCdValueText() {
            return this.cd_valueText;
        }
    }

    private abstract class ValueTypeComposite
    extends Composite
    implements IEditFieldDialogComposite {
        public ValueTypeComposite(Composite parent, int style) {
            super(parent, style);
        }
    }
}

