/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zosconnect.ui.programinterface.editdialogs;

import com.ibm.zosconnect.ui.common.logger.ZCeeUILogger;
import com.ibm.zosconnect.ui.common.util.XSwt;
import com.ibm.zosconnect.ui.common.util.swt.GridDataBuilder;
import com.ibm.zosconnect.ui.common.util.swt.GridLayoutBuilder;
import com.ibm.zosconnect.ui.common.util.swt.VerifyListener2;
import com.ibm.zosconnect.ui.common.util.xml.Xml10Validator;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.CandidateArrayCountersVisitor;
import com.ibm.zosconnect.ui.programinterface.controllers.editor.FieldEditorController;
import com.ibm.zosconnect.ui.programinterface.controllers.model.FieldModel;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialog;
import com.ibm.zosconnect.ui.programinterface.editdialogs.AbstractEditFieldDialogComposite;
import com.ibm.zosconnect.ui.programinterface.resources.utilities.PgmIntXlat;
import com.ibm.zosconnect.wv.metadata.transaction.FieldType;
import com.ibm.zosconnect.wv.transaction.messages.walkers.IMessageVisitor;
import com.ibm.zosconnect.wv.transaction.messages.walkers.JSONConversionUtil;
import com.ibm.zosconnect.wv.transaction.messages.walkers.MessageWalker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ArrayPropertiesComposite
extends AbstractEditFieldDialogComposite {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-CEE (C) Copyright IBM Corp. 2015, 2023. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MaxFieldDecorationWidth = XSwt.getMaxFieldDecorationWidth();
    private AbstractEditFieldDialog parentDialog;
    private Composite parentComposite;
    private Combo countedByCombo;
    private Composite self = this;
    private Composite arrayGroupContents;
    private ControlDecoration cd_countedBy;
    private ControlDecoration cd_textMinItems;
    private Group arrayGroup;
    private Label labelCountedBy;
    private Label labelMinItems;
    private Text textMinItems;
    private FieldModel fieldNode;
    private FieldEditorController fieldEditCtrl;
    private CandidateArrayCountersVisitor counterVisitor;

    public ArrayPropertiesComposite(AbstractEditFieldDialog parentDialog, Composite parentComposite, FieldModel fieldNode, FieldEditorController fieldEditCtrl) {
        super(parentComposite, 0);
        this.parentDialog = parentDialog;
        this.parentComposite = parentComposite;
        this.fieldNode = fieldNode;
        this.fieldEditCtrl = fieldEditCtrl;
        this.setLayout((Layout)new GridLayoutBuilder().horizontalSpacing(0).marginWidth(0).numColumns(2).build());
        this.setLayoutData(new GridDataBuilder().grabExcessHorizontalSpace(true).horizontalSpan(2).build());
        this.createContents();
    }

    private void createContents() {
        FieldType selectedArrayField = this.fieldNode.getField();
        FieldType selectedDataStructureField = this.fieldNode.getDataStructureNode().getField();
        this.counterVisitor = new CandidateArrayCountersVisitor(selectedArrayField);
        try {
            new MessageWalker().accept((IMessageVisitor)this.counterVisitor, selectedDataStructureField);
            if (ZCeeUILogger.isLoggable((Level)Level.FINEST)) {
                for (Map.Entry errors : this.counterVisitor.getErrorMessages().entrySet()) {
                    for (String error : (List)errors.getValue()) {
                        ZCeeUILogger.info((String)error, (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            ZCeeUILogger.error((Throwable)e);
        }
        this.arrayGroup = new Group(this.self, 0);
        GridLayout gl_grpArrayContents = new GridLayout(2, false);
        this.arrayGroup.setText(PgmIntXlat.label((String)"EAP_ARRAY_PROPERTIES"));
        this.arrayGroup.setToolTipText(PgmIntXlat.description((String)"EAP_ARRAY_PROPERTIES_DESC"));
        this.arrayGroup.setLayout((Layout)gl_grpArrayContents);
        this.arrayGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.arrayGroupContents = new Composite((Composite)this.arrayGroup, 0);
        GridLayout gl_compArrayContents = new GridLayout(2, false);
        gl_compArrayContents.horizontalSpacing = 5 + MaxFieldDecorationWidth;
        gl_compArrayContents.marginTop = 5;
        gl_compArrayContents.marginBottom = 5;
        gl_compArrayContents.verticalSpacing = 10;
        this.arrayGroupContents.setLayout((Layout)gl_compArrayContents);
        this.arrayGroupContents.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.labelCountedBy = new Label(this.arrayGroupContents, 0);
        this.labelCountedBy.setText(PgmIntXlat.labelWithColon((String)"EAP_COUNTED_BY"));
        GridData gd_countedByLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelCountedBy.setLayoutData((Object)gd_countedByLabel);
        this.countedByCombo = new Combo(this.arrayGroupContents, 2048);
        GridData gd_countedByCombo = new GridData(4, 0x1000000, true, false, 1, 1);
        this.countedByCombo.setLayoutData((Object)gd_countedByCombo);
        this.countedByCombo.setToolTipText(PgmIntXlat.description((String)"EAP_COUNTED_BY_TIP"));
        this.countedByCombo.setItems(this.counterVisitor.getCandidateCounterFieldPaths(true));
        String existingCounterPath = selectedArrayField.getCounterPath();
        if (StringUtils.isNotBlank((CharSequence)existingCounterPath)) {
            this.countedByCombo.setText(existingCounterPath);
        }
        this.cd_countedBy = new ControlDecoration((Control)this.countedByCombo, 17408);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.countedByCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)new FieldProposalProvider(), null, null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setPropagateKeys(true);
        this.countedByCombo.addSelectionListener((SelectionListener)this.parentDialog);
        this.countedByCombo.addModifyListener((ModifyListener)this.parentDialog);
        XSwt.addTabTraverseListener((Control)this.countedByCombo);
        this.labelMinItems = new Label(this.arrayGroupContents, 0);
        this.labelMinItems.setText(PgmIntXlat.labelWithColon((String)"EAP_MIN_ITEMS"));
        GridData gd_labelMinItems = new GridData(4, 0x1000000, false, false, 1, 1);
        this.labelMinItems.setLayoutData((Object)gd_labelMinItems);
        this.textMinItems = new Text(this.arrayGroupContents, 2048);
        GridData gd_textMinItems = new GridData(4, 0x1000000, true, false, 1, 1);
        this.textMinItems.setLayoutData((Object)gd_textMinItems);
        this.initTextMinItemsValue(selectedArrayField);
        this.textMinItems.setToolTipText(PgmIntXlat.description((String)"EAP_MIN_ITEMS_TIP"));
        this.cd_textMinItems = new ControlDecoration((Control)this.textMinItems, 17408);
        this.textMinItems.addModifyListener((ModifyListener)this.parentDialog);
        this.textMinItems.addVerifyListener((VerifyListener)this.parentDialog);
        XSwt.addTabTraverseListener((Control)this.textMinItems);
        XSwt.addTextEnterKeyListener((Text)this.textMinItems);
        this.textMinItems.addVerifyListener((VerifyListener)new VerifyListener2((Control)this.textMinItems.getParent()){

            public void verifyText(VerifyEvent event, Control owner) throws Exception {
                event.text = Xml10Validator.removeInvalidChar((String)event.text, (boolean)false);
            }
        });
    }

    private void initTextMinItemsValue(FieldType arrayField) {
        Integer maxItems;
        Integer minItemsOrig = arrayField.getOriginalMinOccurs();
        Integer minItems = arrayField.getMinOccurs();
        if (ObjectUtils.compare((Comparable)minItems, (Comparable)(maxItems = arrayField.getMaxOccurs())) == 0 && minItemsOrig == null) {
            XSwt.setText((Text)this.textMinItems, (String)"0");
        } else {
            XSwt.setText((Text)this.textMinItems, (String)(minItems == null ? "" : minItems.toString()));
        }
    }

    @Override
    public IStatus validate() {
        Number maxOccursObj;
        FieldType odoObject;
        this.resetControlDecorators();
        IStatus status = Status.OK_STATUS;
        String msg = null;
        FieldType arrayField = this.fieldNode.getField();
        String selectedCounterPath = XSwt.getTrimText((Combo)this.countedByCombo);
        if (StringUtils.isBlank((CharSequence)selectedCounterPath)) {
            if (XSwt.isEnabled((Control)this.textMinItems)) {
                XSwt.disable((Control[])new Control[]{this.textMinItems});
                XSwt.setText((Text)this.textMinItems, (String)"");
            }
            return Status.OK_STATUS;
        }
        if (!XSwt.isEnabled((Control)this.textMinItems)) {
            XSwt.enable((Control[])new Control[]{this.textMinItems});
            this.initTextMinItemsValue(arrayField);
        }
        if (XSwt.indexOf((Combo)this.countedByCombo, (String)selectedCounterPath) == -1) {
            msg = PgmIntXlat.error((String)"EAP_COUNTER_PATH_INVALID");
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_countedBy, (String)msg);
        }
        if (!status.isOK()) {
            return status;
        }
        String minItemsText = XSwt.getTrimText((Text)this.textMinItems);
        Integer minItems = null;
        try {
            minItems = Integer.parseInt(minItemsText);
            if (minItems < 0) {
                msg = PgmIntXlat.error((String)"EAP_MINITEMS_NOT_AN_INTEGER");
                status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
                XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textMinItems, (String)msg);
            }
        }
        catch (NumberFormatException numberFormatException) {
            msg = PgmIntXlat.error((String)"EAP_MINITEMS_NOT_AN_INTEGER");
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textMinItems, (String)msg);
        }
        if (!status.isOK()) {
            return status;
        }
        Integer maxOccurs = arrayField.getMaxOccurs();
        if (maxOccurs != null && maxOccurs.equals(0) && (odoObject = this.counterVisitor.getFieldFromPath(arrayField.getDependsOnPath())) != null && (maxOccursObj = JSONConversionUtil.getMinOrMaxValue((FieldType)odoObject, (boolean)false)) instanceof Number) {
            maxOccurs = maxOccursObj.intValue();
        }
        if (minItems > maxOccurs) {
            msg = PgmIntXlat.error((String)"EAP_MINITEMS_TOO_LARGE", (Object[])new Object[]{maxOccurs});
            status = new Status(4, "com.ibm.zosconnect.ui.programinterface", msg);
            XSwt.showErrorFieldDecoration((ControlDecoration)this.cd_textMinItems, (String)msg);
        }
        return status;
    }

    @Override
    public void resetControlDecorators() {
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_countedBy);
        XSwt.hideFieldDecoration((ControlDecoration)this.cd_textMinItems);
    }

    @Override
    public void okPressed() {
        FieldType arrayField = this.fieldNode.getField();
        String origCounterPath = arrayField.getCounterPath();
        String newCounterPath = XSwt.getTrimText((Combo)this.countedByCombo);
        this.fieldEditCtrl.setOrigCounterPath(origCounterPath);
        this.fieldEditCtrl.setNewCounterPath(newCounterPath);
        this.fieldEditCtrl.setOrigCounterField(this.counterVisitor.getFieldFromPath(origCounterPath));
        this.fieldEditCtrl.setNewCounterField(this.counterVisitor.getFieldFromPath(newCounterPath));
        String minimumItems = XSwt.getTrimText((Text)this.textMinItems);
        try {
            this.fieldEditCtrl.setMinimumItems(Integer.valueOf(minimumItems));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    @Override
    public List<Control> getControlsToAlignVertically() {
        ArrayList<Control> controls = new ArrayList<Control>();
        controls.add((Control)this.countedByCombo);
        controls.add((Control)this.textMinItems);
        return controls;
    }

    private class FieldProposalProvider
    implements IContentProposalProvider {
        private FieldProposalProvider() {
        }

        public IContentProposal[] getProposals(String text, int textLen) {
            text = StringUtils.trimToEmpty((String)text);
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            if (StringUtils.isEmpty((CharSequence)text)) {
                String[] stringArray = ArrayPropertiesComposite.this.countedByCombo.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    proposals.add(new ContentProposal(item));
                    ++n2;
                }
            } else {
                String item;
                ArrayList<String> proposedItems = new ArrayList<String>();
                String[] stringArray = ArrayPropertiesComposite.this.countedByCombo.getItems();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                        proposedItems.add(item);
                    }
                    ++n3;
                }
                stringArray = ArrayPropertiesComposite.this.countedByCombo.getItems();
                n = stringArray.length;
                n3 = 0;
                while (n3 < n) {
                    item = stringArray[n3];
                    if (!proposedItems.contains(item) && StringUtils.containsIgnoreCase((CharSequence)item, (CharSequence)text)) {
                        proposals.add(new ContentProposal(item));
                    }
                    ++n3;
                }
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        }
    }
}

