/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.validation;

import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.ResourceTagRegistry;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.save.ISaveComponent;
import com.ibm.zcc.ws.rd.save.WRDSaveParticipant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagRegistry;
import org.eclipse.jst.common.internal.annotations.registry.TagAttribSpec;
import org.eclipse.jst.common.internal.annotations.registry.TagSpec;

public class TagValidator
implements ISaveComponent,
ITypeNameRequestor {
    private static TagValidator INSTANCE;
    protected IProject project;
    private static final String id = "tagvalidator";
    private boolean m_typeNameMatchFound;
    private Map m_occurs = new HashMap();
    private Map m_unique = new HashMap();
    private Map m_fileToUKey = new HashMap();

    public String getID() {
        return id;
    }

    public TagValidator() {
        if (INSTANCE != null) {
            throw new IllegalStateException(IWRDResources.getString("TagValidator.Singleton_Err"));
        }
        INSTANCE = this;
    }

    public static TagValidator getInstance() {
        if (INSTANCE == null) {
            WRDSaveParticipant participant = WRDAnnotationCore.getDefault().getSaveParticipant();
            participant.registerSaveComponent("TagValidator");
            participant.loadSaveComponentState("TagValidator");
            if (INSTANCE == null) {
                INSTANCE = new TagValidator();
            }
        }
        return INSTANCE;
    }

    public void clean() {
        this.m_fileToUKey.clear();
        this.m_unique.clear();
        this.m_occurs.clear();
    }

    public void validationBegin(IFile javaSource) {
        this.removeUniqueInfoFor(javaSource);
    }

    public void validationEnd(IFile javaSource) {
        this.m_occurs.clear();
    }

    public void fileRenamed(IFile origJavaSource) {
        this.removeUniqueInfoFor(origJavaSource);
    }

    public boolean checkForUniquenessProblems(TagData td) {
        List ukeylist = (List)this.m_fileToUKey.get(td.getSourceFile());
        boolean rv = true;
        if (ukeylist != null && !ukeylist.isEmpty()) {
            for (String mukey : ukeylist) {
                UniqueVal tdval;
                List uvals = (List)this.m_unique.get(mukey);
                if (uvals == null || uvals.size() <= 1 || (tdval = this.findFor(td, uvals)) == null) continue;
                String valmatch = tdval.val;
                Iterator uviter = uvals.iterator();
                ArrayList<UniqueVal> conflict = null;
                while (uviter.hasNext()) {
                    UniqueVal uv = (UniqueVal)uviter.next();
                    if (uv == tdval || !uv.val.equals(valmatch)) continue;
                    if (conflict == null) {
                        conflict = new ArrayList<UniqueVal>();
                    }
                    conflict.add(uv);
                }
                if (conflict == null) continue;
                this.logUProb(td, conflict);
                rv = false;
            }
        }
        return rv;
    }

    private UniqueVal findFor(TagData td, List uvals) {
        Iterator i = uvals.iterator();
        int ts = td.getTagStart();
        IFile sf = td.getSourceFile();
        while (i.hasNext()) {
            UniqueVal uv = (UniqueVal)i.next();
            if (uv.tagStart != ts || !sf.equals((Object)uv.srcFile)) continue;
            return uv;
        }
        return null;
    }

    public boolean validate(ResourceTagRegistry rtr) {
        boolean retval = true;
        IFile srcFile = rtr.getSourceFile();
        this.project = srcFile == null ? null : srcFile.getProject();
        for (FieldTagData ftd : rtr.getFields()) {
            retval &= this.validate(ftd);
        }
        for (MethodTagData mtd : rtr.getMethods()) {
            retval &= this.validate(mtd);
        }
        for (TypeTagData ttd : rtr.getTypes()) {
            retval &= this.validate(ttd);
        }
        return retval;
    }

    private boolean validate(TypeTagData tag) {
        return this.validate(tag, AnnotationTagRegistry.getTypeTag((String)tag.getName()));
    }

    private boolean validate(MethodTagData tag) {
        return this.validate(tag, AnnotationTagRegistry.getMethodTag((String)tag.getName()));
    }

    private boolean validate(FieldTagData tag) {
        return this.validate(tag, AnnotationTagRegistry.getFieldTag((String)tag.getName()));
    }

    private boolean validate(TagData td, TagSpec ts) {
        if (ts == null) {
            return true;
        }
        Iterator i = ts.getAttributes().iterator();
        boolean rv = true;
        rv = this.updateAndValidateOccurs(td, ts) && rv;
        while (i.hasNext()) {
            TagAttribSpec tas = (TagAttribSpec)i.next();
            String val = td.get(tas.getAttribName());
            if (val != null) {
                if (tas.valueIsJavaType()) {
                    this.validateJavaType(td, tas, val);
                } else if (tas.valueIsBool()) {
                    rv = this.validateBoolType(td, tas, val) && rv;
                } else {
                    String[] validValues = tas.getValidValues();
                    if (validValues != null && validValues.length > 0) {
                        rv = this.validateEnum(validValues, td, tas, val) && rv;
                    }
                }
                TagAttribSpec.Unique un = tas.getUnique();
                if (un == null) continue;
                this.updateUniqueness(td, tas, val, un);
                continue;
            }
            if (!tas.isRequired()) continue;
            rv = false;
            this.requiredError(td, tas);
        }
        rv = this.checkForUnknownAttr(td, ts) && rv;
        return rv;
    }

    private boolean validateEnum(String[] valid, TagData td, TagAttribSpec tas, String val) {
        boolean matchFound = false;
        int i = 0;
        while (i < valid.length) {
            if (valid[i].equals(val)) {
                matchFound = true;
                break;
            }
            ++i;
        }
        if (!matchFound) {
            td.addErr(IWRDResources.getResourceString("TagValidator.Bad_Enum", new Object[]{val, tas.getAttribName(), this.commaSeparate(valid)}));
        }
        return matchFound;
    }

    private String commaSeparate(String[] s) {
        StringBuffer sb = new StringBuffer(s.length * 20);
        int i = 0;
        while (i < s.length) {
            sb.append(s[i]);
            if (i < s.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    private boolean checkForUnknownAttr(TagData td, TagSpec ts) {
        HashSet<String> unks = null;
        Iterator i = td.iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (ts.attributeNamed(attrName) != null) continue;
            if (unks == null) {
                unks = new HashSet<String>();
            }
            unks.add(attrName);
        }
        if (unks != null) {
            this.unknownAttributesErr(td, unks);
            return false;
        }
        return true;
    }

    private void unknownAttributesErr(TagData td, Set unks) {
        StringBuffer sb = new StringBuffer(60 + unks.size() * 32);
        Iterator i = unks.iterator();
        sb.append(IWRDResources.getString("TagValidator.Unk_Attrib_Msg"));
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        td.addErr(sb.toString());
    }

    private String mkUniquenessKey(TagData td, TagAttribSpec tas, TagAttribSpec.Unique un) {
        int scope = un.getScope();
        switch (scope) {
            case 4: {
                FieldTagData ftd = (FieldTagData)td;
                return String.valueOf(td.getName()) + '#' + tas.getAttribName() + '#' + td.getContainingTypeName() + '#' + ftd.fieldName() + '#' + scope;
            }
            case 1: {
                return String.valueOf(td.getName()) + '#' + tas.getAttribName() + '#' + td.getSourceFile().getFullPath() + '#' + scope;
            }
            case 3: {
                MethodTagData mtd = (MethodTagData)td;
                return String.valueOf(td.getName()) + '#' + tas.getAttribName() + '#' + td.getContainingTypeName() + '#' + mtd.getSignature(false) + '#' + scope;
            }
            case 0: {
                return String.valueOf(td.getName()) + '#' + tas.getAttribName() + '#' + td.getSourceFile().getProject().getName() + '#' + scope;
            }
            case 2: {
                return String.valueOf(td.getName()) + '#' + tas.getAttribName() + '#' + td.getContainingTypeName() + '#' + scope;
            }
        }
        return "(?)";
    }

    private void updateUniqueness(TagData td, TagAttribSpec tas, String val, TagAttribSpec.Unique un) {
        String ukey = this.mkUniquenessKey(td, tas, un);
        ArrayList<UniqueVal> uval = (ArrayList<UniqueVal>)this.m_unique.get(ukey);
        if (uval == null) {
            uval = new ArrayList<UniqueVal>();
            this.m_unique.put(ukey, uval);
        }
        UniqueVal v = new UniqueVal();
        v.attribName = tas.getAttribName();
        v.srcFile = td.getSourceFile();
        v.tagName = td.getName();
        v.val = val;
        v.scope = un.getScope();
        v.tagStart = td.getTagStart();
        v.location = this.locationString(td, v.scope);
        uval.add(v);
        ArrayList<String> keylist = (ArrayList<String>)this.m_fileToUKey.get(v.srcFile);
        if (keylist == null) {
            keylist = new ArrayList<String>();
            this.m_fileToUKey.put(v.srcFile, keylist);
        }
        keylist.add(ukey);
    }

    private String stringForScope(int sc) {
        switch (sc) {
            case 4: {
                return IWRDResources.getString("TagValidator.Field_Scope");
            }
            case 1: {
                return IWRDResources.getString("TagValidator.File_Scope");
            }
            case 3: {
                return IWRDResources.getString("TagValidator.Method_Scope");
            }
            case 0: {
                return IWRDResources.getString("TagValidator.Project_Scope");
            }
            case 2: {
                return IWRDResources.getString("TagValidator.Type_Scope");
            }
        }
        return "(?)";
    }

    private String locationString(TagData td, int scope) {
        switch (scope) {
            case 4: {
                return IWRDResources.getResourceString("TagValidator.Field_Location", new Object[]{((FieldTagData)td).fieldName(), td.getContainingTypeName()});
            }
            case 1: {
                return String.valueOf(IWRDResources.getString("TagValidator.Type_Location")) + td.getContainingTypeName();
            }
            case 3: {
                return IWRDResources.getResourceString("TagValidator.Method_Location", new Object[]{((MethodTagData)td).getMethodName(), td.getContainingTypeName()});
            }
            case 0: {
                return String.valueOf(IWRDResources.getString("TagValidator.Type_Location")) + td.getContainingTypeName();
            }
            case 2: {
                return String.valueOf(IWRDResources.getString("TagValidator.Type_Location")) + td.getContainingTypeName();
            }
        }
        return "(?)";
    }

    private void logUProb(TagData td, List uvals) {
        StringBuffer sb = new StringBuffer(128);
        UniqueVal fs = (UniqueVal)uvals.get(0);
        sb.append(IWRDResources.getResourceString("TagValidator.Uniqueness_Err", new Object[]{fs.attribName, this.stringForScope(fs.scope)}));
        Iterator i = uvals.iterator();
        while (i.hasNext()) {
            UniqueVal uv = (UniqueVal)i.next();
            sb.append(uv.location);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        td.addErr(sb.toString());
    }

    private void removeUniqueInfoFor(IFile javaSource) {
        List keylist = (List)this.m_fileToUKey.get(javaSource);
        if (keylist != null && !keylist.isEmpty()) {
            Iterator i = keylist.iterator();
            while (i.hasNext()) {
                List uvlist = (List)this.m_unique.get(i.next());
                if (uvlist != null && !uvlist.isEmpty()) {
                    Iterator uvi = uvlist.iterator();
                    while (uvi.hasNext()) {
                        UniqueVal uv = (UniqueVal)uvi.next();
                        if (!uv.srcFile.equals((Object)javaSource)) continue;
                        uvi.remove();
                    }
                }
                i.remove();
            }
        }
    }

    private String mkOccursKey(TagData td) {
        return String.valueOf(td.getName()) + '#' + td.memberName();
    }

    private boolean updateAndValidateOccurs(TagData td, TagSpec ts) {
        String okey = this.mkOccursKey(td);
        IntRef ival = (IntRef)this.m_occurs.get(okey);
        if (ival == null) {
            ival = new IntRef(0);
            this.m_occurs.put(okey, ival);
        }
        ++ival.val;
        int mult = ts.getMultiplicity();
        if (mult == 1 && ival.val > 1) {
            td.addErr(IWRDResources.getResourceString("TagValidator.Multiplicity_Err", new Object[]{td.getName(), td.scopeString(), new Integer(ival.val)}));
            return false;
        }
        return true;
    }

    private void requiredError(TagData td, TagAttribSpec tas) {
        td.addErr(IWRDResources.getResourceString("TagValidator.Required_Err", new Object[]{tas.getAttribName(), td.getName()}));
    }

    private boolean validateBoolType(TagData td, TagAttribSpec tas, String val) {
        if (val == null) {
            return true;
        }
        if (!val.equalsIgnoreCase("true") && !val.equalsIgnoreCase("false")) {
            td.addErr(IWRDResources.getResourceString("TagValidator.Bool_Msg", new Object[]{tas.getAttribName()}));
            return false;
        }
        return true;
    }

    private void validateJavaType(TagData td, TagAttribSpec tas, String typeName) {
        IStatus s = JavaConventions.validateJavaTypeName((String)typeName);
        if (s.getSeverity() == 4) {
            td.addPersistentWarning(IWRDResources.getResourceString("TagValidator.Java_Valid", new Object[]{tas.getAttribName(), s.getMessage()}));
            return;
        }
        if (this.project == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        if (javaProject == null) {
            return;
        }
        try {
            boolean bl = this.m_typeNameMatchFound = javaProject.findType(typeName) != null;
            if (!this.m_typeNameMatchFound) {
                td.addPersistentWarning(IWRDResources.getResourceString("TagValidator.Java_Resolve", new Object[]{typeName, tas.getAttribName()}));
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void load(ISavedState state) {
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        this.m_typeNameMatchFound = true;
    }

    public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        this.m_typeNameMatchFound = true;
    }

    private class IntRef {
        public int val;

        public IntRef(int x) {
            this.val = x;
        }
    }

    private class UniqueVal {
        public String val;
        public String tagName;
        public String attribName;
        public IFile srcFile;
        public int scope;
        public int tagStart;
        public String location;

        private UniqueVal() {
        }
    }
}

