/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.util;

import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.annotations.util.IJavaResourceHolder;
import com.ibm.zcc.ws.rd.utils.AnnotationUtil;
import com.ibm.zcc.ws.rd.utils.QualifiedName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavaSourceContainer
implements IJavaResourceHolder {
    String contents;
    QualifiedName cuQName;
    ICompilationUnit cu;
    IPackageFragment cuPackageFragment;
    IFolder lastRoot;
    IProject destinationProject;
    boolean needsRebuild;
    boolean hasAnnotations = true;
    IFolder destinationFolder;

    public IPath getGenerationPath() {
        return new Path("/gen/src");
    }

    public JavaSourceContainer(String fullyQualifiedName, String javaSource) throws IllegalArgumentException {
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException(IWRDResources.getString("JavaSourceContainer.Null_QN"));
        }
        if (javaSource == null) {
            throw new IllegalArgumentException(IWRDResources.getString("JavaSourceContainer.Null_Source"));
        }
        this.cuQName = new QualifiedName(fullyQualifiedName);
        this.contents = javaSource;
    }

    private ICompilationUnit getCompilationUnit(IFolder root) {
        if (this.cu == null || root.equals((Object)this.lastRoot)) {
            try {
                IPackageFragmentRoot rt = (IPackageFragmentRoot)JavaCore.create((IFolder)root);
                if (rt != null) {
                    String cuname = String.valueOf(this.cuQName.last()) + ".java";
                    this.cuPackageFragment = rt.createPackageFragment(this.cuQName.allButLastPiece(), true, null);
                    this.cu = this.cuPackageFragment.getCompilationUnit(cuname);
                    this.lastRoot = root;
                }
            }
            catch (JavaModelException e) {
                WRDAnnotationCore.log(4, IWRDResources.getString("JavaSourceContainer.Pack_Err"), e);
                return null;
            }
        }
        return this.cu;
    }

    public IProject getDestinationProject() {
        return this.destinationProject;
    }

    public IFolder getDestinationFolder() {
        return this.destinationFolder;
    }

    public IFile getDestinationFile() {
        if (this.cuQName == null) {
            return null;
        }
        IFolder folder = this.getGenSourceFolder();
        if (folder == null) {
            return null;
        }
        int pieces = this.cuQName.numPieces();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < pieces) {
            buffer.append(this.cuQName.piece(i));
            if (i + 1 < pieces) {
                buffer.append('/');
            }
            ++i;
        }
        Path path = new Path(buffer.toString());
        path = path.addFileExtension("java");
        return folder.getFile((IPath)path);
    }

    private IFolder getGenSourceFolder() {
        if (this.getDestinationFolder() != null) {
            return this.getDestinationFolder().getFolder(this.getGenerationPath());
        }
        return this.getDestinationProject().getFolder(this.getGenerationPath());
    }

    public ICompilationUnit getCompilationUnit() {
        return this.getCompilationUnit(this.getGenSourceFolder());
    }

    public boolean externalize(IFolder aDestinationFolder) throws Exception {
        return this.internExternalize(this.getCompilationUnit());
    }

    public boolean externalize() throws Exception {
        if (this.getDestinationFolder() != null) {
            AnnotationUtil.addGeneratedSourceFolder((IContainer)this.getDestinationFolder());
        } else {
            AnnotationUtil.addGeneratedSourceFolder((IContainer)this.getDestinationProject());
        }
        return this.internExternalize(this.getCompilationUnit());
    }

    protected boolean internExternalize(ICompilationUnit destIcu) throws Exception {
        if (destIcu != null) {
            if (destIcu.exists()) {
                boolean shouldCommit = destIcu.isWorkingCopy() && !destIcu.hasUnsavedChanges();
                String oldContents = destIcu.getBuffer().getContents();
                if (oldContents.equals(this.contents)) {
                    return true;
                }
                destIcu.getBuffer().setContents(this.format(this.contents));
                if (shouldCommit) {
                    destIcu.commitWorkingCopy(true, null);
                } else {
                    destIcu.save(null, true);
                }
            } else {
                this.cuPackageFragment.createCompilationUnit(destIcu.getResource().getName(), this.format(this.contents), true, null);
            }
            return true;
        }
        return false;
    }

    private String format(String aContents) {
        Document doc = new Document(aContents);
        CodeFormatter formatter = ToolFactory.createCodeFormatter(null);
        TextEdit edit = formatter.format(8, aContents, 0, aContents.length(), 0, null);
        if (edit != null) {
            try {
                edit.apply((IDocument)doc);
            }
            catch (Exception exception) {}
        }
        return doc.get();
    }

    public boolean holdsJavaSource() {
        return true;
    }

    public void setDestinationProject(IProject proj) {
        this.destinationProject = proj;
    }

    public String getParentTagSet() {
        return "<UNSET>";
    }

    public void setParentTagSet(String tagSet) {
    }

    public void setNeedsRebuild(boolean b) {
        this.needsRebuild = b;
    }

    @Override
    public boolean needsRebuild() {
        return this.needsRebuild;
    }

    public void setHasAnnotations(boolean b) {
        this.hasAnnotations = b;
    }

    @Override
    public boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public void setDestinationFolder(IFolder folder) {
        this.destinationFolder = folder;
    }
}

