/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.builder.AnnotationWrapper;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationHandlerRegistry;
import com.ibm.zcc.ws.rd.resource.javautil.WRDJavaFileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerHelper;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;
import org.eclipse.jst.common.internal.annotations.registry.TagsetDescriptor;

public class WRDAnnotationController
implements AnnotationsController {
    private static WRDAnnotationController defAC = null;
    private static HashMap processedResourceCache = new HashMap();

    public void addToCache(IResource resource) {
        long lastModified = resource.getModificationStamp();
        processedResourceCache.put(resource, new Long(lastModified));
    }

    public void addToCache(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addToCache(resources[i]);
            ++i;
        }
    }

    public void removeFromCache(IResource resource) {
        processedResourceCache.remove(resource);
    }

    public void clearProcessedResourceCache() {
        processedResourceCache.clear();
    }

    public boolean hasCachedResourceBeenModified(IResource resource) {
        Long stamp = (Long)processedResourceCache.get(resource);
        if (stamp == null) {
            return true;
        }
        return resource.getModificationStamp() != stamp.longValue();
    }

    public boolean isTagHandlerInstalled(String tagSetName) {
        return AnnotationHandlerRegistry.INSTANCE.isTagSetHandled(tagSetName);
    }

    public IStatus disableAnnotations(EObject modelObject) {
        IStatus rv = Status.OK_STATUS;
        ICompilationUnit icu = null;
        icu = AnnotationsControllerHelper.INSTANCE.getAnnotatedCU(modelObject);
        boolean hasWorkingCopy = false;
        if (icu != null) {
            try {
                try {
                    icu = (ICompilationUnit)icu.getWorkingCopy();
                    hasWorkingCopy = true;
                    rv = WRDJavaFileUtil.INST.disableAnnotations(icu);
                }
                catch (JavaModelException javaModelException) {}
            }
            catch (Throwable throwable) {
                if (icu != null && hasWorkingCopy) {
                    try {
                        icu.discardWorkingCopy();
                    }
                    catch (JavaModelException javaModelException) {}
                }
                throw throwable;
            }
            if (icu != null && hasWorkingCopy) {
                try {
                    icu.discardWorkingCopy();
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return rv;
    }

    public IStatus disableAnnotations(EObject modelObject, String tagSet) {
        IStatus rv;
        block15: {
            rv = Status.OK_STATUS;
            ICompilationUnit icu = AnnotationsControllerHelper.INSTANCE.getAnnotatedCU(modelObject);
            boolean hasWorkingCopy = false;
            if (icu != null) {
                try {
                    try {
                        ArrayList dependents = new ArrayList();
                        this.recordAllDependents(tagSet, dependents);
                        String[] depArr = dependents.toArray(new String[dependents.size()]);
                        icu = (ICompilationUnit)icu.getWorkingCopy();
                        hasWorkingCopy = true;
                        rv = WRDJavaFileUtil.INST.disableAnnotations(icu, tagSet, depArr);
                    }
                    catch (JavaModelException javaModelException) {
                        if (icu != null && hasWorkingCopy) {
                            try {
                                icu.discardWorkingCopy();
                            }
                            catch (JavaModelException javaModelException2) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (icu != null && hasWorkingCopy) {
                        try {
                            icu.discardWorkingCopy();
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    throw throwable;
                }
                if (icu != null && hasWorkingCopy) {
                    try {
                        icu.discardWorkingCopy();
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
        }
        return rv;
    }

    public void recordAllDependents(String tagSetName, List dependents) {
        TagsetDescriptor tsnd = AnnotationTagsetRegistry.INSTANCE.getDescriptor(tagSetName);
        if (tsnd != null) {
            dependents.add(tagSetName);
            TagsetDescriptor[] tsds = tsnd.getDirectDependents();
            int i = 0;
            while (i < tsds.length) {
                if (AnnotationHandlerRegistry.INSTANCE.shouldDisableWithParent(tsds[i].getName())) {
                    this.recordAllDependents(tsds[i].getName(), dependents);
                }
                ++i;
            }
        }
    }

    public IFile getEnabledAnnotationFile(EObject modelObject) {
        if (AnnotationsControllerHelper.INSTANCE.isAnnotated(modelObject)) {
            ICompilationUnit icu;
            String tagSet = AnnotationsControllerHelper.INSTANCE.getTagset(modelObject);
            if (tagSet == null) {
                tagSet = "*";
            }
            if ((icu = AnnotationsControllerHelper.INSTANCE.getAnnotatedCU(modelObject)) != null && WRDJavaFileUtil.INST.isAnnotationEnabled(icu, tagSet)) {
                return (IFile)icu.getResource();
            }
        }
        return null;
    }

    public IFile[] process(IResource res) throws CoreException {
        AnnotationWrapper wrap = new AnnotationWrapper(res);
        IFile[] files = wrap.execute();
        this.addToCache(res);
        return files;
    }

    public IFile[] process(IResource[] resources) throws CoreException {
        if (resources != null && resources.length > 0) {
            AnnotationWrapper wrap = new AnnotationWrapper(resources[0]);
            IFile[] files = wrap.execute(resources);
            this.addToCache(resources);
            return files;
        }
        return null;
    }

    public void initialize(IProject project) {
    }

    public void dispose() {
    }

    public static synchronized WRDAnnotationController getDefault() {
        if (defAC == null) {
            defAC = new WRDAnnotationController();
        }
        return defAC;
    }
}

