/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypeTagData
extends TagData {
    public TypeTagData(String name, Map data, TypeDeclaration td) {
        super(name, data, (BodyDeclaration)td);
        this.initFrom(this);
    }

    public TypeTagData(TagData td) {
        super(td);
        this.initFrom(this);
    }

    public TypeDeclaration getTypeDeclaration() {
        return (TypeDeclaration)this.declaration;
    }

    public String getTypeName() {
        return this.getTypeNameFor((ASTNode)this.getDeclaration());
    }

    public String getTypeSuperclass() {
        Name sname = this.getTypeDeclaration().getSuperclass();
        if (sname != null) {
            return TypeTagData.nameToString(sname);
        }
        return null;
    }

    public boolean typeIsA(String tyName) {
        try {
            return this.typeIsA(this.getTypeDeclaration().resolveBinding(), tyName);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean typeIsA(ITypeBinding tbnd, String tyName) {
        if (tbnd != null) {
            ITypeBinding sc = tbnd.getSuperclass();
            if (sc != null && sc.getQualifiedName().equals(tyName)) {
                return true;
            }
            ITypeBinding[] intf = tbnd.getInterfaces();
            int i = 0;
            while (i < intf.length) {
                if (intf[i].getQualifiedName().equals(tyName)) {
                    return true;
                }
                ++i;
            }
            if (this.typeIsA(sc, tyName)) {
                return true;
            }
            i = 0;
            while (i < intf.length) {
                if (this.typeIsA(intf[i], tyName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean isTypeTag() {
        return true;
    }

    @Override
    public String memberName() {
        return this.getContainingTypeName();
    }

    @Override
    public String scopeString() {
        return "type";
    }

    public String getClassName() {
        return this.getTypeName();
    }

    public String getClassPackage() {
        return this.getTypePackage();
    }

    public TypeDeclaration getTypeDecl() {
        return this.getTypeDeclaration();
    }

    public void initFrom(TypeTagData ttd) {
    }
}

