/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TagDataImplRegistry {
    public static TagDataImplRegistry INSTANCE = new TagDataImplRegistry();
    private Map m_types = new HashMap();
    private Map m_methods = new HashMap();
    private Map m_fields = new HashMap();
    private Object[] m_args = new Object[3];

    public synchronized void registerType(String tagName, AnnotationTagHandler th, Class cl) {
        this.store(this.m_types, tagName, th, new TypeConstruct(cl));
    }

    public synchronized void registerMethod(String tagName, AnnotationTagHandler th, Class cl) {
        this.store(this.m_methods, tagName, th, new MethodConstruct(cl));
    }

    public synchronized void registerField(String tagName, AnnotationTagHandler th, Class cl) {
        this.store(this.m_fields, tagName, th, new FieldConstruct(cl));
    }

    private void store(Map base, String tagName, AnnotationTagHandler th, TDConstruct con) {
        String key = tagName.toLowerCase();
        HashMap<AnnotationTagHandler, TDConstruct> thmap = (HashMap<AnnotationTagHandler, TDConstruct>)base.get(key);
        if (thmap == null) {
            thmap = new HashMap<AnnotationTagHandler, TDConstruct>();
            base.put(key, thmap);
        }
        thmap.put(th, con);
    }

    private TDConstruct getConstructFor(Map base, TagData td, AnnotationTagHandler th) {
        Map thmap = (Map)base.get(td.getName().toLowerCase());
        if (thmap != null) {
            return (TDConstruct)thmap.get(th);
        }
        return null;
    }

    private static TagData copyExtras(TagData from, TagData to) {
        to.setSourceFile(from.getSourceFile());
        to.setTagStart(from.getTagStart());
        to.setTagEnd(from.getTagEnd());
        to.shareErrorListWith(from);
        to.setJavaDoc(from.getJavaDoc());
        return to;
    }

    public synchronized TypeTagData specializeType(TypeTagData td, AnnotationTagHandler th) {
        TDConstruct cs = this.getConstructFor(this.m_types, td, th);
        if (cs != null) {
            Constructor cn = cs.getConstructor();
            if (cn != null) {
                try {
                    this.m_args[0] = td.getName();
                    this.m_args[1] = td.getData();
                    this.m_args[2] = td.getDeclaration();
                    return (TypeTagData)TagDataImplRegistry.copyExtras(td, (TagData)cn.newInstance(this.m_args));
                }
                catch (Exception e) {
                    WRDAnnotationCore.log(4, IWRDResources.getResourceString("TagDataImplRegistry.Type_Inst_Err", new Object[]{cs.m_class}), e);
                    return null;
                }
            }
            return null;
        }
        return td;
    }

    public synchronized MethodTagData specializeMethod(MethodTagData td, AnnotationTagHandler th) {
        TDConstruct cs = this.getConstructFor(this.m_methods, td, th);
        if (cs != null) {
            Constructor cn = cs.getConstructor();
            if (cn != null) {
                try {
                    this.m_args[0] = td.getName();
                    this.m_args[1] = td.getData();
                    this.m_args[2] = td.getDeclaration();
                    return (MethodTagData)TagDataImplRegistry.copyExtras(td, (TagData)cn.newInstance(this.m_args));
                }
                catch (Exception e) {
                    WRDAnnotationCore.log(4, IWRDResources.getResourceString("TagDataImplRegistry.Method_Inst_Err", new Object[]{cs.m_class}), e);
                    return null;
                }
            }
            return null;
        }
        return td;
    }

    public synchronized FieldTagData specializeField(FieldTagData td, AnnotationTagHandler th) {
        TDConstruct cs = this.getConstructFor(this.m_fields, td, th);
        if (cs != null) {
            Constructor cn = cs.getConstructor();
            if (cn != null) {
                try {
                    this.m_args[0] = td.getName();
                    this.m_args[1] = td.getData();
                    this.m_args[2] = td.getDeclaration();
                    return (FieldTagData)TagDataImplRegistry.copyExtras(td, (TagData)cn.newInstance(this.m_args));
                }
                catch (Exception e) {
                    WRDAnnotationCore.log(4, IWRDResources.getResourceString("TagDataImplRegistry.Field_Inst_Err", new Object[]{cs.m_class}), e);
                    return null;
                }
            }
            return null;
        }
        return td;
    }

    private static class FieldConstruct
    extends TDConstruct {
        private static Class[] SIG = new Class[]{String.class, Map.class, FieldDeclaration.class};

        public FieldConstruct(Class c) {
            super(c);
        }

        @Override
        protected Class[] getSig() {
            return SIG;
        }
    }

    private static class MethodConstruct
    extends TDConstruct {
        private static Class[] SIG = new Class[]{String.class, Map.class, MethodDeclaration.class};

        public MethodConstruct(Class c) {
            super(c);
        }

        @Override
        protected Class[] getSig() {
            return SIG;
        }
    }

    private static abstract class TDConstruct {
        protected Class m_class;
        private Constructor m_const;

        public TDConstruct(Class c) {
            this.m_class = c;
        }

        public Constructor getConstructor() {
            if (this.m_const == null) {
                this.m_const = this.internGetConstructor();
            }
            return this.m_const;
        }

        protected Constructor internGetConstructor() {
            try {
                return this.m_class.getConstructor(this.getSig());
            }
            catch (Exception e) {
                WRDAnnotationCore.log(4, IWRDResources.getResourceString("TagDataImplRegistry.Constructor_Not_Found", new Object[]{this.m_class}), e);
                return null;
            }
        }

        protected abstract Class[] getSig();
    }

    private static class TypeConstruct
    extends TDConstruct {
        private static Class[] SIG = new Class[]{String.class, Map.class, TypeDeclaration.class};

        public TypeConstruct(Class c) {
            super(c);
        }

        @Override
        protected Class[] getSig() {
            return SIG;
        }
    }
}

