/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.validation.TagValidator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class ResourceTagRegistry {
    IFile srcFile;
    List methods;
    List fields;
    List types;

    public ResourceTagRegistry(IFile src) {
        if (src == null) {
            throw new IllegalArgumentException(IWRDResources.getString("ResourceTagRegistry.Null_Src"));
        }
        this.methods = new ArrayList();
        this.fields = new ArrayList();
        this.types = new ArrayList();
        this.srcFile = src;
    }

    public void freeDeclarations() {
        this.freeDeclarations(this.methods);
        this.freeDeclarations(this.fields);
        this.freeDeclarations(this.types);
    }

    private void freeDeclarations(List list) {
        for (TagData td : list) {
            td.freeDeclaration();
        }
    }

    public List getFields() {
        return this.fields;
    }

    public List getMethods() {
        return this.methods;
    }

    public List getTypes() {
        return this.types;
    }

    public void addMethodTag(MethodTagData mtd) {
        this.methods.add(mtd);
    }

    public void addFieldTag(FieldTagData ftd) {
        this.fields.add(ftd);
    }

    public void addTypeTag(TypeTagData ttd) {
        this.types.add(ttd);
    }

    public boolean containsTypeTag(String tagName) {
        for (TypeTagData ttd : this.types) {
            if (!ttd.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsFieldTag(String tagName) {
        for (FieldTagData ftd : this.fields) {
            if (!ftd.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMethodTag(String tagName) {
        for (MethodTagData mtd : this.methods) {
            if (!mtd.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public TypeTagData getTypeTagData(String tagName) {
        for (TypeTagData ttd : this.types) {
            if (!ttd.getName().equals(tagName)) continue;
            return ttd;
        }
        return null;
    }

    public FieldTagData getFieldTagData(String tagName) {
        for (FieldTagData ftd : this.fields) {
            if (!ftd.getName().equals(tagName)) continue;
            return ftd;
        }
        return null;
    }

    public MethodTagData getMethodTagData(String tagName) {
        for (MethodTagData mtd : this.methods) {
            if (!mtd.getName().equals(tagName)) continue;
            return mtd;
        }
        return null;
    }

    public IFile getSourceFile() {
        return this.srcFile;
    }

    private void maybeValidateAndReport(String markerId, TagData td) {
        if (td.hasMessages()) {
            td.createProblemMarkers(markerId);
            td.clearErrors();
        } else if (!td.beenValidatedOnce() && !td.isValid()) {
            td.createProblemMarkers(markerId);
            td.clearErrors();
        }
    }

    public void validateAndReportErrors(String markerId) {
        for (TagData td : this.fields) {
            TagValidator.getInstance().checkForUniquenessProblems(td);
            this.maybeValidateAndReport(markerId, td);
        }
        for (TagData td : this.methods) {
            TagValidator.getInstance().checkForUniquenessProblems(td);
            this.maybeValidateAndReport(markerId, td);
        }
        for (TagData td : this.types) {
            TagValidator.getInstance().checkForUniquenessProblems(td);
            this.maybeValidateAndReport(markerId, td);
        }
    }
}

