/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.TagData;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class MethodTagData
extends TagData {
    protected static final String GET = "get";
    protected static final String SET = "set";
    protected static final String IS = "is";

    public MethodTagData(String name, Map data, MethodDeclaration md) {
        super(name, data, (BodyDeclaration)md);
        this.initFrom(this);
    }

    public MethodTagData(TagData td) {
        super(td);
        this.initFrom(this);
    }

    public MethodDeclaration getMethodDeclaration() {
        return (MethodDeclaration)this.declaration;
    }

    @Override
    public boolean isMethodTag() {
        return true;
    }

    @Override
    public String memberName() {
        return String.valueOf(this.getContainingTypeName()) + ".M." + this.getSignature(false);
    }

    @Override
    public String scopeString() {
        return "method";
    }

    public MethodDeclaration getMethodDecl() {
        return this.getMethodDeclaration();
    }

    public String getMethodName() {
        return this.getMethodDeclaration().getName().getIdentifier();
    }

    public void initFrom(MethodTagData mtd) {
    }

    public String getReturnType() {
        return TagData.getQualifiedTypeName(this.getMethodDecl().getReturnType2());
    }

    public boolean returnsVoid() {
        return this.getReturnType().equals("void");
    }

    public static String camelCase(String n) {
        if (n == null || n.length() == 0) {
            return "";
        }
        if (Character.isUpperCase(n.charAt(0))) {
            char[] dat = n.toCharArray();
            dat[0] = Character.toLowerCase(dat[0]);
            return new String(dat);
        }
        return n;
    }

    public static String unCamelCase(String n) {
        if (n == null || n.length() == 0) {
            return "";
        }
        if (Character.isLowerCase(n.charAt(0))) {
            char[] dat = n.toCharArray();
            dat[0] = Character.toUpperCase(dat[0]);
            return new String(dat);
        }
        return n;
    }

    public FieldInf getFieldInfo() {
        String methodName = this.getMethodName();
        FieldInf rv = new FieldInf();
        if (methodName.startsWith(GET)) {
            rv.prefixMatched = GET;
        } else if (methodName.startsWith(IS)) {
            rv.prefixMatched = IS;
        } else if (methodName.startsWith(SET)) {
            rv.prefixMatched = SET;
        }
        if (rv.prefixMatched != null) {
            rv.fieldName = MethodTagData.camelCase(methodName.substring(rv.prefixMatched.length()));
        }
        if (rv.prefixMatched == GET || rv.prefixMatched == IS) {
            rv.fieldType = this.getReturnType();
        } else {
            List params = this.getMethodDecl().parameters();
            if (params.size() == 1) {
                SingleVariableDeclaration svd = (SingleVariableDeclaration)params.get(0);
                rv.fieldType = MethodTagData.getQualifiedTypeName(svd.getType());
            }
        }
        return rv;
    }

    public String getSignature(boolean includeExceptions) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.getReturnType()).append(' ').append(this.getMethodName()).append('(');
        String[] ptypes = this.getMethodParameterTypes();
        int i = 0;
        while (i < ptypes.length) {
            buf.append(ptypes[i]);
            if (i != ptypes.length - 1) {
                buf.append(',');
            }
            ++i;
        }
        buf.append(')');
        if (includeExceptions) {
            Object[] exceps = this.getThrownExceptionTypes();
            Arrays.sort(exceps);
            buf.append(' ');
            int i2 = 0;
            while (i2 < exceps.length) {
                buf.append((String)exceps[i2]);
                if (i2 != exceps.length - 1) {
                    buf.append(',');
                }
                ++i2;
            }
        }
        return buf.toString();
    }

    public static String[] getThrownExceptionTypesFor(MethodDeclaration md) {
        List exs = md.thrownExceptions();
        int nex = 0;
        String[] rv = new String[exs.size()];
        for (Name n : exs) {
            IBinding nb = n.resolveBinding();
            if (nb != null && nb.getKind() == 2) {
                ITypeBinding tb = (ITypeBinding)nb;
                rv[nex] = tb.getQualifiedName();
            } else {
                rv[nex] = MethodTagData.resolveQN((ASTNode)md, n.getFullyQualifiedName());
            }
            ++nex;
        }
        return rv;
    }

    public String[] getThrownExceptionTypes() {
        return MethodTagData.getThrownExceptionTypesFor(this.getMethodDecl());
    }

    public static String[] getMethodParameterTypesFor(MethodDeclaration md) {
        ITypeBinding[] ptypes;
        IMethodBinding mb = md.resolveBinding();
        if (mb != null && (ptypes = mb.getParameterTypes()) != null) {
            String[] rv = new String[ptypes.length];
            int i = 0;
            while (i < ptypes.length) {
                rv[i] = ptypes[i].getQualifiedName();
                ++i;
            }
            return rv;
        }
        List params = md.parameters();
        String[] rv = new String[params.size()];
        int idx = 0;
        for (SingleVariableDeclaration pvd : params) {
            Type ty = pvd.getType();
            ITypeBinding tb = ty.resolveBinding();
            rv[idx] = tb != null ? tb.getQualifiedName() : MethodTagData.getQualifiedTypeName(ty);
            ++idx;
        }
        return rv;
    }

    public String[] getMethodParameterTypes() {
        return MethodTagData.getMethodParameterTypesFor(this.getMethodDecl());
    }

    public boolean isAbstract() {
        return (this.getMethodDecl().getModifiers() & 0x400) != 0;
    }

    protected class FieldInf {
        public String prefixMatched;
        public String fieldName;
        public String fieldType;

        protected FieldInf() {
        }
    }
}

