/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;
import org.eclipse.jst.common.internal.annotations.registry.TagsetDescriptor;

public class AnnotationHandlerRegistry {
    public static final AnnotationHandlerRegistry INSTANCE = new AnnotationHandlerRegistry();
    private boolean isInitializing = false;
    private List deferredTagHandlerRegistrations;
    private Map handlerToNames = new HashMap();
    private Map handlerNameToDisableWithParent = new HashMap();
    private List allHandlers = new ArrayList();
    private Set handledSets = new HashSet();
    private Map missingParentTagSetDependents;

    static {
        INSTANCE.init();
    }

    public static String tagSetFromTagName(String name) {
        int idx = name.lastIndexOf(46);
        if (idx != -1) {
            return name.substring(0, idx);
        }
        return "";
    }

    protected AnnotationHandlerRegistry() {
    }

    public synchronized boolean init() {
        try {
            this.isInitializing = true;
            boolean result = this.doInit();
            this.processDeferredRegistrations();
            boolean bl = result;
            return bl;
        }
        finally {
            this.isInitializing = false;
        }
    }

    private void processDeferredRegistrations() {
        if (this.deferredTagHandlerRegistrations == null) {
            return;
        }
        int i = 0;
        while (i < this.deferredTagHandlerRegistrations.size()) {
            this.doRegisterTagHandler((TagHandlerRegistrationInfo)this.deferredTagHandlerRegistrations.get(i));
            ++i;
        }
    }

    private boolean doInit() {
        int i;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint xp = registry.getExtensionPoint("com.ibm.zcc.ws.rapiddeploy.annotations.core", "annotation-taghandler");
        if (xp == null) {
            return false;
        }
        HashMap tsToHand = new HashMap();
        HashMap idMap = new HashMap();
        IExtension[] x = xp.getExtensions();
        int j = 0;
        while (j < x.length) {
            IConfigurationElement[] extenders = x[j].getConfigurationElements();
            if (extenders == null || extenders.length == 0) {
                return true;
            }
            i = 0;
            while (i < extenders.length) {
                IConfigurationElement extender = extenders[i];
                this.initExtender(tsToHand, extender, idMap);
                ++i;
            }
            ++j;
        }
        String[] orderedTagsets = tsToHand.keySet().toArray(new String[tsToHand.size()]);
        TagSetComparator tsc = new TagSetComparator();
        Arrays.sort(orderedTagsets, tsc);
        i = 0;
        while (i < orderedTagsets.length) {
            String tsName = orderedTagsets[i];
            Collection handlers = AnnotationHandlerRegistry.stringToSetFetchOrCreate(tsToHand, tsName);
            Iterator itr = handlers.iterator();
            this.handledSets.add(tsName);
            while (itr.hasNext()) {
                AnnotationTagHandler ath = (AnnotationTagHandler)itr.next();
                if (!this.allHandlers.contains(ath)) {
                    this.allHandlers.add(ath);
                }
                AnnotationHandlerRegistry.objToSetFetchOrCreate(this.handlerToNames, ath).add(tsName);
            }
            ++i;
        }
        HashSet<String> soFar = new HashSet<String>();
        for (AnnotationTagHandler ath : this.allHandlers) {
            Set handled = (Set)this.handlerToNames.get(ath);
            for (String ts : handled) {
                String tsp = tsc.parentOf(ts);
                if (tsp != null && !soFar.contains(tsp)) {
                    WRDAnnotationCore.log(2, IWRDResources.getResourceString("AnnotationHandlerRegistry.Handler_Dependency_Error", new Object[]{tsp, ts, ath}), new Exception());
                }
                soFar.add(ts);
            }
        }
        return true;
    }

    private void initExtender(Map tsToHand, IConfigurationElement extender, Map idMap) {
        String extID = extender.getDeclaringExtension().getUniqueIdentifier();
        try {
            AnnotationTagHandler handler = (AnnotationTagHandler)extender.createExecutableExtension("class");
            String id = extender.getAttribute("id");
            if (id != null) {
                idMap.put(id, handler);
            }
            String parentHandlerId = extender.getAttribute("parentTagHandler");
            IConfigurationElement[] tagSpecs = extender.getChildren("tagSet");
            int k = 0;
            while (k < tagSpecs.length) {
                String tagSetName = tagSpecs[k].getAttribute("name");
                String key = tagSetName;
                ArrayList<AnnotationTagHandler> handlers = (ArrayList<AnnotationTagHandler>)tsToHand.get(key);
                if (handlers == null) {
                    handlers = new ArrayList<AnnotationTagHandler>();
                    tsToHand.put(key, handlers);
                }
                if (parentHandlerId == null) {
                    handlers.add(0, handler);
                } else {
                    Object parentHandler = idMap.get(parentHandlerId);
                    if (parentHandler == null) {
                        handlers.add(handler);
                    } else {
                        int index = handlers.indexOf(parentHandler);
                        if (index > -1) {
                            handlers.add(index + 1, handler);
                        } else {
                            handlers.add(handler);
                        }
                    }
                }
                ++k;
            }
        }
        catch (Exception ex) {
            Logger.getLogger().logError(String.valueOf(IWRDResources.getString("AnnotationHandlerRegistry.Registry_Error")) + extID);
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    protected static Collection objToSetFetchOrCreate(Map m, Object key) {
        if (m != null && key != null) {
            HashSet val = (HashSet)m.get(key);
            if (val == null) {
                val = new HashSet();
                m.put(key, val);
            }
            return val;
        }
        throw new IllegalArgumentException(IWRDResources.getResourceString("AnnotationHandlerRegistry.Null_Argument", new Object[]{key}));
    }

    protected static Collection stringToSetFetchOrCreate(Map m, String key) {
        return AnnotationHandlerRegistry.objToSetFetchOrCreate(m, key);
    }

    public synchronized Map getHandlerSets() {
        return this.handlerToNames;
    }

    public synchronized List getAllHandlers() {
        return this.allHandlers;
    }

    public boolean isTagSetHandled(String tagSetName) {
        return this.handledSets.contains(tagSetName);
    }

    public boolean shouldDisableWithParent(String tagSetName) {
        if (this.handlerNameToDisableWithParent.containsKey(tagSetName)) {
            return (Boolean)this.handlerNameToDisableWithParent.get(tagSetName);
        }
        return true;
    }

    public void registerTagHandler(AnnotationTagHandler handler, String tagSet, String parentTagSet) {
        this.registerTagHandler(handler, tagSet, parentTagSet, true);
    }

    public void registerTagHandler(AnnotationTagHandler handler, String tagSet, String parentTagSet, boolean disableWithParent) {
        if (tagSet == null || handler == null) {
            throw new IllegalArgumentException(IWRDResources.getString("AnnotationHandlerRegistry.Register_Error"));
        }
        if (this.isInitializing) {
            this.queueTagHandlerRegister(handler, tagSet, parentTagSet, disableWithParent);
        } else {
            this.doRegisterTagHandler(handler, tagSet, parentTagSet, disableWithParent);
        }
    }

    private void queueTagHandlerRegister(AnnotationTagHandler handler, String tagSet, String parentTagSet, boolean disableWithParent) {
        if (this.deferredTagHandlerRegistrations == null) {
            this.deferredTagHandlerRegistrations = new ArrayList();
        }
        this.deferredTagHandlerRegistrations.add(new TagHandlerRegistrationInfo(handler, tagSet, parentTagSet, disableWithParent));
    }

    private void doRegisterTagHandler(TagHandlerRegistrationInfo info) {
        this.doRegisterTagHandler(info.handler, info.tagSet, info.parentTagSet, info.disableWithParent);
    }

    private void doRegisterTagHandler(AnnotationTagHandler handler, String tagSet, String parentTagSet, boolean disableWithParent) {
        this.handledSets.add(tagSet);
        Collection handlerNames = AnnotationHandlerRegistry.objToSetFetchOrCreate(this.handlerToNames, handler);
        handlerNames.add(tagSet);
        this.insert(handler, tagSet, parentTagSet, disableWithParent);
        this.reorderForMissingParents();
    }

    private boolean handlesTagSet(AnnotationTagHandler handler, String tagSet) {
        Collection handlerNames = AnnotationHandlerRegistry.objToSetFetchOrCreate(this.handlerToNames, handler);
        return handlerNames.contains(tagSet);
    }

    private void insert(AnnotationTagHandler handler, String tagSet, String parentTagSet, boolean disableWithParent) {
        int oldIndex = this.allHandlers.indexOf(handler);
        if (oldIndex != -1) {
            this.allHandlers.remove(oldIndex);
        }
        int handlerInsertPosition = -1;
        if (parentTagSet != null) {
            int i = 0;
            for (AnnotationTagHandler recordedHandler : this.allHandlers) {
                if (this.handlesTagSet(recordedHandler, parentTagSet)) {
                    handlerInsertPosition = i + 1;
                    break;
                }
                ++i;
            }
            if (handlerInsertPosition == -1) {
                this.addMissingParentDependent(parentTagSet, new TagHandlerRegistrationInfo(handler, tagSet, parentTagSet, disableWithParent));
            }
        } else {
            TagsetDescriptor[] tsds;
            TagsetDescriptor tsnd = AnnotationTagsetRegistry.INSTANCE.getDescriptor(tagSet);
            if (tsnd != null && (tsds = tsnd.getDirectDependents()) != null && tsds.length > 0) {
                int lowestDependentPosition = this.allHandlers.size();
                int i = 0;
                while (i < tsds.length && lowestDependentPosition > 0) {
                    String dependentTagset = tsds[i].getName();
                    int j = 0;
                    for (AnnotationTagHandler recordedHandler : this.allHandlers) {
                        if (this.handlesTagSet(recordedHandler, dependentTagset)) {
                            lowestDependentPosition = Math.min(j, lowestDependentPosition);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (lowestDependentPosition < this.allHandlers.size()) {
                    int n = handlerInsertPosition = lowestDependentPosition == 0 ? 0 : lowestDependentPosition - 1;
                }
            }
        }
        if (handlerInsertPosition > -1 && handlerInsertPosition < this.allHandlers.size() && oldIndex < handlerInsertPosition) {
            this.allHandlers.add(handlerInsertPosition, handler);
        } else if (oldIndex != -1) {
            this.allHandlers.add(oldIndex, handler);
        } else {
            this.allHandlers.add(handler);
        }
    }

    private void addMissingParentDependent(String parentTagSet, TagHandlerRegistrationInfo info) {
        ArrayList<TagHandlerRegistrationInfo> handlers;
        if (this.missingParentTagSetDependents == null) {
            this.missingParentTagSetDependents = new HashMap();
        }
        if ((handlers = (ArrayList<TagHandlerRegistrationInfo>)this.missingParentTagSetDependents.get(parentTagSet)) == null) {
            handlers = new ArrayList<TagHandlerRegistrationInfo>();
            this.missingParentTagSetDependents.put(parentTagSet, handlers);
        }
        handlers.add(info);
    }

    private void reorderForMissingParents() {
        if (this.missingParentTagSetDependents == null || this.missingParentTagSetDependents.isEmpty()) {
            return;
        }
        Iterator it = this.missingParentTagSetDependents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!this.handledSets.contains(entry.getKey())) continue;
            List infos = (List)entry.getValue();
            int i = 0;
            while (i < infos.size()) {
                TagHandlerRegistrationInfo info = (TagHandlerRegistrationInfo)infos.get(i);
                this.insert(info.handler, info.tagSet, info.parentTagSet, info.disableWithParent);
                ++i;
            }
            it.remove();
        }
    }

    private class TagHandlerRegistrationInfo {
        AnnotationTagHandler handler;
        String tagSet;
        String parentTagSet;
        boolean disableWithParent = true;

        TagHandlerRegistrationInfo(AnnotationTagHandler handler, String tagSet, String parentTagSet, boolean disableWithParent) {
            this.handler = handler;
            this.tagSet = tagSet;
            this.parentTagSet = parentTagSet;
            this.disableWithParent = disableWithParent;
            AnnotationHandlerRegistry.this.handlerNameToDisableWithParent.put(tagSet, new Boolean(disableWithParent));
        }
    }

    private class TagSetComparator
    implements Comparator {
        Map tsToDeps = new HashMap();
        Map tsToParent = new HashMap();

        private TagSetComparator() {
        }

        private void recordAllDependents(String tagSetName, Set dependents) {
            TagsetDescriptor tsnd = AnnotationTagsetRegistry.INSTANCE.getDescriptor(tagSetName);
            if (tsnd != null) {
                dependents.add(tagSetName);
                TagsetDescriptor[] tsds = tsnd.getDirectDependents();
                int i = 0;
                while (i < tsds.length) {
                    String tsName = tsds[i].getName();
                    this.tsToParent.put(tsName, tagSetName);
                    this.recordAllDependents(tsName, dependents);
                    ++i;
                }
            }
        }

        public String parentOf(String tagSetName) {
            return (String)this.tsToParent.get(tagSetName);
        }

        public Set dependentsFor(String tagSetName) {
            String lcname = tagSetName;
            HashSet val = (HashSet)this.tsToDeps.get(lcname);
            if (val == null) {
                val = new HashSet();
                this.tsToDeps.put(lcname, val);
                this.recordAllDependents(lcname, val);
            }
            return val;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (s1.equals(s2)) {
                return 0;
            }
            Set deps = this.dependentsFor(s1);
            if (deps.contains(s2)) {
                return -1;
            }
            deps = this.dependentsFor(s2);
            if (deps.contains(s1)) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }
}

