/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.AnnotationArtifactList;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.util.IResourceErrorAccumulator;
import java.util.List;
import org.eclipse.core.resources.IFile;

public abstract class AnnotationArtifact {
    protected TagData td;
    boolean beenValidatedOnce = false;

    public AnnotationArtifact(TagData td) throws IllegalArgumentException {
        if (td == null) {
            throw new IllegalArgumentException(IWRDResources.getString("AnnotationArtifact.0"));
        }
        this.initFrom(td);
    }

    public AnnotationArtifactList createList() {
        return new AnnotationArtifactList(this.td);
    }

    public IFile getResource() {
        return this.td.getSourceFile();
    }

    public int getSourceStartPos() {
        return this.td.getTagStart();
    }

    public int getSourceEndPos() {
        return this.td.getTagEnd();
    }

    public void addErr(String msg) {
        this.td.addErr(msg);
    }

    protected boolean required(String val, String valName) {
        if (val == null || val.length() == 0) {
            this.addErr(String.valueOf(IWRDResources.getString("AnnotationArtifact.1")) + valName + IWRDResources.getString("AnnotationArtifact.2"));
            return false;
        }
        return true;
    }

    protected String pickFromChoices(String val, String[] choices) {
        int i = 0;
        while (i < choices.length) {
            String choice = choices[i];
            if (val.equalsIgnoreCase(choice)) {
                return choice;
            }
            ++i;
        }
        return null;
    }

    protected boolean validEnum(String val, String valName, String[] choices) {
        if (val == null) {
            val = "<NULL>";
        }
        if (this.pickFromChoices(val, choices) == null) {
            StringBuffer cbuf = new StringBuffer(128);
            int i = 0;
            while (i < choices.length) {
                cbuf.append(choices[i]);
                if (i != choices.length - 1) {
                    cbuf.append(", ");
                }
                ++i;
            }
            this.addErr("'" + val + IWRDResources.getString("AnnotationArtifact.6") + valName + IWRDResources.getString("AnnotationArtifact.7") + cbuf.toString());
            return false;
        }
        return true;
    }

    public boolean bool(String val, String valName) {
        if (val != null && !val.equalsIgnoreCase("true") && !val.equalsIgnoreCase("false")) {
            this.addErr("'" + valName + IWRDResources.getString("AnnotationArtifact.11"));
            return false;
        }
        return true;
    }

    public IFile getTagSourceFile() {
        return this.td.getErringResource();
    }

    public IFile getErringResource() {
        return this.td.getErringResource();
    }

    public void addErr(String msg, int start, int end) {
        this.td.addErr(msg, start, end);
    }

    public void takeErrorsFrom(IResourceErrorAccumulator a) {
        this.td.takeErrorsFrom(a);
    }

    public boolean areValid(List aas) {
        return this.td.areValid(aas);
    }

    public void clearErrors() {
        this.td.clearErrors();
    }

    public void createProblemMarkers(String markerId) {
        this.td.createProblemMarkers(markerId);
    }

    public List errorMsgs() {
        return this.td.errorMsgs();
    }

    public boolean isValid() {
        this.beenValidatedOnce = true;
        this.td.clearErrors();
        return true;
    }

    public boolean beenValidatedOnce() {
        return this.beenValidatedOnce;
    }

    public void initFrom(TagData aTd) {
        this.td = aTd;
    }

    public boolean hasErrors() {
        return this.td.hasErrors();
    }

    public TagData getTagData() {
        return this.td;
    }
}

