/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.core;

import com.ibm.zcc.ws.rd.annotations.core.AnnotationHandlerRegistry;
import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.ResourceTagRegistry;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.resource.javautil.DisabledTagSets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jst.common.internal.annotations.core.AnnotationTagParser;
import org.eclipse.jst.common.internal.annotations.core.TagParseEventHandler;
import org.eclipse.jst.common.internal.annotations.core.Token;

public class AnnotationASTVisitor
extends ASTVisitor
implements TagParseEventHandler {
    ResourceTagRegistry rtr;
    private String mTagName;
    private Map mTagData;
    private Javadoc mNode;
    private int mTagStart;
    private int mTagEnd;
    private ICompilationUnit srcCU;
    DisabledTagSets mDisabled;
    boolean ignoringCurrentTag;
    private Set tagsetsEncountered;
    private int firstTagPos;
    private String curNodeText;
    private String curNodeJavadoc;
    AnnotationTagParser parser = new AnnotationTagParser((TagParseEventHandler)this);

    public AnnotationASTVisitor(IFile sourceFile, ICompilationUnit cu, DisabledTagSets dts) {
        this.mDisabled = dts;
        this.rtr = new ResourceTagRegistry(sourceFile);
        this.srcCU = cu;
    }

    public ResourceTagRegistry getTagRegistry() {
        return this.rtr;
    }

    public boolean visit(Javadoc node) {
        this.mNode = node;
        try {
            this.firstTagPos = -1;
            this.curNodeJavadoc = null;
            this.curNodeText = this.srcCU.getBuffer().getText(node.getStartPosition(), node.getLength());
            this.parser.setParserInput(this.curNodeText);
            this.parser.parse();
        }
        catch (JavaModelException jex) {
            WRDAnnotationCore.log(2, IWRDResources.getResourceString("AnnotationASTVisitor.Comment_Parse_Problem", new Object[]{this.srcCU.getResource().getLocation()}), jex);
        }
        return true;
    }

    private Set getTSE() {
        if (this.tagsetsEncountered == null) {
            this.tagsetsEncountered = new HashSet();
        }
        return this.tagsetsEncountered;
    }

    public boolean encounteredAnnotations() {
        return this.tagsetsEncountered != null;
    }

    public Set tagsetsEncountered() {
        return this.tagsetsEncountered;
    }

    public void annotationTag(Token tag) {
        String tagName = tag.getText();
        String tagSetName = AnnotationHandlerRegistry.tagSetFromTagName(tagName);
        int absPos = this.mNode.getStartPosition() + tag.getBeginning();
        if (this.firstTagPos == -1) {
            this.firstTagPos = tag.getBeginning();
        }
        this.getTSE().add(tagSetName);
        if (this.mDisabled.isDisabled(tagSetName)) {
            this.ignoringCurrentTag = true;
        } else {
            this.ignoringCurrentTag = false;
            this.mTagEnd = this.mTagStart = absPos;
            this.mTagData = new HashMap();
            this.mTagName = tag.getText();
        }
    }

    public void attribute(Token name, int eqPos, Token value) {
        if (!this.ignoringCurrentTag && eqPos != -1) {
            this.mTagData.put(name.getText(), value.getText());
        }
    }

    private void setTagArea(TagData td) {
        td.setTagStart(this.mTagStart);
        td.setTagEnd(this.mTagEnd);
    }

    private void setJavadoc(TagData td) {
        if (this.curNodeJavadoc == null) {
            if (this.firstTagPos != -1) {
                int pos = this.firstTagPos - 1;
                while (pos > 0) {
                    char c = this.curNodeText.charAt(pos);
                    if (!Character.isWhitespace(c) && c != '*' && c != '/') break;
                    --pos;
                }
                this.curNodeJavadoc = pos < 3 ? "/** " : this.curNodeText.substring(0, pos + 1);
            } else {
                this.curNodeJavadoc = "/** ";
            }
        }
        td.setJavaDoc(this.curNodeJavadoc);
    }

    public void endOfTag(int pos) {
        if (this.ignoringCurrentTag) {
            return;
        }
        this.mTagEnd = this.mNode.getStartPosition() + pos;
        try {
            switch (this.mNode.getParent().getNodeType()) {
                case 31: {
                    MethodTagData mtd = new MethodTagData(this.mTagName, this.mTagData, (MethodDeclaration)this.mNode.getParent());
                    if (mtd != null) {
                        this.rtr.addMethodTag(mtd);
                        this.setTagArea(mtd);
                        mtd.setSourceFile(this.rtr.getSourceFile());
                        this.setJavadoc(mtd);
                    }
                    break;
                }
                case 23: {
                    FieldTagData ftd = new FieldTagData(this.mTagName, this.mTagData, (FieldDeclaration)this.mNode.getParent());
                    if (ftd != null) {
                        this.rtr.addFieldTag(ftd);
                        this.setTagArea(ftd);
                        ftd.setSourceFile(this.rtr.getSourceFile());
                        this.setJavadoc(ftd);
                    }
                    break;
                }
                case 55: {
                    TypeTagData ttd = new TypeTagData(this.mTagName, this.mTagData, (TypeDeclaration)this.mNode.getParent());
                    if (ttd == null) break;
                    this.rtr.addTypeTag(ttd);
                    this.setTagArea(ttd);
                    ttd.setSourceFile(this.rtr.getSourceFile());
                    this.setJavadoc(ttd);
                }
                default: {
                    break;
                }
            }
        }
        catch (Exception e) {
            WRDAnnotationCore.log(2, IWRDResources.getResourceString("AnnotationASTVisitor.Tag_Record_Problem", new Object[]{this.mTagName}), e);
        }
    }

    public void dispose() {
        this.rtr.freeDeclarations();
        this.rtr = null;
        this.mDisabled = null;
        this.parser = null;
        this.rtr = null;
        this.srcCU = null;
        if (this.tagsetsEncountered != null) {
            this.tagsetsEncountered.clear();
            this.tagsetsEncountered = null;
        }
    }
}

