/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.builder;

import com.ibm.zcc.ws.rd.annotations.builder.AnnotationProcessor;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class AnnotationWrapper {
    IResource res;
    AnnotationProcessor processor;
    List generatedAccum = new ArrayList();
    List statusList = new ArrayList();

    public AnnotationWrapper(IResource resource) {
        this.res = resource;
        this.processor = new AnnotationProcessor(this);
        this.processor.initForOperation(resource == null ? null : resource.getProject());
    }

    protected AnnotationWrapper(AnnotationProcessor processor) {
        this.processor = processor;
    }

    public IFile[] execute() throws CoreException {
        this.generatedAccum.clear();
        this.execute(this.res);
        this.throwExceptionOnErrors();
        return this.generatedAccum.toArray(new IFile[this.generatedAccum.size()]);
    }

    private void execute(IResource resource) throws CoreException {
        IStatus retval = Status.OK_STATUS;
        boolean didProcess = false;
        try {
            if (resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("java")) {
                didProcess = true;
                retval = this.processor.doIt(resource);
                if (!retval.isOK()) {
                    this.statusList.add(retval);
                }
            }
        }
        finally {
            if (didProcess) {
                this.processor.fireEndBuild();
            }
        }
    }

    protected void doExecute(IResource[] resources) throws CoreException {
        this.doExecute(resources, null);
    }

    public IFile[] execute(IResource[] resources) throws CoreException {
        this.generatedAccum.clear();
        this.doExecute(resources);
        this.throwExceptionOnErrors();
        return this.generatedAccum.toArray(new IFile[this.generatedAccum.size()]);
    }

    private void throwExceptionOnErrors() throws CoreException {
        if (!this.statusList.isEmpty()) {
            if (this.statusList.size() == 1) {
                throw new CoreException((IStatus)this.statusList.get(0));
            }
            throw new CoreException((IStatus)new MultiStatus("com.ibm.zcc.ws.rapiddeploy.annotations.core", 0, this.statusList.toArray(new IStatus[this.statusList.size()]), IWRDResources.getString("AnnotationWrapper.Annotation_Problem"), null));
        }
    }

    public void addGeneratedResource(IFile aFile) {
        this.generatedAccum.add(aFile);
    }

    protected void doExecute(IResource[] resources, IFile[] deletedFiles) throws CoreException {
        int i;
        IStatus retval = Status.OK_STATUS;
        if (resources != null) {
            i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("java") && !(retval = this.processor.doIt(resource)).isOK()) {
                    this.statusList.add(retval);
                }
                ++i;
            }
        }
        if (deletedFiles != null) {
            i = 0;
            while (i < deletedFiles.length) {
                this.processor.doDeletePostProcessing(deletedFiles[i]);
                ++i;
            }
        }
        this.processor.fireEndBuild();
    }
}

