/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zcc.ws.rd.annotations.builder;

import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.zcc.ws.rd.annotations.builder.AnnotationWrapper;
import com.ibm.zcc.ws.rd.annotations.core.AnnotatedFileRegistry;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationASTVisitor;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationHandlerRegistry;
import com.ibm.zcc.ws.rd.annotations.core.AnnotationTagHandler;
import com.ibm.zcc.ws.rd.annotations.core.FieldTagData;
import com.ibm.zcc.ws.rd.annotations.core.IAnnotationProcessor;
import com.ibm.zcc.ws.rd.annotations.core.IWRDResources;
import com.ibm.zcc.ws.rd.annotations.core.MethodTagData;
import com.ibm.zcc.ws.rd.annotations.core.ResourceTagRegistry;
import com.ibm.zcc.ws.rd.annotations.core.TagData;
import com.ibm.zcc.ws.rd.annotations.core.TagDataImplRegistry;
import com.ibm.zcc.ws.rd.annotations.core.TagProcessingException;
import com.ibm.zcc.ws.rd.annotations.core.TypeTagData;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationController;
import com.ibm.zcc.ws.rd.annotations.core.WRDAnnotationCore;
import com.ibm.zcc.ws.rd.annotations.util.IJavaResourceHolder;
import com.ibm.zcc.ws.rd.annotations.util.ResourceErrorAccumulator;
import com.ibm.zcc.ws.rd.annotations.validation.TagValidator;
import com.ibm.zcc.ws.rd.io.IResourceHolder;
import com.ibm.zcc.ws.rd.resource.WRDDerivedNode;
import com.ibm.zcc.ws.rd.resource.WRDResourceHelper;
import com.ibm.zcc.ws.rd.resource.WRDResourceRegistry;
import com.ibm.zcc.ws.rd.resource.WRDResourceUtil;
import com.ibm.zcc.ws.rd.resource.javautil.DisabledTagSets;
import com.ibm.zcc.ws.rd.resource.javautil.WRDJavaFileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagRegistry;

public class AnnotationProcessor
extends IncrementalProjectBuilder
implements IResourceProxyVisitor,
IResourceDeltaVisitor,
IAnnotationProcessor {
    private static final String JAVA_EXTENSION = "java";
    private static final String WAS_DEPLOY_FOLDER_NAME = "websphere_deploy";
    private static final String STUB_DOT_JAVA = "_Stub.java";
    private static final String WAS_UNDERSCORE_EJS = "_EJS";
    private static final String WAS_EJS_PREFIX = "EJS";
    Map handlerMap;
    List allHandlers;
    List tagsProcessed = new ArrayList();
    List heldResources = new ArrayList();
    IFile curSource;
    TagData curTag;
    Map filesToBeProcessed = new HashMap();
    Set filesToBeDeleted;
    AnnotationWrapper wrapper;
    boolean isBuilding;
    int depth = -1;
    boolean beginBuildFired = false;
    private Set deferredProcessing = new HashSet();
    private List deferredDeletes;
    public static final String ANNOT_PROB_MARKER = "com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationProblemMarker";
    IProject currentProject;
    public static final String BUILDER_ID = "com.ibm.zcc.ws.rapiddeploy.annotations.core.AnnotationBuilder";
    private Set ignoreThisBuild = new HashSet();
    private ASTParser jParser = ASTParser.newParser((int)3);
    private static final int ECODE_BASE = 1000;
    public static final int ECODE_BASIC_VALIDATION_FAIL = 1001;
    public static final int ECODE_COULD_NOT_PARSE = 1002;

    public AnnotationProcessor() {
    }

    public AnnotationProcessor(AnnotationWrapper wrapper) {
        this.wrapper = wrapper;
    }

    private void commonBuildInit() {
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (!WorkspaceMigrationEngine.instance().isMigratedProject(this.getProject())) {
            return null;
        }
        this.depth = -1;
        this.isBuilding = true;
        try {
            this.doBuild(this.getProject(), kind, monitor);
        }
        finally {
            this.isBuilding = false;
        }
        return null;
    }

    protected IProject[] doBuild(IProject project, int kind, IProgressMonitor monitor) throws CoreException {
        this.commonBuildInit();
        this.currentProject = project;
        this.processBuildDelta(kind);
        int depthPriorToProcessing = this.depth;
        try {
            this.processDeferredDeletes();
            this.processDeferredResources();
        }
        finally {
            if (depthPriorToProcessing != this.depth) {
                this.fireEndBuild();
            }
        }
        return null;
    }

    private void processBuildDelta(int kind) throws CoreException {
        switch (kind) {
            case 6: {
                this.currentProject.accept((IResourceProxyVisitor)this, 1);
                break;
            }
            default: {
                IResourceDelta delta = this.getDelta(this.currentProject);
                if (delta == null) {
                    this.currentProject.accept((IResourceProxyVisitor)this, 1);
                    break;
                }
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
    }

    private void processDeferredResources() {
        if (this.deferredProcessing.isEmpty()) {
            return;
        }
        try {
            for (IResource res : this.deferredProcessing) {
                this.doIt(res);
            }
        }
        finally {
            this.deferredProcessing.clear();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        this.deleteDerivedGenFiles();
        this.cleanHandlers();
        TagValidator.getInstance().clean();
    }

    private void deleteDerivedGenFiles() {
        IFolder[] genSrcFolders = this.getGeneratedSourceFolders(this.currentProject);
        int i = 0;
        while (i < genSrcFolders.length) {
            this.deleteDerivedFiles((IFolder)genSrcFolders[i].getParent(), genSrcFolders[i]);
            ++i;
        }
    }

    private void deleteDerivedFiles(IFolder folder, IFolder sourceFolder) {
        IResource[] members;
        if (folder == null || !folder.isAccessible()) {
            return;
        }
        try {
            members = folder.members();
        }
        catch (CoreException coreException) {
            return;
        }
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            switch (resource.getType()) {
                case 1: {
                    this.deleteIfDerived((IFile)resource);
                    break;
                }
                case 2: {
                    this.deleteDerivedFiles((IFolder)resource, sourceFolder);
                }
            }
            ++i;
        }
        if (!folder.equals((Object)sourceFolder)) {
            this.deleteIfEmpty(folder);
        }
    }

    private void deleteIfEmpty(IFolder folder) {
        try {
            if (folder.members().length == 0) {
                folder.delete(true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void deleteIfDerived(IFile file) {
        if (file == null || !file.isAccessible()) {
            return;
        }
        if (file.isDerived()) {
            try {
                file.delete(true, null);
                WRDResourceUtil.removeCachedGeneratedPart((IResource)file);
            }
            catch (CoreException e) {
                WRDAnnotationCore.log(4, "Failed deleting an annotation generated file during a clean.", e);
            }
        } else {
            try {
                file.deleteMarkers(ANNOT_PROB_MARKER, false, 1);
            }
            catch (CoreException e) {
                WRDAnnotationCore.log(4, "Failed deleting an annotation generated file during a clean.", e);
            }
        }
    }

    private void cleanHandlers() {
        for (AnnotationTagHandler handler : this.allHandlers) {
            try {
                handler.clean(this.currentProject);
            }
            catch (TagProcessingException e) {
                String msg = this.mkHandlerExceptionMsg(handler, "Cleaning", null);
                WRDAnnotationCore.log(4, msg, e);
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        this.initHandlers();
    }

    public void initForOperation(IProject project) {
        this.initHandlers();
        this.currentProject = project;
    }

    protected void setProcessorProject(IProject proj) {
        this.currentProject = proj;
    }

    private void initHandlers() {
        if (this.handlerMap == null) {
            this.handlerMap = AnnotationHandlerRegistry.INSTANCE.getHandlerSets();
        }
        if (this.allHandlers == null) {
            this.allHandlers = AnnotationHandlerRegistry.INSTANCE.getAllHandlers();
        }
    }

    public boolean visit(IResourceDelta res) throws CoreException {
        int kind = res.getKind();
        IResource resource = res.getResource();
        if (resource.getType() == 1 && this.shouldProcessFile((IFile)resource)) {
            if (kind == 1 || kind == 4) {
                if (WRDAnnotationController.getDefault().hasCachedResourceBeenModified(resource)) {
                    this.addDeferredProcessing(resource);
                }
                WRDAnnotationController.getDefault().removeFromCache(resource);
            } else {
                this.addDeferredDelete(res);
            }
        }
        return true;
    }

    private boolean shouldProcessFile(IFile file) {
        String ex = file.getFileExtension();
        return ex != null && ex.equalsIgnoreCase(JAVA_EXTENSION) && !this.smellsLikeDeployFile(file);
    }

    private boolean smellsLikeDeployFile(IFile file) {
        String name = file.getName();
        if (name.startsWith(WAS_EJS_PREFIX) || name.startsWith(WAS_UNDERSCORE_EJS) || name.endsWith(STUB_DOT_JAVA)) {
            return true;
        }
        String[] segments = file.getProjectRelativePath().segments();
        if (segments.length > 2 && segments[segments.length - 2].equals(WAS_DEPLOY_FOLDER_NAME)) {
            return true;
        }
        return segments.length > 3 && segments[segments.length - 3].equals(WAS_DEPLOY_FOLDER_NAME);
    }

    private void notifyRenameOrDelete(IResourceDelta rdelta, IResource resource) {
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            TagValidator.getInstance().fileRenamed(file);
            if ((rdelta.getFlags() & 0x2000) != 0) {
                IPath dest = rdelta.getMovedToPath();
                IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(dest.makeAbsolute());
                if (destFile != null) {
                    AnnotatedFileRegistry.getInstance().javaFileRenamed(file, destFile);
                }
            } else {
                AnnotatedFileRegistry.getInstance().javaFileDeleted(file);
            }
        }
    }

    private void addDeferredDelete(IResourceDelta delta) {
        if (this.deferredDeletes == null) {
            this.deferredDeletes = new ArrayList();
        }
        this.deferredDeletes.add(delta);
    }

    public boolean visit(IResourceProxy proxy) {
        if (proxy.getName().endsWith(".java")) {
            IResource resource = proxy.requestResource();
            this.addDeferredProcessing(resource);
        }
        return true;
    }

    private static String kindString(int k) {
        switch (k) {
            case 5: {
                return "CONTAINER";
            }
            case 1: {
                return "LIBRARY";
            }
            case 2: {
                return "PROJECT";
            }
            case 3: {
                return "SOURCE";
            }
            case 4: {
                return "VAR";
            }
        }
        return "HUH";
    }

    public static void debugInfo(IProject p) {
        IJavaProject jp = JavaCore.create((IProject)p);
        if (jp == null) {
            System.err.println("ADEBUG: Could not create java project for " + p.getName());
            return;
        }
        try {
            IClasspathEntry[] cpes = jp.getResolvedClasspath(false);
            StringBuffer buf = new StringBuffer(512);
            int i = 0;
            while (i < cpes.length) {
                IClasspathEntry cpe = cpes[i];
                buf.append(AnnotationProcessor.kindString(cpe.getEntryKind()));
                buf.append('[');
                buf.append(cpe.getPath());
                buf.append("]:");
                ++i;
            }
            buf.deleteCharAt(buf.length() - 1);
            System.err.println("ADEBUG: dinf: " + buf.toString());
        }
        catch (JavaModelException ex) {
            System.err.println("ADEBUG: Resolve Exception");
            ex.printStackTrace();
        }
    }

    private IStatus callHandlers(IResource res, IStatus currentStatus, AnnotationASTVisitor visitor, boolean hasAnnotations, DisabledTagSets dts) {
        IStatus retval = currentStatus;
        for (AnnotationTagHandler handler : this.allHandlers) {
            if (this.ignoreThisBuild.contains(handler) || this.isAnyHandlerTagsetDisabled(handler, dts)) continue;
            try {
                handler.beginResource(res);
                if (hasAnnotations) {
                    this.processTypes(handler, res, visitor.getTagRegistry());
                    this.processFields(handler, res, visitor.getTagRegistry());
                    this.processMethods(handler, res, visitor.getTagRegistry());
                    this.curTag = null;
                }
                handler.endResource(res);
            }
            catch (Exception ex) {
                String msg = this.mkHandlerExceptionMsg(handler, "Processing", res);
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, msg, ex);
                if (retval != Status.OK_STATUS) continue;
                retval = new Status(4, "com.ibm.zcc.ws.rapiddeploy.annotations.core", 0, msg, (Throwable)ex);
            }
        }
        return retval;
    }

    private boolean isAnyHandlerTagsetDisabled(AnnotationTagHandler handler, DisabledTagSets dts) {
        if (dts.allTagsAreDisabled()) {
            return true;
        }
        if (dts.noTagsAreDisabled()) {
            return false;
        }
        Map handlerTagSetMap = AnnotationHandlerRegistry.INSTANCE.getHandlerSets();
        Collection handlerTagSets = (Collection)handlerTagSetMap.get(handler);
        if (handlerTagSets == null) {
            return true;
        }
        for (String tagset : handlerTagSets) {
            if (!dts.isDisabled(tagset)) continue;
            return true;
        }
        return false;
    }

    private String mkHandlerExceptionMsg(AnnotationTagHandler handler, String stage, IResource resource) {
        StringBuffer b = new StringBuffer();
        b.append(IWRDResources.getString("AnnotationProcessor.Handler_Excn.1"));
        b.append(stage);
        b.append(") '");
        b.append(handler.getClass().toString());
        if (resource != null) {
            b.append(IWRDResources.getString("AnnotationProcessor.Handler_Excn.2"));
            b.append(resource.getLocation());
        }
        return b.toString();
    }

    public IStatus doIt(IResource res) {
        IStatus retval;
        block13: {
            boolean enabled;
            DisabledTagSets dts;
            if (res.getType() != 1) {
                return Status.OK_STATUS;
            }
            this.curSource = (IFile)res;
            this.curTag = null;
            this.fireBeginBuild();
            AnnotatedFileRegistry reg = AnnotatedFileRegistry.getInstance();
            boolean hadAnnotations = reg.fileIsAnnotated(this.curSource);
            IJavaElement element = JavaCore.create((IFile)this.curSource);
            retval = Status.OK_STATUS;
            if (!(element instanceof ICompilationUnit)) break block13;
            ICompilationUnit icu = (ICompilationUnit)element;
            ResourceErrorAccumulator.removeAllAccumulatedProblemMarkers(this.curSource, ANNOT_PROB_MARKER);
            DisabledTagSets disabledTagSets = dts = this.curSource.isAccessible() ? WRDJavaFileUtil.INST.disabledFor(icu) : null;
            boolean bl = dts == null ? false : (enabled = !dts.allTagsAreDisabled());
            if (!enabled) break block13;
            this.jParser.setResolveBindings(true);
            this.jParser.setSource(icu);
            this.jParser.setKind(8);
            ASTNode cunode = this.jParser.createAST(null);
            if (cunode == null || cunode.getNodeType() != 15) {
                String errMsg = String.valueOf(IWRDResources.getString("AnnotationProcessor.Can_Not_Parse_CU")) + res.getLocation();
                WRDAnnotationCore.log(2, errMsg, null);
                return new Status(4, "com.ibm.zcc.ws.rapiddeploy.annotations.core", 1002, errMsg, null);
            }
            CompilationUnit cu = (CompilationUnit)cunode;
            if ((cu.getFlags() & 1) != 0) {
                return new Status(2, "com.ibm.zcc.ws.rapiddeploy.annotations.core", 1002, String.valueOf(IWRDResources.getString("AnnotationProcessor.CU_No_Parse_Warning")) + res.getName() + IWRDResources.getString("AnnotationProcessor.No_Parse_Warning.2"), null);
            }
            AnnotationASTVisitor visitor = new AnnotationASTVisitor(this.curSource, icu, dts);
            try {
                boolean hasAnnotations;
                block14: {
                    cu.accept((ASTVisitor)visitor);
                    hasAnnotations = visitor.encounteredAnnotations();
                    reg = AnnotatedFileRegistry.getInstance();
                    if (!hasAnnotations) break block14;
                    reg.annotatedFileEncountered(this.curSource, visitor.tagsetsEncountered(), dts);
                    ResourceTagRegistry rtr = visitor.getTagRegistry();
                    this.tagsProcessed.add(rtr);
                    TagValidator.getInstance().validationBegin(this.curSource);
                    try {
                        if (!TagValidator.getInstance().validate(rtr)) {
                            Status status = new Status(2, "com.ibm.zcc.ws.rapiddeploy.annotations.core", 1001, String.valueOf(IWRDResources.getString("AnnotationProcessor.Tag_Validation_Problem")) + this.curSource.getLocation(), null);
                            return status;
                        }
                    }
                    finally {
                        TagValidator.getInstance().validationEnd(this.curSource);
                    }
                    {
                    }
                }
                reg.unannotatedFileEncountered(this.curSource);
                if (!hadAnnotations) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                retval = this.callHandlers(res, retval, visitor, hasAnnotations, dts);
            }
            finally {
                visitor.dispose();
            }
        }
        return retval;
    }

    protected IPath getPathForResource(IJavaProject jp, IResource res) {
        try {
            IPath relPath = res.getFullPath();
            IClasspathEntry[] cp = jp.getResolvedClasspath(false);
            int i = 0;
            while (i < cp.length) {
                IPath srcPath;
                if (cp[i].getEntryKind() == 3 && (srcPath = cp[i].getPath()).isPrefixOf(relPath)) {
                    return relPath.removeFirstSegments(srcPath.segmentCount());
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return res.getProjectRelativePath();
    }

    protected void processTypes(AnnotationTagHandler handler, IResource res, ResourceTagRegistry registry) {
        for (TypeTagData td : registry.getTypes()) {
            this.curTag = td;
            try {
                this.fireTypeHandler(handler, res, td);
            }
            catch (Exception ex) {
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "processTypes", res), ex);
                return;
            }
        }
    }

    protected final void fireBeginBuild() {
        if (this.beginBuildFired) {
            return;
        }
        ++this.depth;
        try {
            this.doFireBeginBuild();
        }
        finally {
            this.beginBuildFired = true;
        }
    }

    protected void doFireBeginBuild() {
        this.commonBuildInit();
        this.tagsProcessed.clear();
        for (AnnotationTagHandler handler : this.allHandlers) {
            try {
                handler.beginBuild(this, this.currentProject);
            }
            catch (Exception e) {
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "beginBuild", (IResource)this.currentProject), e);
                this.ignoreThisBuild.add(handler);
            }
        }
    }

    protected final void fireEndBuild() {
        try {
            if (this.beginBuildFired) {
                try {
                    this.doFireEndBuild();
                }
                finally {
                    this.beginBuildFired = false;
                }
            }
            this.processFiles(this.getFilesToBeProcessed(this.currentProject), this.getFilesToBeDeleted(), false);
            this.ignoreThisBuild.clear();
        }
        finally {
            --this.depth;
            this.tagsProcessed.clear();
        }
    }

    private IFile[] getFilesToBeDeleted() {
        IFile[] files = null;
        if (this.filesToBeDeleted != null && !this.filesToBeDeleted.isEmpty()) {
            files = new IFile[this.filesToBeDeleted.size()];
            this.filesToBeDeleted.toArray(files);
            this.filesToBeDeleted.clear();
        }
        return files;
    }

    private Collection getFilesToBeProcessed(IProject project) {
        Collection files = (Collection)this.filesToBeProcessed.remove(project);
        if (files == null) {
            files = Collections.EMPTY_LIST;
        }
        return files;
    }

    private void processDeferredDeletes() {
        if (this.deferredDeletes == null || this.deferredDeletes.isEmpty()) {
            return;
        }
        this.fireBeginBuild();
        try {
            int i = 0;
            while (i < this.deferredDeletes.size()) {
                IResourceDelta delta = (IResourceDelta)this.deferredDeletes.get(i);
                IFile file = (IFile)delta.getResource();
                this.processDeleted(file);
                this.notifyRenameOrDelete(delta, (IResource)file);
                ++i;
            }
        }
        finally {
            this.deferredDeletes.clear();
        }
    }

    protected void doDeletePostProcessing(IFile file) {
        this.fireBeginBuild();
        if (file.exists()) {
            this.deleteFile(file);
        }
        this.removeGeneratedParts((IResource)file);
        this.processDeletedForAnnotated(file);
        WRDResourceUtil.removeCachedGeneratedPart((IResource)file);
    }

    private void processDeleted(IFile file) {
        boolean shouldRemoveGenerated = this.processDeletedForAnnotated(file);
        if (shouldRemoveGenerated &= !this.processDeletedForGeneratedPart(file)) {
            this.removeGeneratedParts((IResource)file);
        }
    }

    private void removeGeneratedParts(IResource resource) {
        IResource[] genParts = WRDResourceHelper.getGeneratedParts((IResource)resource);
        if (genParts != null) {
            int i = 0;
            while (i < genParts.length) {
                if (genParts[i].getType() == 1) {
                    if (AnnotatedFileRegistry.getInstance().fileIsAnnotated((IFile)genParts[i])) {
                        this.cacheDeletedFileToBeProcessed((IFile)genParts[i]);
                    } else {
                        this.removeGeneratedParts(genParts[i]);
                    }
                } else {
                    this.removeGeneratedParts(genParts[i]);
                }
                ++i;
            }
        }
        this.doRemovedGeneratedParts(resource);
    }

    private void doRemovedGeneratedParts(IResource resource) {
        WRDDerivedNode dNode = WRDResourceRegistry.getDerivedNode((IResource)resource);
        if (dNode != null && dNode.getAdapter().removeGeneratedParts() && !dNode.getAdapter().hasAnyMappings()) {
            WRDResourceRegistry.removeResource((IResource)resource);
        }
    }

    private boolean processDeletedForAnnotated(IFile file) {
        Collection tagsets = AnnotatedFileRegistry.getInstance().getTagsets(file);
        if (!tagsets.isEmpty()) {
            this.callNecessaryHandlersForDeletedAnnotatedFile(file, tagsets);
            return true;
        }
        return false;
    }

    private void callNecessaryHandlersForDeletedAnnotatedFile(IFile file, Collection tagsets) {
        Iterator i = this.allHandlers.iterator();
        Map handlerTagSetMap = AnnotationHandlerRegistry.INSTANCE.getHandlerSets();
        while (i.hasNext()) {
            Collection handlerTagSets;
            AnnotationTagHandler handler = (AnnotationTagHandler)i.next();
            if (this.ignoreThisBuild.contains(handler) || (handlerTagSets = (Collection)handlerTagSetMap.get(handler)) == null || !this.containsAny(handlerTagSets, tagsets)) continue;
            try {
                handler.beginResource((IResource)file);
                handler.endResource((IResource)file);
            }
            catch (Throwable ex) {
                String msg = this.mkHandlerExceptionMsg(handler, "Processing deleted", (IResource)file);
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, msg, ex);
            }
        }
    }

    private boolean containsAny(Collection handlerTagSets, Collection tagsets) {
        Iterator iter = tagsets.iterator();
        while (iter.hasNext()) {
            if (!handlerTagSets.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean processDeletedForGeneratedPart(IFile file) {
        IResource genRoot = WRDResourceUtil.getParentResourceFromRoot((IResource)file);
        if (genRoot != null && genRoot.exists()) {
            this.callNecessaryHandlersForDeletedGenTarget(genRoot, file);
            WRDResourceUtil.removeCachedGeneratedPart((IResource)file);
            this.cacheParentRegenFileForProcessing(genRoot);
            return true;
        }
        return false;
    }

    private void callNecessaryHandlersForDeletedGenTarget(IResource genRoot, IFile generatedFile) {
        Collection tagsets = AnnotatedFileRegistry.getInstance().getTagsets((IFile)genRoot);
        Iterator i = this.allHandlers.iterator();
        Map handlerTagSetMap = AnnotationHandlerRegistry.INSTANCE.getHandlerSets();
        while (i.hasNext()) {
            Collection handlerTagSets;
            AnnotationTagHandler handler = (AnnotationTagHandler)i.next();
            if (this.ignoreThisBuild.contains(handler) || (handlerTagSets = (Collection)handlerTagSetMap.get(handler)) == null || !this.containsAny(handlerTagSets, tagsets)) continue;
            try {
                handler.generatedResourceDeleted(generatedFile, genRoot);
            }
            catch (Throwable ex) {
                String msg = this.mkHandlerExceptionMsg(handler, "Handle parent regeneration.", genRoot);
                WRDAnnotationCore.log(4, msg, ex);
            }
        }
    }

    protected void doFireEndBuild() {
        this.curSource = null;
        for (AnnotationTagHandler handler : this.allHandlers) {
            if (this.ignoreThisBuild.contains(handler)) continue;
            try {
                handler.endBuild(this.currentProject);
                this.writeAllHeldResources(this.currentProject);
            }
            catch (Exception ex) {
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "endBuild", (IResource)this.currentProject), ex);
            }
        }
        this.writeAllHeldResources(this.currentProject);
        for (ResourceTagRegistry rtr : this.tagsProcessed) {
            rtr.validateAndReportErrors(ANNOT_PROB_MARKER);
        }
    }

    private void processFiles(Collection generatedFiles, IFile[] deletedFiles, boolean markDirty) {
        IFile[] genResources = null;
        if (generatedFiles != null && !generatedFiles.isEmpty()) {
            genResources = new IFile[generatedFiles.size()];
            generatedFiles.toArray(genResources);
            generatedFiles.clear();
        }
        if (genResources != null || deletedFiles != null && deletedFiles.length > 0) {
            if (this.wrapper == null) {
                this.wrapper = new AnnotationWrapper(this);
            }
            try {
                this.wrapper.doExecute((IResource[])genResources, deletedFiles);
            }
            catch (CoreException e) {
                WRDAnnotationCore.log(4, IWRDResources.getString("AnnotationProcessor.Problem_Processing_Generated_Files"), e);
            }
            if (markDirty) {
                this.markResourcesDirty(genResources);
            }
        }
    }

    private void markResourcesDirty(IFile[] resources) {
        int i = 0;
        while (i < resources.length) {
            IFile file = resources[i];
            try {
                file.touch(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void fireTypeHandler(AnnotationTagHandler handler, IResource res, TypeTagData td) {
        String tagName = td.getName();
        String tagSetName = td.getTagSet();
        Set handlerCovers = (Set)this.handlerMap.get(handler);
        if (handlerCovers != null && handlerCovers.contains(tagSetName) && AnnotationTagRegistry.isTypeTag((String)tagName)) {
            TypeTagData std = TagDataImplRegistry.INSTANCE.specializeType(td, handler);
            try {
                handler.handleTag(std, res);
            }
            catch (Exception ex) {
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "typeHandler", res), ex);
            }
        }
    }

    protected void processFields(AnnotationTagHandler handler, IResource res, ResourceTagRegistry registry) {
        for (FieldTagData fd : registry.getFields()) {
            this.curTag = fd;
            this.fireFieldHandler(handler, res, fd);
        }
    }

    protected void fireFieldHandler(AnnotationTagHandler handler, IResource res, FieldTagData fd) {
        String tagName = fd.getName();
        String tagSetName = fd.getTagSet();
        Set handlerCovers = (Set)this.handlerMap.get(handler);
        if (handlerCovers != null && handlerCovers.contains(tagSetName) && AnnotationTagRegistry.isFieldTag((String)tagName)) {
            FieldTagData sfd = TagDataImplRegistry.INSTANCE.specializeField(fd, handler);
            try {
                handler.handleTag(sfd, res);
            }
            catch (Exception ex) {
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "fieldHandler", res), ex);
            }
        }
    }

    protected void processMethods(AnnotationTagHandler handler, IResource res, ResourceTagRegistry registry) {
        for (MethodTagData md : registry.getMethods()) {
            this.curTag = md;
            this.fireMethodHandler(handler, res, md);
        }
    }

    protected void fireMethodHandler(AnnotationTagHandler handler, IResource res, MethodTagData md) {
        String tagName = md.getName();
        String tagSetName = md.getTagSet();
        Set handlerCovers = (Set)this.handlerMap.get(handler);
        if (handlerCovers != null && handlerCovers.contains(tagSetName) && AnnotationTagRegistry.isMethodTag((String)tagName)) {
            MethodTagData smd = TagDataImplRegistry.INSTANCE.specializeMethod(md, handler);
            try {
                handler.handleTag(smd, res);
            }
            catch (Exception ex) {
                this.ignoreThisBuild.add(handler);
                WRDAnnotationCore.log(4, this.mkHandlerExceptionMsg(handler, "methodHandler", res), ex);
            }
        }
    }

    @Override
    public void generateResource(IResourceHolder heldResource) {
        if (this.curSource != null) {
            if (heldResource.getParentTagSet() == null && this.curTag != null) {
                heldResource.setParentTagSet(this.curTag.getTagSet());
            }
            this.heldResources.add(new InternHeldResource(this.curSource, heldResource));
        } else {
            WRDAnnotationCore.log(4, IWRDResources.getString("AnnotationProcessor.EndOfBuild_Illegal_State"), new Exception());
        }
    }

    @Override
    public void generateResource(IResourceHolder heldResource, IFile sourceFile) {
        if (sourceFile != null) {
            this.heldResources.add(new InternHeldResource(sourceFile, heldResource));
        } else {
            WRDAnnotationCore.log(4, IWRDResources.getString("AnnotationProcessor.Null_Source_File"), new Exception());
        }
    }

    @Override
    public void deleteResource(IResourceHolder heldResource) {
        this.deleteResource(heldResource, (IResource)this.curSource);
    }

    public void deleteResource(IResourceHolder heldResource, IResource sourceResource) {
        IFile file = heldResource.getDestinationFile();
        if (file != null && file.exists()) {
            this.deleteResource(file);
        }
    }

    private void deleteResource(IFile file) {
        if (AnnotatedFileRegistry.getInstance().fileIsAnnotated(file)) {
            this.cacheDeletedFileToBeProcessed(file);
        } else {
            this.deleteFile(file);
            WRDResourceUtil.removeCachedGeneratedPart((IResource)file);
        }
    }

    private void cacheDeletedFileToBeProcessed(IFile file) {
        if (file != null && this.filesToBeDeleted == null) {
            this.filesToBeDeleted = new HashSet();
        }
        this.filesToBeDeleted.add(file);
    }

    private void deleteFile(IFile file) {
        try {
            file.delete(true, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IFolder getGeneratedFolder(IProject proj) {
        return proj.getFolder("gen");
    }

    private IFolder[] getGeneratedSourceFolders(IProject proj) {
        IJavaProject jp = JavaCore.create((IProject)proj);
        ArrayList<IFolder> folders = new ArrayList<IFolder>();
        try {
            IClasspathEntry[] cpEntries = jp.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                IFolder folder;
                IClasspathEntry entry = cpEntries[i];
                if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 1 && (folder = proj.getFolder(entry.getPath().removeFirstSegments(1))).isDerived() && folder.getName().equals("src") && folder.getParent().isDerived() && folder.getParent().getName().equals("gen")) {
                    folders.add(folder);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return folders.toArray(new IFolder[folders.size()]);
    }

    private void writeAllHeldResources(IProject proj) {
        if (this.heldResources.isEmpty()) {
            return;
        }
        for (InternHeldResource irh : this.heldResources) {
            boolean needsDerived;
            IFile destFile = irh.heldResource.getDestinationFile();
            if (destFile == null) continue;
            boolean bl = needsDerived = !destFile.exists();
            if (this.wrapper != null) {
                this.wrapper.addGeneratedResource(destFile);
            }
            try {
                irh.heldResource.externalize();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (needsDerived) {
                try {
                    destFile.setDerived(true);
                    IContainer parent = destFile.getParent();
                    while (parent != null && !parent.isDerived()) {
                        parent.setDerived(true);
                        parent = parent.getParent();
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            WRDResourceUtil.linkGeneratedPart((IResource)irh.sourceFile, (IResource)destFile);
            this.cacheGeneratedFileForProcessing(destFile, irh.heldResource);
        }
        this.heldResources.clear();
    }

    private void cacheGeneratedFileForProcessing(IFile file, IResourceHolder holder) {
        if (JAVA_EXTENSION.equals(file.getFileExtension())) {
            IProject fileProject = file.getProject();
            IJavaResourceHolder jholder = (IJavaResourceHolder)holder;
            if (this.isProcessingProject(fileProject) && jholder.hasAnnotations()) {
                this.cacheFileToBeProcessed(file);
            }
        }
    }

    private void cacheFileToBeProcessed(IFile file) {
        IProject project = file.getProject();
        HashSet<IFile> files = (HashSet<IFile>)this.filesToBeProcessed.get(project);
        if (files == null) {
            files = new HashSet<IFile>();
            this.filesToBeProcessed.put(project, files);
        }
        files.add(file);
    }

    private boolean isProcessingProject(IProject fileProject) {
        IProject testProject;
        IProject iProject = testProject = this.isBuilding ? this.getProject() : this.currentProject;
        return fileProject == testProject;
    }

    private void cacheParentRegenFileForProcessing(IResource file) {
        if (JAVA_EXTENSION.equals(file.getFileExtension())) {
            IProject fileProject = file.getProject();
            if (this.currentProject.equals((Object)fileProject)) {
                this.addDeferredProcessing(file);
            } else if (this.isProcessingProject(fileProject)) {
                this.cacheFileToBeProcessed((IFile)file);
            } else {
                try {
                    file.touch(null);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    @Override
    public Set getFilesAnnotatedWith(String tagsetName) {
        return AnnotatedFileRegistry.getInstance().filesAnnotatedWithTagSet(tagsetName);
    }

    @Override
    public boolean isFileAnnotated(IFile javaSourceFile) {
        return AnnotatedFileRegistry.getInstance().fileIsAnnotated(javaSourceFile);
    }

    @Override
    public Set allAnnotatedFiles() {
        return AnnotatedFileRegistry.getInstance().allAnnotatedFiles();
    }

    @Override
    public void mapTypeTagToModel(AnnotationTagHandler ath, String tagName, Class typeTagDataSubclass) {
        TagDataImplRegistry.INSTANCE.registerType(tagName, ath, typeTagDataSubclass);
    }

    @Override
    public void mapMethodTagToModel(AnnotationTagHandler ath, String tagName, Class methodTagDataSubclass) {
        TagDataImplRegistry.INSTANCE.registerMethod(tagName, ath, methodTagDataSubclass);
    }

    @Override
    public void mapFieldTagToModel(AnnotationTagHandler ath, String tagName, Class fieldTagDataSubclass) {
        TagDataImplRegistry.INSTANCE.registerField(tagName, ath, fieldTagDataSubclass);
    }

    private void addDeferredProcessing(IResource res) {
        this.deferredProcessing.add(res);
    }

    @Override
    public boolean isSecondaryProcessingPass() {
        return this.depth > 0;
    }

    private class InternHeldResource {
        public IFile sourceFile;
        public IResourceHolder heldResource;

        public InternHeldResource(IFile src, IResourceHolder rh) {
            this.sourceFile = src;
            this.heldResource = rh;
        }
    }
}

