/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.validation.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.internal.migration.validation.framework.MigrationValidatorDescriptor;
import com.ibm.etools.common.migration.validation.framework.AbstractMigrationValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class MigrationValidatorRegisty {
    static final String EXTENSION_POINT = "MigrationValidatorExtension";
    static final String ELEMENT_MIGRATION_VALIDATOR = "MigrationValidator";
    static final String ATTRIBUTE_CLASS = "class";
    static final String ATTRIBUTE_ID = "id";
    static final String ATTRIBUTE_REQUIRES = "requires";
    public static MigrationValidatorRegisty INSTANCE = new MigrationValidatorRegisty();
    private List migrationValidatorDescriptors = null;

    public List getMigrationValidators() {
        List descriptors = this.getMigrationValidatorsDescriptors();
        ArrayList<AbstractMigrationValidator> instances = new ArrayList<AbstractMigrationValidator>();
        int i = 0;
        while (i < descriptors.size()) {
            MigrationValidatorDescriptor descriptor = (MigrationValidatorDescriptor)descriptors.get(i);
            try {
                AbstractMigrationValidator migrationValidator = (AbstractMigrationValidator)descriptor.createExecutableExtension();
                migrationValidator.setID(descriptor.getID());
                HashSet requiresMigratorIDs = new HashSet();
                requiresMigratorIDs.addAll(descriptor.getRequires());
                migrationValidator.setRequiresMigratorIDs(requiresMigratorIDs);
                instances.add(migrationValidator);
            }
            catch (CoreException e) {
                MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_failed_class_load, (Object)descriptor));
                MigrationPlugin.logError(e);
                descriptors.remove(i);
                --i;
            }
            ++i;
        }
        return instances;
    }

    public List getMigrationValidatorsDescriptors() {
        if (this.migrationValidatorDescriptors == null) {
            this.readDescriptors();
        }
        return this.migrationValidatorDescriptors;
    }

    public MigrationValidatorDescriptor getMigrationValidatorsDescriptor(String id) {
        List descriptors = this.getMigrationValidatorsDescriptors();
        int i = 0;
        while (i < descriptors.size()) {
            MigrationValidatorDescriptor descriptor = (MigrationValidatorDescriptor)descriptors.get(i);
            if (descriptor.getID().equals(id)) {
                return descriptor;
            }
            ++i;
        }
        return null;
    }

    private void readDescriptors() {
        MigrationValidatorDescriptor descriptor;
        this.migrationValidatorDescriptors = new ArrayList();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.etools.common.migration", EXTENSION_POINT);
        if (point == null) {
            return;
        }
        HashMap<String, MigrationValidatorDescriptor> knownIds = new HashMap<String, MigrationValidatorDescriptor>();
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (ELEMENT_MIGRATION_VALIDATOR.equals(element.getName())) {
                String className;
                String id = element.getAttribute(ATTRIBUTE_ID);
                if (id == null || id.trim().length() == 0) {
                    MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_missing_attr_id, (Object[])new Object[]{EXTENSION_POINT, ELEMENT_MIGRATION_VALIDATOR, ATTRIBUTE_ID}));
                }
                if ((className = element.getAttribute(ATTRIBUTE_CLASS)) == null || className.trim().length() == 0) {
                    MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_missing_attr_class, (Object[])new Object[]{EXTENSION_POINT, ELEMENT_MIGRATION_VALIDATOR, ATTRIBUTE_CLASS}));
                }
                MigrationValidatorDescriptor descriptor2 = new MigrationValidatorDescriptor(element);
                if (knownIds.containsKey(id)) {
                    MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_duplicate_id, (Object)descriptor2));
                } else {
                    knownIds.put(id, descriptor2);
                }
                this.migrationValidatorDescriptors.add(descriptor2);
            } else {
                MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_element_not_named, (Object[])new Object[]{ELEMENT_MIGRATION_VALIDATOR, EXTENSION_POINT}));
                MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_element_invalid, (Object[])new Object[]{element.getName(), EXTENSION_POINT}));
            }
            ++i;
        }
        i = 0;
        while (i < this.migrationValidatorDescriptors.size()) {
            descriptor = (MigrationValidatorDescriptor)this.migrationValidatorDescriptors.get(i);
            Set requires = descriptor.getRequires();
            for (String requiredID : requires) {
                if (knownIds.containsKey(requiredID)) continue;
                MigrationPlugin.logError(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_requiresID_not_found, (Object[])new Object[]{EXTENSION_POINT, descriptor.getElement().getContributor().getName(), descriptor.getID(), requiredID}));
            }
            ++i;
        }
        i = 0;
        while (i < this.migrationValidatorDescriptors.size()) {
            descriptor = (MigrationValidatorDescriptor)this.migrationValidatorDescriptors.get(i);
            Set transitiveRequires = descriptor.getTransitiveRequires();
            if (transitiveRequires.contains(descriptor.getID())) {
                HashSet<MigrationValidatorDescriptor> cycle = new HashSet<MigrationValidatorDescriptor>();
                for (String requiresID : transitiveRequires) {
                    MigrationValidatorDescriptor requiredDescriptor = (MigrationValidatorDescriptor)knownIds.get(requiresID);
                    if (requiredDescriptor.getRequires().isEmpty()) continue;
                    cycle.add(requiredDescriptor);
                }
                StringBuffer strBuff = new StringBuffer();
                strBuff.append(NLS.bind((String)MigrationMessages.MigrationValidatorRegisty_cyclical_requires, (Object)EXTENSION_POINT));
                strBuff.append("\n");
                for (MigrationValidatorDescriptor cycleDescriptor : cycle) {
                    strBuff.append("plugin: ");
                    strBuff.append(cycleDescriptor.getElement().getContributor().getName());
                    strBuff.append(" ID: ");
                    strBuff.append(cycleDescriptor.getID());
                    strBuff.append(" requires: ");
                    Set requiresIDs = cycleDescriptor.getRequires();
                    for (String requiresID : requiresIDs) {
                        strBuff.append(requiresID);
                        strBuff.append(" ");
                    }
                }
                MigrationPlugin.logError(strBuff.toString());
            }
            ++i;
        }
        this.migrationValidatorDescriptors = this.sort(this.migrationValidatorDescriptors);
    }

    private List sort(List descriptors) {
        ArrayList copy = new ArrayList();
        copy.addAll(descriptors);
        ArrayList<MigrationValidatorDescriptor> sortedDescriptors = new ArrayList<MigrationValidatorDescriptor>();
        HashSet<String> sortedIDs = new HashSet<String>();
        while (!copy.isEmpty()) {
            int i = 0;
            while (i < copy.size()) {
                MigrationValidatorDescriptor descriptor = (MigrationValidatorDescriptor)copy.get(i);
                Set transitiveRequires = descriptor.getTransitiveRequires();
                if (sortedIDs.containsAll(transitiveRequires)) {
                    sortedDescriptors.add(descriptor);
                    sortedIDs.add(descriptor.getID());
                    copy.remove(i);
                    --i;
                }
                ++i;
            }
        }
        return sortedDescriptors;
    }
}

