/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework;

import com.ibm.etools.common.internal.migration.framework.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class MigrationLog {
    private static final MigrationLog INSTANCE = new MigrationLog();
    private FileWriter migrationLogStream;
    private static final String lineSeparator = System.getProperty("line.separator");

    public static MigrationLog getInstance() {
        return INSTANCE;
    }

    public void createLogFile(IPath logFileDestination) {
        File directory;
        String path;
        int separatorIndex;
        File file = logFileDestination.toFile();
        if (!file.exists() && (separatorIndex = (path = file.getAbsolutePath()).lastIndexOf(File.separator)) != -1 && !(directory = new File(path.substring(0, separatorIndex))).exists()) {
            directory.mkdirs();
        }
        try {
            this.migrationLogStream = new FileWriter(file, true);
            StringBuffer buffer = new StringBuffer();
            buffer.append(lineSeparator);
            buffer.append("*** ");
            buffer.append(MigrationMessages.MigrationFramework_Startup);
            buffer.append(" - ");
            buffer.append(DateFormat.getDateTimeInstance(1, 1).format(new Date()));
            this.logMessage(buffer.toString());
        }
        catch (IOException e) {
            MigrationPlugin.logError(e);
        }
    }

    public void endLogging() {
        if (this.migrationLogStream == null) {
            return;
        }
        try {
            this.migrationLogStream.close();
            this.migrationLogStream = null;
        }
        catch (IOException e) {
            MigrationPlugin.logError(e);
        }
    }

    public void logProjectMigration(String projectName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineSeparator);
        buffer.append("       ");
        buffer.append(MigrationMessages.bind((String)MigrationMessages.MigrationFramework_MigratingProject, (Object)projectName));
        this.logMessage(buffer.toString());
    }

    public void logResourceCheckout(IFile[] files) {
        if (files.length == 0) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineSeparator);
        buffer.append("       ");
        buffer.append(MigrationMessages.MigrationFramework_attemptCheckout);
        this.sort(files);
        int i = 0;
        while (i < files.length) {
            buffer.append(lineSeparator);
            buffer.append(files[i].getLocation().toString());
            ++i;
        }
        this.logMessage(buffer.toString());
    }

    private void sort(IFile[] files) {
        Arrays.sort(files, new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                return file1.getLocation().toString().compareTo(file2.getLocation().toString());
            }
        });
    }

    public void logMigrationStatusFor(IMigrationStatus migrationStatus, String migratorID) {
        IStatus status = migrationStatus.getStatus();
        int severity = status.getSeverity();
        String message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkOperation_migrationID, (Object[])new Object[]{migratorID});
        Status msgStatus = new Status(severity, "com.ibm.etools.common.migration", message);
        this.logStatus((IStatus)msgStatus, true);
        if (severity != 0) {
            this.logStatus(status, false);
        }
    }

    public void logStatus(IStatus status, boolean showPrefix) {
        if (this.migrationLogStream == null || status == null) {
            return;
        }
        if (!status.isMultiStatus()) {
            StringBuffer buffer = new StringBuffer();
            String linePrefix = "       ";
            if (showPrefix) {
                switch (status.getSeverity()) {
                    case 4: {
                        linePrefix = "ERROR  ";
                        break;
                    }
                    case 2: {
                        linePrefix = "WARNING";
                        break;
                    }
                    case 1: {
                        linePrefix = "INFO   ";
                        break;
                    }
                    default: {
                        linePrefix = "OK     ";
                    }
                }
            }
            buffer.append(linePrefix);
            buffer.append(status.getMessage());
            buffer.append(lineSeparator);
            try {
                this.migrationLogStream.write(buffer.toString());
                this.migrationLogStream.flush();
            }
            catch (IOException e) {
                MigrationPlugin.logError(e);
            }
            return;
        }
        IStatus[] statuses = ((MultiStatus)status).getChildren();
        int i = 0;
        while (i < statuses.length) {
            this.logStatus(statuses[i], showPrefix);
            ++i;
        }
    }

    public void logMessage(String message) {
        if (this.migrationLogStream == null) {
            return;
        }
        try {
            this.migrationLogStream.write(message);
            this.migrationLogStream.write(lineSeparator);
            this.migrationLogStream.flush();
        }
        catch (IOException e) {
            MigrationPlugin.logError(e);
        }
    }
}

