/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TextShapes implements Enumerator
{
    NOMINAL_LITERAL(0, "nominal", "nominal"),
    SHAPED_LITERAL(1, "shaped", "shaped"),
    INITIAL_LITERAL(2, "initial", "initial"),
    MIDDLE_LITERAL(3, "middle", "middle"),
    FINAL_LITERAL(4, "final", "final"),
    ISOLATED_LITERAL(5, "isolated", "isolated");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int NOMINAL = 0;
    public static final int SHAPED = 1;
    public static final int INITIAL = 2;
    public static final int MIDDLE = 3;
    public static final int FINAL = 4;
    public static final int ISOLATED = 5;
    private static final TextShapes[] VALUES_ARRAY;
    public static final List<TextShapes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TextShapes[]{NOMINAL_LITERAL, SHAPED_LITERAL, INITIAL_LITERAL, MIDDLE_LITERAL, FINAL_LITERAL, ISOLATED_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TextShapes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextShapes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextShapes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextShapes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextShapes get(int value) {
        switch (value) {
            case 0: {
                return NOMINAL_LITERAL;
            }
            case 1: {
                return SHAPED_LITERAL;
            }
            case 2: {
                return INITIAL_LITERAL;
            }
            case 3: {
                return MIDDLE_LITERAL;
            }
            case 4: {
                return FINAL_LITERAL;
            }
            case 5: {
                return ISOLATED_LITERAL;
            }
        }
        return null;
    }

    private TextShapes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

