/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SignCodingValue implements Enumerator
{
    TWOS_COMPLEMENT_LITERAL(0, "twosComplement", "twosComplement"),
    ONES_COMPLEMENT_LITERAL(1, "onesComplement", "onesComplement"),
    SIGN_MAGNITUDE_LITERAL(2, "signMagnitude", "signMagnitude"),
    UNSIGNED_BINARY_LITERAL(3, "unsignedBinary", "unsignedBinary"),
    UNSIGNED_DECIMAL_LITERAL(4, "unsignedDecimal", "unsignedDecimal");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int TWOS_COMPLEMENT = 0;
    public static final int ONES_COMPLEMENT = 1;
    public static final int SIGN_MAGNITUDE = 2;
    public static final int UNSIGNED_BINARY = 3;
    public static final int UNSIGNED_DECIMAL = 4;
    private static final SignCodingValue[] VALUES_ARRAY;
    public static final List<SignCodingValue> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SignCodingValue[]{TWOS_COMPLEMENT_LITERAL, ONES_COMPLEMENT_LITERAL, SIGN_MAGNITUDE_LITERAL, UNSIGNED_BINARY_LITERAL, UNSIGNED_DECIMAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SignCodingValue get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignCodingValue result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignCodingValue getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignCodingValue result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignCodingValue get(int value) {
        switch (value) {
            case 0: {
                return TWOS_COMPLEMENT_LITERAL;
            }
            case 1: {
                return ONES_COMPLEMENT_LITERAL;
            }
            case 2: {
                return SIGN_MAGNITUDE_LITERAL;
            }
            case 3: {
                return UNSIGNED_BINARY_LITERAL;
            }
            case 4: {
                return UNSIGNED_DECIMAL_LITERAL;
            }
        }
        return null;
    }

    private SignCodingValue(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

