/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Orientation implements Enumerator
{
    LTR_LITERAL(0, "LTR", "LTR"),
    RTL_LITERAL(1, "RTL", "RTL"),
    CONTEXTUAL_LTR_LITERAL(2, "contextual_LTR", "contextual_LTR"),
    CONTEXTUAL_RTL_LITERAL(3, "contextual_RTL", "contextual_RTL");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int LTR = 0;
    public static final int RTL = 1;
    public static final int CONTEXTUAL_LTR = 2;
    public static final int CONTEXTUAL_RTL = 3;
    private static final Orientation[] VALUES_ARRAY;
    public static final List<Orientation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Orientation[]{LTR_LITERAL, RTL_LITERAL, CONTEXTUAL_LTR_LITERAL, CONTEXTUAL_RTL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Orientation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation get(int value) {
        switch (value) {
            case 0: {
                return LTR_LITERAL;
            }
            case 1: {
                return RTL_LITERAL;
            }
            case 2: {
                return CONTEXTUAL_LTR_LITERAL;
            }
            case 3: {
                return CONTEXTUAL_RTL_LITERAL;
            }
        }
        return null;
    }

    private Orientation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

