/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.typedescriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LanguageType implements Enumerator
{
    COBOL_LITERAL(0, "cobol", "cobol"),
    PLI_LITERAL(1, "pli", "pli"),
    JAVA_LITERAL(2, "java", "java"),
    C_LITERAL(3, "c", "c"),
    CPP_LITERAL(4, "cpp", "cpp"),
    HLASM_LITERAL(5, "hlasm", "hlasm");

    public static final String copyright = "Licensed Material - Property of IBM com.ibm.etools.tdlang Copyright IBM Corp. 2002, 2010 - All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office. ";
    public static final int COBOL = 0;
    public static final int PLI = 1;
    public static final int JAVA = 2;
    public static final int C = 3;
    public static final int CPP = 4;
    public static final int HLASM = 5;
    private static final LanguageType[] VALUES_ARRAY;
    public static final List<LanguageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LanguageType[]{COBOL_LITERAL, PLI_LITERAL, JAVA_LITERAL, C_LITERAL, CPP_LITERAL, HLASM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LanguageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageType get(int value) {
        switch (value) {
            case 0: {
                return COBOL_LITERAL;
            }
            case 1: {
                return PLI_LITERAL;
            }
            case 2: {
                return JAVA_LITERAL;
            }
            case 3: {
                return C_LITERAL;
            }
            case 4: {
                return CPP_LITERAL;
            }
            case 5: {
                return HLASM_LITERAL;
            }
        }
        return null;
    }

    private LanguageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

